/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy;

import javax.net.ssl.SSLEngine;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelPipeline;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy.SpdyFrameCodec;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy.SpdyHttpDecoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy.SpdyHttpEncoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy.SpdyHttpResponseStreamIdHandler;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy.SpdySessionHandler;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.spdy.SpdyVersion;
import org.apache.kudu.shaded.org.jboss.netty.handler.ssl.SslHandler;

public abstract class SpdyOrHttpChooser
implements ChannelUpstreamHandler {
    private final int maxSpdyContentLength;
    private final int maxHttpContentLength;

    protected SpdyOrHttpChooser(int maxSpdyContentLength, int maxHttpContentLength) {
        this.maxSpdyContentLength = maxSpdyContentLength;
        this.maxHttpContentLength = maxHttpContentLength;
    }

    protected abstract SelectedProtocol getProtocol(SSLEngine var1);

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        SslHandler handler = ctx.getPipeline().get(SslHandler.class);
        if (handler == null) {
            throw new IllegalStateException("SslHandler is needed for SPDY");
        }
        ChannelPipeline pipeline = ctx.getPipeline();
        SelectedProtocol protocol = this.getProtocol(handler.getEngine());
        switch (protocol) {
            case None: {
                return;
            }
            case SpdyVersion3_1: {
                this.addSpdyHandlers(ctx, SpdyVersion.SPDY_3_1);
                break;
            }
            case HttpVersion1_0: 
            case HttpVersion1_1: {
                this.addHttpHandlers(ctx);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SelectedProtocol");
            }
        }
        pipeline.remove(this);
        ctx.sendUpstream(e);
    }

    protected void addSpdyHandlers(ChannelHandlerContext ctx, SpdyVersion version2) {
        ChannelPipeline pipeline = ctx.getPipeline();
        pipeline.addLast("spdyFrameCodec", new SpdyFrameCodec(version2));
        pipeline.addLast("spdySessionHandler", new SpdySessionHandler(version2, true));
        pipeline.addLast("spdyHttpEncoder", new SpdyHttpEncoder(version2));
        pipeline.addLast("spdyHttpDecoder", new SpdyHttpDecoder(version2, this.maxSpdyContentLength));
        pipeline.addLast("spdyStreamIdHandler", new SpdyHttpResponseStreamIdHandler());
        pipeline.addLast("httpRequestHandler", this.createHttpRequestHandlerForSpdy());
    }

    protected void addHttpHandlers(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.getPipeline();
        pipeline.addLast("httpRequestDecoder", new HttpRequestDecoder());
        pipeline.addLast("httpResponseEncoder", new HttpResponseEncoder());
        pipeline.addLast("httpChunkAggregator", new HttpChunkAggregator(this.maxHttpContentLength));
        pipeline.addLast("httpRequestHandler", this.createHttpRequestHandlerForHttp());
    }

    protected abstract ChannelUpstreamHandler createHttpRequestHandlerForHttp();

    protected ChannelUpstreamHandler createHttpRequestHandlerForSpdy() {
        return this.createHttpRequestHandlerForHttp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectedProtocol {
        SpdyVersion3_1,
        HttpVersion1_1,
        HttpVersion1_0,
        None;

    }
}

