/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.codec.string;

import java.nio.charset.Charset;
import org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.kudu.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandler;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class StringEncoder
extends OneToOneEncoder {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            return ChannelBuffers.copiedBuffer(ctx.getChannel().getConfig().getBufferFactory().getDefaultOrder(), (String)msg, this.charset);
        }
        return msg;
    }
}

