/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import java.net.InetAddress;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.spark.kudu.Delete$;
import org.apache.kudu.spark.kudu.Insert$;
import org.apache.kudu.spark.kudu.KuduReadOptions;
import org.apache.kudu.spark.kudu.KuduReadOptions$;
import org.apache.kudu.spark.kudu.KuduRelation;
import org.apache.kudu.spark.kudu.KuduSink;
import org.apache.kudu.spark.kudu.KuduWriteOptions;
import org.apache.kudu.spark.kudu.KuduWriteOptions$;
import org.apache.kudu.spark.kudu.OperationType;
import org.apache.kudu.spark.kudu.Update$;
import org.apache.kudu.spark.kudu.Upsert$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u00011\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011YW\u000fZ;\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0002\b\u0015\tA\u0011\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0005\u0019qN]4\u0004\u0001M9\u0001!D\n\u001d?\t*\u0003C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u001555\tQC\u0003\u0002\u0017/\u000591o\\;sG\u0016\u001c(B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u001dI!aG\u000b\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003)uI!AH\u000b\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u000b!\u0013\t\tSCA\rDe\u0016\fG/\u00192mKJ+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u000b$\u0013\t!SC\u0001\fTG\",W.\u0019*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t!b%\u0003\u0002(+\t\u00112\u000b\u001e:fC6\u001c\u0016N\\6Qe>4\u0018\u000eZ3s\u0011\u0015I\u0003\u0001\"\u0001+\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002-\u00015\t!\u0001C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\u0013Q\u000b%\tT#`\u0017\u0016KV#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001\u00027b]\u001eT\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028e\t11\u000b\u001e:j]\u001eDa!\u000f\u0001!\u0002\u0013\u0001\u0014A\u0003+B\u00052+ulS#ZA!91\b\u0001b\u0001\n\u0003y\u0013aC&V\tV{V*Q*U\u000bJCa!\u0010\u0001!\u0002\u0013\u0001\u0014\u0001D&V\tV{V*Q*U\u000bJ\u0003\u0003bB \u0001\u0005\u0004%\taL\u0001\n\u001fB+%+\u0011+J\u001f:Ca!\u0011\u0001!\u0002\u0013\u0001\u0014AC(Q\u000bJ\u000bE+S(OA!91\t\u0001b\u0001\n\u0003y\u0013A\u0006$B+2#v\fV(M\u000bJ\u000be\nV0T\u0007\u0006se*\u0012*\t\r\u0015\u0003\u0001\u0015!\u00031\u0003]1\u0015)\u0016'U?R{E*\u0012*B\u001dR{6kQ!O\u001d\u0016\u0013\u0006\u0005C\u0004H\u0001\t\u0007I\u0011A\u0018\u0002\u001bM\u001b\u0015IT0M\u001f\u000e\u000bE*\u0013+Z\u0011\u0019I\u0005\u0001)A\u0005a\u0005q1kQ!O?2{5)\u0011'J)f\u0003\u0003bB&\u0001\u0005\u0004%\taL\u0001\f\u0013\u001esuJU#`\u001dVcE\n\u0003\u0004N\u0001\u0001\u0006I\u0001M\u0001\r\u0013\u001esuJU#`\u001dVcE\n\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u00010\u0003mIuIT(S\u000b~#U\u000b\u0015'J\u0007\u0006#Vi\u0018*P/~+%KU(S'\"1\u0011\u000b\u0001Q\u0001\nA\nA$S$O\u001fJ+u\fR+Q\u0019&\u001b\u0015\tV#`%>;v,\u0012*S\u001fJ\u001b\u0006\u0005C\u0004T\u0001\t\u0007I\u0011A\u0018\u0002\u0017I+\u0005+\u0011*U\u0013RKuJ\u0014\u0005\u0007+\u0002\u0001\u000b\u0011\u0002\u0019\u0002\u0019I+\u0005+\u0011*U\u0013RKuJ\u0014\u0011\t\u000f]\u0003!\u0019!C\u0001_\u0005\u0001\"+\u0012)B%RKE+S(O?N{%\u000b\u0016\u0005\u00073\u0002\u0001\u000b\u0011\u0002\u0019\u0002#I+\u0005+\u0011*U\u0013RKuJT0T\u001fJ#\u0006\u0005C\u0004\\\u0001\t\u0007I\u0011A\u0018\u0002/M\u001b\u0015IT0S\u000bF+Vi\u0015+`)&kUiT+U?6\u001b\u0006BB/\u0001A\u0003%\u0001'\u0001\rT\u0007\u0006suLU#R+\u0016\u001bFk\u0018+J\u001b\u0016{U\u000bV0N'\u0002Bqa\u0018\u0001C\u0002\u0013\u0005q&\u0001\fT\u001f\u000e[U\tV0S\u000b\u0006#u\fV%N\u000b>+FkX'T\u0011\u0019\t\u0007\u0001)A\u0005a\u000592kT\"L\u000bR{&+R!E?RKU*R(V)~k5\u000b\t\u0005\bG\u0002\u0011\r\u0011\"\u00010\u0003)\u0011\u0015\tV\"I?NK%,\u0012\u0005\u0007K\u0002\u0001\u000b\u0011\u0002\u0019\u0002\u0017\t\u000bEk\u0011%`'&SV\t\t\u0005\bO\u0002\u0011\r\u0011\"\u00010\u0003QYU)\u0012)`\u00032Ke+R0Q\u000bJKu\nR0N'\"1\u0011\u000e\u0001Q\u0001\nA\nQcS#F!~\u000bE*\u0013,F?B+%+S(E?6\u001b\u0006\u0005C\u0004l\u0001\t\u0007I\u0011A\u0018\u0002!M\u0003F*\u0013+`'&SVi\u0018\"Z)\u0016\u001b\u0006BB7\u0001A\u0003%\u0001'A\tT!2KEkX*J5\u0016{&)\u0017+F'\u0002BQa\u001c\u0001\u0005BA\f\u0011b\u001d5peRt\u0015-\\3\u0015\u0003E\u0004\"A];\u000f\u00059\u0019\u0018B\u0001;\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011qG\u001e\u0006\u0003i>AQ\u0001\u001f\u0001\u0005Be\fab\u0019:fCR,'+\u001a7bi&|g\u000e\u0006\u0003{{\u0006\u001d\u0001C\u0001\u000b|\u0013\taXC\u0001\u0007CCN,'+\u001a7bi&|g\u000eC\u0003\u007fo\u0002\u0007q0\u0001\u0006tc2\u001cuN\u001c;fqR\u0004B!!\u0001\u0002\u00045\tq#C\u0002\u0002\u0006]\u0011!bU)M\u0007>tG/\u001a=u\u0011\u001d\tIa\u001ea\u0001\u0003\u0017\t!\u0002]1sC6,G/\u001a:t!\u0015\u0011\u0018QB9r\u0013\r\tyA\u001e\u0002\u0004\u001b\u0006\u0004\bB\u0002=\u0001\t\u0003\n\u0019\u0002F\u0004{\u0003+\t9\"!\u0007\t\ry\f\t\u00021\u0001\u0000\u0011!\tI!!\u0005A\u0002\u0005-\u0001\u0002CA\u000e\u0003#\u0001\r!!\b\u0002\rM\u001c\u0007.Z7b!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012/\u0005)A/\u001f9fg&!\u0011qEA\u0011\u0005)\u0019FO];diRK\b/\u001a\u0005\u0007q\u0002!\t%a\u000b\u0015\u0013i\fi#a\f\u0002:\u0005m\u0002B\u0002@\u0002*\u0001\u0007q\u0010\u0003\u0005\u00022\u0005%\u0002\u0019AA\u001a\u0003\u0011iw\u000eZ3\u0011\t\u0005\u0005\u0011QG\u0005\u0004\u0003o9\"\u0001C*bm\u0016lu\u000eZ3\t\u0011\u0005%\u0011\u0011\u0006a\u0001\u0003\u0017A\u0001\"!\u0010\u0002*\u0001\u0007\u0011qH\u0001\u0005I\u0006$\u0018\r\u0005\u0003\u0002B\u0005uc\u0002BA\"\u00033rA!!\u0012\u0002X9!\u0011qIA+\u001d\u0011\tI%a\u0015\u000f\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014\f\u0003\u0019a$o\\8u}%\t!\"\u0003\u0002\t\u0013%\u0011QaB\u0005\u00031eI1!a\u0017\u0018\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0018\u0002b\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u00037:\u0002bBA3\u0001\u0011\u0005\u0013qM\u0001\u000bGJ,\u0017\r^3TS:\\GCCA5\u0003s\nY(! \u0002\u0012B!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!C:ue\u0016\fW.\u001b8h\u0015\r\t\u0019hF\u0001\nKb,7-\u001e;j_:LA!a\u001e\u0002n\t!1+\u001b8l\u0011\u0019q\u00181\ra\u0001\u007f\"A\u0011\u0011BA2\u0001\u0004\tY\u0001\u0003\u0005\u0002\u0000\u0005\r\u0004\u0019AAA\u0003A\u0001\u0018M\u001d;ji&|gnQ8mk6t7\u000fE\u0003\u0002\u0004\u0006-\u0015O\u0004\u0003\u0002\u0006\u0006%e\u0002BA&\u0003\u000fK\u0011\u0001E\u0005\u0004\u00037z\u0011\u0002BAG\u0003\u001f\u00131aU3r\u0015\r\tYf\u0004\u0005\t\u0003'\u000b\u0019\u00071\u0001\u0002\u0016\u0006Qq.\u001e;qkRlu\u000eZ3\u0011\t\u0005]\u00151T\u0007\u0003\u00033S1!a\u001c\u0018\u0013\u0011\ti*!'\u0003\u0015=+H\u000f];u\u001b>$W\rC\u0004\u0002\"\u0002!I!a)\u0002\u0019\u001d,G\u000fV1cY\u0016t\u0015-\\3\u0015\u0007E\f)\u000b\u0003\u0005\u0002\n\u0005}\u0005\u0019AA\u0006\u0011\u001d\tI\u000b\u0001C\u0005\u0003W\u000babZ3u%\u0016\fGm\u00149uS>t7\u000f\u0006\u0003\u0002.\u0006M\u0006c\u0001\u0017\u00020&\u0019\u0011\u0011\u0017\u0002\u0003\u001f-+H-\u001e*fC\u0012|\u0005\u000f^5p]ND\u0001\"!\u0003\u0002(\u0002\u0007\u00111\u0002\u0005\b\u0003o\u0003A\u0011BA]\u0003=9W\r^,sSR,w\n\u001d;j_:\u001cH\u0003BA^\u0003\u0003\u00042\u0001LA_\u0013\r\tyL\u0001\u0002\u0011\u0017V$Wo\u0016:ji\u0016|\u0005\u000f^5p]ND\u0001\"!\u0003\u00026\u0002\u0007\u00111\u0002\u0005\b\u0003\u000b\u0004A\u0011BAd\u000399W\r^'bgR,'/\u00113eeN$2!]Ae\u0011!\tI!a1A\u0002\u0005-\u0001bBAg\u0001\u0011%\u0011qZ\u0001\u0014O\u0016$8kY1o\u0019>\u001c\u0017\r\\5usRK\b/\u001a\u000b\u0005\u0003#\fi\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9NB\u0001\u0007G2LWM\u001c;\n\t\u0005m\u0017Q\u001b\u0002\u0011%\u0016\u0004H.[2b'\u0016dWm\u0019;j_:Dq!a8\u0002L\u0002\u0007\u0011/A\u0004paB\u000b'/Y7\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u0006\u0001r-\u001a;Pa\u0016\u0014\u0018\r^5p]RK\b/\u001a\u000b\u0005\u0003O\fi\u000fE\u0002-\u0003SL1!a;\u0003\u00055y\u0005/\u001a:bi&|g\u000eV=qK\"A\u0011\u0011BAq\u0001\u0004\tY\u0001C\u0004\u0002r\u0002!I!a=\u0002+M$(/\u001b8h)>|\u0005/\u001a:bi&|g\u000eV=qKR!\u0011q]A{\u0011\u001d\ty.a<A\u0002ED3\u0001AA}!\u0011\tYPa\u0003\u000f\t\u0005u(qA\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005A\u0011-\u001e3jK:\u001cWMC\u0002\u0003\u0006\u001d\tQ!_3ukNLAA!\u0003\u0002\u0000\u0006\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u0011iAa\u0004\u0003\u0011Us7\u000f^1cY\u0016TAA!\u0003\u0002\u0000\"\u001a\u0001Aa\u0005\u0011\t\tU!1\u0004\b\u0005\u0003{\u00149\"\u0003\u0003\u0003\u001a\u0005}\u0018!E%oi\u0016\u0014h-Y2f\u0003V$\u0017.\u001a8dK&!!Q\u0004B\u0010\u0005\u001d\u0001&/\u001b<bi\u0016TAA!\u0007\u0002\u0000\u0002")
public class DefaultSource
implements DataSourceRegister,
RelationProvider,
CreatableRelationProvider,
SchemaRelationProvider,
StreamSinkProvider {
    private final String TABLE_KEY;
    private final String KUDU_MASTER;
    private final String OPERATION;
    private final String FAULT_TOLERANT_SCANNER;
    private final String SCAN_LOCALITY;
    private final String IGNORE_NULL;
    private final String IGNORE_DUPLICATE_ROW_ERRORS;
    private final String REPARTITION;
    private final String REPARTITION_SORT;
    private final String SCAN_REQUEST_TIMEOUT_MS;
    private final String SOCKET_READ_TIMEOUT_MS;
    private final String BATCH_SIZE;
    private final String KEEP_ALIVE_PERIOD_MS;
    private final String SPLIT_SIZE_BYTES;

    public String TABLE_KEY() {
        return this.TABLE_KEY;
    }

    public String KUDU_MASTER() {
        return this.KUDU_MASTER;
    }

    public String OPERATION() {
        return this.OPERATION;
    }

    public String FAULT_TOLERANT_SCANNER() {
        return this.FAULT_TOLERANT_SCANNER;
    }

    public String SCAN_LOCALITY() {
        return this.SCAN_LOCALITY;
    }

    public String IGNORE_NULL() {
        return this.IGNORE_NULL;
    }

    public String IGNORE_DUPLICATE_ROW_ERRORS() {
        return this.IGNORE_DUPLICATE_ROW_ERRORS;
    }

    public String REPARTITION() {
        return this.REPARTITION;
    }

    public String REPARTITION_SORT() {
        return this.REPARTITION_SORT;
    }

    public String SCAN_REQUEST_TIMEOUT_MS() {
        return this.SCAN_REQUEST_TIMEOUT_MS;
    }

    public String SOCKET_READ_TIMEOUT_MS() {
        return this.SOCKET_READ_TIMEOUT_MS;
    }

    public String BATCH_SIZE() {
        return this.BATCH_SIZE;
    }

    public String KEEP_ALIVE_PERIOD_MS() {
        return this.KEEP_ALIVE_PERIOD_MS;
    }

    public String SPLIT_SIZE_BYTES() {
        return this.SPLIT_SIZE_BYTES;
    }

    public String shortName() {
        return "kudu";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema2) {
        String tableName = this.getTableName(parameters);
        String kuduMaster = this.getMasterAddrs(parameters);
        OperationType operationType = this.getOperationType(parameters);
        Option schemaOption = Option$.MODULE$.apply((Object)schema2);
        KuduReadOptions readOptions = this.getReadOptions(parameters);
        KuduWriteOptions writeOptions = this.getWriteOptions(parameters);
        return new KuduRelation(tableName, kuduMaster, operationType, (Option<StructType>)schemaOption, readOptions, writeOptions, sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        BaseRelation kuduRelation = this.createRelation(sqlContext, parameters);
        SaveMode saveMode = mode;
        if (SaveMode.Append.equals(saveMode)) {
            ((KuduRelation)kuduRelation).insert(data, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return kuduRelation;
        }
        throw new UnsupportedOperationException("Currently, only Append is supported");
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        String tableName = this.getTableName(parameters);
        String masterAddrs = this.getMasterAddrs(parameters);
        OperationType operationType = this.getOperationType(parameters);
        KuduReadOptions readOptions = this.getReadOptions(parameters);
        KuduWriteOptions writeOptions = this.getWriteOptions(parameters);
        return new KuduSink(tableName, masterAddrs, operationType, readOptions, writeOptions, sqlContext);
    }

    private String getTableName(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.TABLE_KEY(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kudu table name must be specified in create options using key '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.TABLE_KEY()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private KuduReadOptions getReadOptions(Map<String, String> parameters) {
        int batchSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)this.BATCH_SIZE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return KuduReadOptions$.MODULE$.defaultBatchSize();
            }
        }));
        boolean faultTolerantScanner = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.FAULT_TOLERANT_SCANNER()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return KuduReadOptions$.MODULE$.defaultFaultTolerantScanner();
            }
        }));
        ReplicaSelection scanLocality = (ReplicaSelection)((Object)parameters.get((Object)this.SCAN_LOCALITY()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final ReplicaSelection apply(String opParam) {
                return this.$outer.org$apache$kudu$spark$kudu$DefaultSource$$getScanLocalityType(opParam);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaSelection apply() {
                return KuduReadOptions$.MODULE$.defaultScanLocality();
            }
        }));
        Option scanRequestTimeoutMs = parameters.get((Object)this.SCAN_REQUEST_TIMEOUT_MS()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
            }
        });
        long keepAlivePeriodMs = BoxesRunTime.unboxToLong((Object)parameters.get((Object)this.KEEP_ALIVE_PERIOD_MS()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return KuduReadOptions$.MODULE$.defaultKeepAlivePeriodMs();
            }
        }));
        Option splitSizeBytes = parameters.get((Object)this.SPLIT_SIZE_BYTES()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
            }
        });
        return new KuduReadOptions(batchSize, scanLocality, faultTolerantScanner, keepAlivePeriodMs, (Option<Object>)scanRequestTimeoutMs, (Option<Object>)None$.MODULE$, (Option<Object>)splitSizeBytes);
    }

    private KuduWriteOptions getWriteOptions(Map<String, String> parameters) {
        boolean ignoreDuplicateRowErrors = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, parameters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;
            private final Map parameters$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString((String)this.parameters$1.apply((Object)this.$outer.IGNORE_DUPLICATE_ROW_ERRORS()))).toBoolean();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parameters$1 = parameters$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        })) || BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, parameters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;
            private final Map parameters$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Object object = this.parameters$1.apply((Object)this.$outer.OPERATION());
                String string = "insert-ignore";
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parameters$1 = parameters$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        boolean ignoreNull = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.IGNORE_NULL()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return KuduWriteOptions$.MODULE$.defaultIgnoreNull();
            }
        }));
        boolean repartition = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.REPARTITION()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return KuduWriteOptions$.MODULE$.defaultRepartition();
            }
        }));
        boolean repartitionSort = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.REPARTITION_SORT()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return KuduWriteOptions$.MODULE$.defaultRepartitionSort();
            }
        }));
        return new KuduWriteOptions(ignoreDuplicateRowErrors, ignoreNull, repartition, repartitionSort);
    }

    private String getMasterAddrs(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.KUDU_MASTER(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
        });
    }

    public ReplicaSelection org$apache$kudu$spark$kudu$DefaultSource$$getScanLocalityType(String opParam) {
        block4: {
            ReplicaSelection replicaSelection;
            block3: {
                String string;
                block2: {
                    string = opParam.toLowerCase();
                    if (!"leader_only".equals(string)) break block2;
                    replicaSelection = ReplicaSelection.LEADER_ONLY;
                    break block3;
                }
                if (!"closest_replica".equals(string)) break block4;
                replicaSelection = ReplicaSelection.CLOSEST_REPLICA;
            }
            return replicaSelection;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported replica selection type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opParam})));
    }

    private OperationType getOperationType(Map<String, String> parameters) {
        return (OperationType)parameters.get((Object)this.OPERATION()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final OperationType apply(String opParam) {
                return this.$outer.org$apache$kudu$spark$kudu$DefaultSource$$stringToOperationType(opParam);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Upsert$ apply() {
                return Upsert$.MODULE$;
            }
        });
    }

    public OperationType org$apache$kudu$spark$kudu$DefaultSource$$stringToOperationType(String opParam) {
        block7: {
            OperationType operationType;
            block3: {
                String string;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                string = opParam.toLowerCase();
                                if (!"insert".equals(string)) break block2;
                                operationType = Insert$.MODULE$;
                                break block3;
                            }
                            if (!"insert-ignore".equals(string)) break block4;
                            operationType = Insert$.MODULE$;
                            break block3;
                        }
                        if (!"upsert".equals(string)) break block5;
                        operationType = Upsert$.MODULE$;
                        break block3;
                    }
                    if (!"update".equals(string)) break block6;
                    operationType = Update$.MODULE$;
                    break block3;
                }
                if (!"delete".equals(string)) break block7;
                operationType = Delete$.MODULE$;
            }
            return operationType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operation type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opParam})));
    }

    public DefaultSource() {
        this.TABLE_KEY = "kudu.table";
        this.KUDU_MASTER = "kudu.master";
        this.OPERATION = "kudu.operation";
        this.FAULT_TOLERANT_SCANNER = "kudu.faultTolerantScan";
        this.SCAN_LOCALITY = "kudu.scanLocality";
        this.IGNORE_NULL = "kudu.ignoreNull";
        this.IGNORE_DUPLICATE_ROW_ERRORS = "kudu.ignoreDuplicateRowErrors";
        this.REPARTITION = "kudu.repartition";
        this.REPARTITION_SORT = "kudu.repartition.sort";
        this.SCAN_REQUEST_TIMEOUT_MS = "kudu.scanRequestTimeoutMs";
        this.SOCKET_READ_TIMEOUT_MS = "kudu.socketReadTimeoutMs";
        this.BATCH_SIZE = "kudu.batchSize";
        this.KEEP_ALIVE_PERIOD_MS = "kudu.keepAlivePeriodMs";
        this.SPLIT_SIZE_BYTES = "kudu.splitSizeBytes";
    }
}

