/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import java.util.Random;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.spark.kudu.KuduContext;
import org.apache.kudu.spark.kudu.KuduWriteOptions;
import org.apache.kudu.spark.kudu.KuduWriteOptions$;
import org.apache.kudu.spark.kudu.RowConverter;
import org.apache.kudu.spark.kudu.SparkUtil$;
import org.apache.kudu.spark.tools.DistributedDataGeneratorOptions;
import org.apache.kudu.spark.tools.DistributedDataGeneratorOptions$;
import org.apache.kudu.spark.tools.GeneratedRowIterator;
import org.apache.kudu.spark.tools.GeneratorMetrics;
import org.apache.kudu.spark.tools.GeneratorMetrics$;
import org.apache.kudu.util.DataGenerator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class DistributedDataGenerator$ {
    public static final DistributedDataGenerator$ MODULE$;
    private final Logger log;

    static {
        new DistributedDataGenerator$();
    }

    public Logger log() {
        return this.log;
    }

    public GeneratorMetrics run(DistributedDataGeneratorOptions options, SparkSession ss) {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running a DistributedDataGenerator with options: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options})));
        SparkContext sc = ss.sparkContext();
        KuduContext context = new KuduContext(options.masterAddresses(), sc);
        GeneratorMetrics metrics = GeneratorMetrics$.MODULE$.apply(sc);
        RDD<Row> rdd = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), options.numTasks()), options.numTasks(), ClassTag$.MODULE$.Int()).mapPartitions((Function1)new Serializable(options, context){
            public static final long serialVersionUID = 0L;
            private final DistributedDataGeneratorOptions options$1;
            private final KuduContext context$1;

            public final GeneratedRowIterator apply(Iterator<Object> taskNumIter) {
                int taskNum = BoxesRunTime.unboxToInt((Object)taskNumIter.next());
                DataGenerator generator = new DataGenerator.DataGeneratorBuilder().random(new Random(this.options$1.seed() + (long)taskNum)).stringLength(this.options$1.stringLength()).binaryLength(this.options$1.binaryLength()).build();
                KuduTable table = this.context$1.syncClient().openTable(this.options$1.tableName());
                Schema schema2 = table.getSchema();
                long numRows = this.options$1.numRows() / (long)this.options$1.numTasks();
                long startRow = numRows * (long)taskNum;
                return new GeneratedRowIterator(generator, this.options$1.generatorType(), schema2, startRow, numRows);
            }
            {
                this.options$1 = options$1;
                this.context$1 = context$1;
            }
        }, true, ClassTag$.MODULE$.apply(Row.class));
        if (options.repartition()) {
            KuduTable table = context.syncClient().openTable(options.tableName());
            StructType sparkSchema = SparkUtil$.MODULE$.sparkSchema(table.getSchema(), SparkUtil$.MODULE$.sparkSchema$default$2());
            boolean x$1 = true;
            boolean x$2 = KuduWriteOptions$.MODULE$.apply$default$1();
            boolean x$3 = KuduWriteOptions$.MODULE$.apply$default$3();
            boolean x$4 = KuduWriteOptions$.MODULE$.apply$default$4();
            rdd = context.repartitionRows(rdd, options.tableName(), sparkSchema, new KuduWriteOptions(x$2, x$1, x$3, x$4));
        }
        rdd.foreachPartition((Function1)new Serializable(options, context, metrics){
            public static final long serialVersionUID = 0L;
            private final DistributedDataGeneratorOptions options$1;
            private final KuduContext context$1;
            private final GeneratorMetrics metrics$1;

            public final void apply(Iterator<Row> rows) {
                KuduClient kuduClient = this.context$1.syncClient();
                KuduTable table = kuduClient.openTable(this.options$1.tableName());
                Schema kuduSchema2 = table.getSchema();
                StructType sparkSchema = SparkUtil$.MODULE$.sparkSchema(kuduSchema2, SparkUtil$.MODULE$.sparkSchema$default$2());
                RowConverter converter = new RowConverter(kuduSchema2, sparkSchema, true);
                KuduSession session = kuduClient.newSession();
                session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
                IntRef rowsWritten = IntRef.create((int)0);
                rows.foreach((Function1)new Serializable(this, table, converter, session, rowsWritten){
                    public static final long serialVersionUID = 0L;
                    private final KuduTable table$1;
                    private final RowConverter converter$1;
                    private final KuduSession session$1;
                    private final IntRef rowsWritten$1;

                    public final void apply(Row row) {
                        Insert insert = this.table$1.newInsert();
                        PartialRow partialRow = this.converter$1.toPartialRow(row);
                        insert.setRow(partialRow);
                        this.session$1.apply(insert);
                        ++this.rowsWritten$1.elem;
                    }
                    {
                        this.table$1 = table$1;
                        this.converter$1 = converter$1;
                        this.session$1 = session$1;
                        this.rowsWritten$1 = rowsWritten$1;
                    }
                });
                session.flush();
                IntRef collisions = IntRef.create((int)0);
                Predef$.MODULE$.refArrayOps((Object[])session.getPendingErrors().getRowErrors()).foreach((Function1)new Serializable(this, rowsWritten, collisions){
                    public static final long serialVersionUID = 0L;
                    private final IntRef rowsWritten$1;
                    private final IntRef collisions$1;

                    public final void apply(RowError error) {
                        if (error.getErrorStatus().isAlreadyPresent()) {
                            --this.rowsWritten$1.elem;
                            ++this.collisions$1.elem;
                            return;
                        }
                        throw new RuntimeException(new StringBuilder().append((Object)"Kudu write error: ").append((Object)error.getErrorStatus().toString()).toString());
                    }
                    {
                        this.rowsWritten$1 = rowsWritten$1;
                        this.collisions$1 = collisions$1;
                    }
                });
                this.metrics$1.rowsWritten().add((long)rowsWritten.elem);
                this.metrics$1.collisions().add((long)collisions.elem);
                session.close();
            }
            {
                this.options$1 = options$1;
                this.context$1 = context$1;
                this.metrics$1 = metrics$1;
            }
        });
        return metrics;
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public GeneratorMetrics testMain(String[] args, SparkSession ss) {
        Option<DistributedDataGeneratorOptions> option = DistributedDataGeneratorOptions$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Could not parse arguments");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            DistributedDataGeneratorOptions config = (DistributedDataGeneratorOptions)some.x();
            GeneratorMetrics generatorMetrics = this.run(config, ss);
            return generatorMetrics;
        }
        throw new MatchError(option);
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("DistributedDataGenerator");
        SparkSession ss = SparkSession$.MODULE$.builder().config(conf).getOrCreate();
        GeneratorMetrics metrics = this.testMain(args, ss);
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rows written: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metrics.rowsWritten().value()})));
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Collisions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metrics.collisions().value()})));
    }

    private DistributedDataGenerator$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

