/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import org.apache.kudu.shaded.scopt.OptionParser;
import org.apache.kudu.shaded.scopt.Read$;
import org.apache.kudu.spark.tools.DistributedDataGeneratorOptions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DistributedDataGeneratorOptions$
implements Serializable {
    public static final DistributedDataGeneratorOptions$ MODULE$;
    private final long DefaultNumRows;
    private final int DefaultNumTasks;
    private final int DefaultStringLength;
    private final int DefaultBinaryLength;
    private final String RandomGenerator;
    private final String SequentialGenerator;
    private final String DefaultGeneratorType;
    private final boolean DefaultRepartition;
    private final OptionParser<DistributedDataGeneratorOptions> parser;

    static {
        new DistributedDataGeneratorOptions$();
    }

    public long DefaultNumRows() {
        return this.DefaultNumRows;
    }

    public int DefaultNumTasks() {
        return this.DefaultNumTasks;
    }

    public int DefaultStringLength() {
        return this.DefaultStringLength;
    }

    public int DefaultBinaryLength() {
        return this.DefaultBinaryLength;
    }

    public String RandomGenerator() {
        return this.RandomGenerator;
    }

    public String SequentialGenerator() {
        return this.SequentialGenerator;
    }

    public String DefaultGeneratorType() {
        return this.DefaultGeneratorType;
    }

    public boolean DefaultRepartition() {
        return this.DefaultRepartition;
    }

    private OptionParser<DistributedDataGeneratorOptions> parser() {
        return this.parser;
    }

    public Option<DistributedDataGeneratorOptions> parse(Seq<String> args) {
        return this.parser().parse(args, new DistributedDataGeneratorOptions("", "", this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9()));
    }

    public DistributedDataGeneratorOptions apply(String tableName, String masterAddresses, String generatorType, long numRows, int numTasks, int stringLength, int binaryLength, long seed, boolean repartition) {
        return new DistributedDataGeneratorOptions(tableName, masterAddresses, generatorType, numRows, numTasks, stringLength, binaryLength, seed, repartition);
    }

    public Option<Tuple9<String, String, String, Object, Object, Object, Object, Object, Object>> unapply(DistributedDataGeneratorOptions x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.tableName(), (Object)x$0.masterAddresses(), (Object)x$0.generatorType(), (Object)BoxesRunTime.boxToLong((long)x$0.numRows()), (Object)BoxesRunTime.boxToInteger((int)x$0.numTasks()), (Object)BoxesRunTime.boxToInteger((int)x$0.stringLength()), (Object)BoxesRunTime.boxToInteger((int)x$0.binaryLength()), (Object)BoxesRunTime.boxToLong((long)x$0.seed()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.repartition())));
    }

    public String $lessinit$greater$default$3() {
        return this.DefaultGeneratorType();
    }

    public long $lessinit$greater$default$4() {
        return this.DefaultNumRows();
    }

    public int $lessinit$greater$default$5() {
        return this.DefaultNumTasks();
    }

    public int $lessinit$greater$default$6() {
        return this.DefaultStringLength();
    }

    public int $lessinit$greater$default$7() {
        return this.DefaultStringLength();
    }

    public long $lessinit$greater$default$8() {
        return System.currentTimeMillis();
    }

    public boolean $lessinit$greater$default$9() {
        return this.DefaultRepartition();
    }

    public String apply$default$3() {
        return this.DefaultGeneratorType();
    }

    public long apply$default$4() {
        return this.DefaultNumRows();
    }

    public int apply$default$5() {
        return this.DefaultNumTasks();
    }

    public int apply$default$6() {
        return this.DefaultStringLength();
    }

    public int apply$default$7() {
        return this.DefaultStringLength();
    }

    public long apply$default$8() {
        return System.currentTimeMillis();
    }

    public boolean apply$default$9() {
        return this.DefaultRepartition();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DistributedDataGeneratorOptions$() {
        MODULE$ = this;
        this.DefaultNumRows = 10000L;
        this.DefaultNumTasks = 1;
        this.DefaultStringLength = 128;
        this.DefaultBinaryLength = 128;
        this.RandomGenerator = "random";
        this.SequentialGenerator = "sequential";
        this.DefaultGeneratorType = this.SequentialGenerator();
        this.DefaultRepartition = false;
        this.parser = new OptionParser<DistributedDataGeneratorOptions>(){
            {
                this.arg("table-name", Read$.MODULE$.stringRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(String v, DistributedDataGeneratorOptions o) {
                        return o.copy(v, o.copy$default$2(), o.copy$default$3(), o.copy$default$4(), o.copy$default$5(), o.copy$default$6(), o.copy$default$7(), o.copy$default$8(), o.copy$default$9());
                    }
                }).text("The table to load with random data");
                this.arg("master-addresses", Read$.MODULE$.stringRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(String v, DistributedDataGeneratorOptions o) {
                        String x$5 = v;
                        String x$6 = o.copy$default$1();
                        String x$7 = o.copy$default$3();
                        long x$8 = o.copy$default$4();
                        int x$9 = o.copy$default$5();
                        int x$10 = o.copy$default$6();
                        int x$11 = o.copy$default$7();
                        long x$12 = o.copy$default$8();
                        boolean x$13 = o.copy$default$9();
                        return o.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
                    }
                }).text("Comma-separated addresses of Kudu masters");
                this.opt("type", Read$.MODULE$.stringRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(String v, DistributedDataGeneratorOptions o) {
                        String x$14 = v;
                        String x$15 = o.copy$default$1();
                        String x$16 = o.copy$default$2();
                        long x$17 = o.copy$default$4();
                        int x$18 = o.copy$default$5();
                        int x$19 = o.copy$default$6();
                        int x$20 = o.copy$default$7();
                        long x$21 = o.copy$default$8();
                        boolean x$22 = o.copy$default$9();
                        return o.copy(x$15, x$16, x$14, x$17, x$18, x$19, x$20, x$21, x$22);
                    }
                }).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The type of data generator. Must be one of 'random' or 'sequential'. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DistributedDataGeneratorOptions$.MODULE$.DefaultGeneratorType()}))).toString()).optional();
                this.opt("num-rows", Read$.MODULE$.longRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(long v, DistributedDataGeneratorOptions o) {
                        long x$23 = v;
                        String x$24 = o.copy$default$1();
                        String x$25 = o.copy$default$2();
                        String x$26 = o.copy$default$3();
                        int x$27 = o.copy$default$5();
                        int x$28 = o.copy$default$6();
                        int x$29 = o.copy$default$7();
                        long x$30 = o.copy$default$8();
                        boolean x$31 = o.copy$default$9();
                        return o.copy(x$24, x$25, x$26, x$23, x$27, x$28, x$29, x$30, x$31);
                    }
                }).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The total number of unique rows to generate. Default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)DistributedDataGeneratorOptions$.MODULE$.DefaultNumRows())}))).optional();
                this.opt("num-tasks", Read$.MODULE$.intRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(int v, DistributedDataGeneratorOptions o) {
                        int x$32 = v;
                        String x$33 = o.copy$default$1();
                        String x$34 = o.copy$default$2();
                        String x$35 = o.copy$default$3();
                        long x$36 = o.copy$default$4();
                        int x$37 = o.copy$default$6();
                        int x$38 = o.copy$default$7();
                        long x$39 = o.copy$default$8();
                        boolean x$40 = o.copy$default$9();
                        return o.copy(x$33, x$34, x$35, x$36, x$32, x$37, x$38, x$39, x$40);
                    }
                }).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The total number of Spark tasks to use when generating data. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DistributedDataGeneratorOptions$.MODULE$.DefaultNumTasks())}))).toString()).optional();
                this.opt("string-length", Read$.MODULE$.intRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(int v, DistributedDataGeneratorOptions o) {
                        int x$41 = v;
                        String x$42 = o.copy$default$1();
                        String x$43 = o.copy$default$2();
                        String x$44 = o.copy$default$3();
                        long x$45 = o.copy$default$4();
                        int x$46 = o.copy$default$5();
                        int x$47 = o.copy$default$7();
                        long x$48 = o.copy$default$8();
                        boolean x$49 = o.copy$default$9();
                        return o.copy(x$42, x$43, x$44, x$45, x$46, x$41, x$47, x$48, x$49);
                    }
                }).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The length of generated string fields. Default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DistributedDataGeneratorOptions$.MODULE$.DefaultStringLength())}))).optional();
                this.opt("binary-length", Read$.MODULE$.intRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(int v, DistributedDataGeneratorOptions o) {
                        int x$50 = v;
                        String x$51 = o.copy$default$1();
                        String x$52 = o.copy$default$2();
                        String x$53 = o.copy$default$3();
                        long x$54 = o.copy$default$4();
                        int x$55 = o.copy$default$5();
                        int x$56 = o.copy$default$6();
                        long x$57 = o.copy$default$8();
                        boolean x$58 = o.copy$default$9();
                        return o.copy(x$51, x$52, x$53, x$54, x$55, x$56, x$50, x$57, x$58);
                    }
                }).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The length of generated binary fields. Default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DistributedDataGeneratorOptions$.MODULE$.DefaultBinaryLength())}))).optional();
                this.opt("seed", Read$.MODULE$.longRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(long v, DistributedDataGeneratorOptions o) {
                        long x$59 = v;
                        String x$60 = o.copy$default$1();
                        String x$61 = o.copy$default$2();
                        String x$62 = o.copy$default$3();
                        long x$63 = o.copy$default$4();
                        int x$64 = o.copy$default$5();
                        int x$65 = o.copy$default$6();
                        int x$66 = o.copy$default$7();
                        boolean x$67 = o.copy$default$9();
                        return o.copy(x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$59, x$67);
                    }
                }).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The seed to use in the random data generator. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default: `System.currentTimeMillis()`"})).s((Seq)Nil$.MODULE$)).toString());
                this.opt("repartition", Read$.MODULE$.booleanRead()).action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DistributedDataGeneratorOptions apply(boolean v, DistributedDataGeneratorOptions o) {
                        boolean x$68 = v;
                        String x$69 = o.copy$default$1();
                        String x$70 = o.copy$default$2();
                        String x$71 = o.copy$default$3();
                        long x$72 = o.copy$default$4();
                        int x$73 = o.copy$default$5();
                        int x$74 = o.copy$default$6();
                        int x$75 = o.copy$default$7();
                        long x$76 = o.copy$default$8();
                        return o.copy(x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$68);
                    }
                }).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repartition the data to ensure each spark task talks to a minimal "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"set of tablet servers."})).s((Seq)Nil$.MODULE$)).toString());
            }
        };
    }
}

