/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Update;
import org.apache.kudu.mapreduce.tools.BigLinkedListCommon;
import org.apache.kudu.spark.kudu.KuduContext;
import org.apache.kudu.spark.tools.Generator;
import org.apache.kudu.spark.tools.Generator$Args$;
import org.apache.kudu.spark.tools.IntegrationTestBigLinkedList$;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

public final class Generator$ {
    public static final Generator$ MODULE$;

    static {
        new Generator$();
    }

    public String usage() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       | Usage: generate --tasks=<tasks> --lists=<lists> --nodes=<nodes>\n       |                 --hash-partitions=<hash-partitions> --range-partitions=<range-partitions>\n       |                 --replicas=<replicas> --master-addrs=<master-addrs> --table-name=<table-name>\n       |    where\n       |      tasks: number of Spark tasks to create, default: 1\n       |      lists: number of linked lists to create per task, default: 1\n       |      nodes: number of nodes to create per list, default: 10000000\n       |      hashPartitions: number of hash partitions to create for the new linked list table, if it doesn't exist, default: 1\n       |      rangePartitions: number of range partitions to create for the new linked list table, if it doesn't exist, default: 1\n       |      replicas: number of replicas to create for the new linked list table, if it doesn't exist, default: 1\n       |      master-addrs: comma separated addresses of Kudu master nodes, default: ", "\n       |      table-name: the name of the linked list table, default: ", "\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{IntegrationTestBigLinkedList$.MODULE$.defaultMasterAddrs(), "default.IntegrationTestBigLinkedList"})))).stripMargin();
    }

    public void run(Generator.Args args, SparkSession ss) {
        Object object;
        KuduContext kc = new KuduContext(args.masterAddrs(), ss.sparkContext());
        String applicationId = ss.sparkContext().applicationId();
        KuduClient client = kc.syncClient();
        if (client.tableExists(args.tableName())) {
            object = BoxedUnit.UNIT;
        } else {
            Schema schema2 = BigLinkedListCommon.getTableSchema();
            CreateTableOptions options = BigLinkedListCommon.getCreateTableOptions(schema2, args.replicas(), args.rangePartitions(), args.hashPartitions());
            object = client.createTable(args.tableName(), BigLinkedListCommon.getTableSchema(), options);
        }
        ss.sparkContext().makeRDD((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.tasks()), args.tasks(), ClassTag$.MODULE$.Int()).foreach((Function1)new Serializable(args, kc, applicationId){
            public static final long serialVersionUID = 0L;
            private final Generator.Args args$1;
            private final KuduContext kc$1;
            private final String applicationId$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                Generator$.MODULE$.generate(this.args$1, this.applicationId$1, this.kc$1);
            }
            {
                this.args$1 = args$1;
                this.kc$1 = kc$1;
                this.applicationId$1 = applicationId$1;
            }
        });
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Integration Test Big Linked List Generator");
        SparkSession ss = SparkSession$.MODULE$.builder().config(conf).getOrCreate();
        this.run(Generator$Args$.MODULE$.parse(args), ss);
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public void testMain(String[] args, SparkSession ss) {
        this.run(Generator$Args$.MODULE$.parse(args), ss);
    }

    /*
     * WARNING - void declaration
     */
    public void generate(Generator.Args args, String applicationId, KuduContext kc) {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        String clientId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationId, BoxesRunTime.boxToInteger((int)taskContext.partitionId())}));
        BigLinkedListCommon.Xoroshiro128PlusRandom rand = new BigLinkedListCommon.Xoroshiro128PlusRandom();
        KuduClient client = kc.syncClient();
        KuduTable table = client.openTable(args.tableName());
        KuduSession session = client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.lists()).foreach$mVc$sp((Function1)new Serializable(args, clientId, rand, table, session){
                public static final long serialVersionUID = 0L;
                private final Generator.Args args$2;
                private final String clientId$1;
                private final BigLinkedListCommon.Xoroshiro128PlusRandom rand$1;
                private final KuduTable table$1;
                private final KuduSession session$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    long start = System.nanoTime();
                    Generator$.MODULE$.insertList(this.clientId$1, this.args$2, this.table$1, this.session$1, this.rand$1);
                    IntegrationTestBigLinkedList$.MODULE$.LOG().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " inserted ", " node linked list in {}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clientId$1, BoxesRunTime.boxToInteger((int)this.args$2.nodes())})), new Object[]{IntegrationTestBigLinkedList$.MODULE$.nanosToHuman(System.nanoTime() - start)});
                }
                {
                    this.args$2 = args$2;
                    this.clientId$1 = clientId$1;
                    this.rand$1 = rand$1;
                    this.table$1 = table$1;
                    this.session$1 = session$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var9_9;
            var9_9.close();
            throw throwable;
        }
        session.close();
    }

    public void insertList(String clientId, Generator.Args args, KuduTable table, KuduSession session, BigLinkedListCommon.Xoroshiro128PlusRandom rand) {
        long headKeyOne = rand.nextLong();
        long headKeyTwo = rand.nextLong();
        Insert insert = table.newInsert();
        insert.getRow().addLong(0, headKeyOne);
        insert.getRow().addLong(1, headKeyTwo);
        insert.getRow().addLong(4, 0L);
        insert.getRow().addString(5, clientId);
        insert.getRow().addInt(6, 0);
        session.apply(insert);
        LongRef prevKeyOne = LongRef.create((long)headKeyOne);
        LongRef prevKeyTwo = LongRef.create((long)headKeyTwo);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), args.nodes()).foreach$mVc$sp((Function1)new Serializable(clientId, table, session, rand, prevKeyOne, prevKeyTwo){
            public static final long serialVersionUID = 0L;
            private final String clientId$2;
            private final KuduTable table$2;
            private final KuduSession session$2;
            private final BigLinkedListCommon.Xoroshiro128PlusRandom rand$2;
            private final LongRef prevKeyOne$1;
            private final LongRef prevKeyTwo$1;

            public final void apply(int rowIdx) {
                this.apply$mcVI$sp(rowIdx);
            }

            public void apply$mcVI$sp(int rowIdx) {
                long keyOne = this.rand$2.nextLong();
                long keyTwo = this.rand$2.nextLong();
                Insert insert = this.table$2.newInsert();
                insert.getRow().addLong(0, keyOne);
                insert.getRow().addLong(1, keyTwo);
                insert.getRow().addLong(2, this.prevKeyOne$1.elem);
                insert.getRow().addLong(3, this.prevKeyTwo$1.elem);
                insert.getRow().addLong(4, (long)rowIdx);
                insert.getRow().addString(5, this.clientId$2);
                insert.getRow().addInt(6, 0);
                this.session$2.apply(insert);
                this.prevKeyOne$1.elem = keyOne;
                this.prevKeyTwo$1.elem = keyTwo;
            }
            {
                this.clientId$2 = clientId$2;
                this.table$2 = table$2;
                this.session$2 = session$2;
                this.rand$2 = rand$2;
                this.prevKeyOne$1 = prevKeyOne$1;
                this.prevKeyTwo$1 = prevKeyTwo$1;
            }
        });
        Update update = table.newUpdate();
        update.getRow().addLong(0, headKeyOne);
        update.getRow().addLong(1, headKeyTwo);
        update.getRow().addLong(2, prevKeyOne.elem);
        update.getRow().addLong(3, prevKeyTwo.elem);
        session.apply(update);
        session.flush();
        RowErrorsAndOverflowStatus errors = session.getPendingErrors();
        if (errors.getRowErrors().length > 0) {
            throw new RuntimeException(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])errors.getRowErrors()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(RowError x$3) {
                    return x$3.getErrorStatus().toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("Row errors: [", ", ", "]"));
        }
    }

    private Generator$() {
        MODULE$ = this;
    }
}

