/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import java.net.InetAddress;
import org.apache.kudu.spark.tools.Generator$;
import org.apache.kudu.spark.tools.Looper$;
import org.apache.kudu.spark.tools.Verifier$;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Try$;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class IntegrationTestBigLinkedList$ {
    public static final IntegrationTestBigLinkedList$ MODULE$;
    private final Logger LOG;

    static {
        new IntegrationTestBigLinkedList$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String usage() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       | Usage: COMMAND [COMMAND options]\");\n       |    where COMMAND is one of:\n       |\n       |        generate    A Spark job that generates linked list data.\n       |\n       |        verify      A Spark job that verifies generated linked list data.\n       |                    Fails the job if any UNDEFINED, UNREFERENCED, or\n       |                    EXTRAREFERENCES nodes are found. Do not run at the\n       |                     same time as the Generate command.\n       |\n       |        loop        Loops the generate and verify jobs indefinitely.\n       |                    Data is not cleaned between runs, so each iteration\n       |                    adds more data.\n    "})).s((Seq)Nil$.MODULE$))).stripMargin();
    }

    public int parseIntFlag(String flag, String num) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)new Serializable(num){
            public static final long serialVersionUID = 0L;
            private final String num$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.num$1)).toInt();
            }
            {
                this.num$1 = num$1;
            }
        }).getOrElse((Function0)new Serializable(flag, num){
            public static final long serialVersionUID = 0L;
            private final String flag$1;
            private final String num$1;

            public final Nothing$ apply() {
                return IntegrationTestBigLinkedList$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to parse ", " value as integer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flag$1, this.num$1})));
            }
            {
                this.flag$1 = flag$1;
                this.num$1 = num$1;
            }
        }));
    }

    public long parseLongFlag(String flag, String num) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(num){
            public static final long serialVersionUID = 0L;
            private final String num$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.num$2)).toLong();
            }
            {
                this.num$2 = num$2;
            }
        }).getOrElse((Function0)new Serializable(flag, num){
            public static final long serialVersionUID = 0L;
            private final String flag$2;
            private final String num$2;

            public final Nothing$ apply() {
                return IntegrationTestBigLinkedList$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to parse ", " value as integer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flag$2, this.num$2})));
            }
            {
                this.flag$2 = flag$2;
                this.num$2 = num$2;
            }
        }));
    }

    public Nothing$ fail(String msg) {
        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILURE: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})));
        return package$.MODULE$.exit(1);
    }

    public String nanosToHuman(long n) {
        return (double)n > 6.0E11 ? new StringOps(Predef$.MODULE$.augmentString("%s.3m")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)n / 6.0E10))})) : ((double)n > 1.0E9 ? new StringOps(Predef$.MODULE$.augmentString("%s.3s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)n / 1.0E9))})) : ((double)n > 1000000.0 ? new StringOps(Predef$.MODULE$.augmentString("%s.3ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)n / 1000000.0))})) : ((double)n > 1000.0 ? new StringOps(Predef$.MODULE$.augmentString("%s.3\u03bcs")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)n / 1000.0))})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n)})))));
    }

    public String defaultMasterAddrs() {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public void main(String[] args) {
        block7: {
            block5: {
                String string;
                block6: {
                    block4: {
                        if (Predef$.MODULE$.refArrayOps((Object[])args).isEmpty()) {
                            throw this.fail(this.usage());
                        }
                        string = args[0].toLowerCase();
                        if (!"generate".equals(string)) break block4;
                        Generator$.MODULE$.main((String[])Predef$.MODULE$.refArrayOps((Object[])args).slice(1, args.length));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    if (!"verify".equals(string)) break block6;
                    Verifier$.MODULE$.main((String[])Predef$.MODULE$.refArrayOps((Object[])args).slice(1, args.length));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!"loop".equals(string)) break block7;
                Looper$.MODULE$.main((String[])Predef$.MODULE$.refArrayOps((Object[])args).slice(1, args.length));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw this.fail(this.usage());
    }

    private IntegrationTestBigLinkedList$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

