/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.tools;

import org.apache.kudu.spark.tools.IntegrationTestBigLinkedList$;
import org.apache.kudu.spark.tools.Verifier;
import org.apache.kudu.spark.tools.Verifier$Args$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Verifier$ {
    public static final Verifier$ MODULE$;

    static {
        new Verifier$();
    }

    public String usage() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       | Usage: verify --nodes=<nodes> --master-addrs=<master-addrs> --table-name=<table-name>\n       |    where\n       |      nodes: number of nodes expected to be in the linked list table\n       |      master-addrs: comma separated addresses of Kudu master nodes, default: ", "\n       |      table-name: the name of the linked list table, default: ", "\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{IntegrationTestBigLinkedList$.MODULE$.defaultMasterAddrs(), "default.IntegrationTestBigLinkedList"})))).stripMargin();
    }

    public Option<String> verify(Option<Object> expected, Verifier.Counts counts) {
        return expected.exists((Function1)new Serializable(counts){
            public static final long serialVersionUID = 0L;
            private final Verifier.Counts counts$1;

            public final boolean apply(long x$5) {
                return this.apply$mcZJ$sp(x$5);
            }

            public boolean apply$mcZJ$sp(long x$5) {
                return x$5 != this.counts$1.referenced();
            }
            {
                this.counts$1 = counts$1;
            }
        }) ? new Some((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " referenced nodes, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)counts.referenced())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which does not match the expected count of ", " nodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected.get()}))).toString()) : (counts.unreferenced() > 0L ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " unreferenced nodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)counts.unreferenced())}))) : (counts.undefined() > 0L ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " undefined nodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)counts.undefined())}))) : (counts.extrareferences() > 0L ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " extra-referenced nodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)counts.extrareferences())}))) : None$.MODULE$)));
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public Verifier.Counts run(Verifier.Args args, SparkSession ss) {
        SQLContext sql = ss.sqlContext();
        sql.read().option("kudu.master", args.masterAddrs()).option("kudu.table", args.tableName()).format("kudu").load().createOrReplaceTempView("nodes");
        sql.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT (SELECT COUNT(*)\n         |         FROM nodes t2\n         |         WHERE t1.", " = t2.", "\n         |           AND t1.", " = t2.", ") AS ref_count\n         | FROM nodes t1\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key1", "prev1", "key2", "prev2"})))).stripMargin()).createOrReplaceTempView("ref_counts");
        sql.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT (CASE WHEN ref_count > 1 THEN 2 ELSE ref_count END) as ref_count\n         | FROM ref_counts\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).createOrReplaceTempView("ref_counts");
        sql.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT ref_count, COUNT(*) as nodes\n         | FROM ref_counts\n         | GROUP BY ref_count\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).createOrReplaceTempView("ref_counts");
        sql.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT CASE WHEN ref_count = 0 THEN \"UNREFERENCED\"\n         |             WHEN ref_count = 1 THEN \"REFERENCED\"\n         |             ELSE \"EXTRAREFERENCES\" END as state,\n         |        nodes\n         | FROM ref_counts\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).createOrReplaceTempView("ref_counts");
        sql.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT ", " as list, \"UNDEFINED\" as state, COUNT(*) as nodes\n         | FROM nodes t1\n         | WHERE ", " IS NOT NULL\n         |   AND ", " IS NOT NULL\n         |   AND NOT EXISTS (\n         |       SELECT * FROM nodes t2\n         |       WHERE t1.", " = t2.", "\n         |         AND t1.", " = t2.", ")\n         | GROUP BY ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"client", "prev1", "prev2", "prev1", "key1", "prev2", "key2", "client"})))).stripMargin()).createOrReplaceTempView("undefined");
        Row[] rows = (Row[])sql.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT state, nodes FROM ref_counts\n         | UNION ALL\n         | SELECT state, nodes FROM undefined\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).collect();
        return (Verifier.Counts)Predef$.MODULE$.refArrayOps((Object[])rows).foldLeft((Object)new Verifier.Counts(0L, 0L, 0L, 0L), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Verifier.Counts apply(Verifier.Counts counts, Row row) {
                String string;
                block6: {
                    Verifier.Counts counts2;
                    block3: {
                        long count;
                        block5: {
                            block4: {
                                block2: {
                                    String state = row.getString(0);
                                    count = row.getLong(1);
                                    string = state;
                                    if (!"REFERENCED".equals(string)) break block2;
                                    counts2 = counts.copy(count, counts.copy$default$2(), counts.copy$default$3(), counts.copy$default$4());
                                    break block3;
                                }
                                if (!"UNREFERENCED".equals(string)) break block4;
                                long x$69 = count;
                                long x$70 = counts.copy$default$1();
                                long x$71 = counts.copy$default$3();
                                long x$72 = counts.copy$default$4();
                                counts2 = counts.copy(x$70, x$69, x$71, x$72);
                                break block3;
                            }
                            if (!"UNDEFINED".equals(string)) break block5;
                            long x$73 = count;
                            long x$74 = counts.copy$default$1();
                            long x$75 = counts.copy$default$2();
                            long x$76 = counts.copy$default$3();
                            counts2 = counts.copy(x$74, x$75, x$76, x$73);
                            break block3;
                        }
                        if (!"EXTRAREFERENCES".equals(string)) break block6;
                        long x$77 = count;
                        long x$78 = counts.copy$default$1();
                        long x$79 = counts.copy$default$2();
                        long x$80 = counts.copy$default$4();
                        counts2 = counts.copy(x$78, x$79, x$77, x$80);
                    }
                    return counts2;
                }
                throw new MatchError((Object)string);
            }
        });
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public Verifier.Counts testMain(String[] arguments2, SparkSession ss) {
        return this.run(Verifier$Args$.MODULE$.parse(arguments2), ss);
    }

    public void main(String[] arguments2) {
        Verifier.Args args = Verifier$Args$.MODULE$.parse(arguments2);
        SparkConf conf = new SparkConf().setAppName("Integration Test Big Linked List Generator");
        SparkSession ss = SparkSession$.MODULE$.builder().config(conf).getOrCreate();
        Verifier.Counts counts = this.run(Verifier$Args$.MODULE$.parse(arguments2), ss);
        this.verify(args.nodes(), counts).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                return IntegrationTestBigLinkedList$.MODULE$.fail(msg);
            }
        });
    }

    private Verifier$() {
        MODULE$ = this;
    }
}

