/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public class AvroTestUtil {
    public static Schema record(String name, Schema.Field ... fields) {
        Schema record = Schema.createRecord((String)name, null, null, (boolean)false);
        record.setFields(Arrays.asList(fields));
        return record;
    }

    public static Schema.Field field(String name, Schema schema) {
        return new Schema.Field(name, schema, null, null);
    }

    public static Schema.Field optionalField(String name, Schema schema) {
        return new Schema.Field(name, AvroTestUtil.optional(schema), null, (JsonNode)NullNode.getInstance());
    }

    public static Schema array(Schema element) {
        return Schema.createArray((Schema)element);
    }

    public static Schema primitive(Schema.Type type) {
        return Schema.create((Schema.Type)type);
    }

    public static Schema optional(Schema original) {
        return Schema.createUnion((List)Lists.newArrayList((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), original}));
    }

    public static GenericRecord instance(Schema schema, Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new RuntimeException("Not enough values");
        }
        GenericData.Record record = new GenericData.Record(schema);
        for (int i = 0; i < pairs.length; i += 2) {
            record.put(pairs[i].toString(), pairs[i + 1]);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D> List<D> read(GenericData model, Schema schema, File file) throws IOException {
        ArrayList<Object> data = new ArrayList<Object>();
        Configuration conf = new Configuration(false);
        AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)schema);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)schema);
        try (ParquetReader fileReader = AvroParquetReader.builder((Path)new Path(file.toString())).withDataModel(model).withConf(conf).build();){
            Object datum;
            while ((datum = fileReader.read()) != null) {
                data.add(datum);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D> File write(TemporaryFolder temp, GenericData model, Schema schema, D ... data) throws IOException {
        File file = temp.newFile();
        Assert.assertTrue((boolean)file.delete());
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)new Path(file.toString())).withDataModel(model).withSchema(schema).build();){
            for (D datum : data) {
                writer.write(datum);
            }
        }
        return file;
    }
}

