/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAvroSchemaConverter {
    private static final Configuration NEW_BEHAVIOR = new Configuration(false);
    public static final String ALL_PARQUET_SCHEMA = "message org.apache.parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated int32 array;\n  }\n  optional group myoptionalarray (LIST) {\n    repeated int32 array;\n  }\n  required group myarrayofoptional (LIST) {\n    repeated group list {\n      optional int32 element;\n    }\n  }\n  required group myrecordarray (LIST) {\n    repeated group array {\n      required int32 a;\n      required int32 b;\n    }\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n";

    @BeforeClass
    public static void setupConf() {
        NEW_BEHAVIOR.setBoolean("parquet.avro.add-list-element-records", false);
        NEW_BEHAVIOR.setBoolean("parquet.avro.write-old-list-structure", false);
    }

    private void testAvroToParquetConversion(Schema avroSchema, String schemaString) throws Exception {
        this.testAvroToParquetConversion(new Configuration(false), avroSchema, schemaString);
    }

    private void testAvroToParquetConversion(Configuration conf, Schema avroSchema, String schemaString) throws Exception {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(conf);
        MessageType schema = avroSchemaConverter.convert(avroSchema);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)schemaString);
        Assert.assertEquals((String)("converting " + schema + " to " + schemaString), (Object)expectedMT.toString(), (Object)schema.toString());
    }

    private void testParquetToAvroConversion(Schema avroSchema, String schemaString) throws Exception {
        this.testParquetToAvroConversion(new Configuration(false), avroSchema, schemaString);
    }

    private void testParquetToAvroConversion(Configuration conf, Schema avroSchema, String schemaString) throws Exception {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(conf);
        Schema schema = avroSchemaConverter.convert(MessageTypeParser.parseMessageType((String)schemaString));
        Assert.assertEquals((String)("converting " + schemaString + " to " + avroSchema), (Object)avroSchema.toString(), (Object)schema.toString());
    }

    private void testRoundTripConversion(Schema avroSchema, String schemaString) throws Exception {
        this.testRoundTripConversion(new Configuration(), avroSchema, schemaString);
    }

    private void testRoundTripConversion(Configuration conf, Schema avroSchema, String schemaString) throws Exception {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter(conf);
        MessageType schema = avroSchemaConverter.convert(avroSchema);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)schemaString);
        Assert.assertEquals((String)("converting " + schema + " to " + schemaString), (Object)expectedMT.toString(), (Object)schema.toString());
        Schema convertedAvroSchema = avroSchemaConverter.convert(expectedMT);
        Assert.assertEquals((String)("converting " + expectedMT + " to " + avroSchema.toString(true)), (Object)avroSchema.toString(), (Object)convertedAvroSchema.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTopLevelMustBeARecord() {
        new AvroSchemaConverter().convert(Schema.create((Schema.Type)Schema.Type.INT));
    }

    @Test
    public void testAllTypes() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"all.avsc").openStream());
        this.testAvroToParquetConversion(NEW_BEHAVIOR, schema, "message org.apache.parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated group list {\n      required int32 element;\n    }\n  }\n  required group myemptyarray (LIST) {\n    repeated group list {\n      required int32 element;\n    }\n  }\n  optional group myoptionalarray (LIST) {\n    repeated group list {\n      required int32 element;\n    }\n  }\n  required group myarrayofoptional (LIST) {\n    repeated group list {\n      optional int32 element;\n    }\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required group myemptymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n");
    }

    @Test
    public void testAllTypesOldListBehavior() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"all.avsc").openStream());
        this.testAvroToParquetConversion(schema, "message org.apache.parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated int32 array;\n  }\n  required group myemptyarray (LIST) {\n    repeated int32 array;\n  }\n  optional group myoptionalarray (LIST) {\n    repeated int32 array;\n  }\n  required group myarrayofoptional (LIST) {\n    repeated int32 array;\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required group myemptymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n");
    }

    @Test
    public void testAllTypesParquetToAvro() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"allFromParquetNewBehavior.avsc").openStream());
        this.testParquetToAvroConversion(NEW_BEHAVIOR, schema, ALL_PARQUET_SCHEMA);
    }

    @Test
    public void testAllTypesParquetToAvroOldBehavior() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"allFromParquetOldBehavior.avsc").openStream());
        this.testParquetToAvroConversion(schema, ALL_PARQUET_SCHEMA);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParquetMapWithNonStringKeyFails() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message myrecord {\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required int32 key;\n      required int32 value;\n    }\n  }\n}\n");
        new AvroSchemaConverter().convert(parquetSchema);
    }

    @Test
    public void testOptionalFields() throws Exception {
        Schema schema = Schema.createRecord((String)"record1", null, null, (boolean)false);
        Schema optionalInt = TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.INT));
        schema.setFields(Arrays.asList(new Schema.Field("myint", optionalInt, null, (JsonNode)NullNode.getInstance())));
        this.testRoundTripConversion(schema, "message record1 {\n  optional int32 myint;\n}\n");
    }

    @Test
    public void testOptionalMapValue() throws Exception {
        Schema schema = Schema.createRecord((String)"record1", null, null, (boolean)false);
        Schema optionalIntMap = Schema.createMap((Schema)TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.INT)));
        schema.setFields(Arrays.asList(new Schema.Field("myintmap", optionalIntMap, null, null)));
        this.testRoundTripConversion(schema, "message record1 {\n  required group myintmap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional int32 value;\n    }\n  }\n}\n");
    }

    @Test
    public void testOptionalArrayElement() throws Exception {
        Schema schema = Schema.createRecord((String)"record1", null, null, (boolean)false);
        Schema optionalIntArray = Schema.createArray((Schema)TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.INT)));
        schema.setFields(Arrays.asList(new Schema.Field("myintarray", optionalIntArray, null, null)));
        this.testRoundTripConversion(NEW_BEHAVIOR, schema, "message record1 {\n  required group myintarray (LIST) {\n    repeated group list {\n      optional int32 element;\n    }\n  }\n}\n");
    }

    @Test
    public void testUnionOfTwoTypes() throws Exception {
        Schema schema = Schema.createRecord((String)"record2", null, null, (boolean)false);
        Schema multipleTypes = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.FLOAT)));
        schema.setFields(Arrays.asList(new Schema.Field("myunion", multipleTypes, null, (JsonNode)NullNode.getInstance())));
        this.testAvroToParquetConversion(schema, "message record2 {\n  optional group myunion {\n    optional int32 member0;\n    optional float member1;\n  }\n}\n");
    }

    @Test
    public void testArrayOfOptionalRecords() throws Exception {
        Schema innerRecord = Schema.createRecord((String)"element", null, null, (boolean)false);
        Schema optionalString = TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.STRING));
        innerRecord.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("s1", optionalString, null, (JsonNode)NullNode.getInstance()), new Schema.Field("s2", optionalString, null, (JsonNode)NullNode.getInstance())}));
        Schema schema = Schema.createRecord((String)"HasArray", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("myarray", Schema.createArray((Schema)TestAvroSchemaConverter.optional(innerRecord)), null, null)}));
        System.err.println("Avro schema: " + schema.toString(true));
        this.testRoundTripConversion(NEW_BEHAVIOR, schema, "message HasArray {\n  required group myarray (LIST) {\n    repeated group list {\n      optional group element {\n        optional binary s1 (UTF8);\n        optional binary s2 (UTF8);\n      }\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayOfOptionalRecordsOldBehavior() throws Exception {
        Schema innerRecord = Schema.createRecord((String)"InnerRecord", null, null, (boolean)false);
        Schema optionalString = TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.STRING));
        innerRecord.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("s1", optionalString, null, (JsonNode)NullNode.getInstance()), new Schema.Field("s2", optionalString, null, (JsonNode)NullNode.getInstance())}));
        Schema schema = Schema.createRecord((String)"HasArray", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("myarray", Schema.createArray((Schema)TestAvroSchemaConverter.optional(innerRecord)), null, null)}));
        System.err.println("Avro schema: " + schema.toString(true));
        this.testAvroToParquetConversion(schema, "message HasArray {\n  required group myarray (LIST) {\n    repeated group array {\n      optional binary s1 (UTF8);\n      optional binary s2 (UTF8);\n    }\n  }\n}\n");
    }

    @Test
    public void testOldAvroListOfLists() throws Exception {
        Schema listOfLists = TestAvroSchemaConverter.optional(Schema.createArray((Schema)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT))));
        Schema schema = Schema.createRecord((String)"AvroCompatListInList", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("listOfLists", listOfLists, null, (JsonNode)NullNode.getInstance())}));
        System.err.println("Avro schema: " + schema.toString(true));
        this.testRoundTripConversion(schema, "message AvroCompatListInList {\n  optional group listOfLists (LIST) {\n    repeated group array (LIST) {\n      repeated int32 array;\n    }\n  }\n}");
        this.testParquetToAvroConversion(NEW_BEHAVIOR, schema, "message AvroCompatListInList {\n  optional group listOfLists (LIST) {\n    repeated group array (LIST) {\n      repeated int32 array;\n    }\n  }\n}");
    }

    @Test
    public void testOldThriftListOfLists() throws Exception {
        Schema listOfLists = TestAvroSchemaConverter.optional(Schema.createArray((Schema)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT))));
        Schema schema = Schema.createRecord((String)"ThriftCompatListInList", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("listOfLists", listOfLists, null, (JsonNode)NullNode.getInstance())}));
        System.err.println("Avro schema: " + schema.toString(true));
        this.testParquetToAvroConversion(schema, "message ThriftCompatListInList {\n  optional group listOfLists (LIST) {\n    repeated group listOfLists_tuple (LIST) {\n      repeated int32 listOfLists_tuple_tuple;\n    }\n  }\n}");
        this.testParquetToAvroConversion(NEW_BEHAVIOR, schema, "message ThriftCompatListInList {\n  optional group listOfLists (LIST) {\n    repeated group listOfLists_tuple (LIST) {\n      repeated int32 listOfLists_tuple_tuple;\n    }\n  }\n}");
    }

    @Test
    public void testUnknownTwoLevelListOfLists() throws Exception {
        Schema listOfLists = TestAvroSchemaConverter.optional(Schema.createArray((Schema)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT))));
        Schema schema = Schema.createRecord((String)"UnknownTwoLevelListInList", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("listOfLists", listOfLists, null, (JsonNode)NullNode.getInstance())}));
        System.err.println("Avro schema: " + schema.toString(true));
        this.testParquetToAvroConversion(schema, "message UnknownTwoLevelListInList {\n  optional group listOfLists (LIST) {\n    repeated group mylist (LIST) {\n      repeated int32 innerlist;\n    }\n  }\n}");
        this.testParquetToAvroConversion(NEW_BEHAVIOR, schema, "message UnknownTwoLevelListInList {\n  optional group listOfLists (LIST) {\n    repeated group mylist (LIST) {\n      repeated int32 innerlist;\n    }\n  }\n}");
    }

    @Test
    public void testParquetMapWithoutMapKeyValueAnnotation() throws Exception {
        Schema schema = Schema.createRecord((String)"myrecord", null, null, (boolean)false);
        Schema map = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        schema.setFields(Collections.singletonList(new Schema.Field("mymap", map, null, null)));
        String parquetSchema = "message myrecord {\n  required group mymap (MAP) {\n    repeated group map {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n}\n";
        this.testParquetToAvroConversion(schema, parquetSchema);
        this.testParquetToAvroConversion(NEW_BEHAVIOR, schema, parquetSchema);
    }

    @Test
    public void testDecimalBytesType() throws Exception {
        Schema schema = Schema.createRecord((String)"myrecord", null, null, (boolean)false);
        Schema decimal = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        schema.setFields(Collections.singletonList(new Schema.Field("dec", decimal, null, null)));
        this.testRoundTripConversion(schema, "message myrecord {\n  required binary dec (DECIMAL(9,2));\n}\n");
    }

    @Test
    public void testDecimalFixedType() throws Exception {
        Schema schema = Schema.createRecord((String)"myrecord", null, null, (boolean)false);
        Schema decimal = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.createFixed((String)"dec", null, null, (int)8));
        schema.setFields(Collections.singletonList(new Schema.Field("dec", decimal, null, null)));
        this.testRoundTripConversion(schema, "message myrecord {\n  required fixed_len_byte_array(8) dec (DECIMAL(9,2));\n}\n");
    }

    @Test
    public void testDecimalIntegerType() throws Exception {
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("dec", Schema.create((Schema.Type)Schema.Type.INT), null, null)));
        this.testParquetToAvroConversion(expected, "message myrecord {\n  required int32 dec (DECIMAL(9,2));\n}\n");
    }

    @Test
    public void testDecimalLongType() throws Exception {
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("dec", Schema.create((Schema.Type)Schema.Type.LONG), null, null)));
        this.testParquetToAvroConversion(expected, "message myrecord {\n  required int64 dec (DECIMAL(9,2));\n}\n");
    }

    @Test
    public void testDateType() throws Exception {
        Schema date = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("date", date, null, null)));
        this.testRoundTripConversion(expected, "message myrecord {\n  required int32 date (DATE);\n}\n");
        for (PrimitiveType.PrimitiveTypeName primitive : new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            final PrimitiveType type = primitive == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? new PrimitiveType(Type.Repetition.REQUIRED, primitive, 12, "test", OriginalType.DATE) : new PrimitiveType(Type.Repetition.REQUIRED, primitive, "test", OriginalType.DATE);
            TestAvroSchemaConverter.assertThrows("Should not allow TIME_MICROS with " + primitive, IllegalArgumentException.class, new Runnable(){

                @Override
                public void run() {
                    new AvroSchemaConverter().convert(TestAvroSchemaConverter.message(type));
                }
            });
        }
    }

    @Test
    public void testTimeMillisType() throws Exception {
        Schema date = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("time", date, null, null)));
        this.testRoundTripConversion(expected, "message myrecord {\n  required int32 time (TIME(MILLIS,true));\n}\n");
        for (PrimitiveType.PrimitiveTypeName primitive : new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            final PrimitiveType type = primitive == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? new PrimitiveType(Type.Repetition.REQUIRED, primitive, 12, "test", OriginalType.TIME_MILLIS) : new PrimitiveType(Type.Repetition.REQUIRED, primitive, "test", OriginalType.TIME_MILLIS);
            TestAvroSchemaConverter.assertThrows("Should not allow TIME_MICROS with " + primitive, IllegalArgumentException.class, new Runnable(){

                @Override
                public void run() {
                    new AvroSchemaConverter().convert(TestAvroSchemaConverter.message(type));
                }
            });
        }
    }

    @Test
    public void testTimeMicrosType() throws Exception {
        Schema date = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("time", date, null, null)));
        this.testRoundTripConversion(expected, "message myrecord {\n  required int64 time (TIME(MICROS,true));\n}\n");
        for (PrimitiveType.PrimitiveTypeName primitive : new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            final PrimitiveType type = primitive == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? new PrimitiveType(Type.Repetition.REQUIRED, primitive, 12, "test", OriginalType.TIME_MICROS) : new PrimitiveType(Type.Repetition.REQUIRED, primitive, "test", OriginalType.TIME_MICROS);
            TestAvroSchemaConverter.assertThrows("Should not allow TIME_MICROS with " + primitive, IllegalArgumentException.class, new Runnable(){

                @Override
                public void run() {
                    new AvroSchemaConverter().convert(TestAvroSchemaConverter.message(type));
                }
            });
        }
    }

    @Test
    public void testTimestampMillisType() throws Exception {
        Schema date = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("timestamp", date, null, null)));
        this.testRoundTripConversion(expected, "message myrecord {\n  required int64 timestamp (TIMESTAMP(MILLIS,true));\n}\n");
        for (PrimitiveType.PrimitiveTypeName primitive : new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            final PrimitiveType type = primitive == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? new PrimitiveType(Type.Repetition.REQUIRED, primitive, 12, "test", OriginalType.TIMESTAMP_MILLIS) : new PrimitiveType(Type.Repetition.REQUIRED, primitive, "test", OriginalType.TIMESTAMP_MILLIS);
            TestAvroSchemaConverter.assertThrows("Should not allow TIMESTAMP_MILLIS with " + primitive, IllegalArgumentException.class, new Runnable(){

                @Override
                public void run() {
                    new AvroSchemaConverter().convert(TestAvroSchemaConverter.message(type));
                }
            });
        }
    }

    @Test
    public void testTimestampMicrosType() throws Exception {
        Schema date = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema expected = Schema.createRecord((String)"myrecord", null, null, (boolean)false, Arrays.asList(new Schema.Field("timestamp", date, null, null)));
        this.testRoundTripConversion(expected, "message myrecord {\n  required int64 timestamp (TIMESTAMP(MICROS,true));\n}\n");
        for (PrimitiveType.PrimitiveTypeName primitive : new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            final PrimitiveType type = primitive == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? new PrimitiveType(Type.Repetition.REQUIRED, primitive, 12, "test", OriginalType.TIMESTAMP_MICROS) : new PrimitiveType(Type.Repetition.REQUIRED, primitive, "test", OriginalType.TIMESTAMP_MICROS);
            TestAvroSchemaConverter.assertThrows("Should not allow TIMESTAMP_MICROS with " + primitive, IllegalArgumentException.class, new Runnable(){

                @Override
                public void run() {
                    new AvroSchemaConverter().convert(TestAvroSchemaConverter.message(type));
                }
            });
        }
    }

    public static Schema optional(Schema original) {
        return Schema.createUnion((List)Lists.newArrayList((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), original}));
    }

    public static MessageType message(PrimitiveType primitive) {
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)primitive)).named("myrecord");
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            try {
                Assert.assertEquals((String)message, expected, actual.getClass());
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).addSuppressed(actual);
                throw e;
            }
        }
    }
}

