/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.ReflectData;
import org.apache.parquet.avro.AvroTestUtil;
import org.apache.parquet.avro.RecordWithStringUUID;
import org.apache.parquet.avro.RecordWithUUID;
import org.apache.parquet.avro.RecordWithUUIDArray;
import org.apache.parquet.avro.RecordWithUUIDList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestReflectLogicalTypes {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public static final ReflectData REFLECT = new ReflectData();

    @BeforeClass
    public static void addUUID() {
        REFLECT.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
        REFLECT.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
    }

    @Test
    public void testReflectedSchema() {
        Schema expected = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDList.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        expected.getField("uuids").schema().addProp("java-class", List.class.getName());
        LogicalTypes.uuid().addToSchema(expected.getField("uuids").schema().getElementType());
        Schema actual = REFLECT.getSchema(RecordWithUUIDList.class);
        Assert.assertEquals((String)"Should use the UUID logical type", (Object)expected, (Object)actual);
    }

    @Test
    public void testDecimalBytes() throws IOException {
        Schema schema = REFLECT.getSchema(DecimalRecordBytes.class);
        Assert.assertEquals((String)"Should have the correct record name", (Object)"org.apache.parquet.avro.TestReflectLogicalTypes$", (Object)schema.getNamespace());
        Assert.assertEquals((String)"Should have the correct record name", (Object)"DecimalRecordBytes", (Object)schema.getName());
        Assert.assertEquals((String)"Should have the correct logical type", (Object)LogicalTypes.decimal((int)9, (int)2), (Object)LogicalTypes.fromSchema((Schema)schema.getField("decimal").schema()));
        DecimalRecordBytes record = new DecimalRecordBytes();
        record.decimal = new BigDecimal("3.14");
        File test = this.write((GenericData)REFLECT, schema, record);
        Assert.assertEquals((String)"Should match the decimal after round trip", Arrays.asList(record), AvroTestUtil.read((GenericData)REFLECT, schema, test));
    }

    @Test
    public void testDecimalFixed() throws IOException {
        Schema schema = REFLECT.getSchema(DecimalRecordFixed.class);
        Assert.assertEquals((String)"Should have the correct record name", (Object)"org.apache.parquet.avro.TestReflectLogicalTypes$", (Object)schema.getNamespace());
        Assert.assertEquals((String)"Should have the correct record name", (Object)"DecimalRecordFixed", (Object)schema.getName());
        Assert.assertEquals((String)"Should have the correct logical type", (Object)LogicalTypes.decimal((int)9, (int)2), (Object)LogicalTypes.fromSchema((Schema)schema.getField("decimal").schema()));
        DecimalRecordFixed record = new DecimalRecordFixed();
        record.decimal = new BigDecimal("3.14");
        File test = this.write((GenericData)REFLECT, schema, record);
        Assert.assertEquals((String)"Should match the decimal after round trip", Arrays.asList(record), AvroTestUtil.read((GenericData)REFLECT, schema, test));
    }

    @Test
    public void testPairRecord() throws IOException {
        ReflectData model = new ReflectData();
        model.addLogicalTypeConversion((Conversion)new Conversion<Pair>(){

            public Class<Pair> getConvertedType() {
                return Pair.class;
            }

            public String getLogicalTypeName() {
                return "pair";
            }

            public Pair fromRecord(IndexedRecord value, Schema schema, LogicalType type) {
                return Pair.of(value.get(0), value.get(1));
            }

            public IndexedRecord toRecord(Pair value, Schema schema, LogicalType type) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put(0, value.first);
                record.put(1, value.second);
                return record;
            }
        });
        LogicalTypes.register((String)"pair", (LogicalTypes.LogicalTypeFactory)new LogicalTypes.LogicalTypeFactory(){
            private final LogicalType PAIR = new LogicalType("pair");

            public LogicalType fromSchema(Schema schema) {
                return this.PAIR;
            }
        });
        Schema schema = model.getSchema(PairRecord.class);
        Assert.assertEquals((String)"Should have the correct record name", (Object)"org.apache.parquet.avro.TestReflectLogicalTypes$", (Object)schema.getNamespace());
        Assert.assertEquals((String)"Should have the correct record name", (Object)"PairRecord", (Object)schema.getName());
        Assert.assertEquals((String)"Should have the correct logical type", (Object)"pair", (Object)LogicalTypes.fromSchema((Schema)schema.getField("pair").schema()).getName());
        PairRecord record = new PairRecord();
        record.pair = Pair.of(34L, 35L);
        ArrayList<PairRecord> expected = new ArrayList<PairRecord>();
        expected.add(record);
        File test = this.write((GenericData)model, schema, record);
        Pair<Long, Long> actual = ((PairRecord)AvroTestUtil.read((GenericData)model, (Schema)schema, (File)test).get((int)0)).pair;
        Assert.assertEquals((String)"Data should match after serialization round-trip", (long)34L, (long)((Long)((Pair)actual).first));
        Assert.assertEquals((String)"Data should match after serialization round-trip", (long)35L, (long)((Long)((Pair)actual).second));
    }

    @Test
    public void testReadUUID() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithStringUUID r1 = new RecordWithStringUUID();
        r1.uuid = u1.toString();
        RecordWithStringUUID r2 = new RecordWithStringUUID();
        r2.uuid = u2.toString();
        List<RecordWithUUID> expected = Arrays.asList(new RecordWithUUID(), new RecordWithUUID());
        expected.get((int)0).uuid = u1;
        expected.get((int)1).uuid = u2;
        File test = this.write(ReflectData.get().getSchema(RecordWithStringUUID.class), r1, r2);
        Assert.assertEquals((String)"Should convert Strings to UUIDs", expected, AvroTestUtil.read((GenericData)REFLECT, uuidSchema, test));
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidStringSchema.getField("uuid").schema());
        Assert.assertEquals((String)"Should not convert to UUID if accessor is String", Arrays.asList(r1, r2), AvroTestUtil.read((GenericData)REFLECT, uuidStringSchema, test));
    }

    @Test
    public void testWriteUUID() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithUUID r1 = new RecordWithUUID();
        r1.uuid = u1;
        RecordWithUUID r2 = new RecordWithUUID();
        r2.uuid = u2;
        List<RecordWithStringUUID> expected = Arrays.asList(new RecordWithStringUUID(), new RecordWithStringUUID());
        expected.get((int)0).uuid = u1.toString();
        expected.get((int)1).uuid = u2.toString();
        File test = this.write((GenericData)REFLECT, uuidSchema, r1, r2);
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        Assert.assertEquals((String)"Should read uuid as String without UUID conversion", expected, AvroTestUtil.read((GenericData)REFLECT, uuidStringSchema, test));
        LogicalTypes.uuid().addToSchema(uuidStringSchema.getField("uuid").schema());
        Assert.assertEquals((String)"Should read uuid as String without UUID logical type", expected, AvroTestUtil.read((GenericData)ReflectData.get(), uuidStringSchema, test));
    }

    @Test
    public void testWriteNullableUUID() throws IOException {
        Schema nullableUuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().optionalString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema((Schema)nullableUuidSchema.getField("uuid").schema().getTypes().get(1));
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithUUID r1 = new RecordWithUUID();
        r1.uuid = u1;
        RecordWithUUID r2 = new RecordWithUUID();
        r2.uuid = u2;
        List<RecordWithStringUUID> expected = Arrays.asList(new RecordWithStringUUID(), new RecordWithStringUUID());
        expected.get((int)0).uuid = u1.toString();
        expected.get((int)1).uuid = u2.toString();
        File test = this.write((GenericData)REFLECT, nullableUuidSchema, r1, r2);
        Schema nullableUuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().optionalString("uuid").endRecord();
        Assert.assertEquals((String)"Should read uuid as String without UUID conversion", expected, AvroTestUtil.read((GenericData)REFLECT, nullableUuidStringSchema, test));
    }

    @Test(expected=ClassCastException.class)
    public void testWriteUUIDMissingLogicalType() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithUUID r1 = new RecordWithUUID();
        r1.uuid = u1;
        RecordWithUUID r2 = new RecordWithUUID();
        r2.uuid = u2;
        File test = this.write(uuidSchema, r1, r2);
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        AvroTestUtil.read((GenericData)ReflectData.get(), uuidStringSchema, test);
    }

    @Test
    public void testReadUUIDGenericRecord() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)"RecordWithUUID").fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithStringUUID r1 = new RecordWithStringUUID();
        r1.uuid = u1.toString();
        RecordWithStringUUID r2 = new RecordWithStringUUID();
        r2.uuid = u2.toString();
        List<GenericData.Record> expected = Arrays.asList(new GenericData.Record(uuidSchema), new GenericData.Record(uuidSchema));
        expected.get(0).put("uuid", (Object)u1);
        expected.get(1).put("uuid", (Object)u2);
        File test = this.write(ReflectData.get().getSchema(RecordWithStringUUID.class), r1, r2);
        Assert.assertEquals((String)"Should convert Strings to UUIDs", expected, AvroTestUtil.read((GenericData)REFLECT, uuidSchema, test));
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        Assert.assertEquals((String)"Should not convert to UUID if accessor is String", Arrays.asList(r1, r2), AvroTestUtil.read((GenericData)REFLECT, uuidStringSchema, test));
    }

    @Test
    public void testReadUUIDArray() throws IOException {
        Schema uuidArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDArray.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        LogicalTypes.uuid().addToSchema(uuidArraySchema.getField("uuids").schema().getElementType());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record r = new GenericData.Record(uuidArraySchema);
        r.put("uuids", Arrays.asList(u1.toString(), u2.toString()));
        RecordWithUUIDArray expected = new RecordWithUUIDArray();
        expected.uuids = new UUID[]{u1, u2};
        File test = this.write(uuidArraySchema, r);
        Assert.assertEquals((String)"Should convert Strings to UUIDs", (Object)expected, AvroTestUtil.read((GenericData)REFLECT, uuidArraySchema, test).get(0));
    }

    @Test
    public void testWriteUUIDArray() throws IOException {
        Schema uuidArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDArray.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        LogicalTypes.uuid().addToSchema(uuidArraySchema.getField("uuids").schema().getElementType());
        Schema stringArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"RecordWithUUIDArray").fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        stringArraySchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record expected = new GenericData.Record(stringArraySchema);
        ArrayList<String> uuids = new ArrayList<String>();
        uuids.add(u1.toString());
        uuids.add(u2.toString());
        expected.put("uuids", uuids);
        RecordWithUUIDArray r = new RecordWithUUIDArray();
        r.uuids = new UUID[]{u1, u2};
        File test = this.write((GenericData)REFLECT, uuidArraySchema, r);
        Assert.assertEquals((String)"Should read UUIDs as Strings", (Object)expected, AvroTestUtil.read((GenericData)ReflectData.get(), stringArraySchema, test).get(0));
    }

    @Test
    public void testReadUUIDList() throws IOException {
        Schema uuidListSchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDList.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        uuidListSchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        LogicalTypes.uuid().addToSchema(uuidListSchema.getField("uuids").schema().getElementType());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record r = new GenericData.Record(uuidListSchema);
        r.put("uuids", Arrays.asList(u1.toString(), u2.toString()));
        RecordWithUUIDList expected = new RecordWithUUIDList();
        expected.uuids = Arrays.asList(u1, u2);
        File test = this.write(uuidListSchema, r);
        Assert.assertEquals((String)"Should convert Strings to UUIDs", (Object)expected, AvroTestUtil.read((GenericData)REFLECT, uuidListSchema, test).get(0));
    }

    @Test
    public void testWriteUUIDList() throws IOException {
        Schema uuidListSchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDList.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        uuidListSchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        LogicalTypes.uuid().addToSchema(uuidListSchema.getField("uuids").schema().getElementType());
        Schema stringArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"RecordWithUUIDArray").fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        stringArraySchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record expected = new GenericData.Record(stringArraySchema);
        expected.put("uuids", Arrays.asList(u1.toString(), u2.toString()));
        RecordWithUUIDList r = new RecordWithUUIDList();
        r.uuids = Arrays.asList(u1, u2);
        File test = this.write((GenericData)REFLECT, uuidListSchema, r);
        Assert.assertEquals((String)"Should read UUIDs as Strings", (Object)expected, AvroTestUtil.read((GenericData)REFLECT, stringArraySchema, test).get(0));
    }

    private <D> File write(Schema schema, D ... data) throws IOException {
        return this.write((GenericData)ReflectData.get(), schema, data);
    }

    private <D> File write(GenericData model, Schema schema, D ... data) throws IOException {
        return AvroTestUtil.write(this.temp, model, schema, data);
    }

    public static class PairRecord {
        @AvroSchema(value="{\"name\": \"Pair\",\"type\": \"record\",\"fields\": [    {\"name\": \"x\", \"type\": \"long\"},    {\"name\": \"y\", \"type\": \"long\"}  ],\"logicalType\": \"pair\"}")
        Pair<Long, Long> pair;
    }

    public static class Pair<X, Y> {
        private final X first;
        private final Y second;

        private Pair(X first, Y second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Pair that = (Pair)other;
            if (this.first == null ? that.first != null : this.first.equals(that.first)) {
                return false;
            }
            return !(this.second == null ? that.second != null : this.second.equals(that.second));
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.first, this.second});
        }

        public static <X, Y> Pair<X, Y> of(X first, Y second) {
            return new Pair<X, Y>(first, second);
        }
    }

    public static class DecimalRecordFixed {
        @AvroSchema(value="{\"name\": \"decimal_9\",\"type\": \"fixed\",\"size\": 4,\"logicalType\": \"decimal\",\"precision\": 9,\"scale\": 2}")
        private BigDecimal decimal;

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DecimalRecordFixed that = (DecimalRecordFixed)other;
            if (this.decimal == null) {
                return that.decimal == null;
            }
            return this.decimal.equals(that.decimal);
        }

        public int hashCode() {
            return this.decimal != null ? this.decimal.hashCode() : 0;
        }
    }

    public static class DecimalRecordBytes {
        @AvroSchema(value="{\"type\": \"bytes\",\"logicalType\": \"decimal\",\"precision\": 9,\"scale\": 2}")
        private BigDecimal decimal;

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DecimalRecordBytes that = (DecimalRecordBytes)other;
            if (this.decimal == null) {
                return that.decimal == null;
            }
            return this.decimal.equals(that.decimal);
        }

        public int hashCode() {
            return this.decimal != null ? this.decimal.hashCode() : 0;
        }
    }
}

