/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.GenericDataSupplier;
import org.apache.parquet.avro.ReflectDataSupplier;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.Assert;
import org.junit.Test;

public class TestReflectReadWrite {
    @Test
    public void testReadWriteReflect() throws IOException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)conf, ReflectDataSupplier.class);
        Path path = this.writePojosToParquetFile(10, CompressionCodecName.UNCOMPRESSED, false);
        AvroParquetReader reader = new AvroParquetReader(conf, path);
        Pojo object = this.getPojo();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)object, (Object)reader.read());
        }
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testWriteReflectReadGeneric() throws IOException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)conf, GenericDataSupplier.class);
        Path path = this.writePojosToParquetFile(2, CompressionCodecName.UNCOMPRESSED, false);
        AvroParquetReader reader = new AvroParquetReader(conf, path);
        GenericRecord object = this.getGenericPojoUtf8();
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)object, (Object)reader.read());
        }
        Assert.assertNull((Object)reader.read());
    }

    private GenericRecord getGenericPojoUtf8() {
        Schema schema = ReflectData.get().getSchema(Pojo.class);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("myboolean", (Object)true);
        record.put("mybyte", (Object)1);
        record.put("myshort", (Object)1);
        record.put("myint", (Object)1);
        record.put("mylong", (Object)2L);
        record.put("myfloat", (Object)Float.valueOf(3.1f));
        record.put("mydouble", (Object)4.1);
        record.put("mybytes", (Object)ByteBuffer.wrap(new byte[]{1, 2, 3, 4}));
        record.put("mystring", (Object)new Utf8("Hello"));
        record.put("myenum", (Object)new GenericData.EnumSymbol(schema.getField("myenum").schema(), "A"));
        HashMap<Utf8, Utf8> map = new HashMap<Utf8, Utf8>();
        map.put(new Utf8("a"), new Utf8("1"));
        map.put(new Utf8("b"), new Utf8("2"));
        record.put("mymap", map);
        record.put("myshortarray", (Object)new GenericData.Array(schema.getField("myshortarray").schema(), (Collection)Lists.newArrayList((Object[])new Integer[]{1, 2})));
        record.put("myintarray", (Object)new GenericData.Array(schema.getField("myintarray").schema(), (Collection)Lists.newArrayList((Object[])new Integer[]{1, 2})));
        record.put("mystringarray", (Object)new GenericData.Array(schema.getField("mystringarray").schema(), (Collection)Lists.newArrayList((Object[])new Utf8[]{new Utf8("a"), new Utf8("b")})));
        record.put("mylist", (Object)new GenericData.Array(schema.getField("mylist").schema(), (Collection)Lists.newArrayList((Object[])new Utf8[]{new Utf8("a"), new Utf8("b"), new Utf8("c")})));
        return record;
    }

    private Pojo getPojo() {
        Pojo object = new Pojo();
        object.myboolean = true;
        object.mybyte = 1;
        object.myshort = 1;
        object.myint = 1;
        object.mylong = 2L;
        object.myfloat = 3.1f;
        object.mydouble = 4.1;
        object.mybytes = new byte[]{1, 2, 3, 4};
        object.mystring = "Hello";
        object.myenum = E.A;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "1");
        map.put("b", "2");
        object.mymap = map;
        Pojo.access$102(object, new short[]{1, 2});
        Pojo.access$202(object, new int[]{1, 2});
        Pojo.access$302(object, new String[]{"a", "b"});
        object.mylist = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        return object;
    }

    private Path writePojosToParquetFile(int num, CompressionCodecName compression, boolean enableDictionary) throws IOException {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path path = new Path(tmp.getPath());
        Pojo object = this.getPojo();
        Schema schema = ReflectData.get().getSchema(object.getClass());
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)path).withSchema(schema).withCompressionCodec(compression)).withDataModel((GenericData)ReflectData.get()).withDictionaryEncoding(enableDictionary)).build();
        for (int i = 0; i < num; ++i) {
            writer.write((Object)object);
        }
        writer.close();
        return path;
    }

    public static class Pojo {
        public boolean myboolean;
        public byte mybyte;
        public short myshort;
        public int myint;
        public long mylong;
        public float myfloat;
        public double mydouble;
        public byte[] mybytes;
        public String mystring;
        public E myenum;
        private Map<String, String> mymap;
        private short[] myshortarray;
        private int[] myintarray;
        private String[] mystringarray;
        private List<String> mylist;

        public boolean equals(Object o) {
            if (!(o instanceof Pojo)) {
                return false;
            }
            Pojo that = (Pojo)o;
            return this.myboolean == that.myboolean && this.mybyte == that.mybyte && this.myshort == that.myshort && this.myint == that.myint && this.mylong == that.mylong && this.myfloat == that.myfloat && this.mydouble == that.mydouble && Arrays.equals(this.mybytes, that.mybytes) && this.mystring.equals(that.mystring) && this.myenum == that.myenum && this.mymap.equals(that.mymap) && Arrays.equals(this.myshortarray, that.myshortarray) && Arrays.equals(this.myintarray, that.myintarray) && Arrays.equals(this.mystringarray, that.mystringarray) && this.mylist.equals(that.mylist);
        }

        public String toString() {
            return "Pojo{myboolean=" + this.myboolean + ", mybyte=" + this.mybyte + ", myshort=" + this.myshort + ", myint=" + this.myint + ", mylong=" + this.mylong + ", myfloat=" + this.myfloat + ", mydouble=" + this.mydouble + ", mybytes=" + Arrays.toString(this.mybytes) + ", mystring='" + this.mystring + '\'' + ", myenum=" + (Object)((Object)this.myenum) + ", mymap=" + this.mymap + ", myshortarray=" + Arrays.toString(this.myshortarray) + ", myintarray=" + Arrays.toString(this.myintarray) + ", mystringarray=" + Arrays.toString(this.mystringarray) + ", mylist=" + this.mylist + '}';
        }

        static /* synthetic */ short[] access$102(Pojo x0, short[] x1) {
            x0.myshortarray = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(Pojo x0, int[] x1) {
            x0.myintarray = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(Pojo x0, String[] x1) {
            x0.mystringarray = x1;
            return x1;
        }
    }

    public static enum E {
        A,
        B;

    }
}

