/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.DirectWriterTest;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.AvroTestUtil;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestArrayCompatibility
extends DirectWriterTest {
    public static final Configuration OLD_BEHAVIOR_CONF = new Configuration();
    public static final Configuration NEW_BEHAVIOR_CONF = new Configuration();

    @BeforeClass
    public static void setupNewBehaviorConfiguration() {
        OLD_BEHAVIOR_CONF.setBoolean("parquet.avro.add-list-element-records", true);
        NEW_BEHAVIOR_CONF.setBoolean("parquet.avro.add-list-element-records", false);
    }

    @Test
    @Ignore(value="Not yet supported")
    public void testUnannotatedListOfPrimitives() throws Exception {
        Path test = this.writeDirect("message UnannotatedListOfPrimitives {  repeated int32 list_of_ints;}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
        Schema expectedSchema = AvroTestUtil.record("OldPrimitiveInList", AvroTestUtil.field("list_of_ints", AvroTestUtil.array(AvroTestUtil.primitive(Schema.Type.INT))));
        GenericRecord expectedRecord = AvroTestUtil.instance(expectedSchema, "list_of_ints", Arrays.asList(34, 35, 36));
        this.assertReaderContains(this.oldBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
        this.assertReaderContains(this.newBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
    }

    @Test
    @Ignore(value="Not yet supported")
    public void testUnannotatedListOfGroups() throws Exception {
        Path test = this.writeDirect("message UnannotatedListOfGroups {  repeated group list_of_points {    required float x;    required float y;  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_points", 0);
                rc.startGroup();
                rc.startField("x", 0);
                rc.addFloat(1.0f);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addFloat(1.0f);
                rc.endField("y", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("x", 0);
                rc.addFloat(2.0f);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addFloat(2.0f);
                rc.endField("y", 1);
                rc.endGroup();
                rc.endField("list_of_points", 0);
                rc.endMessage();
            }
        });
        Schema point = AvroTestUtil.record("?", AvroTestUtil.field("x", AvroTestUtil.primitive(Schema.Type.FLOAT)), AvroTestUtil.field("y", AvroTestUtil.primitive(Schema.Type.FLOAT)));
        Schema expectedSchema = AvroTestUtil.record("OldPrimitiveInList", AvroTestUtil.field("list_of_points", AvroTestUtil.array(point)));
        GenericRecord expectedRecord = AvroTestUtil.instance(expectedSchema, "list_of_points", Arrays.asList(AvroTestUtil.instance(point, "x", Float.valueOf(1.0f), "y", Float.valueOf(1.0f)), AvroTestUtil.instance(point, "x", Float.valueOf(2.0f), "y", Float.valueOf(2.0f))));
        this.assertReaderContains(this.oldBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
        this.assertReaderContains(this.newBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
    }

    @Test
    public void testRepeatedPrimitiveInList() throws Exception {
        Path test = this.writeDirect("message RepeatedPrimitiveInList {  required group list_of_ints (LIST) {    repeated int32 array;  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
        Schema expectedSchema = AvroTestUtil.record("RepeatedPrimitiveInList", AvroTestUtil.field("list_of_ints", AvroTestUtil.array(Schema.create((Schema.Type)Schema.Type.INT))));
        GenericRecord expectedRecord = AvroTestUtil.instance(expectedSchema, "list_of_ints", Arrays.asList(34, 35, 36));
        this.assertReaderContains(this.oldBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
        this.assertReaderContains(this.newBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
    }

    @Test
    public void testMultiFieldGroupInList() throws Exception {
        Path test = this.writeDirect("message MultiFieldGroupInList {  optional group locations (LIST) {    repeated group element {      required double latitude;      required double longitude;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema expectedSchema = AvroTestUtil.record("MultiFieldGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(location)));
        GenericRecord expectedRecord = AvroTestUtil.instance(expectedSchema, "locations", Arrays.asList(AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0), AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0)));
        this.assertReaderContains(this.oldBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
        this.assertReaderContains(this.newBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
    }

    @Test
    public void testSingleFieldGroupInList() throws Exception {
        Path test = this.writeDirect("message SingleFieldGroupInList {  optional group single_element_groups (LIST) {    repeated group single_element_group {      required int64 count;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("single_element_groups", 0);
                rc.startGroup();
                rc.startField("single_element_group", 0);
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(1234L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(2345L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.endField("single_element_group", 0);
                rc.endGroup();
                rc.endField("single_element_groups", 0);
                rc.endMessage();
            }
        });
        Schema singleElementGroupSchema = AvroTestUtil.record("single_element_group", AvroTestUtil.field("count", AvroTestUtil.primitive(Schema.Type.LONG)));
        Schema oldSchema = AvroTestUtil.record("SingleFieldGroupInList", AvroTestUtil.optionalField("single_element_groups", AvroTestUtil.array(singleElementGroupSchema)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "single_element_groups", Arrays.asList(AvroTestUtil.instance(singleElementGroupSchema, "count", 1234L), AvroTestUtil.instance(singleElementGroupSchema, "count", 2345L)));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        Schema newSchema = AvroTestUtil.record("SingleFieldGroupInList", AvroTestUtil.optionalField("single_element_groups", AvroTestUtil.array(AvroTestUtil.primitive(Schema.Type.LONG))));
        GenericRecord newRecord = AvroTestUtil.instance(newSchema, "single_element_groups", Arrays.asList(1234L, 2345L));
        this.assertReaderContains(this.newBehaviorReader(test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
    }

    @Test
    public void testSingleFieldGroupInListWithSchema() throws Exception {
        Schema singleElementRecord = AvroTestUtil.record("single_element_group", AvroTestUtil.field("count", AvroTestUtil.primitive(Schema.Type.LONG)));
        Schema expectedSchema = AvroTestUtil.record("SingleFieldGroupInList", AvroTestUtil.optionalField("single_element_groups", AvroTestUtil.array(singleElementRecord)));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("parquet.avro.schema", expectedSchema.toString());
        Path test = this.writeDirect("message SingleFieldGroupInList {  optional group single_element_groups (LIST) {    repeated group single_element_group {      required int64 count;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("single_element_groups", 0);
                rc.startGroup();
                rc.startField("single_element_group", 0);
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(1234L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(2345L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.endField("single_element_group", 0);
                rc.endGroup();
                rc.endField("single_element_groups", 0);
                rc.endMessage();
            }
        }, metadata);
        GenericRecord expectedRecord = AvroTestUtil.instance(expectedSchema, "single_element_groups", Arrays.asList(AvroTestUtil.instance(singleElementRecord, "count", 1234L), AvroTestUtil.instance(singleElementRecord, "count", 2345L)));
        this.assertReaderContains(this.oldBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
        this.assertReaderContains(this.newBehaviorReader(test), expectedSchema, (IndexedRecord[])new GenericRecord[]{expectedRecord});
    }

    @Test
    public void testNewOptionalGroupInList() throws Exception {
        Path test = this.writeDirect("message NewOptionalGroupInList {  optional group locations (LIST) {    repeated group list {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema elementRecord = AvroTestUtil.record("list", AvroTestUtil.optionalField("element", location));
        Schema oldSchema = AvroTestUtil.record("NewOptionalGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(elementRecord)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "locations", Arrays.asList(AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0)), AvroTestUtil.instance(elementRecord, new Object[0]), AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0))));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        Schema newSchema = AvroTestUtil.record("NewOptionalGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(AvroTestUtil.optional(location))));
        GenericRecord newRecord = AvroTestUtil.instance(newSchema, "locations", Arrays.asList(AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0), null, AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0)));
        this.assertReaderContains(this.newBehaviorReader(test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
    }

    @Test
    public void testNewRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("message NewRequiredGroupInList {  optional group locations (LIST) {    repeated group list {      required group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema elementRecord = AvroTestUtil.record("list", AvroTestUtil.field("element", location));
        Schema oldSchema = AvroTestUtil.record("NewRequiredGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(elementRecord)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "locations", Arrays.asList(AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0)), AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0))));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        Schema newSchema = AvroTestUtil.record("NewRequiredGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(location)));
        GenericRecord newRecord = AvroTestUtil.instance(newSchema, "locations", Arrays.asList(AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0), AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0)));
        this.assertReaderContains(this.newBehaviorReader(test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
    }

    @Test
    public void testAvroCompatOptionalGroupInList() throws Exception {
        Path test = this.writeDirect("message AvroCompatOptionalGroupInList {  optional group locations (LIST) {    repeated group array {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema elementRecord = AvroTestUtil.record("array", AvroTestUtil.optionalField("element", location));
        Schema oldSchema = AvroTestUtil.record("AvroCompatOptionalGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(elementRecord)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "locations", Arrays.asList(AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0)), AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0))));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        this.assertReaderContains(this.newBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
    }

    @Test
    public void testAvroCompatOptionalGroupInListWithSchema() throws Exception {
        Path test = this.writeDirect("message AvroCompatOptionalGroupInListWithSchema {  optional group locations (LIST) {    repeated group array {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema newSchema = AvroTestUtil.record("AvroCompatOptionalGroupInListWithSchema", AvroTestUtil.optionalField("locations", AvroTestUtil.array(AvroTestUtil.optional(location))));
        GenericRecord newRecord = AvroTestUtil.instance(newSchema, "locations", Arrays.asList(AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0), AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0)));
        Configuration oldConfWithSchema = new Configuration();
        AvroReadSupport.setAvroReadSchema((Configuration)oldConfWithSchema, (Schema)newSchema);
        this.assertReaderContains(new AvroParquetReader(oldConfWithSchema, test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
        Configuration newConfWithSchema = new Configuration(NEW_BEHAVIOR_CONF);
        AvroReadSupport.setAvroReadSchema((Configuration)newConfWithSchema, (Schema)newSchema);
        this.assertReaderContains(new AvroParquetReader(newConfWithSchema, test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
    }

    @Test
    public void testAvroCompatListInList() throws Exception {
        Path test = this.writeDirect("message AvroCompatListInList {  optional group listOfLists (LIST) {    repeated group array (LIST) {      repeated int32 array;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("array", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(32);
                rc.addInteger(33);
                rc.addInteger(34);
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema listOfLists = AvroTestUtil.array(AvroTestUtil.array(AvroTestUtil.primitive(Schema.Type.INT)));
        Schema oldSchema = AvroTestUtil.record("AvroCompatListInList", AvroTestUtil.optionalField("listOfLists", listOfLists));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "listOfLists", Arrays.asList(Arrays.asList(34, 35, 36), Arrays.asList(new Object[0]), Arrays.asList(32, 33, 34)));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        this.assertReaderContains(this.newBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
    }

    @Test
    public void testThriftCompatListInList() throws Exception {
        Path test = this.writeDirect("message ThriftCompatListInList {  optional group listOfLists (LIST) {    repeated group listOfLists_tuple (LIST) {      repeated int32 listOfLists_tuple_tuple;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("listOfLists_tuple", 0);
                rc.startGroup();
                rc.startField("listOfLists_tuple_tuple", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("listOfLists_tuple_tuple", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("listOfLists_tuple_tuple", 0);
                rc.addInteger(32);
                rc.addInteger(33);
                rc.addInteger(34);
                rc.endField("listOfLists_tuple_tuple", 0);
                rc.endGroup();
                rc.endField("listOfLists_tuple", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema listOfLists = AvroTestUtil.array(AvroTestUtil.array(AvroTestUtil.primitive(Schema.Type.INT)));
        Schema oldSchema = AvroTestUtil.record("ThriftCompatListInList", AvroTestUtil.optionalField("listOfLists", listOfLists));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "listOfLists", Arrays.asList(Arrays.asList(34, 35, 36), Arrays.asList(new Object[0]), Arrays.asList(32, 33, 34)));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        this.assertReaderContains(this.newBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
    }

    @Test
    public void testThriftCompatRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("message ThriftCompatRequiredGroupInList {  optional group locations (LIST) {    repeated group locations_tuple {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("locations_tuple", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("locations_tuple", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema elementRecord = AvroTestUtil.record("locations_tuple", AvroTestUtil.optionalField("element", location));
        Schema oldSchema = AvroTestUtil.record("ThriftCompatRequiredGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(elementRecord)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "locations", Arrays.asList(AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0)), AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0))));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        this.assertReaderContains(this.newBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
    }

    @Test
    public void testHiveCompatOptionalGroupInList() throws Exception {
        Path test = this.writeDirect("message HiveCompatOptionalGroupInList {  optional group locations (LIST) {    repeated group bag {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("bag", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("bag", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        Schema location = AvroTestUtil.record("element", AvroTestUtil.field("latitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)), AvroTestUtil.field("longitude", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema elementRecord = AvroTestUtil.record("bag", AvroTestUtil.optionalField("element", location));
        Schema oldSchema = AvroTestUtil.record("HiveCompatOptionalGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(elementRecord)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "locations", Arrays.asList(AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0)), AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0))));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        Schema newSchema = AvroTestUtil.record("HiveCompatOptionalGroupInList", AvroTestUtil.optionalField("locations", AvroTestUtil.array(AvroTestUtil.optional(location))));
        GenericRecord newRecord = AvroTestUtil.instance(newSchema, "locations", Arrays.asList(AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 180.0), AvroTestUtil.instance(location, "latitude", 0.0, "longitude", 0.0)));
        this.assertReaderContains(this.newBehaviorReader(test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
    }

    @Test
    public void testListOfSingleElementStructsWithElementField() throws Exception {
        Path test = this.writeDirect("message ListOfSingleElementStructsWithElementField {  optional group list_of_structs (LIST) {    repeated group list {      required group element {        required float element;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_structs", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.addFloat(33.0f);
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.addFloat(34.0f);
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("list_of_structs", 0);
                rc.endMessage();
            }
        });
        Schema structWithElementField = AvroTestUtil.record("element", AvroTestUtil.field("element", AvroTestUtil.primitive(Schema.Type.FLOAT)));
        Schema elementRecord = AvroTestUtil.record("list", AvroTestUtil.field("element", structWithElementField));
        Schema oldSchema = AvroTestUtil.record("ListOfSingleElementStructsWithElementField", AvroTestUtil.optionalField("list_of_structs", AvroTestUtil.array(elementRecord)));
        GenericRecord oldRecord = AvroTestUtil.instance(oldSchema, "list_of_structs", Arrays.asList(AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(structWithElementField, "element", Float.valueOf(33.0f))), AvroTestUtil.instance(elementRecord, "element", AvroTestUtil.instance(structWithElementField, "element", Float.valueOf(34.0f)))));
        ParquetFileReader reader = ParquetFileReader.open((Configuration)new Configuration(), (Path)test);
        MessageType fileSchema = reader.getFileMetaData().getSchema();
        Assert.assertEquals((String)"Converted schema should assume 2-layer structure", (Object)oldSchema, (Object)new AvroSchemaConverter(OLD_BEHAVIOR_CONF).convert(fileSchema));
        this.assertReaderContains(this.oldBehaviorReader(test), oldSchema, (IndexedRecord[])new GenericRecord[]{oldRecord});
        Schema newSchema = AvroTestUtil.record("ListOfSingleElementStructsWithElementField", AvroTestUtil.optionalField("list_of_structs", AvroTestUtil.array(structWithElementField)));
        GenericRecord newRecord = AvroTestUtil.instance(newSchema, "list_of_structs", Arrays.asList(AvroTestUtil.instance(structWithElementField, "element", Float.valueOf(33.0f)), AvroTestUtil.instance(structWithElementField, "element", Float.valueOf(34.0f))));
        Assert.assertEquals((String)"Converted schema should assume 3-layer structure", (Object)newSchema, (Object)new AvroSchemaConverter(NEW_BEHAVIOR_CONF).convert(fileSchema));
        this.assertReaderContains(this.newBehaviorReader(test), newSchema, (IndexedRecord[])new GenericRecord[]{newRecord});
        Schema structWithDoubleElementField = AvroTestUtil.record("element", AvroTestUtil.field("element", AvroTestUtil.primitive(Schema.Type.DOUBLE)));
        Schema doubleElementRecord = AvroTestUtil.record("list", AvroTestUtil.field("element", structWithDoubleElementField));
        Schema oldDoubleSchema = AvroTestUtil.record("ListOfSingleElementStructsWithElementField", AvroTestUtil.optionalField("list_of_structs", AvroTestUtil.array(doubleElementRecord)));
        GenericRecord oldDoubleRecord = AvroTestUtil.instance(oldDoubleSchema, "list_of_structs", Arrays.asList(AvroTestUtil.instance(doubleElementRecord, "element", AvroTestUtil.instance(structWithDoubleElementField, "element", 33.0)), AvroTestUtil.instance(doubleElementRecord, "element", AvroTestUtil.instance(structWithDoubleElementField, "element", 34.0))));
        this.assertReaderContains(this.oldBehaviorReader(test, oldDoubleSchema), oldDoubleSchema, (IndexedRecord[])new GenericRecord[]{oldDoubleRecord});
        Schema newDoubleSchema = AvroTestUtil.record("ListOfSingleElementStructsWithElementField", AvroTestUtil.optionalField("list_of_structs", AvroTestUtil.array(structWithDoubleElementField)));
        GenericRecord newDoubleRecord = AvroTestUtil.instance(newDoubleSchema, "list_of_structs", Arrays.asList(AvroTestUtil.instance(structWithDoubleElementField, "element", 33.0), AvroTestUtil.instance(structWithDoubleElementField, "element", 34.0)));
        this.assertReaderContains(this.newBehaviorReader(test, newDoubleSchema), newDoubleSchema, (IndexedRecord[])new GenericRecord[]{newDoubleRecord});
    }

    public <T extends IndexedRecord> AvroParquetReader<T> oldBehaviorReader(Path path) throws IOException {
        return new AvroParquetReader(OLD_BEHAVIOR_CONF, path);
    }

    public <T extends IndexedRecord> AvroParquetReader<T> oldBehaviorReader(Path path, Schema expectedSchema) throws IOException {
        Configuration conf = new Configuration(OLD_BEHAVIOR_CONF);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)expectedSchema);
        return new AvroParquetReader(conf, path);
    }

    public <T extends IndexedRecord> AvroParquetReader<T> newBehaviorReader(Path path) throws IOException {
        return new AvroParquetReader(NEW_BEHAVIOR_CONF, path);
    }

    public <T extends IndexedRecord> AvroParquetReader<T> newBehaviorReader(Path path, Schema expectedSchema) throws IOException {
        Configuration conf = new Configuration(NEW_BEHAVIOR_CONF);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)expectedSchema);
        return new AvroParquetReader(conf, path);
    }

    public <T extends IndexedRecord> void assertReaderContains(AvroParquetReader<T> reader, Schema expectedSchema, T ... expectedRecords) throws IOException {
        for (T expectedRecord : expectedRecords) {
            IndexedRecord actualRecord = (IndexedRecord)reader.read();
            Assert.assertEquals((String)"Should match expected schema", (Object)expectedSchema, (Object)actualRecord.getSchema());
            Assert.assertEquals((String)"Should match the expected record", expectedRecord, (Object)actualRecord);
        }
        Assert.assertNull((String)("Should only contain " + expectedRecords.length + " record" + (expectedRecords.length == 1 ? "" : "s")), (Object)reader.read());
    }
}

