/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.io.Resources;
import java.io.IOException;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.junit.Assert;
import org.junit.Test;

public class TestBackwardCompatibility {
    @Test
    public void testCompatStringCompatibility() throws IOException {
        GenericRecord r;
        Path testFile = new Path(Resources.getResource((String)"strings-2.parquet").getFile());
        Configuration conf = new Configuration();
        ParquetReader reader = AvroParquetReader.builder((ReadSupport)new AvroReadSupport(), (Path)testFile).withConf(conf).build();
        while ((r = (GenericRecord)reader.read()) != null) {
            Assert.assertTrue((String)"Should read value into a String", (boolean)(r.get("text") instanceof String));
        }
    }

    @Test
    public void testStringCompatibility() throws IOException {
        GenericRecord r;
        Path testFile = new Path(Resources.getResource((String)"strings-2.parquet").getFile());
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.avro.compatible", false);
        ParquetReader reader = AvroParquetReader.builder((ReadSupport)new AvroReadSupport(), (Path)testFile).withConf(conf).build();
        while ((r = (GenericRecord)reader.read()) != null) {
            Assert.assertTrue((String)"Should read value into a String", (boolean)(r.get("text") instanceof Utf8));
        }
    }
}

