/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.parquet.avro.AvroTestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestGenericLogicalTypes {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public static final GenericData GENERIC = new GenericData();
    public static final LogicalType DECIMAL_9_2 = LogicalTypes.decimal((int)9, (int)2);
    public static final BigDecimal D1 = new BigDecimal("-34.34");
    public static final BigDecimal D2 = new BigDecimal("117230.00");

    @BeforeClass
    public static void addDecimalAndUUID() {
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
    }

    private <T> List<T> getFieldValues(Collection<GenericRecord> records, String field, Class<T> expectedClass) {
        ArrayList<T> values = new ArrayList<T>();
        for (GenericRecord record : records) {
            values.add(expectedClass.cast(record.get(field)));
        }
        return values;
    }

    @Test
    public void testReadUUID() throws IOException {
        Schema uuidSchema = AvroTestUtil.record("R", AvroTestUtil.field("uuid", LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING))));
        GenericRecord u1 = AvroTestUtil.instance(uuidSchema, "uuid", UUID.randomUUID());
        GenericRecord u2 = AvroTestUtil.instance(uuidSchema, "uuid", UUID.randomUUID());
        Schema stringSchema = AvroTestUtil.record("R", AvroTestUtil.field("uuid", Schema.create((Schema.Type)Schema.Type.STRING)));
        GenericRecord s1 = AvroTestUtil.instance(stringSchema, "uuid", u1.get("uuid").toString());
        GenericRecord s2 = AvroTestUtil.instance(stringSchema, "uuid", u2.get("uuid").toString());
        File test = this.write(stringSchema, s1, s2);
        Assert.assertEquals((String)"Should convert Strings to UUIDs", Arrays.asList(u1, u2), AvroTestUtil.read(GENERIC, uuidSchema, test));
    }

    @Test
    public void testWriteUUIDReadStringSchema() throws IOException {
        Schema uuidSchema = AvroTestUtil.record("R", AvroTestUtil.field("uuid", LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING))));
        GenericRecord u1 = AvroTestUtil.instance(uuidSchema, "uuid", UUID.randomUUID());
        GenericRecord u2 = AvroTestUtil.instance(uuidSchema, "uuid", UUID.randomUUID());
        Schema stringUuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        stringUuidSchema.addProp("avro.java.string", "String");
        Schema stringSchema = AvroTestUtil.record("R", AvroTestUtil.field("uuid", stringUuidSchema));
        GenericRecord s1 = AvroTestUtil.instance(stringSchema, "uuid", u1.get("uuid").toString());
        GenericRecord s2 = AvroTestUtil.instance(stringSchema, "uuid", u2.get("uuid").toString());
        File test = this.write(GENERIC, uuidSchema, u1, u2);
        Assert.assertEquals((String)"Should read UUIDs as Strings", Arrays.asList(s1, s2), AvroTestUtil.read(GENERIC, stringSchema, test));
    }

    @Test
    public void testWriteUUIDReadStringMissingLogicalType() throws IOException {
        Schema uuidSchema = AvroTestUtil.record("R", AvroTestUtil.field("uuid", LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING))));
        GenericRecord u1 = AvroTestUtil.instance(uuidSchema, "uuid", UUID.randomUUID());
        GenericRecord u2 = AvroTestUtil.instance(uuidSchema, "uuid", UUID.randomUUID());
        GenericRecord s1 = AvroTestUtil.instance(uuidSchema, "uuid", new Utf8(u1.get("uuid").toString()));
        GenericRecord s2 = AvroTestUtil.instance(uuidSchema, "uuid", new Utf8(u2.get("uuid").toString()));
        File test = this.write(GENERIC, uuidSchema, u1, u2);
        Assert.assertEquals((String)"Should read UUIDs as Strings", Arrays.asList(s1, s2), AvroTestUtil.read(GenericData.get(), uuidSchema, test));
    }

    @Test
    public void testWriteNullableUUID() throws IOException {
        Schema nullableUuidSchema = AvroTestUtil.record("R", AvroTestUtil.optionalField("uuid", LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING))));
        GenericRecord u1 = AvroTestUtil.instance(nullableUuidSchema, "uuid", UUID.randomUUID());
        GenericRecord u2 = AvroTestUtil.instance(nullableUuidSchema, "uuid", UUID.randomUUID());
        Schema stringUuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        stringUuidSchema.addProp("avro.java.string", "String");
        Schema nullableStringSchema = AvroTestUtil.record("R", AvroTestUtil.optionalField("uuid", stringUuidSchema));
        GenericRecord s1 = AvroTestUtil.instance(nullableStringSchema, "uuid", u1.get("uuid").toString());
        GenericRecord s2 = AvroTestUtil.instance(nullableStringSchema, "uuid", u2.get("uuid").toString());
        File test = this.write(GENERIC, nullableUuidSchema, u1, u2);
        Assert.assertEquals((String)"Should read UUIDs as Strings", Arrays.asList(s1, s2), AvroTestUtil.read(GENERIC, nullableStringSchema, test));
    }

    @Test
    public void testReadDecimalFixed() throws IOException {
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        Schema fixedRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", fixedSchema));
        Schema decimalSchema = DECIMAL_9_2.addToSchema(Schema.createFixed((String)"aFixed", null, null, (int)4));
        Schema decimalRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", decimalSchema));
        GenericRecord r1 = AvroTestUtil.instance(decimalRecord, "dec", D1);
        GenericRecord r2 = AvroTestUtil.instance(decimalRecord, "dec", D2);
        List<GenericRecord> expected = Arrays.asList(r1, r2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericRecord r1fixed = AvroTestUtil.instance(fixedRecord, "dec", conversion.toFixed((Object)D1, fixedSchema, DECIMAL_9_2));
        GenericRecord r2fixed = AvroTestUtil.instance(fixedRecord, "dec", conversion.toFixed((Object)D2, fixedSchema, DECIMAL_9_2));
        File test = this.write(fixedRecord, r1fixed, r2fixed);
        Assert.assertEquals((String)"Should convert fixed to BigDecimals", expected, AvroTestUtil.read(GENERIC, decimalRecord, test));
    }

    @Test
    public void testWriteDecimalFixed() throws IOException {
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        Schema fixedRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", fixedSchema));
        Schema decimalSchema = DECIMAL_9_2.addToSchema(Schema.createFixed((String)"aFixed", null, null, (int)4));
        Schema decimalRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", decimalSchema));
        GenericRecord r1 = AvroTestUtil.instance(decimalRecord, "dec", D1);
        GenericRecord r2 = AvroTestUtil.instance(decimalRecord, "dec", D2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericRecord r1fixed = AvroTestUtil.instance(fixedRecord, "dec", conversion.toFixed((Object)D1, fixedSchema, DECIMAL_9_2));
        GenericRecord r2fixed = AvroTestUtil.instance(fixedRecord, "dec", conversion.toFixed((Object)D2, fixedSchema, DECIMAL_9_2));
        List<GenericRecord> expected = Arrays.asList(r1fixed, r2fixed);
        File test = this.write(GENERIC, decimalRecord, r1, r2);
        Assert.assertEquals((String)"Should read BigDecimals as fixed", expected, AvroTestUtil.read(GENERIC, fixedRecord, test));
    }

    @Test
    public void testReadDecimalBytes() throws IOException {
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema bytesRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", bytesSchema));
        Schema decimalSchema = DECIMAL_9_2.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema decimalRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", decimalSchema));
        GenericRecord r1 = AvroTestUtil.instance(decimalRecord, "dec", D1);
        GenericRecord r2 = AvroTestUtil.instance(decimalRecord, "dec", D2);
        List<GenericRecord> expected = Arrays.asList(r1, r2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericRecord r1bytes = AvroTestUtil.instance(bytesRecord, "dec", conversion.toBytes((Object)D1, bytesSchema, DECIMAL_9_2));
        GenericRecord r2bytes = AvroTestUtil.instance(bytesRecord, "dec", conversion.toBytes((Object)D2, bytesSchema, DECIMAL_9_2));
        File test = this.write(bytesRecord, r1bytes, r2bytes);
        Assert.assertEquals((String)"Should convert bytes to BigDecimals", expected, AvroTestUtil.read(GENERIC, decimalRecord, test));
    }

    @Test
    public void testWriteDecimalBytes() throws IOException {
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema bytesRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", bytesSchema));
        Schema decimalSchema = DECIMAL_9_2.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema decimalRecord = AvroTestUtil.record("R", AvroTestUtil.field("dec", decimalSchema));
        GenericRecord r1 = AvroTestUtil.instance(decimalRecord, "dec", D1);
        GenericRecord r2 = AvroTestUtil.instance(decimalRecord, "dec", D2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericRecord r1bytes = AvroTestUtil.instance(bytesRecord, "dec", conversion.toBytes((Object)D1, bytesSchema, DECIMAL_9_2));
        GenericRecord r2bytes = AvroTestUtil.instance(bytesRecord, "dec", conversion.toBytes((Object)D2, bytesSchema, DECIMAL_9_2));
        List<GenericRecord> expected = Arrays.asList(r1bytes, r2bytes);
        File test = this.write(GENERIC, decimalRecord, r1, r2);
        Assert.assertEquals((String)"Should read BigDecimals as bytes", expected, AvroTestUtil.read(GENERIC, bytesRecord, test));
    }

    private <D> File write(Schema schema, D ... data) throws IOException {
        return this.write(GenericData.get(), schema, data);
    }

    private <D> File write(GenericData model, Schema schema, D ... data) throws IOException {
        return AvroTestUtil.write(this.temp, model, schema, data);
    }
}

