/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroTestUtil;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestReadWrite {
    private final boolean compat;
    private final Configuration testConf = new Configuration();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public TestReadWrite(boolean compat) {
        this.compat = compat;
        this.testConf.setBoolean("parquet.avro.compatible", compat);
        this.testConf.setBoolean("parquet.avro.add-list-element-records", false);
        this.testConf.setBoolean("parquet.avro.write-old-list-structure", false);
    }

    @Test
    public void testEmptyArray() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"array.avsc").openStream());
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();
        ArrayList emptyArray = new ArrayList();
        GenericData.Record record = new GenericRecordBuilder(schema).set("myarray", emptyArray).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals(emptyArray, (Object)nextRecord.get("myarray"));
    }

    @Test
    public void testEmptyMap() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"map.avsc").openStream());
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();
        ImmutableMap emptyMap = new ImmutableMap.Builder().build();
        GenericData.Record record = new GenericRecordBuilder(schema).set("mymap", (Object)emptyMap).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)emptyMap, (Object)nextRecord.get("mymap"));
    }

    @Test
    public void testMapWithNulls() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"map_with_nulls.avsc").openStream());
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();
        HashMap<CharSequence, Integer> map = new HashMap<CharSequence, Integer>();
        map.put(this.str("thirty-four"), 34);
        map.put(this.str("eleventy-one"), null);
        map.put(this.str("one-hundred"), 100);
        GenericData.Record record = new GenericRecordBuilder(schema).set("mymap", map).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals(map, (Object)nextRecord.get("mymap"));
    }

    @Test(expected=RuntimeException.class)
    public void testMapRequiredValueWithNull() throws Exception {
        Schema schema = Schema.createRecord((String)"record1", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("mymap", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.INT)), null, null)}));
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("thirty-four", 34);
        map.put("eleventy-one", null);
        map.put("one-hundred", 100);
        GenericData.Record record = new GenericRecordBuilder(schema).set("mymap", map).build();
        writer.write((Object)record);
    }

    @Test
    public void testMapWithUtf8Key() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"map.avsc").openStream());
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();
        GenericData.Record record = new GenericRecordBuilder(schema).set("mymap", (Object)ImmutableMap.of((Object)new Utf8("a"), (Object)1, (Object)new Utf8("b"), (Object)2)).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)ImmutableMap.of((Object)this.str("a"), (Object)1, (Object)this.str("b"), (Object)2), (Object)nextRecord.get("mymap"));
    }

    @Test
    public void testDecimalValues() throws Exception {
        GenericRecord rec;
        Schema decimalSchema = Schema.createRecord((String)"myrecord", null, null, (boolean)false);
        Schema decimal = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        decimalSchema.setFields(Collections.singletonList(new Schema.Field("dec", decimal, null, null)));
        GenericData decimalSupport = new GenericData();
        decimalSupport.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        File file = this.temp.newFile("decimal.parquet");
        file.delete();
        Path path = new Path(file.toString());
        ParquetWriter writer = AvroParquetWriter.builder((Path)path).withDataModel(decimalSupport).withSchema(decimalSchema).build();
        Random random = new Random(34L);
        GenericRecordBuilder builder = new GenericRecordBuilder(decimalSchema);
        ArrayList expected = Lists.newArrayList();
        for (int i = 0; i < 1000; ++i) {
            BigDecimal dec = new BigDecimal(new BigInteger(31, random), 2);
            builder.set("dec", (Object)dec);
            rec = builder.build();
            expected.add(rec);
            writer.write((Object)builder.build());
        }
        writer.close();
        ParquetReader reader = AvroParquetReader.builder((Path)path).withDataModel(decimalSupport).disableCompatibility().build();
        ArrayList records = Lists.newArrayList();
        while ((rec = (GenericRecord)reader.read()) != null) {
            records.add(rec);
        }
        reader.close();
        Assert.assertTrue((String)"dec field should be a BigDecimal instance", (boolean)(((GenericRecord)records.get(0)).get("dec") instanceof BigDecimal));
        Assert.assertEquals((String)"Content should match", (Object)expected, (Object)records);
    }

    @Test
    public void testFixedDecimalValues() throws Exception {
        GenericRecord rec;
        Schema decimalSchema = Schema.createRecord((String)"myrecord", null, null, (boolean)false);
        Schema decimal = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.createFixed((String)"dec", null, null, (int)4));
        decimalSchema.setFields(Collections.singletonList(new Schema.Field("dec", decimal, null, null)));
        GenericData decimalSupport = new GenericData();
        decimalSupport.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        File file = this.temp.newFile("decimal.parquet");
        file.delete();
        Path path = new Path(file.toString());
        ParquetWriter writer = AvroParquetWriter.builder((Path)path).withDataModel(decimalSupport).withSchema(decimalSchema).build();
        Random random = new Random(34L);
        GenericRecordBuilder builder = new GenericRecordBuilder(decimalSchema);
        ArrayList expected = Lists.newArrayList();
        for (int i = 0; i < 1000; ++i) {
            BigDecimal dec = new BigDecimal(new BigInteger(31, random), 2);
            builder.set("dec", (Object)dec);
            rec = builder.build();
            expected.add(rec);
            writer.write((Object)builder.build());
        }
        writer.close();
        ParquetReader reader = AvroParquetReader.builder((Path)path).withDataModel(decimalSupport).disableCompatibility().build();
        ArrayList records = Lists.newArrayList();
        while ((rec = (GenericRecord)reader.read()) != null) {
            records.add(rec);
        }
        reader.close();
        Assert.assertTrue((String)"dec field should be a BigDecimal instance", (boolean)(((GenericRecord)records.get(0)).get("dec") instanceof BigDecimal));
        Assert.assertEquals((String)"Content should match", (Object)expected, (Object)records);
    }

    @Test
    public void testAll() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"all.avsc").openStream());
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();
        GenericData.Record nestedRecord = new GenericRecordBuilder(schema.getField("mynestedrecord").schema()).set("mynestedint", (Object)1).build();
        List<Integer> integerArray = Arrays.asList(1, 2, 3);
        GenericData.Array genericIntegerArray = new GenericData.Array(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)), integerArray);
        GenericData.Fixed genericFixed = new GenericData.Fixed(Schema.createFixed((String)"fixed", null, null, (int)1), new byte[]{65});
        ArrayList emptyArray = new ArrayList();
        ImmutableMap emptyMap = new ImmutableMap.Builder().build();
        Schema arrayOfOptionalIntegers = Schema.createArray((Schema)AvroTestUtil.optional(Schema.create((Schema.Type)Schema.Type.INT)));
        GenericData.Array genericIntegerArrayWithNulls = new GenericData.Array(arrayOfOptionalIntegers, Arrays.asList(1, null, 2, null, 3));
        GenericData.Record record = new GenericRecordBuilder(schema).set("mynull", null).set("myboolean", (Object)true).set("myint", (Object)1).set("mylong", (Object)2L).set("myfloat", (Object)Float.valueOf(3.1f)).set("mydouble", (Object)4.1).set("mybytes", (Object)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))).set("mystring", (Object)"hello").set("mynestedrecord", (Object)nestedRecord).set("myenum", (Object)"a").set("myarray", (Object)genericIntegerArray).set("myemptyarray", emptyArray).set("myoptionalarray", (Object)genericIntegerArray).set("myarrayofoptional", (Object)genericIntegerArrayWithNulls).set("mymap", (Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2)).set("myemptymap", (Object)emptyMap).set("myfixed", (Object)genericFixed).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        String expectedEnumSymbol = this.compat ? "a" : new GenericData.EnumSymbol(schema.getField("myenum").schema(), "a");
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals(null, (Object)nextRecord.get("mynull"));
        Assert.assertEquals((Object)true, (Object)nextRecord.get("myboolean"));
        Assert.assertEquals((Object)1, (Object)nextRecord.get("myint"));
        Assert.assertEquals((Object)2L, (Object)nextRecord.get("mylong"));
        Assert.assertEquals((Object)Float.valueOf(3.1f), (Object)nextRecord.get("myfloat"));
        Assert.assertEquals((Object)4.1, (Object)nextRecord.get("mydouble"));
        Assert.assertEquals((Object)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), (Object)nextRecord.get("mybytes"));
        Assert.assertEquals((Object)this.str("hello"), (Object)nextRecord.get("mystring"));
        Assert.assertEquals((Object)expectedEnumSymbol, (Object)nextRecord.get("myenum"));
        Assert.assertEquals((Object)nestedRecord, (Object)nextRecord.get("mynestedrecord"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myarray"));
        Assert.assertEquals(emptyArray, (Object)nextRecord.get("myemptyarray"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myoptionalarray"));
        Assert.assertEquals((Object)genericIntegerArrayWithNulls, (Object)nextRecord.get("myarrayofoptional"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)this.str("a"), (Object)1, (Object)this.str("b"), (Object)2), (Object)nextRecord.get("mymap"));
        Assert.assertEquals((Object)emptyMap, (Object)nextRecord.get("myemptymap"));
        Assert.assertEquals((Object)genericFixed, (Object)nextRecord.get("myfixed"));
    }

    @Test
    public void testAllUsingDefaultAvroSchema() throws Exception {
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter parquetWriter = new ParquetWriter(file, (WriteSupport)new WriteSupport<Map<String, Object>>(){
            private RecordConsumer recordConsumer;

            public WriteSupport.WriteContext init(Configuration configuration) {
                return new WriteSupport.WriteContext(MessageTypeParser.parseMessageType((String)"message org.apache.parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated int32 array;\n  }\n  optional group myoptionalarray (LIST) {\n    repeated int32 array;\n  }\n  required group myarrayofoptional (LIST) {\n    repeated group list {\n      optional int32 element;\n    }\n  }\n  required group myrecordarray (LIST) {\n    repeated group array {\n      required int32 a;\n      required int32 b;\n    }\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n"), new HashMap());
            }

            public void prepareForWrite(RecordConsumer recordConsumer) {
                this.recordConsumer = recordConsumer;
            }

            public void write(Map<String, Object> record) {
                this.recordConsumer.startMessage();
                int index = 0;
                this.recordConsumer.startField("myboolean", index);
                this.recordConsumer.addBoolean(((Boolean)record.get("myboolean")).booleanValue());
                this.recordConsumer.endField("myboolean", index++);
                this.recordConsumer.startField("myint", index);
                this.recordConsumer.addInteger(((Integer)record.get("myint")).intValue());
                this.recordConsumer.endField("myint", index++);
                this.recordConsumer.startField("mylong", index);
                this.recordConsumer.addLong(((Long)record.get("mylong")).longValue());
                this.recordConsumer.endField("mylong", index++);
                this.recordConsumer.startField("myfloat", index);
                this.recordConsumer.addFloat(((Float)record.get("myfloat")).floatValue());
                this.recordConsumer.endField("myfloat", index++);
                this.recordConsumer.startField("mydouble", index);
                this.recordConsumer.addDouble(((Double)record.get("mydouble")).doubleValue());
                this.recordConsumer.endField("mydouble", index++);
                this.recordConsumer.startField("mybytes", index);
                this.recordConsumer.addBinary(Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)record.get("mybytes"))));
                this.recordConsumer.endField("mybytes", index++);
                this.recordConsumer.startField("mystring", index);
                this.recordConsumer.addBinary(Binary.fromString((String)((String)record.get("mystring"))));
                this.recordConsumer.endField("mystring", index++);
                this.recordConsumer.startField("mynestedrecord", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("mynestedint", 0);
                this.recordConsumer.addInteger(((Integer)record.get("mynestedint")).intValue());
                this.recordConsumer.endField("mynestedint", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("mynestedrecord", index++);
                this.recordConsumer.startField("myenum", index);
                this.recordConsumer.addBinary(Binary.fromString((String)((String)record.get("myenum"))));
                this.recordConsumer.endField("myenum", index++);
                this.recordConsumer.startField("myarray", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("array", 0);
                for (int val : (int[])record.get("myarray")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("array", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myarray", index++);
                this.recordConsumer.startField("myoptionalarray", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("array", 0);
                for (int val : (int[])record.get("myoptionalarray")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("array", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myoptionalarray", index++);
                this.recordConsumer.startField("myarrayofoptional", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("list", 0);
                for (Integer val : (Integer[])record.get("myarrayofoptional")) {
                    this.recordConsumer.startGroup();
                    if (val != null) {
                        this.recordConsumer.startField("element", 0);
                        this.recordConsumer.addInteger(val.intValue());
                        this.recordConsumer.endField("element", 0);
                    }
                    this.recordConsumer.endGroup();
                }
                this.recordConsumer.endField("list", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myarrayofoptional", index++);
                this.recordConsumer.startField("myrecordarray", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("array", 0);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("a", 0);
                for (int val : (int[])record.get("myrecordarraya")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("a", 0);
                this.recordConsumer.startField("b", 1);
                for (int val : (int[])record.get("myrecordarrayb")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("b", 1);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("array", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myrecordarray", index++);
                this.recordConsumer.startField("mymap", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("map", 0);
                this.recordConsumer.startGroup();
                Map map = (Map)record.get("mymap");
                this.recordConsumer.startField("key", 0);
                for (String key : map.keySet()) {
                    this.recordConsumer.addBinary(Binary.fromString((String)key));
                }
                this.recordConsumer.endField("key", 0);
                this.recordConsumer.startField("value", 1);
                Iterator<Object> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    int val = (Integer)iterator.next();
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("value", 1);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("map", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("mymap", index++);
                this.recordConsumer.startField("myfixed", index);
                this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])((byte[])record.get("myfixed"))));
                this.recordConsumer.endField("myfixed", index++);
                this.recordConsumer.endMessage();
            }
        });
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("myboolean", true);
        record.put("myint", 1);
        record.put("mylong", 2L);
        record.put("myfloat", Float.valueOf(3.1f));
        record.put("mydouble", 4.1);
        record.put("mybytes", ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        record.put("mystring", "hello");
        record.put("myenum", "a");
        record.put("mynestedint", 1);
        record.put("myarray", new int[]{1, 2, 3});
        record.put("myoptionalarray", new int[]{1, 2, 3});
        record.put("myarrayofoptional", new Integer[]{1, null, 2, null, 3});
        record.put("myrecordarraya", new int[]{1, 2, 3});
        record.put("myrecordarrayb", new int[]{4, 5, 6});
        record.put("mymap", ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
        record.put("myfixed", new byte[]{65});
        parquetWriter.write(record);
        parquetWriter.close();
        Schema nestedRecordSchema = Schema.createRecord((String)"mynestedrecord", null, null, (boolean)false);
        nestedRecordSchema.setFields(Arrays.asList(new Schema.Field("mynestedint", Schema.create((Schema.Type)Schema.Type.INT), null, null)));
        GenericData.Record nestedRecord = new GenericRecordBuilder(nestedRecordSchema).set("mynestedint", (Object)1).build();
        List<Integer> integerArray = Arrays.asList(1, 2, 3);
        List<Integer> ingeterArrayWithNulls = Arrays.asList(1, null, 2, null, 3);
        Schema recordArraySchema = Schema.createRecord((String)"array", null, null, (boolean)false);
        recordArraySchema.setFields(Arrays.asList(new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.INT), null, null), new Schema.Field("b", Schema.create((Schema.Type)Schema.Type.INT), null, null)));
        GenericRecordBuilder builder = new GenericRecordBuilder(recordArraySchema);
        ArrayList<GenericData.Record> recordArray = new ArrayList<GenericData.Record>();
        recordArray.add(builder.set("a", (Object)1).set("b", (Object)4).build());
        recordArray.add(builder.set("a", (Object)2).set("b", (Object)5).build());
        recordArray.add(builder.set("a", (Object)3).set("b", (Object)6).build());
        GenericData.Array genericRecordArray = new GenericData.Array(Schema.createArray((Schema)recordArraySchema), recordArray);
        GenericData.Fixed genericFixed = new GenericData.Fixed(Schema.createFixed((String)"fixed", null, null, (int)1), new byte[]{65});
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)true, (Object)nextRecord.get("myboolean"));
        Assert.assertEquals((Object)1, (Object)nextRecord.get("myint"));
        Assert.assertEquals((Object)2L, (Object)nextRecord.get("mylong"));
        Assert.assertEquals((Object)Float.valueOf(3.1f), (Object)nextRecord.get("myfloat"));
        Assert.assertEquals((Object)4.1, (Object)nextRecord.get("mydouble"));
        Assert.assertEquals((Object)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), (Object)nextRecord.get("mybytes"));
        Assert.assertEquals((Object)this.str("hello"), (Object)nextRecord.get("mystring"));
        Assert.assertEquals((Object)this.str("a"), (Object)nextRecord.get("myenum"));
        Assert.assertEquals((Object)nestedRecord, (Object)nextRecord.get("mynestedrecord"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myarray"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myoptionalarray"));
        Assert.assertEquals(ingeterArrayWithNulls, (Object)nextRecord.get("myarrayofoptional"));
        Assert.assertEquals((Object)genericRecordArray, (Object)nextRecord.get("myrecordarray"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)this.str("a"), (Object)1, (Object)this.str("b"), (Object)2), (Object)nextRecord.get("mymap"));
        Assert.assertEquals((Object)genericFixed, (Object)nextRecord.get("myfixed"));
    }

    @Test
    public void testUnionWithSingleNonNullType() throws Exception {
        Schema avroSchema = Schema.createRecord((String)"SingleStringUnionRecord", null, null, (boolean)false);
        avroSchema.setFields(Collections.singletonList(new Schema.Field("value", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.STRING)}), null, null)));
        Path file = new Path(this.createTempFile().getPath());
        ParquetWriter parquetWriter = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(avroSchema).withConf(new Configuration())).build();
        GenericData.Record record = new GenericRecordBuilder(avroSchema).set("value", (Object)"theValue").build();
        parquetWriter.write((Object)record);
        parquetWriter.close();
        AvroParquetReader reader = new AvroParquetReader(this.testConf, file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)this.str("theValue"), (Object)nextRecord.get("value"));
    }

    @Test
    public void testDuplicatedValuesWithDictionary() throws Exception {
        Schema schema = (Schema)SchemaBuilder.record((String)"spark_schema").fields().optionalBytes("value").endRecord();
        Path file = new Path(this.createTempFile().getPath());
        String[] records = new String[]{"one", "two", "three", "three", "two", "one", "zero"};
        try (ParquetWriter writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)file).withSchema(schema).withConf(this.testConf)).build();){
            for (String record : records) {
                writer.write((Object)new GenericRecordBuilder(schema).set("value", (Object)record.getBytes()).build());
            }
        }
        var5_5 = null;
        try (ParquetReader reader = AvroParquetReader.builder((Path)file).withConf(this.testConf).build();){
            GenericRecord rec;
            int i = 0;
            while ((rec = (GenericRecord)reader.read()) != null) {
                ByteBuffer buf = (ByteBuffer)rec.get("value");
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                Assert.assertEquals((Object)records[i++], (Object)new String(bytes));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private File createTempFile() throws IOException {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        return tmp;
    }

    public CharSequence str(String value) {
        return this.compat ? value : new Utf8(value);
    }
}

