/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Union;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.parquet.avro.AvroParquetInputFormat;
import org.apache.parquet.avro.AvroParquetOutputFormat;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.avro.ReflectDataSupplier;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.filter.ColumnPredicates;
import org.apache.parquet.filter.ColumnRecordFilter;
import org.apache.parquet.filter.RecordFilter;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReflectInputOutputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestReflectInputOutputFormat.class);
    public static final Schema CAR_SCHEMA = ReflectData.get().getSchema(Car.class);
    public static final Schema SHORT_CAR_SCHEMA = ReflectData.get().getSchema(ShortCar.class);
    final Configuration conf = new Configuration();
    final Path inputPath = new Path("src/test/java/org/apache/parquet/avro/TestReflectInputOutputFormat.java");
    final Path parquetPath = new Path("target/test/hadoop/TestReflectInputOutputFormat/parquet");
    final Path outputPath = new Path("target/test/hadoop/TestReflectInputOutputFormat/out");

    public static Car nextRecord(int i) {
        Car car = new Car();
        car.doors = 2;
        car.make = "Tesla";
        car.model = String.format("Model X v%d", i % 2);
        Car.access$302(car, String.format("1VXBR12EXCP%06d", i).getBytes());
        car.year = 2014 + i;
        car.registration = "California";
        LeatherTrim trim = new LeatherTrim();
        trim.colour = "black";
        car.optionalExtra = trim;
        Engine engine = new Engine();
        engine.capacity = 85.0f;
        engine.type = i % 2 == 0 ? EngineType.ELECTRIC : EngineType.PETROL;
        engine.hasTurboCharger = false;
        car.engine = engine;
        if (i % 4 == 0) {
            Service service = new Service();
            service.date = 1374084640L;
            service.mechanic = "Elon Musk";
            car.serviceHistory = Lists.newArrayList();
            car.serviceHistory.add(service);
        }
        return car;
    }

    @Before
    public void createParquetFile() throws Exception {
        this.conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)this.conf, ReflectDataSupplier.class);
        AvroWriteSupport.setAvroDataSupplier((Configuration)this.conf, ReflectDataSupplier.class);
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
        Job job = new Job(this.conf, "write");
        TextInputFormat.addInputPath((Job)job, (Path)this.inputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)this.parquetPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)CAR_SCHEMA);
        AvroParquetOutputFormat.setAvroDataSupplier((Job)job, ReflectDataSupplier.class);
        this.waitForJob(job);
    }

    @Test
    public void testReadWrite() throws Exception {
        Car car;
        this.conf.setBoolean("parquet.avro.compatible", false);
        Job job = new Job(this.conf, "read");
        job.setInputFormatClass(AvroParquetInputFormat.class);
        AvroParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.parquetPath});
        AvroParquetInputFormat.setUnboundRecordFilter((Job)job, ElectricCarFilter.class);
        Schema projection = Schema.createRecord((String)CAR_SCHEMA.getName(), (String)CAR_SCHEMA.getDoc(), (String)CAR_SCHEMA.getNamespace(), (boolean)false);
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : ReflectData.get().getSchema(Car.class).getFields()) {
            if ("optionalExtra".equals(field.name())) continue;
            fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order()));
        }
        projection.setFields((List)fields);
        AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)projection);
        job.setMapperClass(MyMapper2.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)CAR_SCHEMA);
        this.waitForJob(job);
        Path mapperOutput = new Path(this.outputPath.toString(), "part-m-00000.parquet");
        AvroParquetReader out = new AvroParquetReader(this.conf, mapperOutput);
        Car previousCar = null;
        int lineNumber = 0;
        while ((car = (Car)out.read()) != null) {
            if (previousCar != null) {
                Assert.assertTrue((car.model == previousCar.model ? 1 : 0) != 0);
            }
            if (car.engine.type == EngineType.PETROL) {
                Assert.fail((String)"UnboundRecordFilter failed to remove cars with PETROL engines");
            }
            Car expectedCar = TestReflectInputOutputFormat.nextRecord(lineNumber * 2);
            expectedCar.optionalExtra = null;
            Assert.assertEquals((String)("line " + lineNumber), (Object)expectedCar, (Object)car);
            ++lineNumber;
            previousCar = car;
        }
        out.close();
    }

    @Test
    public void testReadWriteChangedCar() throws Exception {
        ShortCar car;
        this.conf.setBoolean("parquet.avro.compatible", false);
        Job job = new Job(this.conf, "read changed/short");
        job.setInputFormatClass(AvroParquetInputFormat.class);
        AvroParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.parquetPath});
        AvroParquetInputFormat.setUnboundRecordFilter((Job)job, ElectricCarFilter.class);
        Schema projection = Schema.createRecord((String)CAR_SCHEMA.getName(), (String)CAR_SCHEMA.getDoc(), (String)CAR_SCHEMA.getNamespace(), (boolean)false);
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : CAR_SCHEMA.getFields()) {
            if (!"engine".equals(field.name()) && !"year".equals(field.name()) && !"vin".equals(field.name())) continue;
            fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order()));
        }
        projection.setFields((List)fields);
        AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)projection);
        AvroParquetInputFormat.setAvroReadSchema((Job)job, (Schema)SHORT_CAR_SCHEMA);
        job.setMapperClass(MyMapperShort.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)SHORT_CAR_SCHEMA);
        this.waitForJob(job);
        Path mapperOutput = new Path(this.outputPath.toString(), "part-m-00000.parquet");
        AvroParquetReader out = new AvroParquetReader(this.conf, mapperOutput);
        int lineNumber = 0;
        while ((car = (ShortCar)out.read()) != null) {
            Car expectedCar = TestReflectInputOutputFormat.nextRecord(lineNumber * 2);
            Assert.assertNull((Object)car.make);
            Assert.assertEquals((Object)car.engine, (Object)expectedCar.engine);
            Assert.assertEquals((long)car.year, (long)expectedCar.year);
            Assert.assertArrayEquals((byte[])car.vin, (byte[])expectedCar.vin);
            ++lineNumber;
        }
        out.close();
    }

    private void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            LOG.debug("waiting for job {}", (Object)job.getJobName());
            Thread.sleep(100L);
        }
        LOG.info("status for job {}: {}", (Object)job.getJobName(), (Object)(job.isSuccessful() ? "SUCCESS" : "FAILURE"));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    @After
    public void deleteOutputFile() throws IOException {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
    }

    public static class ElectricCarFilter
    implements UnboundRecordFilter {
        private final UnboundRecordFilter filter = ColumnRecordFilter.column((String)"engine.type", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((Enum)org.apache.parquet.avro.EngineType.ELECTRIC));

        public RecordFilter bind(Iterable<ColumnReader> readers) {
            return this.filter.bind(readers);
        }
    }

    public static class MyMapperShort
    extends Mapper<Void, ShortCar, Void, ShortCar> {
        protected void map(Void key, ShortCar car, Mapper.Context context) throws IOException, InterruptedException {
            if (car != null) {
                context.write(null, (Object)car);
            }
        }
    }

    public static class MyMapper2
    extends Mapper<Void, Car, Void, Car> {
        protected void map(Void key, Car car, Mapper.Context context) throws IOException, InterruptedException {
            if (car != null) {
                context.write(null, (Object)car);
            }
        }
    }

    public static class MyMapper
    extends Mapper<LongWritable, Text, Void, Car> {
        public void run(Mapper.Context context) throws IOException, InterruptedException {
            for (int i = 0; i < 10; ++i) {
                context.write(null, (Object)TestReflectInputOutputFormat.nextRecord(i));
            }
        }
    }

    public static class ShortCar {
        @Nullable
        private String make = null;
        private Engine engine;
        private long year;
        private byte[] vin;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShortCar shortCar = (ShortCar)o;
            if (this.year != shortCar.year) {
                return false;
            }
            if (!this.engine.equals(shortCar.engine)) {
                return false;
            }
            if (this.make != null ? !this.make.equals(shortCar.make) : shortCar.make != null) {
                return false;
            }
            return Arrays.equals(this.vin, shortCar.vin);
        }

        public int hashCode() {
            int result = this.make != null ? this.make.hashCode() : 0;
            result = 31 * result + this.engine.hashCode();
            result = 31 * result + (int)(this.year ^ this.year >>> 32);
            result = 31 * result + Arrays.hashCode(this.vin);
            return result;
        }
    }

    public static class Car {
        private long year;
        private String registration;
        private String make;
        private String model;
        private byte[] vin;
        private int doors;
        private Engine engine;
        private Extra optionalExtra = null;
        @Nullable
        private List<Service> serviceHistory = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Car car = (Car)o;
            if (this.doors != car.doors) {
                return false;
            }
            if (this.year != car.year) {
                return false;
            }
            if (!this.engine.equals(car.engine)) {
                return false;
            }
            if (!this.make.equals(car.make)) {
                return false;
            }
            if (!this.model.equals(car.model)) {
                return false;
            }
            if (this.optionalExtra != null ? !this.optionalExtra.equals(car.optionalExtra) : car.optionalExtra != null) {
                return false;
            }
            if (!this.registration.equals(car.registration)) {
                return false;
            }
            if (this.serviceHistory != null ? !this.serviceHistory.equals(car.serviceHistory) : car.serviceHistory != null) {
                return false;
            }
            return Arrays.equals(this.vin, car.vin);
        }

        public int hashCode() {
            int result = (int)(this.year ^ this.year >>> 32);
            result = 31 * result + this.registration.hashCode();
            result = 31 * result + this.make.hashCode();
            result = 31 * result + this.model.hashCode();
            result = 31 * result + Arrays.hashCode(this.vin);
            result = 31 * result + this.doors;
            result = 31 * result + this.engine.hashCode();
            result = 31 * result + (this.optionalExtra != null ? this.optionalExtra.hashCode() : 0);
            result = 31 * result + (this.serviceHistory != null ? this.serviceHistory.hashCode() : 0);
            return result;
        }

        static /* synthetic */ byte[] access$302(Car x0, byte[] x1) {
            x0.vin = x1;
            return x1;
        }
    }

    @Union(value={Void.class, Stereo.class, LeatherTrim.class})
    public static class Extra {
    }

    public static class LeatherTrim
    extends Extra {
        private String colour;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeatherTrim that = (LeatherTrim)o;
            return this.colour.equals(that.colour);
        }

        public int hashCode() {
            return this.colour.hashCode();
        }
    }

    public static class Stereo
    extends Extra {
        private String make;
        private int speakers;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stereo stereo = (Stereo)o;
            if (this.speakers != stereo.speakers) {
                return false;
            }
            return this.make.equals(stereo.make);
        }

        public int hashCode() {
            int result = this.make.hashCode();
            result = 31 * result + this.speakers;
            return result;
        }
    }

    public static class Engine {
        private EngineType type;
        private float capacity;
        private boolean hasTurboCharger;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Engine engine = (Engine)o;
            if (Float.compare(engine.capacity, this.capacity) != 0) {
                return false;
            }
            if (this.hasTurboCharger != engine.hasTurboCharger) {
                return false;
            }
            return this.type == engine.type;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.capacity != 0.0f ? Float.floatToIntBits(this.capacity) : 0);
            result = 31 * result + (this.hasTurboCharger ? 1 : 0);
            return result;
        }
    }

    public static enum EngineType {
        DIESEL,
        PETROL,
        ELECTRIC;

    }

    public static class Service {
        private long date;
        private String mechanic;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Service service = (Service)o;
            if (this.date != service.date) {
                return false;
            }
            return this.mechanic.equals(service.mechanic);
        }

        public int hashCode() {
            int result = (int)(this.date ^ this.date >>> 32);
            result = 31 * result + this.mechanic.hashCode();
            return result;
        }
    }
}

