/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.GenericDataSupplier;
import org.apache.parquet.avro.ReflectDataSupplier;
import org.apache.parquet.avro.SpecificDataSupplier;
import org.apache.parquet.avro.StringBehaviorTest;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestStringBehavior {
    public static Schema SCHEMA = null;
    public static BigDecimal BIG_DECIMAL = new BigDecimal("3.14");
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public Path parquetFile;
    public File avroFile;

    @BeforeClass
    public static void readSchemaFile() throws IOException {
        SCHEMA = new Schema.Parser().parse(Resources.getResource((String)"stringBehavior.avsc").openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void writeDataFiles() throws IOException {
        GenericData.Record record = new GenericRecordBuilder(SCHEMA).set("default_class", (Object)"default").set("string_class", (Object)"string").set("stringable_class", (Object)BIG_DECIMAL.toString()).set("default_map", (Object)ImmutableMap.of((Object)"default_key", (Object)34)).set("string_map", (Object)ImmutableMap.of((Object)"string_key", (Object)35)).set("stringable_map", (Object)ImmutableMap.of((Object)BIG_DECIMAL.toString(), (Object)36)).build();
        File file = this.temp.newFile("parquet");
        file.delete();
        file.deleteOnExit();
        this.parquetFile = new Path(file.getPath());
        try (ParquetWriter parquet = AvroParquetWriter.builder((Path)this.parquetFile).withDataModel(GenericData.get()).withSchema(SCHEMA).build();){
            parquet.write((Object)record);
        }
        this.avroFile = this.temp.newFile("avro");
        this.avroFile.delete();
        this.avroFile.deleteOnExit();
        try (DataFileWriter avro = new DataFileWriter((DatumWriter)new GenericDatumWriter(SCHEMA)).create(SCHEMA, this.avroFile);){
            avro.append((Object)record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGeneric() throws IOException {
        GenericRecord parquetRecord;
        GenericRecord avroRecord;
        try (DataFileReader avro = new DataFileReader(this.avroFile, (DatumReader)new GenericDatumReader(SCHEMA));){
            avroRecord = (GenericRecord)avro.next();
        }
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)conf, GenericDataSupplier.class);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)SCHEMA);
        try (ParquetReader parquet = AvroParquetReader.builder((Path)this.parquetFile).withConf(conf).build();){
            parquetRecord = (GenericRecord)parquet.read();
        }
        Assert.assertEquals((String)"Avro default string class should be Utf8", Utf8.class, avroRecord.get("default_class").getClass());
        Assert.assertEquals((String)"Parquet default string class should be Utf8", Utf8.class, parquetRecord.get("default_class").getClass());
        Assert.assertEquals((String)"Avro avro.java.string=String class should be String", String.class, avroRecord.get("string_class").getClass());
        Assert.assertEquals((String)"Parquet avro.java.string=String class should be String", String.class, parquetRecord.get("string_class").getClass());
        Assert.assertEquals((String)"Avro stringable class should be Utf8", Utf8.class, avroRecord.get("stringable_class").getClass());
        Assert.assertEquals((String)"Parquet stringable class should be Utf8", Utf8.class, parquetRecord.get("stringable_class").getClass());
        Assert.assertEquals((String)"Avro map default string class should be Utf8", Utf8.class, TestStringBehavior.keyClass(avroRecord.get("default_map")));
        Assert.assertEquals((String)"Parquet map default string class should be Utf8", Utf8.class, TestStringBehavior.keyClass(parquetRecord.get("default_map")));
        Assert.assertEquals((String)"Avro map avro.java.string=String class should be String", String.class, TestStringBehavior.keyClass(avroRecord.get("string_map")));
        Assert.assertEquals((String)"Parquet map avro.java.string=String class should be String", String.class, TestStringBehavior.keyClass(parquetRecord.get("string_map")));
        Assert.assertEquals((String)"Avro map stringable class should be Utf8", Utf8.class, TestStringBehavior.keyClass(avroRecord.get("stringable_map")));
        Assert.assertEquals((String)"Parquet map stringable class should be Utf8", Utf8.class, TestStringBehavior.keyClass(parquetRecord.get("stringable_map")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecific() throws IOException {
        StringBehaviorTest parquetRecord;
        StringBehaviorTest avroRecord;
        try (DataFileReader avro = new DataFileReader(this.avroFile, (DatumReader)new SpecificDatumReader(StringBehaviorTest.getClassSchema()));){
            avroRecord = (StringBehaviorTest)((Object)avro.next());
        }
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)conf, SpecificDataSupplier.class);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)StringBehaviorTest.getClassSchema());
        try (ParquetReader parquet = AvroParquetReader.builder((Path)this.parquetFile).withConf(conf).build();){
            parquetRecord = (StringBehaviorTest)((Object)parquet.read());
        }
        Assert.assertEquals((String)"Avro default string class should be String", Utf8.class, avroRecord.default_class.getClass());
        Assert.assertEquals((String)"Parquet default string class should be String", Utf8.class, parquetRecord.default_class.getClass());
        Assert.assertEquals((String)"Avro avro.java.string=String class should be String", String.class, avroRecord.string_class.getClass());
        Assert.assertEquals((String)"Parquet avro.java.string=String class should be String", String.class, parquetRecord.string_class.getClass());
        Assert.assertEquals((String)"Avro stringable class should be BigDecimal", BigDecimal.class, avroRecord.stringable_class.getClass());
        Assert.assertEquals((String)"Parquet stringable class should be BigDecimal", BigDecimal.class, parquetRecord.stringable_class.getClass());
        Assert.assertEquals((String)"Should have the correct BigDecimal value", (Object)BIG_DECIMAL, (Object)parquetRecord.stringable_class);
        Assert.assertEquals((String)"Avro map default string class should be String", Utf8.class, TestStringBehavior.keyClass(avroRecord.default_map));
        Assert.assertEquals((String)"Parquet map default string class should be String", Utf8.class, TestStringBehavior.keyClass(parquetRecord.default_map));
        Assert.assertEquals((String)"Avro map avro.java.string=String class should be String", String.class, TestStringBehavior.keyClass(avroRecord.string_map));
        Assert.assertEquals((String)"Parquet map avro.java.string=String class should be String", String.class, TestStringBehavior.keyClass(parquetRecord.string_map));
        Assert.assertEquals((String)"Avro map stringable class should be BigDecimal", BigDecimal.class, TestStringBehavior.keyClass(avroRecord.stringable_map));
        Assert.assertEquals((String)"Parquet map stringable class should be BigDecimal", BigDecimal.class, TestStringBehavior.keyClass(parquetRecord.stringable_map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReflect() throws IOException {
        ReflectRecord parquetRecord;
        ReflectRecord avroRecord;
        Schema reflectSchema = ReflectData.get().getSchema(ReflectRecord.class);
        try (DataFileReader avro = new DataFileReader(this.avroFile, (DatumReader)new ReflectDatumReader(reflectSchema));){
            avroRecord = (ReflectRecord)avro.next();
        }
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)conf, ReflectDataSupplier.class);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)reflectSchema);
        try (ParquetReader parquet = AvroParquetReader.builder((Path)this.parquetFile).withConf(conf).build();){
            parquetRecord = (ReflectRecord)parquet.read();
        }
        Assert.assertEquals((String)"Avro default string class should be String", String.class, avroRecord.default_class.getClass());
        Assert.assertEquals((String)"Parquet default string class should be String", String.class, parquetRecord.default_class.getClass());
        Assert.assertEquals((String)"Avro avro.java.string=String class should be String", String.class, avroRecord.string_class.getClass());
        Assert.assertEquals((String)"Parquet avro.java.string=String class should be String", String.class, parquetRecord.string_class.getClass());
        Assert.assertEquals((String)"Avro stringable class should be BigDecimal", BigDecimal.class, avroRecord.stringable_class.getClass());
        Assert.assertEquals((String)"Parquet stringable class should be BigDecimal", BigDecimal.class, parquetRecord.stringable_class.getClass());
        Assert.assertEquals((String)"Should have the correct BigDecimal value", (Object)BIG_DECIMAL, (Object)parquetRecord.stringable_class);
        Assert.assertEquals((String)"Avro map default string class should be String", String.class, TestStringBehavior.keyClass(avroRecord.default_map));
        Assert.assertEquals((String)"Parquet map default string class should be String", String.class, TestStringBehavior.keyClass(parquetRecord.default_map));
        Assert.assertEquals((String)"Avro map avro.java.string=String class should be String", String.class, TestStringBehavior.keyClass(avroRecord.string_map));
        Assert.assertEquals((String)"Parquet map avro.java.string=String class should be String", String.class, TestStringBehavior.keyClass(parquetRecord.string_map));
        Assert.assertEquals((String)"Avro map stringable class should be BigDecimal", BigDecimal.class, TestStringBehavior.keyClass(avroRecord.stringable_map));
        Assert.assertEquals((String)"Parquet map stringable class should be BigDecimal", BigDecimal.class, TestStringBehavior.keyClass(parquetRecord.stringable_map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReflectJavaClass() throws IOException {
        ReflectRecordJavaClass parquetRecord;
        ReflectRecordJavaClass avroRecord;
        Schema reflectSchema = ReflectData.get().getSchema(ReflectRecordJavaClass.class);
        System.err.println("Schema: " + reflectSchema.toString(true));
        try (DataFileReader avro = new DataFileReader(this.avroFile, (DatumReader)new ReflectDatumReader(reflectSchema));){
            avroRecord = (ReflectRecordJavaClass)avro.next();
        }
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.avro.compatible", false);
        AvroReadSupport.setAvroDataSupplier((Configuration)conf, ReflectDataSupplier.class);
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)reflectSchema);
        AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)reflectSchema);
        try (ParquetReader parquet = AvroParquetReader.builder((Path)this.parquetFile).withConf(conf).build();){
            parquetRecord = (ReflectRecordJavaClass)parquet.read();
        }
        Assert.assertEquals((String)"Avro default string class should be String", String.class, avroRecord.default_class.getClass());
        Assert.assertEquals((String)"Parquet default string class should be String", String.class, parquetRecord.default_class.getClass());
        Assert.assertEquals((String)"Avro stringable class should be BigDecimal", BigDecimal.class, avroRecord.stringable_class.getClass());
        Assert.assertEquals((String)"Parquet stringable class should be BigDecimal", BigDecimal.class, parquetRecord.stringable_class.getClass());
        Assert.assertEquals((String)"Should have the correct BigDecimal value", (Object)BIG_DECIMAL, (Object)parquetRecord.stringable_class);
    }

    public static Class<?> keyClass(Object obj) {
        Assert.assertTrue((String)"Should be a map", (boolean)(obj instanceof Map));
        Map map = (Map)obj;
        return Iterables.getFirst(map.keySet(), null).getClass();
    }

    public static class ReflectRecordJavaClass {
        @AvroSchema(value="{\"type\": \"string\", \"avro.java.string\": \"CharSequence\"}")
        private String default_class;
        @AvroSchema(value="{\"type\": \"string\", \"java-class\": \"java.math.BigDecimal\"}")
        private BigDecimal stringable_class;
    }

    public static class ReflectRecord {
        private String default_class;
        private String string_class;
        @Stringable
        private BigDecimal stringable_class;
        private Map<String, Integer> default_map;
        private Map<String, Integer> string_map;
        private Map<BigDecimal, Integer> stringable_map;
    }
}

