/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.dictionary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.values.RequiresFallback;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.dictionary.IntList;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.Double2IntLinkedOpenHashMap;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.Double2IntMap;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import shaded.parquet.it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import shaded.parquet.it.unimi.dsi.fastutil.floats.Float2IntMap;
import shaded.parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import shaded.parquet.it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import shaded.parquet.it.unimi.dsi.fastutil.ints.Int2IntMap;
import shaded.parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import shaded.parquet.it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import shaded.parquet.it.unimi.dsi.fastutil.longs.Long2IntMap;
import shaded.parquet.it.unimi.dsi.fastutil.longs.LongIterator;
import shaded.parquet.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import shaded.parquet.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shaded.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;

public abstract class DictionaryValuesWriter
extends ValuesWriter
implements RequiresFallback {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryValuesWriter.class);
    private static final int MAX_DICTIONARY_ENTRIES = 0x7FFFFFFE;
    private static final int MIN_INITIAL_SLAB_SIZE = 64;
    private final Encoding encodingForDataPage;
    protected final Encoding encodingForDictionaryPage;
    protected final int maxDictionaryByteSize;
    protected boolean dictionaryTooBig;
    protected int dictionaryByteSize;
    protected int lastUsedDictionaryByteSize;
    protected int lastUsedDictionarySize;
    protected IntList encodedValues = new IntList();
    protected boolean firstPage = true;
    protected ByteBufferAllocator allocator;
    private List<RunLengthBitPackingHybridEncoder> encoders = new ArrayList<RunLengthBitPackingHybridEncoder>();

    protected DictionaryValuesWriter(int maxDictionaryByteSize, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
        this.allocator = allocator;
        this.maxDictionaryByteSize = maxDictionaryByteSize;
        this.encodingForDataPage = encodingForDataPage;
        this.encodingForDictionaryPage = encodingForDictionaryPage;
    }

    protected DictionaryPage dictPage(ValuesWriter dictPageWriter) {
        DictionaryPage ret = new DictionaryPage(dictPageWriter.getBytes(), this.lastUsedDictionarySize, this.encodingForDictionaryPage);
        dictPageWriter.close();
        return ret;
    }

    @Override
    public boolean shouldFallBack() {
        return this.dictionaryByteSize > this.maxDictionaryByteSize || this.getDictionarySize() > 0x7FFFFFFE;
    }

    @Override
    public boolean isCompressionSatisfying(long rawSize, long encodedSize) {
        return encodedSize + (long)this.dictionaryByteSize < rawSize;
    }

    @Override
    public void fallBackAllValuesTo(ValuesWriter writer) {
        this.fallBackDictionaryEncodedData(writer);
        if (this.lastUsedDictionarySize == 0) {
            this.clearDictionaryContent();
            this.dictionaryByteSize = 0;
            this.encodedValues = new IntList();
        }
    }

    protected abstract void fallBackDictionaryEncodedData(ValuesWriter var1);

    @Override
    public long getBufferedSize() {
        return this.encodedValues.size() * 4;
    }

    @Override
    public long getAllocatedSize() {
        return this.encodedValues.size() * 4 + this.dictionaryByteSize;
    }

    @Override
    public BytesInput getBytes() {
        int maxDicId = this.getDictionarySize() - 1;
        LOG.debug("max dic id {}", (Object)maxDicId);
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)maxDicId);
        int initialSlabSize = CapacityByteArrayOutputStream.initialSlabSizeHeuristic((int)64, (int)this.maxDictionaryByteSize, (int)10);
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(bitWidth, initialSlabSize, this.maxDictionaryByteSize, this.allocator);
        this.encoders.add(encoder);
        IntList.IntIterator iterator = this.encodedValues.iterator();
        try {
            while (iterator.hasNext()) {
                encoder.writeInt(iterator.next());
            }
            byte[] bytesHeader = new byte[]{(byte)bitWidth};
            BytesInput rleEncodedBytes = encoder.toBytes();
            LOG.debug("rle encoded bytes {}", (Object)rleEncodedBytes.size());
            BytesInput bytes = BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((byte[])bytesHeader), rleEncodedBytes});
            this.lastUsedDictionarySize = this.getDictionarySize();
            this.lastUsedDictionaryByteSize = this.dictionaryByteSize;
            return bytes;
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not encode the values", e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return this.encodingForDataPage;
    }

    @Override
    public void reset() {
        this.close();
        this.encodedValues = new IntList();
    }

    @Override
    public void close() {
        this.encodedValues = null;
        for (RunLengthBitPackingHybridEncoder encoder : this.encoders) {
            encoder.close();
        }
        this.encoders.clear();
    }

    @Override
    public void resetDictionary() {
        this.lastUsedDictionaryByteSize = 0;
        this.lastUsedDictionarySize = 0;
        this.dictionaryTooBig = false;
        this.clearDictionaryContent();
    }

    protected abstract void clearDictionaryContent();

    protected abstract int getDictionarySize();

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s DictionaryValuesWriter{\n%s\n%s\n%s}\n", prefix, prefix + " dict:" + this.dictionaryByteSize, prefix + " values:" + String.valueOf(this.encodedValues.size() * 4), prefix);
    }

    public static class PlainFloatDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Float2IntMap floatDictionaryContent = new Float2IntLinkedOpenHashMap();

        public PlainFloatDictionaryValuesWriter(int maxDictionaryByteSize, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
            super(maxDictionaryByteSize, encodingForDataPage, encodingForDictionaryPage, allocator);
            this.floatDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeFloat(float v) {
            int id = this.floatDictionaryContent.get(v);
            if (id == -1) {
                id = this.floatDictionaryContent.size();
                this.floatDictionaryContent.put(v, id);
                this.dictionaryByteSize += 4;
            }
            this.encodedValues.add(id);
        }

        @Override
        public DictionaryPage toDictPageAndClose() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize, this.maxDictionaryByteSize, this.allocator);
                FloatIterator floatIterator = this.floatDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeFloat(floatIterator.nextFloat());
                }
                return this.dictPage(dictionaryEncoder);
            }
            return null;
        }

        @Override
        public int getDictionarySize() {
            return this.floatDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.floatDictionaryContent.clear();
        }

        @Override
        public void fallBackDictionaryEncodedData(ValuesWriter writer) {
            float[] reverseDictionary = new float[this.getDictionarySize()];
            for (Float2IntMap.Entry entry : this.floatDictionaryContent.float2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getFloatKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                writer.writeFloat(reverseDictionary[id]);
            }
        }
    }

    public static class PlainIntegerDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Int2IntMap intDictionaryContent = new Int2IntLinkedOpenHashMap();

        public PlainIntegerDictionaryValuesWriter(int maxDictionaryByteSize, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
            super(maxDictionaryByteSize, encodingForDataPage, encodingForDictionaryPage, allocator);
            this.intDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeInteger(int v) {
            int id = this.intDictionaryContent.get(v);
            if (id == -1) {
                id = this.intDictionaryContent.size();
                this.intDictionaryContent.put(v, id);
                this.dictionaryByteSize += 4;
            }
            this.encodedValues.add(id);
        }

        @Override
        public DictionaryPage toDictPageAndClose() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize, this.maxDictionaryByteSize, this.allocator);
                IntIterator intIterator = this.intDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeInteger(intIterator.nextInt());
                }
                return this.dictPage(dictionaryEncoder);
            }
            return null;
        }

        @Override
        public int getDictionarySize() {
            return this.intDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.intDictionaryContent.clear();
        }

        @Override
        public void fallBackDictionaryEncodedData(ValuesWriter writer) {
            int[] reverseDictionary = new int[this.getDictionarySize()];
            for (Int2IntMap.Entry entry : this.intDictionaryContent.int2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getIntKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                writer.writeInteger(reverseDictionary[id]);
            }
        }
    }

    public static class PlainDoubleDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Double2IntMap doubleDictionaryContent = new Double2IntLinkedOpenHashMap();

        public PlainDoubleDictionaryValuesWriter(int maxDictionaryByteSize, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
            super(maxDictionaryByteSize, encodingForDataPage, encodingForDictionaryPage, allocator);
            this.doubleDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeDouble(double v) {
            int id = this.doubleDictionaryContent.get(v);
            if (id == -1) {
                id = this.doubleDictionaryContent.size();
                this.doubleDictionaryContent.put(v, id);
                this.dictionaryByteSize += 8;
            }
            this.encodedValues.add(id);
        }

        @Override
        public DictionaryPage toDictPageAndClose() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize, this.maxDictionaryByteSize, this.allocator);
                DoubleIterator doubleIterator = this.doubleDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeDouble(doubleIterator.nextDouble());
                }
                return this.dictPage(dictionaryEncoder);
            }
            return null;
        }

        @Override
        public int getDictionarySize() {
            return this.doubleDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.doubleDictionaryContent.clear();
        }

        @Override
        public void fallBackDictionaryEncodedData(ValuesWriter writer) {
            double[] reverseDictionary = new double[this.getDictionarySize()];
            for (Double2IntMap.Entry entry : this.doubleDictionaryContent.double2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getDoubleKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                writer.writeDouble(reverseDictionary[id]);
            }
        }
    }

    public static class PlainLongDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Long2IntMap longDictionaryContent = new Long2IntLinkedOpenHashMap();

        public PlainLongDictionaryValuesWriter(int maxDictionaryByteSize, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
            super(maxDictionaryByteSize, encodingForDataPage, encodingForDictionaryPage, allocator);
            this.longDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeLong(long v) {
            int id = this.longDictionaryContent.get(v);
            if (id == -1) {
                id = this.longDictionaryContent.size();
                this.longDictionaryContent.put(v, id);
                this.dictionaryByteSize += 8;
            }
            this.encodedValues.add(id);
        }

        @Override
        public DictionaryPage toDictPageAndClose() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize, this.maxDictionaryByteSize, this.allocator);
                LongIterator longIterator = this.longDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeLong(longIterator.nextLong());
                }
                return this.dictPage(dictionaryEncoder);
            }
            return null;
        }

        @Override
        public int getDictionarySize() {
            return this.longDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.longDictionaryContent.clear();
        }

        @Override
        public void fallBackDictionaryEncodedData(ValuesWriter writer) {
            long[] reverseDictionary = new long[this.getDictionarySize()];
            for (Long2IntMap.Entry entry : this.longDictionaryContent.long2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getLongKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                writer.writeLong(reverseDictionary[id]);
            }
        }
    }

    public static class PlainFixedLenArrayDictionaryValuesWriter
    extends PlainBinaryDictionaryValuesWriter {
        private final int length;

        public PlainFixedLenArrayDictionaryValuesWriter(int maxDictionaryByteSize, int length, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
            super(maxDictionaryByteSize, encodingForDataPage, encodingForDictionaryPage, allocator);
            this.length = length;
        }

        @Override
        public void writeBytes(Binary value) {
            int id = this.binaryDictionaryContent.getInt(value);
            if (id == -1) {
                id = this.binaryDictionaryContent.size();
                this.binaryDictionaryContent.put(value.copy(), id);
                this.dictionaryByteSize += this.length;
            }
            this.encodedValues.add(id);
        }

        @Override
        public DictionaryPage toDictPageAndClose() {
            if (this.lastUsedDictionarySize > 0) {
                FixedLenByteArrayPlainValuesWriter dictionaryEncoder = new FixedLenByteArrayPlainValuesWriter(this.length, this.lastUsedDictionaryByteSize, this.maxDictionaryByteSize, this.allocator);
                ObjectIterator binaryIterator = this.binaryDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    Binary entry = (Binary)binaryIterator.next();
                    dictionaryEncoder.writeBytes(entry);
                }
                return this.dictPage(dictionaryEncoder);
            }
            return null;
        }
    }

    public static class PlainBinaryDictionaryValuesWriter
    extends DictionaryValuesWriter {
        protected Object2IntMap<Binary> binaryDictionaryContent = new Object2IntLinkedOpenHashMap<Binary>();

        public PlainBinaryDictionaryValuesWriter(int maxDictionaryByteSize, Encoding encodingForDataPage, Encoding encodingForDictionaryPage, ByteBufferAllocator allocator) {
            super(maxDictionaryByteSize, encodingForDataPage, encodingForDictionaryPage, allocator);
            this.binaryDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeBytes(Binary v) {
            int id = this.binaryDictionaryContent.getInt(v);
            if (id == -1) {
                id = this.binaryDictionaryContent.size();
                this.binaryDictionaryContent.put(v.copy(), id);
                this.dictionaryByteSize += 4 + v.length();
            }
            this.encodedValues.add(id);
        }

        @Override
        public DictionaryPage toDictPageAndClose() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize, this.maxDictionaryByteSize, this.allocator);
                ObjectIterator<Binary> binaryIterator = this.binaryDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    Binary entry = (Binary)binaryIterator.next();
                    dictionaryEncoder.writeBytes(entry);
                }
                return this.dictPage(dictionaryEncoder);
            }
            return null;
        }

        @Override
        public int getDictionarySize() {
            return this.binaryDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.binaryDictionaryContent.clear();
        }

        @Override
        public void fallBackDictionaryEncodedData(ValuesWriter writer) {
            Binary[] reverseDictionary = new Binary[this.getDictionarySize()];
            for (Object2IntMap.Entry entry : this.binaryDictionaryContent.object2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = (Binary)entry.getKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                writer.writeBytes(reverseDictionary[n]);
            }
        }
    }
}

