/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.Preconditions;
import org.apache.parquet.ShouldNeverHappenException;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveComparator;
import org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeConverter;
import org.apache.parquet.schema.TypeVisitor;
import org.apache.parquet.schema.Types;

public final class PrimitiveType
extends Type {
    private final PrimitiveTypeName primitive;
    private final int length;
    private final DecimalMetadata decimalMeta;
    private final ColumnOrder columnOrder;

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name) {
        this(repetition, primitive, 0, name, (LogicalTypeAnnotation)null, null, null);
    }

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name) {
        this(repetition, primitive, length, name, (LogicalTypeAnnotation)null, null, null);
    }

    @Deprecated
    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name, OriginalType originalType) {
        this(repetition, primitive, 0, name, originalType, null, null);
    }

    @Deprecated
    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, OriginalType originalType) {
        this(repetition, primitive, length, name, originalType, null, null);
    }

    @Deprecated
    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, OriginalType originalType, DecimalMetadata decimalMeta, Type.ID id) {
        this(repetition, primitive, length, name, originalType, decimalMeta, id, null);
    }

    PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, OriginalType originalType, DecimalMetadata decimalMeta, Type.ID id, ColumnOrder columnOrder) {
        super(name, repetition, originalType, decimalMeta, id);
        this.primitive = primitive;
        this.length = length;
        this.decimalMeta = decimalMeta;
        if (columnOrder == null) {
            columnOrder = primitive == PrimitiveTypeName.INT96 || originalType == OriginalType.INTERVAL ? ColumnOrder.undefined() : ColumnOrder.typeDefined();
        }
        this.columnOrder = this.requireValidColumnOrder(columnOrder);
    }

    PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name, LogicalTypeAnnotation logicalTypeAnnotation) {
        this(repetition, primitive, 0, name, logicalTypeAnnotation, null, null);
    }

    PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, LogicalTypeAnnotation logicalTypeAnnotation, Type.ID id) {
        this(repetition, primitive, length, name, logicalTypeAnnotation, id, null);
    }

    PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, int length, String name, LogicalTypeAnnotation logicalTypeAnnotation, Type.ID id, ColumnOrder columnOrder) {
        super(name, repetition, logicalTypeAnnotation, id);
        this.primitive = primitive;
        this.length = length;
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
            this.decimalMeta = new DecimalMetadata(decimal.getPrecision(), decimal.getScale());
        } else {
            this.decimalMeta = null;
        }
        if (columnOrder == null) {
            columnOrder = primitive == PrimitiveTypeName.INT96 || logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation ? ColumnOrder.undefined() : ColumnOrder.typeDefined();
        }
        this.columnOrder = this.requireValidColumnOrder(columnOrder);
    }

    private ColumnOrder requireValidColumnOrder(ColumnOrder columnOrder) {
        if (this.primitive == PrimitiveTypeName.INT96) {
            Preconditions.checkArgument((columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.UNDEFINED ? 1 : 0) != 0, (String)"The column order {} is not supported by INT96", (Object[])new Object[]{columnOrder});
        }
        if (this.getLogicalTypeAnnotation() != null) {
            Preconditions.checkArgument((boolean)this.getLogicalTypeAnnotation().isValidColumnOrder(columnOrder), (String)"The column order {} is not supported by {} ({})", (Object[])new Object[]{columnOrder, this.primitive, this.getLogicalTypeAnnotation()});
        }
        return columnOrder;
    }

    @Override
    public PrimitiveType withId(int id) {
        return new PrimitiveType(this.getRepetition(), this.primitive, this.length, this.getName(), this.getLogicalTypeAnnotation(), new Type.ID(id), this.columnOrder);
    }

    public PrimitiveTypeName getPrimitiveTypeName() {
        return this.primitive;
    }

    public int getTypeLength() {
        return this.length;
    }

    @Deprecated
    public DecimalMetadata getDecimalMetadata() {
        return this.decimalMeta;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append(indent).append(this.getRepetition().name().toLowerCase(Locale.ENGLISH)).append(" ").append(this.primitive.name().toLowerCase());
        if (this.primitive == PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            sb.append("(" + this.length + ")");
        }
        sb.append(" ").append(this.getName());
        if (this.getLogicalTypeAnnotation() != null) {
            sb.append(" (").append(this.getLogicalTypeAnnotation().toString()).append(")");
        }
        if (this.getId() != null) {
            sb.append(" = ").append(this.getId());
        }
    }

    @Override
    @Deprecated
    protected int typeHashCode() {
        return this.hashCode();
    }

    @Override
    @Deprecated
    protected boolean typeEquals(Type other) {
        return this.equals(other);
    }

    @Override
    protected boolean equals(Type other) {
        if (!other.isPrimitive()) {
            return false;
        }
        PrimitiveType otherPrimitive = other.asPrimitiveType();
        return super.equals(other) && this.primitive == otherPrimitive.getPrimitiveTypeName() && this.length == otherPrimitive.length && this.columnOrder.equals(otherPrimitive.columnOrder) && this.eqOrBothNull(this.decimalMeta, otherPrimitive.decimalMeta);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.primitive.hashCode();
        hash = hash * 31 + this.length;
        hash = hash * 31 + this.columnOrder.hashCode();
        if (this.decimalMeta != null) {
            hash = hash * 31 + this.decimalMeta.hashCode();
        }
        return hash;
    }

    @Override
    public int getMaxRepetitionLevel(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node, path invalid");
        }
        return this.isRepetition(Type.Repetition.REPEATED) ? 1 : 0;
    }

    @Override
    public int getMaxDefinitionLevel(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node, path invalid");
        }
        return this.isRepetition(Type.Repetition.REQUIRED) ? 0 : 1;
    }

    @Override
    public Type getType(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node at index " + i + " , path invalid: " + Arrays.toString(path));
        }
        return this;
    }

    @Override
    protected List<String[]> getPaths(int depth) {
        return Arrays.asList(new String[][]{new String[depth]});
    }

    @Override
    void checkContains(Type subType) {
        super.checkContains(subType);
        if (!subType.isPrimitive()) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        PrimitiveType primitiveType = subType.asPrimitiveType();
        if (this.primitive != primitiveType.primitive) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
    }

    @Override
    public <T> T convert(List<GroupType> path, TypeConverter<T> converter) {
        return converter.convertPrimitiveType(path, this);
    }

    @Override
    protected boolean containsPath(String[] path, int depth) {
        return path.length == depth;
    }

    @Override
    protected Type union(Type toMerge) {
        return this.union(toMerge, true);
    }

    private void reportSchemaMergeError(Type toMerge) {
        throw new IncompatibleSchemaModificationException("can not merge type " + toMerge + " into " + this);
    }

    private void reportSchemaMergeErrorWithColumnOrder(Type toMerge) {
        throw new IncompatibleSchemaModificationException("can not merge type " + toMerge + " with column order " + toMerge.asPrimitiveType().columnOrder() + " into " + this + " with column order " + this.columnOrder());
    }

    @Override
    protected Type union(Type toMerge, boolean strict) {
        if (!toMerge.isPrimitive()) {
            this.reportSchemaMergeError(toMerge);
        }
        if (strict) {
            if (!this.primitive.equals((Object)toMerge.asPrimitiveType().getPrimitiveTypeName()) || !Objects.equals(this.getLogicalTypeAnnotation(), toMerge.getLogicalTypeAnnotation())) {
                this.reportSchemaMergeError(toMerge);
            }
            int toMergeLength = toMerge.asPrimitiveType().getTypeLength();
            if (this.primitive == PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY && this.length != toMergeLength) {
                this.reportSchemaMergeError(toMerge);
            }
            if (!this.columnOrder().equals(toMerge.asPrimitiveType().columnOrder())) {
                this.reportSchemaMergeErrorWithColumnOrder(toMerge);
            }
        }
        Type.Repetition repetition = Type.Repetition.leastRestrictive(this.getRepetition(), toMerge.getRepetition());
        Types.PrimitiveBuilder<PrimitiveType> builder = Types.primitive(this.primitive, repetition);
        if (PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY == this.primitive) {
            builder.length(this.length);
        }
        return (Type)((Types.PrimitiveBuilder)builder.as(this.getLogicalTypeAnnotation())).named(this.getName());
    }

    public <T> PrimitiveComparator<T> comparator() {
        return this.getPrimitiveTypeName().comparator(this.getLogicalTypeAnnotation());
    }

    public ColumnOrder columnOrder() {
        return this.columnOrder;
    }

    public PrimitiveStringifier stringifier() {
        LogicalTypeAnnotation logicalTypeAnnotation = this.getLogicalTypeAnnotation();
        return logicalTypeAnnotation == null ? PrimitiveStringifier.DEFAULT_STRINGIFIER : logicalTypeAnnotation.valueStringifier(this);
    }

    public static enum PrimitiveTypeName {
        INT64("getLong", (Class)Long.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getLong());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addLong(columnReader.getLong());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addLong(columnReader.getLong());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT64(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.SIGNED_INT64_COMPARATOR;
                }
                return logicalType.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveComparator>(){

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                        return intLogicalType.isSigned() ? Optional.of(PrimitiveComparator.SIGNED_INT64_COMPARATOR) : Optional.of(PrimitiveComparator.UNSIGNED_INT64_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(PrimitiveComparator.SIGNED_INT64_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                        return Optional.of(PrimitiveComparator.SIGNED_INT64_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                        return Optional.of(PrimitiveComparator.SIGNED_INT64_COMPARATOR);
                    }
                }).orElseThrow(() -> new ShouldNeverHappenException("No comparator logic implemented for INT64 logical type: " + logicalType));
            }
        }
        ,
        INT32("getInteger", (Class)Integer.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getInteger());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addInteger(columnReader.getInteger());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addInt(columnReader.getInteger());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT32(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.SIGNED_INT32_COMPARATOR;
                }
                return logicalType.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveComparator>(){

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                        if (intLogicalType.getBitWidth() == 64) {
                            return Optional.empty();
                        }
                        return intLogicalType.isSigned() ? Optional.of(PrimitiveComparator.SIGNED_INT32_COMPARATOR) : Optional.of(PrimitiveComparator.UNSIGNED_INT32_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(PrimitiveComparator.SIGNED_INT32_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                        return Optional.of(PrimitiveComparator.SIGNED_INT32_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                        if (timeLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                            return Optional.of(PrimitiveComparator.SIGNED_INT32_COMPARATOR);
                        }
                        return Optional.empty();
                    }
                }).orElseThrow(() -> new ShouldNeverHappenException("No comparator logic implemented for INT32 logical type: " + logicalType));
            }
        }
        ,
        BOOLEAN("getBoolean", (Class)Boolean.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBoolean());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBoolean(columnReader.getBoolean());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBoolean(columnReader.getBoolean());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertBOOLEAN(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                return PrimitiveComparator.BOOLEAN_COMPARATOR;
            }
        }
        ,
        BINARY("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBinary());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertBINARY(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR;
                }
                return logicalType.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveComparator>(){

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                        return Optional.of(PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                        return Optional.of(PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                        return Optional.of(PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR);
                    }
                }).orElseThrow(() -> new ShouldNeverHappenException("No comparator logic implemented for BINARY logical type: " + logicalType));
            }
        }
        ,
        FLOAT("getFloat", (Class)Float.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getFloat());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addFloat(columnReader.getFloat());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addFloat(columnReader.getFloat());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertFLOAT(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                return PrimitiveComparator.FLOAT_COMPARATOR;
            }
        }
        ,
        DOUBLE("getDouble", (Class)Double.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getDouble());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addDouble(columnReader.getDouble());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addDouble(columnReader.getDouble());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertDOUBLE(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                return PrimitiveComparator.DOUBLE_COMPARATOR;
            }
        }
        ,
        INT96("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return Arrays.toString(columnReader.getBinary().getBytesUnsafe());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT96(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                return PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR;
            }
        }
        ,
        FIXED_LEN_BYTE_ARRAY("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBinary());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertFIXED_LEN_BYTE_ARRAY(this);
            }

            @Override
            PrimitiveComparator<?> comparator(LogicalTypeAnnotation logicalType) {
                if (logicalType == null) {
                    return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR;
                }
                return logicalType.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveComparator>(){

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR);
                    }

                    @Override
                    public Optional<PrimitiveComparator> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
                        return Optional.of(PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR);
                    }
                }).orElseThrow(() -> new ShouldNeverHappenException("No comparator logic implemented for FIXED_LEN_BYTE_ARRAY logical type: " + logicalType));
            }
        };

        public final String getMethod;
        public final Class<?> javaType;

        private PrimitiveTypeName(String getMethod, Class<?> javaType) {
            this.getMethod = getMethod;
            this.javaType = javaType;
        }

        public abstract String toString(ColumnReader var1);

        public abstract void addValueToRecordConsumer(RecordConsumer var1, ColumnReader var2);

        public abstract void addValueToPrimitiveConverter(PrimitiveConverter var1, ColumnReader var2);

        public abstract <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> var1) throws E;

        abstract PrimitiveComparator<?> comparator(LogicalTypeAnnotation var1);
    }

    public static interface PrimitiveTypeNameConverter<T, E extends Exception> {
        public T convertFLOAT(PrimitiveTypeName var1) throws E;

        public T convertDOUBLE(PrimitiveTypeName var1) throws E;

        public T convertINT32(PrimitiveTypeName var1) throws E;

        public T convertINT64(PrimitiveTypeName var1) throws E;

        public T convertINT96(PrimitiveTypeName var1) throws E;

        public T convertFIXED_LEN_BYTE_ARRAY(PrimitiveTypeName var1) throws E;

        public T convertBOOLEAN(PrimitiveTypeName var1) throws E;

        public T convertBINARY(PrimitiveTypeName var1) throws E;
    }
}

