/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnChunkPageReadStore
implements PageReadStore,
DictionaryPageReadStore {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnChunkPageReadStore.class);
    private final Map<ColumnDescriptor, ColumnChunkPageReader> readers = new HashMap<ColumnDescriptor, ColumnChunkPageReader>();
    private final long rowCount;
    private final long rowIndexOffset;
    private final RowRanges rowRanges;

    public ColumnChunkPageReadStore(long rowCount) {
        this(rowCount, -1L);
    }

    ColumnChunkPageReadStore(RowRanges rowRanges) {
        this(rowRanges, -1L);
    }

    ColumnChunkPageReadStore(long rowCount, long rowIndexOffset) {
        this.rowCount = rowCount;
        this.rowIndexOffset = rowIndexOffset;
        this.rowRanges = null;
    }

    ColumnChunkPageReadStore(RowRanges rowRanges, long rowIndexOffset) {
        this.rowRanges = rowRanges;
        this.rowIndexOffset = rowIndexOffset;
        this.rowCount = rowRanges.rowCount();
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Optional<Long> getRowIndexOffset() {
        return this.rowIndexOffset < 0L ? Optional.empty() : Optional.of(this.rowIndexOffset);
    }

    @Override
    public PageReader getPageReader(ColumnDescriptor path) {
        if (!this.readers.containsKey(path)) {
            throw new IllegalArgumentException(path + " is not in the store: " + this.readers.keySet() + " " + this.rowCount);
        }
        return this.readers.get(path);
    }

    @Override
    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        return this.readers.get(descriptor).readDictionaryPage();
    }

    @Override
    public Optional<PrimitiveIterator.OfLong> getRowIndexes() {
        return this.rowRanges == null ? Optional.empty() : Optional.of(this.rowRanges.iterator());
    }

    void addColumn(ColumnDescriptor path, ColumnChunkPageReader reader) {
        if (this.readers.put(path, reader) != null) {
            throw new RuntimeException(path + " was added twice");
        }
    }

    static final class ColumnChunkPageReader
    implements PageReader {
        private final CompressionCodecFactory.BytesInputDecompressor decompressor;
        private final long valueCount;
        private final List<DataPage> compressedPages;
        private final DictionaryPage compressedDictionaryPage;
        private final OffsetIndex offsetIndex;
        private final long rowCount;
        private int pageIndex = 0;

        ColumnChunkPageReader(CompressionCodecFactory.BytesInputDecompressor decompressor, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage, OffsetIndex offsetIndex, long rowCount) {
            this.decompressor = decompressor;
            this.compressedPages = new LinkedList<DataPage>(compressedPages);
            this.compressedDictionaryPage = compressedDictionaryPage;
            long count = 0L;
            for (DataPage p : compressedPages) {
                count += (long)p.getValueCount();
            }
            this.valueCount = count;
            this.offsetIndex = offsetIndex;
            this.rowCount = rowCount;
        }

        @Override
        public long getTotalValueCount() {
            return this.valueCount;
        }

        @Override
        public DataPage readPage() {
            if (this.compressedPages.isEmpty()) {
                return null;
            }
            DataPage compressedPage = this.compressedPages.remove(0);
            final int currentPageIndex = this.pageIndex++;
            return compressedPage.accept(new DataPage.Visitor<DataPage>(){

                @Override
                public DataPage visit(DataPageV1 dataPageV1) {
                    try {
                        BytesInput decompressed = decompressor.decompress(dataPageV1.getBytes(), dataPageV1.getUncompressedSize());
                        if (offsetIndex == null) {
                            return new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                        }
                        long firstRowIndex = offsetIndex.getFirstRowIndex(currentPageIndex);
                        return new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), firstRowIndex, Math.toIntExact(offsetIndex.getLastRowIndex(currentPageIndex, rowCount) - firstRowIndex + 1L), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", e);
                    }
                }

                @Override
                public DataPage visit(DataPageV2 dataPageV2) {
                    if (!dataPageV2.isCompressed()) {
                        if (offsetIndex == null) {
                            return dataPageV2;
                        }
                        return DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), offsetIndex.getFirstRowIndex(currentPageIndex), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), dataPageV2.getData(), dataPageV2.getStatistics());
                    }
                    try {
                        int uncompressedSize = Math.toIntExact((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size());
                        BytesInput decompressed = decompressor.decompress(dataPageV2.getData(), uncompressedSize);
                        if (offsetIndex == null) {
                            return DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), decompressed, dataPageV2.getStatistics());
                        }
                        return DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), offsetIndex.getFirstRowIndex(currentPageIndex), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), decompressed, dataPageV2.getStatistics());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", e);
                    }
                }
            });
        }

        @Override
        public DictionaryPage readDictionaryPage() {
            if (this.compressedDictionaryPage == null) {
                return null;
            }
            try {
                return new DictionaryPage(this.decompressor.decompress(this.compressedDictionaryPage.getBytes(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Could not decompress dictionary page", e);
            }
        }
    }
}

