/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageReadStore;
import org.apache.parquet.hadoop.DictionaryPageReader;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetFileReader
implements Closeable {
    private static final Log LOG = Log.getLog(ParquetFileReader.class);
    public static String PARQUET_READ_PARALLELISM = "parquet.metadata.read.parallelism";
    private final ParquetMetadataConverter converter;
    private final CodecFactory codecFactory;
    private final SeekableInputStream f;
    private final FileStatus fileStatus;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();
    private final FileMetaData fileMetaData;
    private final ByteBufferAllocator allocator;
    private final Configuration conf;
    private ParquetMetadata footer;
    private List<BlockMetaData> blocks;
    private int currentBlock = 0;
    private ColumnChunkPageReadStore currentRowGroup = null;
    private DictionaryPageReader nextDictionaryReader = null;

    @Deprecated
    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(Configuration configuration, List<FileStatus> partFiles) throws IOException {
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, partFiles, false);
    }

    private static ParquetMetadataConverter.MetadataFilter filter(boolean skipRowGroups) {
        return skipRowGroups ? ParquetMetadataConverter.SKIP_ROW_GROUPS : ParquetMetadataConverter.NO_FILTER;
    }

    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(final Configuration configuration, final Collection<FileStatus> partFiles, final boolean skipRowGroups) throws IOException {
        HashSet<Path> parents = new HashSet<Path>();
        for (FileStatus fileStatus : partFiles) {
            parents.add(fileStatus.getPath().getParent());
        }
        ArrayList summaries = new ArrayList();
        for (final Path path : parents) {
            summaries.add(new Callable<Map<Path, Footer>>(){

                @Override
                public Map<Path, Footer> call() throws Exception {
                    ParquetMetadata mergedMetadata = ParquetFileReader.readSummaryMetadata(configuration, path, skipRowGroups);
                    if (mergedMetadata != null) {
                        List<Object> footers;
                        if (skipRowGroups) {
                            footers = new ArrayList();
                            for (FileStatus f : partFiles) {
                                footers.add(new Footer(f.getPath(), mergedMetadata));
                            }
                        } else {
                            footers = ParquetFileReader.footersFromSummaryFile(path, mergedMetadata);
                        }
                        HashMap<Path, Footer> map = new HashMap<Path, Footer>();
                        for (Footer footer : footers) {
                            Footer footer2 = new Footer(new Path(path, footer.getFile().getName()), footer.getParquetMetadata());
                            map.put(footer2.getFile(), footer2);
                        }
                        return map;
                    }
                    return Collections.emptyMap();
                }
            });
        }
        HashMap hashMap = new HashMap();
        try {
            List<Map> footersFromSummaries = ParquetFileReader.runAllInParallel(configuration.getInt(PARQUET_READ_PARALLELISM, 5), summaries);
            for (Map footers : footersFromSummaries) {
                hashMap.putAll(footers);
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error reading summaries", e);
        }
        ArrayList<Footer> result = new ArrayList<Footer>(partFiles.size());
        ArrayList<FileStatus> toRead = new ArrayList<FileStatus>();
        for (FileStatus part : partFiles) {
            Footer f = (Footer)hashMap.get(part.getPath());
            if (f != null) {
                result.add(f);
                continue;
            }
            toRead.add(part);
        }
        if (toRead.size() > 0) {
            if (Log.INFO) {
                LOG.info((Object)("reading another " + toRead.size() + " footers"));
            }
            result.addAll(ParquetFileReader.readAllFootersInParallel(configuration, toRead, skipRowGroups));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> runAllInParallel(int parallelism, List<Callable<T>> toRun) throws ExecutionException {
        LOG.info((Object)("Initiating action with parallelism: " + parallelism));
        ExecutorService threadPool = Executors.newFixedThreadPool(parallelism);
        try {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
            for (Callable<T> callable : toRun) {
                futures.add(threadPool.submit(callable));
            }
            ArrayList result = new ArrayList(toRun.size());
            for (Future future : futures) {
                try {
                    result.add(future.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("The thread was interrupted", e);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, List<FileStatus> partFiles) throws IOException {
        return ParquetFileReader.readAllFootersInParallel(configuration, partFiles, false);
    }

    public static List<Footer> readAllFootersInParallel(final Configuration configuration, List<FileStatus> partFiles, final boolean skipRowGroups) throws IOException {
        ArrayList footers = new ArrayList();
        for (final FileStatus currentFile : partFiles) {
            footers.add(new Callable<Footer>(){

                @Override
                public Footer call() throws Exception {
                    try {
                        return new Footer(currentFile.getPath(), ParquetFileReader.readFooter(configuration, currentFile, ParquetFileReader.filter(skipRowGroups)));
                    }
                    catch (IOException e) {
                        throw new IOException("Could not read footer for file " + currentFile, e);
                    }
                }
            });
        }
        try {
            return ParquetFileReader.runAllInParallel(configuration.getInt(PARQUET_READ_PARALLELISM, 5), footers);
        }
        catch (ExecutionException e) {
            throw new IOException("Could not read footer: " + e.getMessage(), e.getCause());
        }
    }

    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus, boolean skipRowGroups) throws IOException {
        List<FileStatus> statuses = ParquetFileReader.listFiles(configuration, fileStatus);
        return ParquetFileReader.readAllFootersInParallel(configuration, statuses, skipRowGroups);
    }

    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus) throws IOException {
        return ParquetFileReader.readAllFootersInParallel(configuration, fileStatus, false);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, Path path) throws IOException {
        return ParquetFileReader.readFooters(configuration, ParquetFileReader.status(configuration, path));
    }

    private static FileStatus status(Configuration configuration, Path path) throws IOException {
        return path.getFileSystem(configuration).getFileStatus(path);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus) throws IOException {
        return ParquetFileReader.readFooters(configuration, pathStatus, false);
    }

    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus, boolean skipRowGroups) throws IOException {
        List<FileStatus> files = ParquetFileReader.listFiles(configuration, pathStatus);
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, files, skipRowGroups);
    }

    private static List<FileStatus> listFiles(Configuration conf, FileStatus fileStatus) throws IOException {
        if (fileStatus.isDir()) {
            FileSystem fs = fileStatus.getPath().getFileSystem(conf);
            FileStatus[] list = fs.listStatus(fileStatus.getPath(), (PathFilter)HiddenFileFilter.INSTANCE);
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            for (FileStatus sub : list) {
                result.addAll(ParquetFileReader.listFiles(conf, sub));
            }
            return result;
        }
        return Arrays.asList(fileStatus);
    }

    public static List<Footer> readSummaryFile(Configuration configuration, FileStatus summaryStatus) throws IOException {
        Path parent = summaryStatus.getPath().getParent();
        ParquetMetadata mergedFooters = ParquetFileReader.readFooter(configuration, summaryStatus, ParquetFileReader.filter(false));
        return ParquetFileReader.footersFromSummaryFile(parent, mergedFooters);
    }

    static ParquetMetadata readSummaryMetadata(Configuration configuration, Path basePath, boolean skipRowGroups) throws IOException {
        Path metadataFile = new Path(basePath, "_metadata");
        Path commonMetaDataFile = new Path(basePath, "_common_metadata");
        FileSystem fileSystem = basePath.getFileSystem(configuration);
        if (skipRowGroups && fileSystem.exists(commonMetaDataFile)) {
            if (Log.INFO) {
                LOG.info((Object)("reading summary file: " + commonMetaDataFile));
            }
            return ParquetFileReader.readFooter(configuration, commonMetaDataFile, ParquetFileReader.filter(skipRowGroups));
        }
        if (fileSystem.exists(metadataFile)) {
            if (Log.INFO) {
                LOG.info((Object)("reading summary file: " + metadataFile));
            }
            return ParquetFileReader.readFooter(configuration, metadataFile, ParquetFileReader.filter(skipRowGroups));
        }
        return null;
    }

    static List<Footer> footersFromSummaryFile(Path parent, ParquetMetadata mergedFooters) {
        HashMap<Path, ParquetMetadata> footers = new HashMap<Path, ParquetMetadata>();
        List<BlockMetaData> blocks = mergedFooters.getBlocks();
        for (BlockMetaData block : blocks) {
            String path = block.getPath();
            Path fullPath = new Path(parent, path);
            ParquetMetadata current = (ParquetMetadata)footers.get(fullPath);
            if (current == null) {
                current = new ParquetMetadata(mergedFooters.getFileMetaData(), new ArrayList<BlockMetaData>());
                footers.put(fullPath, current);
            }
            current.getBlocks().add(block);
        }
        ArrayList<Footer> result = new ArrayList<Footer>();
        for (Map.Entry entry : footers.entrySet()) {
            result.add(new Footer((Path)entry.getKey(), (ParquetMetadata)entry.getValue()));
        }
        return result;
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, Path file) throws IOException {
        return ParquetFileReader.readFooter(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    public static ParquetMetadata readFooter(Configuration configuration, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.readFooter(HadoopInputFile.fromPath(file, configuration), filter);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file) throws IOException {
        return ParquetFileReader.readFooter(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.readFooter(HadoopInputFile.fromStatus(file, configuration), filter);
    }

    public static final ParquetMetadata readFooter(InputFile file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        ParquetMetadataConverter converter = file instanceof HadoopInputFile ? new ParquetMetadataConverter(((HadoopInputFile)file).getConfiguration()) : new ParquetMetadataConverter();
        try (SeekableInputStream in = file.newStream();){
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter(converter, file.getLength(), file.toString(), in, filter);
            return parquetMetadata;
        }
    }

    private static final ParquetMetadata readFooter(ParquetMetadataConverter converter, long fileLen, String filePath, SeekableInputStream f, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        int FOOTER_LENGTH_SIZE;
        if (Log.DEBUG) {
            LOG.debug((Object)("File length " + fileLen));
        }
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + (FOOTER_LENGTH_SIZE = 4) + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException(filePath + " is not a Parquet file (too small)");
        }
        long footerLengthIndex = fileLen - (long)FOOTER_LENGTH_SIZE - (long)ParquetFileWriter.MAGIC.length;
        if (Log.DEBUG) {
            LOG.debug((Object)("reading footer index at " + footerLengthIndex));
        }
        f.seek(footerLengthIndex);
        int footerLength = BytesUtils.readIntLittleEndian((InputStream)f);
        byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
        f.readFully(magic);
        if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
            throw new RuntimeException(filePath + " is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetFileWriter.MAGIC) + " but found " + Arrays.toString(magic));
        }
        long footerIndex = footerLengthIndex - (long)footerLength;
        if (Log.DEBUG) {
            LOG.debug((Object)("read footer length: " + footerLength + ", footer index: " + footerIndex));
        }
        if (footerIndex < (long)ParquetFileWriter.MAGIC.length || footerIndex >= footerLengthIndex) {
            throw new RuntimeException("corrupted file: the footer index is not within the file");
        }
        f.seek(footerIndex);
        return converter.readParquetMetadata((InputStream)f, filter);
    }

    public static ParquetFileReader open(Configuration conf, Path file) throws IOException {
        return new ParquetFileReader(conf, file);
    }

    public static ParquetFileReader open(Configuration conf, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return new ParquetFileReader(conf, file, filter);
    }

    public static ParquetFileReader open(Configuration conf, Path file, ParquetMetadata footer) throws IOException {
        return new ParquetFileReader(conf, file, footer);
    }

    public ParquetFileReader(Configuration configuration, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this(configuration, null, filePath, blocks, columns);
    }

    @Deprecated
    public ParquetFileReader(Configuration configuration, FileMetaData fileMetaData, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this.converter = new ParquetMetadataConverter(configuration);
        this.conf = configuration;
        this.fileMetaData = fileMetaData;
        FileSystem fs = filePath.getFileSystem(configuration);
        this.f = HadoopStreams.wrap(fs.open(filePath));
        this.fileStatus = fs.getFileStatus(filePath);
        this.blocks = blocks;
        for (ColumnDescriptor col : columns) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
        this.codecFactory = new CodecFactory(configuration, 0);
        this.allocator = new HeapByteBufferAllocator();
    }

    private ParquetFileReader(Configuration configuration, Path file) throws IOException {
        this(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    public ParquetFileReader(Configuration conf, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        this.converter = new ParquetMetadataConverter(conf);
        this.conf = conf;
        FileSystem fs = file.getFileSystem(conf);
        this.fileStatus = fs.getFileStatus(file);
        this.f = HadoopStreams.wrap(fs.open(file));
        this.footer = ParquetFileReader.readFooter(this.converter, this.fileStatus.getLen(), this.fileStatus.getPath().toString(), this.f, filter);
        this.fileMetaData = this.footer.getFileMetaData();
        this.blocks = this.footer.getBlocks();
        for (ColumnDescriptor col : this.footer.getFileMetaData().getSchema().getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
        this.codecFactory = new CodecFactory(conf, 0);
        this.allocator = new HeapByteBufferAllocator();
    }

    public ParquetFileReader(Configuration conf, Path file, ParquetMetadata footer) throws IOException {
        this.converter = new ParquetMetadataConverter(conf);
        this.conf = conf;
        FileSystem fs = file.getFileSystem(conf);
        this.fileStatus = fs.getFileStatus(file);
        this.f = HadoopStreams.wrap(fs.open(file));
        this.footer = footer;
        this.fileMetaData = footer.getFileMetaData();
        this.blocks = footer.getBlocks();
        for (ColumnDescriptor col : footer.getFileMetaData().getSchema().getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
        this.codecFactory = new CodecFactory(conf, 0);
        this.allocator = new HeapByteBufferAllocator();
    }

    public ParquetMetadata getFooter() {
        if (this.footer == null) {
            try {
                this.footer = ParquetFileReader.readFooter(this.converter, this.fileStatus.getLen(), this.fileStatus.getPath().toString(), this.f, ParquetMetadataConverter.SKIP_ROW_GROUPS);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Unable to read file footer", (Throwable)e);
            }
        }
        return this.footer;
    }

    public FileMetaData getFileMetaData() {
        if (this.fileMetaData != null) {
            return this.fileMetaData;
        }
        return this.getFooter().getFileMetaData();
    }

    public long getRecordCount() {
        long total = 0L;
        for (BlockMetaData block : this.blocks) {
            total += block.getRowCount();
        }
        return total;
    }

    public Path getPath() {
        return this.fileStatus.getPath();
    }

    void filterRowGroups(FilterCompat.Filter filter) throws IOException {
        ArrayList<RowGroupFilter.FilterLevel> levels = new ArrayList<RowGroupFilter.FilterLevel>();
        if (this.conf.getBoolean("parquet.filter.stats.enabled", true)) {
            levels.add(RowGroupFilter.FilterLevel.STATISTICS);
        }
        if (this.conf.getBoolean("parquet.filter.dictionary.enabled", false)) {
            levels.add(RowGroupFilter.FilterLevel.DICTIONARY);
        }
        this.blocks = RowGroupFilter.filterRowGroups(levels, filter, this.blocks, this);
    }

    public List<BlockMetaData> getRowGroups() {
        return this.blocks;
    }

    public void setRequestedSchema(MessageType projection) {
        this.paths.clear();
        for (ColumnDescriptor col : projection.getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
    }

    public void appendTo(ParquetFileWriter writer) throws IOException {
        writer.appendRowGroups(this.f, this.blocks, true);
    }

    public PageReadStore readNextRowGroup() throws IOException {
        if (this.currentBlock == this.blocks.size()) {
            return null;
        }
        BlockMetaData block = this.blocks.get(this.currentBlock);
        if (block.getRowCount() == 0L) {
            throw new RuntimeException("Illegal row group of 0 rows");
        }
        this.currentRowGroup = new ColumnChunkPageReadStore(block.getRowCount());
        ArrayList<ConsecutiveChunkList> allChunks = new ArrayList<ConsecutiveChunkList>();
        ConsecutiveChunkList currentChunks = null;
        for (ColumnChunkMetaData mc : block.getColumns()) {
            ColumnPath pathKey = mc.getPath();
            BenchmarkCounter.incrementTotalBytes(mc.getTotalSize());
            ColumnDescriptor columnDescriptor = this.paths.get(pathKey);
            if (columnDescriptor == null) continue;
            long startingPos = mc.getStartingPos();
            if (currentChunks == null || currentChunks.endPos() != startingPos) {
                currentChunks = new ConsecutiveChunkList(startingPos);
                allChunks.add(currentChunks);
            }
            currentChunks.addChunk(new ChunkDescriptor(columnDescriptor, mc, startingPos, (int)mc.getTotalSize()));
        }
        for (ConsecutiveChunkList consecutiveChunks : allChunks) {
            List<Chunk> chunks = consecutiveChunks.readAll(this.f);
            for (Chunk chunk : chunks) {
                this.currentRowGroup.addColumn(chunk.descriptor.col, chunk.readAllPages());
            }
        }
        if (this.nextDictionaryReader != null) {
            this.nextDictionaryReader.setRowGroup(this.currentRowGroup);
        }
        this.advanceToNextBlock();
        return this.currentRowGroup;
    }

    public boolean skipNextRowGroup() {
        return this.advanceToNextBlock();
    }

    private boolean advanceToNextBlock() {
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        ++this.currentBlock;
        this.nextDictionaryReader = null;
        return true;
    }

    public DictionaryPageReadStore getNextDictionaryReader() {
        if (this.nextDictionaryReader == null && this.currentBlock < this.blocks.size()) {
            this.nextDictionaryReader = this.getDictionaryReader(this.blocks.get(this.currentBlock));
        }
        return this.nextDictionaryReader;
    }

    public DictionaryPageReader getDictionaryReader(BlockMetaData block) {
        return new DictionaryPageReader(this, block);
    }

    DictionaryPage readDictionary(ColumnChunkMetaData meta) throws IOException {
        PageHeader pageHeader;
        if (!meta.getEncodings().contains(Encoding.PLAIN_DICTIONARY) && !meta.getEncodings().contains(Encoding.RLE_DICTIONARY)) {
            return null;
        }
        if (this.f.getPos() != meta.getStartingPos()) {
            this.f.seek(meta.getStartingPos());
        }
        if (!(pageHeader = Util.readPageHeader((InputStream)this.f)).isSetDictionary_page_header()) {
            return null;
        }
        DictionaryPage compressedPage = this.readCompressedDictionary(pageHeader, this.f);
        CodecFactory.BytesDecompressor decompressor = this.codecFactory.getDecompressor(meta.getCodec());
        return new DictionaryPage(decompressor.decompress(compressedPage.getBytes(), compressedPage.getUncompressedSize()), compressedPage.getDictionarySize(), compressedPage.getEncoding());
    }

    private DictionaryPage readCompressedDictionary(PageHeader pageHeader, SeekableInputStream fin) throws IOException {
        DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
        int uncompressedPageSize = pageHeader.getUncompressed_page_size();
        int compressedPageSize = pageHeader.getCompressed_page_size();
        byte[] dictPageBytes = new byte[compressedPageSize];
        fin.readFully(dictPageBytes);
        BytesInput bin = BytesInput.from((byte[])dictPageBytes);
        return new DictionaryPage(bin, uncompressedPageSize, dictHeader.getNum_values(), this.converter.getEncoding(dictHeader.getEncoding()));
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        finally {
            if (this.codecFactory != null) {
                this.codecFactory.release();
            }
        }
    }

    private class ConsecutiveChunkList {
        private final long offset;
        private int length;
        private final List<ChunkDescriptor> chunks = new ArrayList<ChunkDescriptor>();

        ConsecutiveChunkList(long offset) {
            this.offset = offset;
        }

        public void addChunk(ChunkDescriptor descriptor) {
            this.chunks.add(descriptor);
            this.length += descriptor.size;
        }

        public List<Chunk> readAll(SeekableInputStream f) throws IOException {
            ArrayList<Chunk> result = new ArrayList<Chunk>(this.chunks.size());
            f.seek(this.offset);
            ByteBuffer chunksByteBuffer = ParquetFileReader.this.allocator.allocate(this.length);
            f.readFully(chunksByteBuffer);
            BenchmarkCounter.incrementBytesRead(this.length);
            int currentChunkOffset = 0;
            for (int i = 0; i < this.chunks.size(); ++i) {
                ChunkDescriptor descriptor = this.chunks.get(i);
                if (i < this.chunks.size() - 1) {
                    result.add(new Chunk(descriptor, chunksByteBuffer, currentChunkOffset));
                } else {
                    result.add(new WorkaroundChunk(descriptor, chunksByteBuffer, currentChunkOffset, f));
                }
                currentChunkOffset += descriptor.size;
            }
            return result;
        }

        public long endPos() {
            return this.offset + (long)this.length;
        }
    }

    private static class ChunkDescriptor {
        private final ColumnDescriptor col;
        private final ColumnChunkMetaData metadata;
        private final long fileOffset;
        private final int size;

        private ChunkDescriptor(ColumnDescriptor col, ColumnChunkMetaData metadata, long fileOffset, int size) {
            this.col = col;
            this.metadata = metadata;
            this.fileOffset = fileOffset;
            this.size = size;
        }
    }

    private class WorkaroundChunk
    extends Chunk {
        private final SeekableInputStream f;

        private WorkaroundChunk(ChunkDescriptor descriptor, ByteBuffer byteBuf, int offset, SeekableInputStream f) {
            super(descriptor, byteBuf, offset);
            this.f = f;
        }

        @Override
        protected PageHeader readPageHeader() throws IOException {
            PageHeader pageHeader;
            int initialPos = this.pos();
            try {
                pageHeader = Util.readPageHeader((InputStream)((Object)this));
            }
            catch (IOException e) {
                this.byteBuf.position(initialPos);
                LOG.info((Object)"completing the column chunk to read the page header");
                pageHeader = Util.readPageHeader((InputStream)new SequenceInputStream((InputStream)((Object)this), (InputStream)this.f));
            }
            return pageHeader;
        }

        @Override
        public BytesInput readAsBytesInput(int size) throws IOException {
            if (this.pos() + size > this.initPos + this.count) {
                int l1 = this.initPos + this.count - this.pos();
                int l2 = size - l1;
                LOG.info((Object)("completed the column chunk with " + l2 + " bytes"));
                return BytesInput.concat((BytesInput[])new BytesInput[]{super.readAsBytesInput(l1), BytesInput.copy((BytesInput)BytesInput.from((InputStream)this.f, (int)l2))});
            }
            return super.readAsBytesInput(size);
        }
    }

    private class Chunk
    extends ByteBufferInputStream {
        private final ChunkDescriptor descriptor;

        public Chunk(ChunkDescriptor descriptor, ByteBuffer data, int offset) {
            super(data, offset, descriptor.size);
            this.descriptor = descriptor;
        }

        protected PageHeader readPageHeader() throws IOException {
            return Util.readPageHeader((InputStream)((Object)this));
        }

        public ColumnChunkPageReadStore.ColumnChunkPageReader readAllPages() throws IOException {
            ArrayList<DataPage> pagesInChunk = new ArrayList<DataPage>();
            DictionaryPage dictionaryPage = null;
            PrimitiveType type = ParquetFileReader.this.getFileMetaData().getSchema().getType(this.descriptor.col.getPath()).asPrimitiveType();
            long valuesCountReadSoFar = 0L;
            block5: while (valuesCountReadSoFar < this.descriptor.metadata.getValueCount()) {
                PageHeader pageHeader = this.readPageHeader();
                int uncompressedPageSize = pageHeader.getUncompressed_page_size();
                int compressedPageSize = pageHeader.getCompressed_page_size();
                switch (pageHeader.type) {
                    case DICTIONARY_PAGE: {
                        if (dictionaryPage != null) {
                            throw new ParquetDecodingException("more than one dictionary page in column " + this.descriptor.col);
                        }
                        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
                        dictionaryPage = new DictionaryPage(this.readAsBytesInput(compressedPageSize), uncompressedPageSize, dicHeader.getNum_values(), ParquetFileReader.this.converter.getEncoding(dicHeader.getEncoding()));
                        continue block5;
                    }
                    case DATA_PAGE: {
                        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
                        pagesInChunk.add((DataPage)new DataPageV1(this.readAsBytesInput(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, ParquetFileReader.this.converter.fromParquetStatistics(ParquetFileReader.this.getFileMetaData().getCreatedBy(), dataHeaderV1.getStatistics(), type), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getRepetition_level_encoding()), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getDefinition_level_encoding()), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getEncoding())));
                        valuesCountReadSoFar += (long)dataHeaderV1.getNum_values();
                        continue block5;
                    }
                    case DATA_PAGE_V2: {
                        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
                        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
                        pagesInChunk.add((DataPage)new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.readAsBytesInput(dataHeaderV2.getRepetition_levels_byte_length()), this.readAsBytesInput(dataHeaderV2.getDefinition_levels_byte_length()), ParquetFileReader.this.converter.getEncoding(dataHeaderV2.getEncoding()), this.readAsBytesInput(dataSize), uncompressedPageSize, ParquetFileReader.this.converter.fromParquetStatistics(ParquetFileReader.this.getFileMetaData().getCreatedBy(), dataHeaderV2.getStatistics(), type), dataHeaderV2.isIs_compressed()));
                        valuesCountReadSoFar += (long)dataHeaderV2.getNum_values();
                        continue block5;
                    }
                }
                if (Log.DEBUG) {
                    LOG.debug((Object)("skipping page of type " + pageHeader.getType() + " of size " + compressedPageSize));
                }
                this.skip(compressedPageSize);
            }
            if (valuesCountReadSoFar != this.descriptor.metadata.getValueCount()) {
                throw new IOException("Expected " + this.descriptor.metadata.getValueCount() + " values in column chunk at " + ParquetFileReader.this.getPath() + " offset " + this.descriptor.metadata.getFirstDataPageOffset() + " but got " + valuesCountReadSoFar + " values instead over " + pagesInChunk.size() + " pages ending at file offset " + (this.descriptor.fileOffset + (long)this.pos()));
            }
            CodecFactory.BytesDecompressor decompressor = ParquetFileReader.this.codecFactory.getDecompressor(this.descriptor.metadata.getCodec());
            return new ColumnChunkPageReadStore.ColumnChunkPageReader(decompressor, pagesInChunk, dictionaryPage);
        }

        public int pos() {
            return this.byteBuf.position();
        }

        public BytesInput readAsBytesInput(int size) throws IOException {
            int pos = this.byteBuf.position();
            BytesInput r = BytesInput.from((ByteBuffer)this.byteBuf, (int)pos, (int)size);
            this.byteBuf.position(pos + size);
            return r;
        }
    }
}

