/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroFileFormat$;
import org.apache.spark.sql.avro.AvroFileFormat$$anonfun$4$;
import org.apache.spark.sql.avro.AvroFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!B\u0001\u0003\u0001\ta!AD!we>4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u0007\u0011\tA!\u0019<s_*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\r\u0001i1cG\u0011(!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#G\u0007\u0002+)\u0011acF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0019\t\u0005IQ\r_3dkRLwN\\\u0005\u00035U\u0011!BR5mK\u001a{'/\\1u!\tar$D\u0001\u001e\u0015\tqB!A\u0004t_V\u00148-Z:\n\u0005\u0001j\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0004\u0002\u0011%tG/\u001a:oC2L!AJ\u0012\u0003\u000f1{wmZ5oOB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0003S>T\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\ta1+\u001a:jC2L'0\u00192mK\")\u0001\u0007\u0001C\u0001e\u00051A(\u001b8jiz\u001a\u0001\u0001F\u00014!\t!\u0004!D\u0001\u0003\u0011\u00151\u0004\u0001\"\u00118\u0003\u0019)\u0017/^1mgR\u0011\u0001h\u000f\t\u0003\u001deJ!AO\b\u0003\u000f\t{w\u000e\\3b]\")A(\u000ea\u0001{\u0005)q\u000e\u001e5feB\u0011aBP\u0005\u0003\u007f=\u00111!\u00118z\u0011\u0015\t\u0005\u0001\"\u0011C\u0003!A\u0017m\u001d5D_\u0012,G#A\"\u0011\u00059!\u0015BA#\u0010\u0005\rIe\u000e\u001e\u0005\u0006\u000f\u0002!\t\u0005S\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003J%^\u001b\u0007c\u0001\bK\u0019&\u00111j\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\u0003V\"\u0001(\u000b\u0005=#\u0011!\u0002;za\u0016\u001c\u0018BA)O\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u000f\u0019\u0003\ra\u0015\t\u0003)Vk\u0011\u0001B\u0005\u0003-\u0012\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001\u0017$A\u0002e\u000bqa\u001c9uS>t7\u000f\u0005\u0003[;\u0002\u0004gB\u0001\b\\\u0013\tav\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u00131!T1q\u0015\tav\u0002\u0005\u0002[C&\u0011!m\u0018\u0002\u0007'R\u0014\u0018N\\4\t\u000b\u00114\u0005\u0019A3\u0002\u000b\u0019LG.Z:\u0011\u0007\u0019t\u0017O\u0004\u0002hY:\u0011\u0001n[\u0007\u0002S*\u0011!.M\u0001\u0007yI|w\u000e\u001e \n\u0003AI!!\\\b\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA7\u0010!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0002gg*\u0011a\u000fC\u0001\u0007Q\u0006$wn\u001c9\n\u0005a\u001c(A\u0003$jY\u0016\u001cF/\u0019;vg\")!\u0010\u0001C\u0005w\u0006A\u0012N\u001c4fe\u00063(o\\*dQ\u0016l\u0017M\u0012:p[\u001aKG.Z:\u0015\u0013q\f\u0019!!\u0002\u0002\u0014\u0005]\u0001CA?\u0000\u001b\u0005q(BA\u0002\t\u0013\r\t\tA \u0002\u0007'\u000eDW-\\1\t\u000b\u0011L\b\u0019A3\t\u000f\u0005\u001d\u0011\u00101\u0001\u0002\n\u0005!1m\u001c8g!\u0011\tY!a\u0004\u000e\u0005\u00055!bAA\u0004k&!\u0011\u0011CA\u0007\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1\u0011QC=A\u0002a\nq\"[4o_J,W\t\u001f;f]NLwN\u001c\u0005\u0007\u00033I\b\u0019\u0001\u001d\u0002%%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm\u001d\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u0001a\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\t1\"[:Ta2LG/\u00192mKR9\u0001(a\n\u0002,\u00055\u0002bBA\u0015\u0003C\u0001\raU\u0001\rgB\f'o[*fgNLwN\u001c\u0005\u00071\u0006\u0005\u0002\u0019A-\t\u0011\u0005=\u0012\u0011\u0005a\u0001\u0003c\tA\u0001]1uQB\u0019!/a\r\n\u0007\u0005U2O\u0001\u0003QCRD\u0007bBA\u001d\u0001\u0011\u0005\u00131H\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u000b\u0003{\t\u0019%!\u0012\u0002V\u0005]\u0003c\u0001\u000b\u0002@%\u0019\u0011\u0011I\u000b\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\r\u001d\t9\u00041\u0001T\u0011!\t9%a\u000eA\u0002\u0005%\u0013a\u00016pEB!\u00111JA)\u001b\t\tiEC\u0002\u0002PU\f\u0011\"\\1qe\u0016$WoY3\n\t\u0005M\u0013Q\n\u0002\u0004\u0015>\u0014\u0007B\u0002-\u00028\u0001\u0007\u0011\fC\u0004\u0002Z\u0005]\u0002\u0019\u0001'\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\rC\u0004\u0002^\u0001!\t%a\u0018\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003C\ny(!!\u0002\u0004\u0006\u001d\u00151RAL\u00033\u0003rADA2\u0003O\ni'C\u0002\u0002f=\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007Q\tI'C\u0002\u0002lU\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006M\u0006=\u00141O\u0005\u0004\u0003c\u0002(\u0001C%uKJ\fGo\u001c:\u0011\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f\u0005\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA?\u0003o\u00121\"\u00138uKJt\u0017\r\u001c*po\"1q!a\u0017A\u0002MCq!!\u0017\u0002\\\u0001\u0007A\nC\u0004\u0002\u0006\u0006m\u0003\u0019\u0001'\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Dq!!#\u0002\\\u0001\u0007A*\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u0011\u00055\u00151\fa\u0001\u0003\u001f\u000bqAZ5mi\u0016\u00148\u000f\u0005\u0003g]\u0006E\u0005c\u0001\u000f\u0002\u0014&\u0019\u0011QS\u000f\u0003\r\u0019KG\u000e^3s\u0011\u0019A\u00161\fa\u00013\"A\u00111TA.\u0001\u0004\tI!\u0001\u0006iC\u0012|w\u000e]\"p]\u001a<\u0001\"a(\u0003\u0011\u0003\u0011\u0011\u0011U\u0001\u000f\u0003Z\u0014xNR5mK\u001a{'/\\1u!\r!\u00141\u0015\u0004\b\u0003\tA\tAAAS'\u0015\t\u0019+DAT!\rq\u0011\u0011V\u0005\u0003]=Aq\u0001MAR\t\u0003\ti\u000b\u0006\u0002\u0002\"\"Q\u0011\u0011WAR\u0005\u0004%\t!a-\u0002G%;gn\u001c:f\r&dWm],ji\"|W\u000f^#yi\u0016t7/[8o!J|\u0007/\u001a:usV\u0011\u0011Q\u0017\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111X\u0016\u0002\t1\fgnZ\u0005\u0004E\u0006e\u0006\"CAa\u0003G\u0003\u000b\u0011BA[\u0003\u0011JuM\\8sK\u001aKG.Z:XSRDw.\u001e;FqR,gn]5p]B\u0013x\u000e]3sif\u0004\u0003BCAc\u0003G\u000b\t\u0011\"\u0003\u0002H\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\r\u0005\u0003\u00028\u0006-\u0017\u0002BAg\u0003s\u0013aa\u00142kK\u000e$\b")
public class AvroFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String IgnoreFilesWithoutExtensionProperty() {
        return AvroFileFormat$.MODULE$.IgnoreFilesWithoutExtensionProperty();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.class.vectorTypes((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.class.supportDataType((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public boolean equals(Object other) {
        Object object = other;
        boolean bl = object instanceof AvroFileFormat;
        return bl;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public Option<StructType> inferSchema(SparkSession spark, Map<String, String> options, Seq<FileStatus> files) {
        void var6_7;
        Configuration conf = spark.sessionState().newHadoopConf();
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        Schema.Parser parser = new Schema.Parser();
        Schema avroSchema = (Schema)parsedOptions.schema().map((Function1)new scala.Serializable(this, parser){
            public static final long serialVersionUID = 0L;
            private final Schema.Parser eta$0$1$1;

            public final Schema apply(String x$1) {
                return this.eta$0$1$1.parse(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }).getOrElse((Function0)new scala.Serializable(this, spark, files, conf, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroFileFormat $outer;
            private final SparkSession spark$1;
            private final Seq files$1;
            private final Configuration conf$1;
            private final AvroOptions parsedOptions$1;

            public final Schema apply() {
                return this.$outer.org$apache$spark$sql$avro$AvroFileFormat$$inferAvroSchemaFromFiles((Seq<FileStatus>)this.files$1, this.conf$1, this.parsedOptions$1.ignoreExtension(), this.spark$1.sessionState().conf().ignoreCorruptFiles());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.spark$1 = spark$1;
                this.files$1 = files$1;
                this.conf$1 = conf$1;
                this.parsedOptions$1 = parsedOptions$1;
            }
        });
        DataType dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Some some = new Some((Object)structType);
            return some;
        }
        throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_7.toString(true)})))).stripMargin());
    }

    public Schema org$apache$spark$sql$avro$AvroFileFormat$$inferAvroSchemaFromFiles(Seq<FileStatus> files, Configuration conf, boolean ignoreExtension, boolean ignoreCorruptFiles) {
        FileReader reader;
        Option avroReader = files.iterator().map((Function1)new scala.Serializable(this, conf, ignoreExtension, ignoreCorruptFiles){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroFileFormat $outer;
            public final Configuration conf$2;
            private final boolean ignoreExtension$1;
            public final boolean ignoreCorruptFiles$1;

            public final Option<FileReader<GenericRecord>> apply(FileStatus f) {
                Path path = f.getPath();
                return this.ignoreExtension$1 || path.getName().endsWith(".avro") ? (Option)Utils$.MODULE$.tryWithResource((Function0)new scala.Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final Path path$1;

                    public final FsInput apply() {
                        return new FsInput(this.path$1, this.$outer.conf$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.path$1 = path$1;
                    }
                }, (Function1)new scala.Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    public final Path path$1;

                    public final Option<FileReader<GenericRecord>> apply(FsInput in) {
                        IOException iOException2;
                        block2: {
                            Some some;
                            try {
                                some = new Some((Object)DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader()));
                            }
                            catch (IOException iOException2) {
                                if (!this.$outer.ignoreCorruptFiles$1) break block2;
                                this.$outer.org$apache$spark$sql$avro$AvroFileFormat$$anonfun$$$outer().logWarning((Function0<String>)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$4$$anonfun$apply$2 $outer;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the footer in the corrupted file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.path$1}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, iOException2);
                                some = None$.MODULE$;
                            }
                            return some;
                        }
                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1})), (Throwable)iOException2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.path$1 = path$1;
                    }
                }) : None$.MODULE$;
            }

            public /* synthetic */ AvroFileFormat org$apache$spark$sql$avro$AvroFileFormat$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conf$2 = conf$2;
                this.ignoreExtension$1 = ignoreExtension$1;
                this.ignoreCorruptFiles$1 = ignoreCorruptFiles$1;
            }
        }).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<FileReader<GenericRecord>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    FileReader reader = (FileReader)some.x();
                    object = reader;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<FileReader<GenericRecord>> x1) {
                Option<FileReader<GenericRecord>> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        });
        Option option = avroReader;
        if (option instanceof Some) {
            Some some = (Some)option;
            reader = (FileReader)some.x();
            Schema schema = reader.getSchema();
            return schema;
        }
        if (None$.MODULE$.equals(option)) {
            throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
        }
        throw new MatchError((Object)option);
        finally {
            reader.close();
        }
    }

    public String shortName() {
        return "avro";
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public OutputWriterFactory prepareWrite(SparkSession spark, Job job, Map<String, String> options, StructType dataSchema) {
        String string;
        block6: {
            Schema outputAvroSchema;
            block3: {
                String string2;
                block5: {
                    block4: {
                        AvroOptions parsedOptions;
                        block2: {
                            parsedOptions = new AvroOptions(options, spark.sessionState().newHadoopConf());
                            Schema.Parser parser = new Schema.Parser();
                            outputAvroSchema = (Schema)parsedOptions.schema().map((Function1)new scala.Serializable(this, parser){
                                public static final long serialVersionUID = 0L;
                                private final Schema.Parser eta$0$2$1;

                                public final Schema apply(String x$1) {
                                    return this.eta$0$2$1.parse(x$1);
                                }
                                {
                                    this.eta$0$2$1 = eta$0$2$1;
                                }
                            }).getOrElse((Function0)new scala.Serializable(this, dataSchema, parsedOptions){
                                public static final long serialVersionUID = 0L;
                                private final StructType dataSchema$1;
                                private final AvroOptions parsedOptions$2;

                                public final Schema apply() {
                                    return SchemaConverters$.MODULE$.toAvroType((DataType)this.dataSchema$1, false, this.parsedOptions$2.recordName(), this.parsedOptions$2.recordNamespace());
                                }
                                {
                                    this.dataSchema$1 = dataSchema$1;
                                    this.parsedOptions$2 = parsedOptions$2;
                                }
                            });
                            AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
                            String string3 = parsedOptions.compression();
                            String string4 = "uncompressed";
                            if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                            job.getConfiguration().setBoolean("mapred.output.compress", false);
                            break block3;
                        }
                        job.getConfiguration().setBoolean("mapred.output.compress", true);
                        this.logInfo((Function0<String>)new scala.Serializable(this, parsedOptions){
                            public static final long serialVersionUID = 0L;
                            private final AvroOptions parsedOptions$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compressing Avro output using the ", " codec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parsedOptions$2.compression()}));
                            }
                            {
                                this.parsedOptions$2 = parsedOptions$2;
                            }
                        });
                        string = parsedOptions.compression();
                        if (!"deflate".equals(string)) break block4;
                        int deflateLevel = spark.sessionState().conf().avroDeflateLevel();
                        this.logInfo((Function0<String>)new scala.Serializable(this, deflateLevel){
                            public static final long serialVersionUID = 0L;
                            private final int deflateLevel$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Avro compression level ", " will be used for ", " codec."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.deflateLevel$1), "deflate"}));
                            }
                            {
                                this.deflateLevel$1 = deflateLevel$1;
                            }
                        });
                        job.getConfiguration().setInt("avro.mapred.deflate.level", deflateLevel);
                        string2 = "deflate";
                        break block5;
                    }
                    boolean bl = "snappy".equals(string) ? true : ("bzip2".equals(string) ? true : "xz".equals(string));
                    if (!bl) break block6;
                    string2 = string;
                }
                String codec = string2;
                job.getConfiguration().set("avro.output.codec", codec);
            }
            return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString());
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid compression codec: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession spark, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        AvroOptions parsedOptions = new AvroOptions(options, hadoopConf);
        return new scala.Serializable(this, requiredSchema, broadcastedConf, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroFileFormat $outer;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedConf$1;
            private final AvroOptions parsedOptions$3;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Iterator<InternalRow> apply(PartitionedFile file) {
                FileReader reader;
                Iterator iterator;
                Configuration conf = ((SerializableConfiguration)this.broadcastedConf$1.value()).value();
                Schema.Parser parser = new Schema.Parser();
                Option userProvidedSchema = this.parsedOptions$3.schema().map((Function1)new scala.Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final Schema.Parser eta$0$3$1;

                    public final Schema apply(String x$1) {
                        return this.eta$0$3$1.parse(x$1);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                });
                if (!this.parsedOptions$3.ignoreExtension() && !file.filePath().endsWith(".avro")) {
                    iterator = package$.MODULE$.Iterator().empty();
                    return iterator;
                }
                FsInput in = new FsInput(new Path(new URI(file.filePath())), conf);
                try {
                    GenericDatumReader genericDatumReader;
                    Option option = userProvidedSchema;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Schema userSchema = (Schema)some.x();
                        genericDatumReader = new GenericDatumReader(userSchema);
                    } else {
                        genericDatumReader = new GenericDatumReader();
                    }
                    GenericDatumReader datumReader = genericDatumReader;
                    reader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.logError((Function0<String>)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Exception while opening DataFileReader";
                        }
                    }, e);
                    in.close();
                    throw e;
                }
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new scala.Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    public final FileReader reader$1;

                    public final TaskContext apply(TaskContext taskContext) {
                        return taskContext.addTaskCompletionListener((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$4 $outer;

                            public final void apply(TaskContext x$1) {
                                this.$outer.reader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                });
                reader.sync(file.start());
                long stop = file.start() + file.length();
                AvroDeserializer deserializer = new AvroDeserializer((Schema)userProvidedSchema.getOrElse((Function0)new scala.Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    private final FileReader reader$1;

                    public final Schema apply() {
                        return this.reader$1.getSchema();
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                }), (DataType)this.requiredSchema$1);
                iterator = new Iterator<InternalRow>(this, reader, stop, deserializer){
                    private boolean completed;
                    private final FileReader reader$1;
                    private final long stop$1;
                    private final AvroDeserializer deserializer$1;

                    public Iterator<InternalRow> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<InternalRow> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<InternalRow, U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<InternalRow, Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<InternalRow, Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<InternalRow> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.class.grouped((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<InternalRow> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<InternalRow> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<InternalRow> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<InternalRow> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<InternalRow, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<InternalRow> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<InternalRow> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<InternalRow> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<InternalRow> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<InternalRow> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<InternalRow, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public boolean hasNext() {
                        boolean bl;
                        if (this.completed) {
                            bl = false;
                        } else {
                            void var1_1;
                            boolean r;
                            boolean bl2 = r = this.reader$1.hasNext() && !this.reader$1.pastSync(this.stop$1);
                            if (!r) {
                                this.reader$1.close();
                                this.completed = true;
                            }
                            bl = var1_1;
                        }
                        return bl;
                    }

                    public InternalRow next() {
                        if (this.hasNext()) {
                            GenericRecord record = (GenericRecord)this.reader$1.next();
                            return (InternalRow)this.deserializer$1.deserialize(record);
                        }
                        throw new NoSuchElementException("next on empty iterator");
                    }
                    {
                        this.reader$1 = reader$1;
                        this.stop$1 = stop$1;
                        this.deserializer$1 = deserializer$1;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                        this.completed = false;
                    }
                };
                return iterator;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedConf$1 = broadcastedConf$1;
                this.parsedOptions$3 = parsedOptions$3;
            }
        };
    }

    public AvroFileFormat() {
        FileFormat.class.$init$((FileFormat)this);
        Logging.class.$init$((Logging)this);
    }
}

