/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.net.URI;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CatalogUtils$ {
    public static final CatalogUtils$ MODULE$;
    private final byte ACCESSTYPE_NONE;
    private final byte ACCESSTYPE_READONLY;
    private final byte ACCESSTYPE_WRITEONLY;
    private final byte ACCESSTYPE_READWRITE;
    private final String TRANSLATION_LAYER_ACCESSTYPE_PROPERTY_TEST;

    static {
        new CatalogUtils$();
    }

    public Map<String, String> maskCredentials(Map<String, String> options) {
        return (Map)options.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<String, String> apply(Tuple2<String, String> x0$2) {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String string = key.toLowerCase(Locale.ROOT);
                    String string2 = "password";
                    if (string == null) {
                        if (string2 == null) return new Tuple2((Object)key, (Object)"###");
                    } else if (string.equals(string2)) {
                        return new Tuple2((Object)key, (Object)"###");
                    }
                }
                if (tuple2 == null) return tuple2;
                String key = (String)tuple2._1();
                String value2 = (String)tuple2._2();
                String string = key.toLowerCase(Locale.ROOT);
                String string3 = "url";
                if (string == null) {
                    if (string3 != null) {
                        return tuple2;
                    }
                } else if (!string.equals(string3)) return tuple2;
                if (!value2.toLowerCase(Locale.ROOT).contains("password")) return tuple2;
                return new Tuple2((Object)key, (Object)"###");
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Seq<String> normalizePartCols(String tableName, Seq<String> tableCols, Seq<String> partCols, Function2<String, String, Object> resolver) {
        return (Seq)partCols.map((Function1)new Serializable(tableName, tableCols, resolver){
            public static final long serialVersionUID = 0L;
            private final String tableName$1;
            private final Seq tableCols$1;
            private final Function2 resolver$1;

            public final String apply(String x$6) {
                return CatalogUtils$.MODULE$.org$apache$spark$sql$catalyst$catalog$CatalogUtils$$normalizeColumnName(this.tableName$1, (Seq<String>)this.tableCols$1, x$6, "partition", (Function2<String, String, Object>)this.resolver$1);
            }
            {
                this.tableName$1 = tableName$1;
                this.tableCols$1 = tableCols$1;
                this.resolver$1 = resolver$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BucketSpec normalizeBucketSpec(String tableName, Seq<String> tableCols, BucketSpec bucketSpec, Function2<String, String, Object> resolver) {
        BucketSpec bucketSpec2 = bucketSpec;
        if (bucketSpec2 != null) {
            Tuple3 tuple3;
            int numBuckets = bucketSpec2.numBuckets();
            Seq<String> bucketColumnNames = bucketSpec2.bucketColumnNames();
            Seq<String> sortColumnNames = bucketSpec2.sortColumnNames();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)numBuckets), bucketColumnNames, sortColumnNames);
            int numBuckets2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Seq bucketColumnNames2 = (Seq)tuple32._2();
            Seq sortColumnNames2 = (Seq)tuple32._3();
            Seq normalizedBucketCols = (Seq)bucketColumnNames2.map((Function1)new Serializable(tableName, tableCols, resolver){
                public static final long serialVersionUID = 0L;
                private final String tableName$3;
                private final Seq tableCols$3;
                private final Function2 resolver$3;

                public final String apply(String colName) {
                    return CatalogUtils$.MODULE$.org$apache$spark$sql$catalyst$catalog$CatalogUtils$$normalizeColumnName(this.tableName$3, (Seq<String>)this.tableCols$3, colName, "bucket", (Function2<String, String, Object>)this.resolver$3);
                }
                {
                    this.tableName$3 = tableName$3;
                    this.tableCols$3 = tableCols$3;
                    this.resolver$3 = resolver$3;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq normalizedSortCols = (Seq)sortColumnNames2.map((Function1)new Serializable(tableName, tableCols, resolver){
                public static final long serialVersionUID = 0L;
                private final String tableName$3;
                private final Seq tableCols$3;
                private final Function2 resolver$3;

                public final String apply(String colName) {
                    return CatalogUtils$.MODULE$.org$apache$spark$sql$catalyst$catalog$CatalogUtils$$normalizeColumnName(this.tableName$3, (Seq<String>)this.tableCols$3, colName, "sort", (Function2<String, String, Object>)this.resolver$3);
                }
                {
                    this.tableName$3 = tableName$3;
                    this.tableCols$3 = tableCols$3;
                    this.resolver$3 = resolver$3;
                }
            }, Seq$.MODULE$.canBuildFrom());
            return new BucketSpec(numBuckets2, (Seq<String>)normalizedBucketCols, (Seq<String>)normalizedSortCols);
        }
        throw new MatchError((Object)bucketSpec2);
    }

    public String URIToString(URI uri) {
        return new Path(uri).toString();
    }

    public URI stringToURI(String str) {
        return new Path(str).toUri();
    }

    public String org$apache$spark$sql$catalyst$catalog$CatalogUtils$$normalizeColumnName(String tableName, Seq<String> tableCols, String colName, String colType, Function2<String, String, Object> resolver) {
        return (String)tableCols.find((Function1)new Serializable(colName, resolver){
            public static final long serialVersionUID = 0L;
            private final String colName$1;
            private final Function2 resolver$2;

            public final boolean apply(String x$8) {
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$2.apply((Object)x$8, (Object)this.colName$1));
            }
            {
                this.colName$1 = colName$1;
                this.resolver$2 = resolver$2;
            }
        }).getOrElse((Function0)new Serializable(tableName, tableCols, colName, colType){
            public static final long serialVersionUID = 0L;
            private final String tableName$2;
            private final Seq tableCols$2;
            private final String colName$1;
            private final String colType$1;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column ", " is not defined in table ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.colType$1, this.colName$1, this.tableName$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"defined table columns are: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableCols$2.mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.tableName$2 = tableName$2;
                this.tableCols$2 = tableCols$2;
                this.colName$1 = colName$1;
                this.colType$1 = colType$1;
            }
        });
    }

    public byte ACCESSTYPE_NONE() {
        return this.ACCESSTYPE_NONE;
    }

    public byte ACCESSTYPE_READONLY() {
        return this.ACCESSTYPE_READONLY;
    }

    public byte ACCESSTYPE_WRITEONLY() {
        return this.ACCESSTYPE_WRITEONLY;
    }

    public byte ACCESSTYPE_READWRITE() {
        return this.ACCESSTYPE_READWRITE;
    }

    public String TRANSLATION_LAYER_ACCESSTYPE_PROPERTY_TEST() {
        return this.TRANSLATION_LAYER_ACCESSTYPE_PROPERTY_TEST;
    }

    private Option<CatalogTable> getMetaData(TableIdentifier tableName, SessionCatalog catalog) {
        Throwable throwable2;
        block2: {
            Some some;
            try {
                some = new Some((Object)catalog.getTableMetadata(tableName));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof NoSuchDatabaseException ? true : throwable3 instanceof NoSuchTableException;
                if (!bl) break block2;
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        }
        throw throwable2;
    }

    public void throwIfNoAccess(CatalogTable table) {
        if (SQLConf$.MODULE$.get().checkTranslationLayer() && table.accessInfo().accessType() == this.ACCESSTYPE_NONE()) {
            String requiredCapabilities = ((TraversableOnce)table.accessInfo().requiredReadCapabilities().$plus$plus(table.accessInfo().requiredWriteCapabilities(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |Spark has no access to table ", ". Clients can access this table only if\n          |they have the following capabilities: ", ".\n          |This table may be a Hive-managed ACID table, or require some other capability that Spark\n          |currently does not implement"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.identifier(), requiredCapabilities})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void throwIfNoAccess(TableIdentifier tableName, SessionCatalog catalog) {
        this.getMetaData(tableName, catalog).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CatalogTable tableMeta) {
                CatalogUtils$.MODULE$.throwIfNoAccess(tableMeta);
            }
        });
    }

    public void throwIfRO(CatalogTable table) {
        if (SQLConf$.MODULE$.get().checkTranslationLayer()) {
            this.throwIfNoAccess(table);
            if (table.accessInfo().accessType() == this.ACCESSTYPE_READONLY()) {
                String requiredCapabilities = table.accessInfo().requiredReadCapabilities().mkString(",");
                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |Spark has only read access to table ", ". Clients can modify this table\n          |only if they have the following capabilities: ", ".\n          |This table may be a Hive-managed ACID table, or require some other capability that Spark\n          |currently does not implement"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.identifier(), requiredCapabilities})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
    }

    public void throwIfRO(TableIdentifier tableName, SessionCatalog catalog) {
        this.getMetaData(tableName, catalog).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CatalogTable tableMeta) {
                CatalogUtils$.MODULE$.throwIfRO(tableMeta);
            }
        });
    }

    public void throwIfDropNotAllowed(TableIdentifier tableName, SessionCatalog catalog) {
        this.getMetaData(tableName, catalog).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CatalogTable tableMeta) {
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                if (catalogTableType == null ? catalogTableType2 != null : !((Object)catalogTableType).equals(catalogTableType2)) {
                    CatalogUtils$.MODULE$.throwIfRO(tableMeta);
                }
            }
        });
    }

    private CatalogUtils$() {
        MODULE$ = this;
        this.ACCESSTYPE_NONE = 1;
        this.ACCESSTYPE_READONLY = (byte)2;
        this.ACCESSTYPE_WRITEONLY = (byte)4;
        this.ACCESSTYPE_READWRITE = (byte)8;
        this.TRANSLATION_LAYER_ACCESSTYPE_PROPERTY_TEST = "xtranslationLayer.accessTypex";
    }
}

