/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public abstract class PredicateHelper$class {
    public static Seq splitConjunctivePredicates(PredicateHelper $this, Expression condition) {
        List list;
        Expression expression = condition;
        if (expression instanceof And) {
            And and2 = (And)expression;
            Expression cond1 = and2.left();
            Expression cond2 = and2.right();
            list = (Seq)$this.splitConjunctivePredicates(cond1).$plus$plus($this.splitConjunctivePredicates(cond2), Seq$.MODULE$.canBuildFrom());
        } else {
            Expression expression2 = expression;
            list = Nil$.MODULE$.$colon$colon((Object)expression2);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Option findExpressionAndTrackLineageDown(PredicateHelper $this, Expression exp, LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan child = project.child();
            AttributeMap<Expression> aliases = AttributeMap$.MODULE$.apply((Seq)projectList.collect((PartialFunction)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final <A1 extends NamedExpression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Alias) {
                        Alias alias = (Alias)A1;
                        Expression child = alias.child();
                        object = new Tuple2((Object)alias.toAttribute(), (Object)child);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(NamedExpression x1) {
                    NamedExpression namedExpression = x1;
                    boolean bl = namedExpression instanceof Alias;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom()));
            return $this.findExpressionAndTrackLineageDown($this.replaceAlias(exp, aliases), child);
        }
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            Seq<NamedExpression> aggregateExpressions = aggregate.aggregateExpressions();
            LogicalPlan child = aggregate.child();
            AttributeMap<Expression> aliasMap = AttributeMap$.MODULE$.apply((Seq)aggregateExpressions.collect((PartialFunction)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final <A1 extends NamedExpression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Alias alias;
                    A1 A1 = x2;
                    Object object = A1 instanceof Alias && (alias = (Alias)A1).child().find(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Expression x$2) {
                            return x$2 instanceof AggregateExpression;
                        }
                    }).isEmpty() ? new Tuple2((Object)alias.toAttribute(), (Object)alias.child()) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(NamedExpression x2) {
                    Alias alias;
                    NamedExpression namedExpression = x2;
                    boolean bl = namedExpression instanceof Alias && (alias = (Alias)namedExpression).child().find(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Expression x$2) {
                            return x$2 instanceof AggregateExpression;
                        }
                    }).isEmpty();
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom()));
            return $this.findExpressionAndTrackLineageDown($this.replaceAlias(exp, aliasMap), child);
        }
        if (!(logicalPlan instanceof LeafNode)) return ((TraversableLike)logicalPlan.children().flatMap((Function1)new Serializable($this, exp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PredicateHelper $outer;
            private final Expression exp$1;

            public final Iterable<Tuple2<Expression, LogicalPlan>> apply(LogicalPlan child) {
                return this.exp$1.references().subsetOf(child.outputSet()) ? Option$.MODULE$.option2Iterable(this.$outer.findExpressionAndTrackLineageDown(this.exp$1, child)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.exp$1 = exp$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
        LeafNode leafNode = (LeafNode)logicalPlan;
        if (!exp.references().subsetOf(leafNode.outputSet())) return ((TraversableLike)logicalPlan.children().flatMap((Function1)new /* invalid duplicate definition of identical inner class */, Seq$.MODULE$.canBuildFrom())).headOption();
        return new Some((Object)new Tuple2((Object)exp, (Object)leafNode));
    }

    public static Seq splitDisjunctivePredicates(PredicateHelper $this, Expression condition) {
        List list;
        Expression expression = condition;
        if (expression instanceof Or) {
            Or or2 = (Or)expression;
            Expression cond1 = or2.left();
            Expression cond2 = or2.right();
            list = (Seq)$this.splitDisjunctivePredicates(cond1).$plus$plus($this.splitDisjunctivePredicates(cond2), Seq$.MODULE$.canBuildFrom());
        } else {
            Expression expression2 = expression;
            list = Nil$.MODULE$.$colon$colon((Object)expression2);
        }
        return list;
    }

    public static Expression replaceAlias(PredicateHelper $this, Expression condition, AttributeMap aliases) {
        return (Expression)condition.transformUp(new Serializable($this, aliases){
            public static final long serialVersionUID = 0L;
            private final AttributeMap aliases$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof Attribute) {
                    Attribute attribute = (Attribute)A1;
                    object = this.aliases$1.getOrElse(attribute, (Function0)new Serializable(this, attribute){
                        public static final long serialVersionUID = 0L;
                        private final Attribute x2$1;

                        public final Attribute apply() {
                            return this.x2$1;
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    });
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x3) {
                Expression expression = x3;
                boolean bl = expression instanceof Attribute;
                return bl;
            }
            {
                this.aliases$1 = aliases$1;
            }
        });
    }

    public static boolean canEvaluate(PredicateHelper $this, Expression expr, LogicalPlan plan2) {
        return expr.references().subsetOf(plan2.outputSet());
    }

    public static boolean canEvaluateWithinJoin(PredicateHelper $this, Expression expr) {
        boolean bl;
        Expression expression = expr;
        if (expression.deterministic()) {
            boolean bl2 = expression instanceof ListQuery ? true : expression instanceof Exists;
            if (bl2) {
                bl = false;
            } else if (expression instanceof SubqueryExpression) {
                SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                bl = subqueryExpression.children().isEmpty();
            } else {
                bl = expression instanceof AttributeReference ? true : (expression instanceof Unevaluable ? false : expression.children().forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PredicateHelper $outer;

                    public final boolean apply(Expression expr) {
                        return this.$outer.canEvaluateWithinJoin(expr);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static void $init$(PredicateHelper $this) {
    }
}

