/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;

public final class SpecializedGettersReader {
    private SpecializedGettersReader() {
    }

    public static Object read(SpecializedGetters obj, int ordinal, DataType dataType2, boolean handleNull, boolean handleUserDefinedType) {
        if (handleNull && (obj.isNullAt(ordinal) || dataType2 instanceof NullType)) {
            return null;
        }
        if (dataType2 instanceof BooleanType) {
            return obj.getBoolean(ordinal);
        }
        if (dataType2 instanceof ByteType) {
            return obj.getByte(ordinal);
        }
        if (dataType2 instanceof ShortType) {
            return obj.getShort(ordinal);
        }
        if (dataType2 instanceof IntegerType) {
            return obj.getInt(ordinal);
        }
        if (dataType2 instanceof LongType) {
            return obj.getLong(ordinal);
        }
        if (dataType2 instanceof FloatType) {
            return Float.valueOf(obj.getFloat(ordinal));
        }
        if (dataType2 instanceof DoubleType) {
            return obj.getDouble(ordinal);
        }
        if (dataType2 instanceof StringType) {
            return obj.getUTF8String(ordinal);
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType dt = (DecimalType)dataType2;
            return obj.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (dataType2 instanceof DateType) {
            return obj.getInt(ordinal);
        }
        if (dataType2 instanceof TimestampType) {
            return obj.getLong(ordinal);
        }
        if (dataType2 instanceof CalendarIntervalType) {
            return obj.getInterval(ordinal);
        }
        if (dataType2 instanceof BinaryType) {
            return obj.getBinary(ordinal);
        }
        if (dataType2 instanceof StructType) {
            return obj.getStruct(ordinal, ((StructType)dataType2).size());
        }
        if (dataType2 instanceof ArrayType) {
            return obj.getArray(ordinal);
        }
        if (dataType2 instanceof MapType) {
            return obj.getMap(ordinal);
        }
        if (handleUserDefinedType && dataType2 instanceof UserDefinedType) {
            return obj.get(ordinal, ((UserDefinedType)dataType2).sqlType());
        }
        throw new UnsupportedOperationException("Unsupported data type " + dataType2.simpleString());
    }
}

