/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression$class;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the leading string contains the characters from the trim string\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('Sp', 'SSparkSQLS');\n       arkSQLS\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ew!B\u0001\u0003\u0011\u0003y\u0011AD*ue&tw\r\u0016:j[2+g\r\u001e\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\tq1\u000b\u001e:j]\u001e$&/[7MK\u001a$8cA\t\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"!F\u000e\n\u0005q1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0010\u0012\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u0015\t\u0013\u0003\"\u0001#\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u0013qSAN!\t\u0001BE\u0002\u0003\u0013\u0005\u0001+3#\u0002\u0013'S1R\u0002C\u0001\t(\u0013\tA#A\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001\u0005\u0016\n\u0005-\u0012!!F*ue&twM\r+sS6,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003+5J!A\f\f\u0003\u000fA\u0013x\u000eZ;di\"A\u0001\u0007\nBK\u0002\u0013\u0005\u0011'\u0001\u0004te\u000e\u001cFO]\u000b\u0002M!A1\u0007\nB\tB\u0003%a%A\u0004te\u000e\u001cFO\u001d\u0011\t\u0011U\"#Q3A\u0005\u0002Y\nq\u0001\u001e:j[N#(/F\u00018!\r)\u0002HJ\u0005\u0003sY\u0011aa\u00149uS>t\u0007\u0002C\u001e%\u0005#\u0005\u000b\u0011B\u001c\u0002\u0011Q\u0014\u0018.\\*ue\u0002BQA\b\u0013\u0005\u0002u\"2a\t @\u0011\u0015\u0001D\b1\u0001'\u0011\u001d)D\b%AA\u0002]BQA\b\u0013\u0005\u0002\u0005#2a\t\"D\u0011\u0015)\u0004\t1\u0001'\u0011\u0015\u0001\u0004\t1\u0001'\u0011\u0015qB\u0005\"\u0001F)\t\u0019c\tC\u00031\t\u0002\u0007a\u0005C\u0003II\u0011\u0005\u0013*\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0013\t\u0003\u0017:s!!\u0006'\n\u000553\u0012A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\f\t\u000bI#C\u0011I*\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012\u0001\u0016\t\u0004+v3cB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tIf\"\u0001\u0004=e>|GOP\u0005\u0002/%\u0011ALF\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001\u0018\f\t\u000b\u0005$C\u0011\t2\u0002\t\u00154\u0018\r\u001c\u000b\u0003G\u001a\u0004\"!\u00063\n\u0005\u00154\"aA!os\"9q\r\u0019I\u0001\u0002\u0004A\u0017!B5oaV$\bCA5k\u001b\u0005!\u0011BA6\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b5$C\u0011\u000b8\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA8vuB\u0011\u0001o]\u0007\u0002c*\u0011!OA\u0001\bG>$WmZ3o\u0013\t!\u0018O\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151H\u000e1\u0001x\u0003\r\u0019G\u000f\u001f\t\u0003abL!!_9\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u0010\u001ca\u0001_\u0006\u0011QM\u001e\u0005\b{\u0012\n\t\u0011\"\u0001\u007f\u0003\u0011\u0019w\u000e]=\u0015\t\rz\u0018\u0011\u0001\u0005\baq\u0004\n\u00111\u0001'\u0011\u001d)D\u0010%AA\u0002]B\u0011\"!\u0002%#\u0003%\t!a\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0002\u0016\u0004M\u0005-1FAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]a#\u0001\u0006b]:|G/\u0019;j_:LA!a\u0007\u0002\u0012\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005}A%%A\u0005\u0002\u0005\u0005\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003GQ3aNA\u0006\u0011%\t9\u0003JA\u0001\n\u0003\nI#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0003mC:<'BAA\u001b\u0003\u0011Q\u0017M^1\n\u0007=\u000by\u0003C\u0005\u0002<\u0011\n\t\u0011\"\u0001\u0002>\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\b\t\u0004+\u0005\u0005\u0013bAA\"-\t\u0019\u0011J\u001c;\t\u0013\u0005\u001dC%!A\u0005\u0002\u0005%\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004G\u0006-\u0003BCA'\u0003\u000b\n\t\u00111\u0001\u0002@\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005EC%!A\u0005B\u0005M\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0003#BA,\u0003;\u001aWBAA-\u0015\r\tYFF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA0\u00033\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003G\"\u0013\u0011!C\u0001\u0003K\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\ni\u0007E\u0002\u0016\u0003SJ1!a\u001b\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0014\u0002b\u0005\u0005\t\u0019A2\t\u0013\u0005ED%!A\u0005B\u0005M\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002h\u0005U\u0004\"CA'\u0003_\n\t\u00111\u0001dQM!\u0013\u0011PA@\u0003\u0003\u000b))a\"\u0002\f\u00065\u0015\u0011SAJ!\r\u0001\u00121P\u0005\u0004\u0003{\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0007\u000b\u0011Q\u000b\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fA1,\u0017\rZ5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`QQ\u0014\u0018.\\*ue2\u00023\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fA1,\u0017\rZ5oO\u0002\u001aHO]5oO\u0002\u001awN\u001c;bS:\u001c\b\u0005\u001e5fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004C\u000f[3!iJLW\u000eI:ue&twM\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002\n\u0006\tiB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ue&l7\u000b\u001e:![\u0001\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tAQ|\u0007\u0005\u001e:j[2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013\rI:j]\u001edW\rI:qC\u000e,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a$\u0002\u0003\u0017Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u0011!A\u0001\u001a\u0006/\u0019:l'Fc\u0005\u0005\t\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sWN\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B<C\u0006I\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011be.\u001c\u0016\u000bT*\u000bA\u0001\nQa]5oG\u0016\f#!!&\u0002\u000bErSG\f\u0019\t\r\u0005e\u0005\u00051\u0001'\u0003\r\u0019HO\u001d\u0005\u0006k\u0001\u0002\rA\n\u0005\u0007CE!\t!a(\u0015\u0007\r\n\t\u000bC\u0004\u0002\u001a\u0006u\u0005\u0019\u0001\u0014\t\u0011\u0005\n\u0012\u0011!CA\u0003K#RaIAT\u0003SCa\u0001MAR\u0001\u00041\u0003\u0002C\u001b\u0002$B\u0005\t\u0019A\u001c\t\u0013\u00055\u0016#!A\u0005\u0002\u0006=\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003c\u000bI\f\u0005\u0003\u0016q\u0005M\u0006#B\u000b\u00026\u001a:\u0014bAA\\-\t1A+\u001e9mKJB\u0011\"a/\u0002,\u0006\u0005\t\u0019A\u0012\u0002\u0007a$\u0003\u0007C\u0005\u0002@F\t\n\u0011\"\u0001\u0002\"\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB\u0011\"a1\u0012#\u0003%\t!!\t\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIIB\u0011\"a2\u0012\u0003\u0003%I!!3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u0004B!!\f\u0002N&!\u0011qZA\u0018\u0005\u0019y%M[3di\u0002")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression$class.dataType(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression$class.inputTypes(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression$class.nullable(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression$class.foldable(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimLeft((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimLeft());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$4;

            public final ExprCode apply(Expression x$44) {
                return x$44.genCode(this.ctx$4);
            }
            {
                this.ctx$4 = ctx$4;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$45) {
                    return x$45.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimLeftFunction = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft(", ");\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimString.isNull(), ev.isNull(), ev.value(), srcString.value(), trimString.value()}));
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$46) {
                    return x$46.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimLeftFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 0: {
                object = this.srcStr();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes$class.$init$(this);
        String2TrimExpression$class.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

