/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.net.URL;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class StaticSQLConf$
implements Logging {
    public static final StaticSQLConf$ MODULE$;
    private final ConfigEntry<String> WAREHOUSE_PATH;
    private final ConfigEntry<String> CATALOG_IMPLEMENTATION;
    private final ConfigEntry<String> GLOBAL_TEMP_DATABASE;
    private final ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD;
    private final ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    private final ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES;
    private final ConfigEntry<Object> CODEGEN_COMMENTS;
    private final ConfigEntry<Object> DEBUG_MODE;
    private final ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION;
    private final OptionalConfigEntry<Seq<String>> SPARK_SESSION_EXTENSIONS;
    private final OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS;
    private final OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS;
    private final ConfigEntry<Object> UI_RETAINED_EXECUTIONS;
    private final ConfigEntry<Object> SUBQUERY_MAX_THREAD_THRESHOLD;
    private final ConfigEntry<Object> STREAMING_UI_ENABLED;
    private final ConfigEntry<Object> STREAMING_UI_RETAINED_PROGRESS_UPDATES;
    private final ConfigEntry<Object> STREAMING_UI_RETAINED_QUERIES;
    private final ConfigEntry<Seq<String>> ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StaticSQLConf$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ConfigEntry<String> WAREHOUSE_PATH() {
        return this.WAREHOUSE_PATH;
    }

    public ConfigEntry<String> CATALOG_IMPLEMENTATION() {
        return this.CATALOG_IMPLEMENTATION;
    }

    public String org$apache$spark$sql$internal$StaticSQLConf$$defaultCatalogImplementation() {
        String string;
        boolean hasHiveClasses;
        boolean bl;
        URL hiveSiteXML = Utils$.MODULE$.getContextOrSparkClassLoader().getResource("hive-site.xml");
        try {
            Utils$.MODULE$.classForName("org.apache.spark.sql.hive.HiveExternalCatalog");
            bl = true;
        }
        catch (Exception exception) {
            bl = hasHiveClasses = false;
        }
        if (hiveSiteXML != null && hasHiveClasses && !package$.MODULE$.env().contains((Object)"SPARK_TESTING")) {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "found hive-site.xml on classpath, enabling hive support";
                }
            });
            string = "hive";
        } else {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "no hive-site.xml found on classpath, disabling hive support";
                }
            });
            string = "in-memory";
        }
        return string;
    }

    public ConfigEntry<String> GLOBAL_TEMP_DATABASE() {
        return this.GLOBAL_TEMP_DATABASE;
    }

    public ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD() {
        return this.SCHEMA_STRING_LENGTH_THRESHOLD;
    }

    public ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE() {
        return this.FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    }

    public ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES() {
        return this.CODEGEN_CACHE_MAX_ENTRIES;
    }

    public ConfigEntry<Object> CODEGEN_COMMENTS() {
        return this.CODEGEN_COMMENTS;
    }

    public ConfigEntry<Object> DEBUG_MODE() {
        return this.DEBUG_MODE;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION() {
        return this.HIVE_THRIFT_SERVER_SINGLESESSION;
    }

    public OptionalConfigEntry<Seq<String>> SPARK_SESSION_EXTENSIONS() {
        return this.SPARK_SESSION_EXTENSIONS;
    }

    public OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS() {
        return this.QUERY_EXECUTION_LISTENERS;
    }

    public OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS() {
        return this.STREAMING_QUERY_LISTENERS;
    }

    public ConfigEntry<Object> UI_RETAINED_EXECUTIONS() {
        return this.UI_RETAINED_EXECUTIONS;
    }

    public ConfigEntry<Object> SUBQUERY_MAX_THREAD_THRESHOLD() {
        return this.SUBQUERY_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> STREAMING_UI_ENABLED() {
        return this.STREAMING_UI_ENABLED;
    }

    public ConfigEntry<Object> STREAMING_UI_RETAINED_PROGRESS_UPDATES() {
        return this.STREAMING_UI_RETAINED_PROGRESS_UPDATES;
    }

    public ConfigEntry<Object> STREAMING_UI_RETAINED_QUERIES() {
        return this.STREAMING_UI_RETAINED_QUERIES;
    }

    public ConfigEntry<Seq<String>> ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST() {
        return this.ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST;
    }

    private StaticSQLConf$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.WAREHOUSE_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.warehouse.dir").doc("The default location for managed databases and tables.").stringConf().createWithDefault((Object)Utils$.MODULE$.resolveURI("spark-warehouse").toString());
        this.CATALOG_IMPLEMENTATION = SQLConf$.MODULE$.buildStaticConf("spark.sql.catalogImplementation").internal().stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "in-memory"}))).createWithDefaultFunction((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return StaticSQLConf$.MODULE$.org$apache$spark$sql$internal$StaticSQLConf$$defaultCatalogImplementation();
            }
        });
        this.GLOBAL_TEMP_DATABASE = SQLConf$.MODULE$.buildStaticConf("spark.sql.globalTempDatabase").internal().stringConf().createWithDefault((Object)"global_temp");
        this.SCHEMA_STRING_LENGTH_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.sources.schemaStringLengthThreshold").doc("The maximum length allowed in a single cell when storing additional schema information in Hive's metastore.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4000));
        this.FILESOURCE_TABLE_RELATION_CACHE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.sql.filesourceTableRelationCacheSize").internal().doc("The maximum size of the cache that maps qualified table names to table relation plans.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int cacheSize) {
                return this.apply$mcZI$sp(cacheSize);
            }

            public boolean apply$mcZI$sp(int cacheSize) {
                return cacheSize >= 0;
            }
        }, "The maximum size of the cache must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.CODEGEN_CACHE_MAX_ENTRIES = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.cache.maxEntries").internal().doc("When nonzero, enable caching of generated classes for operators and expressions. All jobs share the cache that can use up to the specified number for generated classes.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int maxEntries) {
                return this.apply$mcZI$sp(maxEntries);
            }

            public boolean apply$mcZI$sp(int maxEntries) {
                return maxEntries >= 0;
            }
        }, "The maximum must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.CODEGEN_COMMENTS = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.comments").internal().doc("When true, put comment in the generated code. Since computing huge comments can be extremely expensive in certain cases, such as deeply-nested expressions which operate over inputs with wide schemas, default is false.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DEBUG_MODE = SQLConf$.MODULE$.buildStaticConf("spark.sql.debug").internal().doc("Only used for internal debugging. Not all functions are supported when it is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_THRIFT_SERVER_SINGLESESSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.thriftServer.singleSession").doc("When set to true, Hive Thrift server is running in a single session mode. All the JDBC/ODBC connections share the temporary views, function registries, SQL configuration and the current database.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.SPARK_SESSION_EXTENSIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.extensions").doc("A comma-separated list of classes that implement Function1[SparkSessionExtension, Unit] used to configure Spark Session extensions. The classes must have a no-args constructor. If multiple extensions are specified, they are applied in the specified order. For the case of rules and planner strategies, they are applied in the specified order. For the case of parsers, the last parser is used and each parser can delegate to its predecessor. For the case of function name conflicts, the last registered function name is used.").stringConf().toSequence().createOptional();
        this.QUERY_EXECUTION_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.queryExecutionListeners").doc("List of class names implementing QueryExecutionListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").stringConf().toSequence().createOptional();
        this.STREAMING_QUERY_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.streamingQueryListeners").doc("List of class names implementing StreamingQueryListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").stringConf().toSequence().createOptional();
        this.UI_RETAINED_EXECUTIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.ui.retainedExecutions").doc("Number of executions to retain in the Spark UI.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.SUBQUERY_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.subquery.maxThreadThreshold").internal().doc("The maximum degree of parallelism to execute the subquery.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int thres) {
                return this.apply$mcZI$sp(thres);
            }

            public boolean apply$mcZI$sp(int thres) {
                return thres > 0 && thres <= 128;
            }
        }, "The threshold must be in (0,128].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)16));
        this.STREAMING_UI_ENABLED = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.enabled").doc("Whether to run the Structured Streaming Web UI for the Spark application when the Spark Web UI is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.STREAMING_UI_RETAINED_PROGRESS_UPDATES = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.retainedProgressUpdates").doc("The number of progress updates to retain for a streaming query for Structured Streaming UI.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.STREAMING_UI_RETAINED_QUERIES = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.retainedQueries").doc("The number of inactive queries to retain for Structured Streaming UI.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.ui.enabledCustomMetricList").internal().doc("Configures a list of custom metrics on Structured Streaming UI, which are enabled. The list contains the name of the custom metrics separated by comma. In aggregationonly sum used. The list of supported custom metrics is state store provider specific and it can be found out for example from query progress log entry.").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
    }
}

