/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.util.VersionInfo;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveClientImpl;
import org.apache.spark.sql.hive.client.IsolatedClientLoader;
import org.apache.spark.sql.hive.client.IsolatedClientLoader$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveUtils$
implements Logging {
    public static final HiveUtils$ MODULE$;
    private final String hiveExecutionVersion;
    private final ConfigEntry<String> HIVE_METASTORE_VERSION;
    private final ConfigEntry<String> HIVE_EXECUTION_VERSION;
    private final ConfigEntry<String> HIVE_METASTORE_JARS;
    private final ConfigEntry<Object> CONVERT_METASTORE_PARQUET;
    private final ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    private final ConfigEntry<Object> CONVERT_METASTORE_ORC;
    private final ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES;
    private final ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES;
    private final ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC;
    private final Seq<AtomicType> primitiveTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HiveUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public SparkContext withHiveExternalCatalog(SparkContext sc) {
        sc.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive");
        return sc;
    }

    public String hiveExecutionVersion() {
        return this.hiveExecutionVersion;
    }

    public ConfigEntry<String> HIVE_METASTORE_VERSION() {
        return this.HIVE_METASTORE_VERSION;
    }

    public ConfigEntry<String> HIVE_EXECUTION_VERSION() {
        return this.HIVE_EXECUTION_VERSION;
    }

    public ConfigEntry<String> HIVE_METASTORE_JARS() {
        return this.HIVE_METASTORE_JARS;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET() {
        return this.CONVERT_METASTORE_PARQUET;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING() {
        return this.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_ORC() {
        return this.CONVERT_METASTORE_ORC;
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES() {
        return this.HIVE_METASTORE_SHARED_PREFIXES;
    }

    private Seq<String> jdbcPrefixes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.mysql.jdbc", "org.postgresql", "com.microsoft.sqlserver", "oracle.jdbc"}));
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES() {
        return this.HIVE_METASTORE_BARRIER_PREFIXES;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC() {
        return this.HIVE_THRIFT_SERVER_ASYNC;
    }

    private String hiveMetastoreVersion(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_VERSION());
    }

    private String hiveMetastoreJars(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_JARS());
    }

    private Seq<String> hiveMetastoreSharedPrefixes(SQLConf conf) {
        return (Seq)((TraversableLike)conf.getConf(this.HIVE_METASTORE_SHARED_PREFIXES())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = "";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
    }

    private Seq<String> hiveMetastoreBarrierPrefixes(SQLConf conf) {
        return (Seq)((TraversableLike)conf.getConf(this.HIVE_METASTORE_BARRIER_PREFIXES())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                String string = x$2;
                String string2 = "";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
    }

    public Map<String, String> hiveClientConfigurations(Configuration hadoopConf) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HMSHANDLERINTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_CLEAN_FREQ), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_EXPIRY_DURATION), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVES_AUTO_PROGRESS_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_STATS_JDBC_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_STATS_RETRIES_WAIT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_TXN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_CHECK_INTERVAL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_IDLE_TIME), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_WORKER_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_WORKER_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SERVER_READ_SOCKET_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_CLIENT_FUTURE_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_JOB_MONITOR_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT), (Object)TimeUnit.MILLISECONDS)}))).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final Tuple2<String, String> apply(Tuple2<HiveConf.ConfVars, TimeUnit> x0$1) {
                Tuple2<HiveConf.ConfVars, TimeUnit> tuple2 = x0$1;
                if (tuple2 != null) {
                    HiveConf.ConfVars confVar = (HiveConf.ConfVars)tuple2._1();
                    TimeUnit unit = (TimeUnit)((Object)tuple2._2());
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)confVar.varname), (Object)((Object)BoxesRunTime.boxToLong((long)HiveConf.getTimeVar((Configuration)this.hadoopConf$1, (HiveConf.ConfVars)confVar, (TimeUnit)unit))).toString());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public HiveClientImpl newClientForExecution(SparkConf conf, Configuration hadoopConf) {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing execution hive, version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HiveUtils$.MODULE$.hiveExecutionVersion()}));
            }
        });
        package.HiveVersion x$6 = IsolatedClientLoader$.MODULE$.hiveVersion(this.hiveExecutionVersion());
        SparkConf x$7 = conf;
        Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Configuration x$9 = hadoopConf;
        Map<String, String> x$10 = this.newTemporaryConfiguration(true);
        boolean x$11 = false;
        ClassLoader x$12 = Utils$.MODULE$.getContextOrSparkClassLoader();
        boolean x$13 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
        ClassLoader x$14 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
        Seq<String> x$15 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$10();
        Seq<String> x$16 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$11();
        IsolatedClientLoader loader = new IsolatedClientLoader(x$6, x$7, x$9, (Seq<URL>)x$8, x$10, x$11, x$13, x$14, x$12, x$15, x$16);
        return (HiveClientImpl)loader.createClient();
    }

    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf) {
        Map<String, String> configurations = this.hiveClientConfigurations(hadoopConf);
        return this.newClientForMetadata(conf, hadoopConf, configurations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf, Map<String, String> configurations) {
        IsolatedClientLoader isolatedClientLoader;
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLContext$.MODULE$.getSQLProperties(conf));
        String hiveMetastoreVersion = this.hiveMetastoreVersion(sqlConf);
        String hiveMetastoreJars = this.hiveMetastoreJars(sqlConf);
        Seq<String> hiveMetastoreSharedPrefixes2 = this.hiveMetastoreSharedPrefixes(sqlConf);
        Seq<String> hiveMetastoreBarrierPrefixes2 = this.hiveMetastoreBarrierPrefixes(sqlConf);
        package.HiveVersion metaVersion = IsolatedClientLoader$.MODULE$.hiveVersion(hiveMetastoreVersion);
        String string = hiveMetastoreJars;
        String string2 = "builtin";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = this.hiveExecutionVersion();
            String string4 = hiveMetastoreVersion;
            if (string3 != null ? !string3.equals(string4) : string4 != null) throw new IllegalArgumentException(new StringBuilder().append((Object)"Builtin jars can only be used when hive execution version == hive metastore version. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Execution: ", " != Metastore: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveExecutionVersion(), hiveMetastoreVersion}))).append((Object)"Specify a vaild path to the correct hive jars using $HIVE_METASTORE_JARS ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"or change ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HIVE_METASTORE_VERSION().key(), this.hiveExecutionVersion()}))).toString());
            ClassLoader classLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
            URL[] jars = this.allJars$1(classLoader);
            if (jars.length == 0) {
                throw new IllegalArgumentException("Unable to locate hive jars to connect to metastore. Please set spark.sql.hive.metastore.jars.");
            }
            this.logInfo((Function0<String>)new Serializable(hiveMetastoreVersion){
                public static final long serialVersionUID = 0L;
                private final String hiveMetastoreVersion$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing HiveMetastoreConnection version ", " using Spark classes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveMetastoreVersion$1}));
                }
                {
                    this.hiveMetastoreVersion$1 = hiveMetastoreVersion$1;
                }
            });
            package.HiveVersion x$17 = metaVersion;
            SparkConf x$18 = conf;
            Configuration x$19 = hadoopConf;
            Seq x$20 = Predef$.MODULE$.refArrayOps((Object[])jars).toSeq();
            Map<String, String> x$21 = configurations;
            boolean x$22 = true;
            Seq<String> x$23 = hiveMetastoreBarrierPrefixes2;
            Seq<String> x$24 = hiveMetastoreSharedPrefixes2;
            boolean x$25 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
            ClassLoader x$26 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
            ClassLoader x$27 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$9();
            isolatedClientLoader = new IsolatedClientLoader(x$17, x$18, x$19, (Seq<URL>)x$20, x$21, x$22, x$25, x$26, x$27, x$24, x$23);
        } else {
            String string5 = hiveMetastoreJars;
            String string6 = "maven";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.logInfo((Function0<String>)new Serializable(hiveMetastoreVersion){
                    public static final long serialVersionUID = 0L;
                    private final String hiveMetastoreVersion$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing HiveMetastoreConnection version ", " using maven."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveMetastoreVersion$1}));
                    }
                    {
                        this.hiveMetastoreVersion$1 = hiveMetastoreVersion$1;
                    }
                });
                String x$28 = hiveMetastoreVersion;
                String x$29 = VersionInfo.getVersion();
                SparkConf x$30 = conf;
                Configuration x$31 = hadoopConf;
                Map<String, String> x$32 = configurations;
                Seq<String> x$33 = hiveMetastoreBarrierPrefixes2;
                Seq<String> x$34 = hiveMetastoreSharedPrefixes2;
                Option<String> x$35 = IsolatedClientLoader$.MODULE$.forVersion$default$6();
                isolatedClientLoader = IsolatedClientLoader$.MODULE$.forVersion(x$28, x$29, x$30, x$31, x$32, x$35, x$34, x$33);
            } else {
                URL[] jars = (URL[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hiveMetastoreJars.split(File.pathSeparator)).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TraversableOnce<File> apply(String x0$2) {
                        List list;
                        String string = x0$2;
                        String string2 = new File(string).getName();
                        String string3 = "*";
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            Nil$ nil$;
                            File[] files = new File(string).getParentFile().listFiles();
                            if (files == null) {
                                HiveUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this, string){
                                    public static final long serialVersionUID = 0L;
                                    private final String x1$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hive jar path '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                                    }
                                    {
                                        this.x1$1 = x1$1;
                                    }
                                });
                                nil$ = Nil$.MODULE$;
                            } else {
                                nil$ = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(File x$3) {
                                        return x$3.getName().toLowerCase().endsWith(".jar");
                                    }
                                }));
                            }
                            list = nil$;
                        } else {
                            File file = new File(string);
                            list = Nil$.MODULE$.$colon$colon((Object)file);
                        }
                        return list;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final URL apply(File x$5) {
                        return x$5.toURI().toURL();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
                this.logInfo((Function0<String>)new Serializable(hiveMetastoreVersion, jars){
                    public static final long serialVersionUID = 0L;
                    private final String hiveMetastoreVersion$1;
                    private final URL[] jars$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing HiveMetastoreConnection version ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveMetastoreVersion$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.jars$1).mkString(":")}))).toString();
                    }
                    {
                        this.hiveMetastoreVersion$1 = hiveMetastoreVersion$1;
                        this.jars$1 = jars$1;
                    }
                });
                package.HiveVersion x$36 = metaVersion;
                SparkConf x$37 = conf;
                Configuration x$38 = hadoopConf;
                Seq x$39 = Predef$.MODULE$.refArrayOps((Object[])jars).toSeq();
                Map<String, String> x$40 = configurations;
                boolean x$41 = true;
                Seq<String> x$42 = hiveMetastoreBarrierPrefixes2;
                Seq<String> x$43 = hiveMetastoreSharedPrefixes2;
                boolean x$44 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
                ClassLoader x$45 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
                ClassLoader x$46 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$9();
                isolatedClientLoader = new IsolatedClientLoader(x$36, x$37, x$38, (Seq<URL>)x$39, x$40, x$41, x$44, x$45, x$46, x$43, x$42);
            }
        }
        IsolatedClientLoader isolatedLoader = isolatedClientLoader;
        return isolatedLoader.createClient();
    }

    public Map<String, String> newTemporaryConfiguration(boolean useInMemoryDerby) {
        String withInMemoryMode = useInMemoryDerby ? "memory:" : "";
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File localMetastore = new File(tempDir, "metastore");
        HashMap propMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])HiveConf.ConfVars.values()).foreach((Function1)new Serializable(propMap){
            public static final long serialVersionUID = 0L;
            private final HashMap propMap$1;

            public final Object apply(HiveConf.ConfVars confvar) {
                return confvar.varname.contains("datanucleus") || confvar.varname.contains("jdo") || confvar.varname.contains("hive.metastore.rawstore.impl") ? this.propMap$1.put((Object)confvar.varname, (Object)confvar.getDefaultExpr()) : BoxedUnit.UNIT;
            }
            {
                this.propMap$1 = propMap$1;
            }
        });
        propMap.put((Object)StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), (Object)localMetastore.toURI().toString());
        propMap.put((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:", ";databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{withInMemoryMode, localMetastore.getAbsolutePath()})));
        propMap.put((Object)"datanucleus.rdbms.datastoreAdapterClassName", (Object)"org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        propMap.put((Object)HiveConf.ConfVars.METASTOREURIS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS.varname, (Object)"");
        return propMap.toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<AtomicType> primitiveTypes() {
        return this.primitiveTypes;
    }

    public String toHiveString(Tuple2<Object, DataType> a) {
        Tuple2<Object, DataType> tuple2;
        block11: {
            String string;
            block3: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    Object object;
                                    block5: {
                                        block4: {
                                            block2: {
                                                tuple2 = a;
                                                if (tuple2 == null) break block2;
                                                Object struct = tuple2._1();
                                                DataType dataType = (DataType)tuple2._2();
                                                if (!(struct instanceof Row)) break block2;
                                                Row row = (Row)struct;
                                                if (!(dataType instanceof StructType)) break block2;
                                                StructType structType = (StructType)dataType;
                                                StructField[] fields = structType.fields();
                                                string = ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply(Tuple2<Object, StructField> x0$3) {
                                                        Tuple2<Object, StructField> tuple2 = x0$3;
                                                        if (tuple2 != null) {
                                                            Object v = tuple2._1();
                                                            StructField t = (StructField)tuple2._2();
                                                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), HiveUtils$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))}));
                                                            return string;
                                                        }
                                                        throw new MatchError(tuple2);
                                                    }
                                                }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                                                break block3;
                                            }
                                            if (tuple2 == null) break block4;
                                            Object seq = tuple2._1();
                                            DataType dataType = (DataType)tuple2._2();
                                            if (!(seq instanceof Seq)) break block4;
                                            Seq seq2 = (Seq)seq;
                                            if (!(dataType instanceof ArrayType)) break block4;
                                            ArrayType arrayType = (ArrayType)dataType;
                                            DataType typ = arrayType.elementType();
                                            string = ((TraversableOnce)((TraversableLike)seq2.map((Function1)new Serializable(typ){
                                                public static final long serialVersionUID = 0L;
                                                private final DataType typ$1;

                                                public final Tuple2<Object, DataType> apply(Object v) {
                                                    return new Tuple2(v, (Object)this.typ$1);
                                                }
                                                {
                                                    this.typ$1 = typ$1;
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(Tuple2<Object, DataType> a) {
                                                    return HiveUtils$.MODULE$.toHiveStructString(a);
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                                            break block3;
                                        }
                                        if (tuple2 == null) break block5;
                                        Object map = tuple2._1();
                                        DataType dataType = (DataType)tuple2._2();
                                        if (!(map instanceof Map)) break block5;
                                        Map map2 = (Map)map;
                                        if (!(dataType instanceof MapType)) break block5;
                                        MapType mapType = (MapType)dataType;
                                        DataType kType = mapType.keyType();
                                        DataType vType = mapType.valueType();
                                        string = ((TraversableOnce)((TraversableOnce)map2.map((Function1)new Serializable(kType, vType){
                                            public static final long serialVersionUID = 0L;
                                            private final DataType kType$1;
                                            private final DataType vType$1;

                                            public final String apply(Tuple2<Object, Object> x0$4) {
                                                Tuple2<Object, Object> tuple2 = x0$4;
                                                if (tuple2 != null) {
                                                    Object key = tuple2._1();
                                                    Object value = tuple2._2();
                                                    String string = new StringBuilder().append((Object)HiveUtils$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)this.kType$1))).append((Object)":").append((Object)HiveUtils$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)this.vType$1))).toString();
                                                    return string;
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                            {
                                                this.kType$1 = kType$1;
                                                this.vType$1 = vType$1;
                                            }
                                        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                                        break block3;
                                    }
                                    if (tuple2 == null || (object = tuple2._1()) != null) break block6;
                                    string = "NULL";
                                    break block3;
                                }
                                if (tuple2 == null) break block7;
                                Object d = tuple2._1();
                                DataType dataType = (DataType)tuple2._2();
                                if (!(d instanceof Integer)) break block7;
                                int n = BoxesRunTime.unboxToInt((Object)d);
                                if (!DateType$.MODULE$.equals(dataType)) break block7;
                                string = new DateWritable(n).toString();
                                break block3;
                            }
                            if (tuple2 == null) break block8;
                            Object t = tuple2._1();
                            DataType dataType = (DataType)tuple2._2();
                            if (!(t instanceof Timestamp)) break block8;
                            Timestamp timestamp = (Timestamp)t;
                            if (!TimestampType$.MODULE$.equals(dataType)) break block8;
                            string = new TimestampWritable(timestamp).toString();
                            break block3;
                        }
                        if (tuple2 == null) break block9;
                        Object bin = tuple2._1();
                        DataType dataType = (DataType)tuple2._2();
                        if (!(bin instanceof byte[])) break block9;
                        byte[] byArray = (byte[])bin;
                        if (!BinaryType$.MODULE$.equals(dataType)) break block9;
                        string = new String(byArray, StandardCharsets.UTF_8);
                        break block3;
                    }
                    if (tuple2 == null) break block10;
                    Object decimal = tuple2._1();
                    DataType dataType = (DataType)tuple2._2();
                    if (!(decimal instanceof BigDecimal)) break block10;
                    BigDecimal bigDecimal = (BigDecimal)decimal;
                    if (!DecimalType$.MODULE$.unapply(dataType)) break block10;
                    string = HiveDecimal.create((BigDecimal)bigDecimal).toString();
                    break block3;
                }
                if (tuple2 == null) break block11;
                Object other = tuple2._1();
                DataType tpe = (DataType)tuple2._2();
                if (!this.primitiveTypes().contains((Object)tpe)) break block11;
                string = other.toString();
            }
            return string;
        }
        throw new MatchError(tuple2);
    }

    public String toHiveStructString(Tuple2<Object, DataType> a) {
        Tuple2<Object, DataType> tuple2;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            Object object;
                            block5: {
                                block4: {
                                    block2: {
                                        tuple2 = a;
                                        if (tuple2 == null) break block2;
                                        Object struct = tuple2._1();
                                        DataType dataType = (DataType)tuple2._2();
                                        if (!(struct instanceof Row)) break block2;
                                        Row row = (Row)struct;
                                        if (!(dataType instanceof StructType)) break block2;
                                        StructType structType = (StructType)dataType;
                                        StructField[] fields = structType.fields();
                                        string = ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(Tuple2<Object, StructField> x0$5) {
                                                Tuple2<Object, StructField> tuple2 = x0$5;
                                                if (tuple2 != null) {
                                                    Object v = tuple2._1();
                                                    StructField t = (StructField)tuple2._2();
                                                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), HiveUtils$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))}));
                                                    return string;
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                                        break block3;
                                    }
                                    if (tuple2 == null) break block4;
                                    Object seq = tuple2._1();
                                    DataType dataType = (DataType)tuple2._2();
                                    if (!(seq instanceof Seq)) break block4;
                                    Seq seq2 = (Seq)seq;
                                    if (!(dataType instanceof ArrayType)) break block4;
                                    ArrayType arrayType = (ArrayType)dataType;
                                    DataType typ = arrayType.elementType();
                                    string = ((TraversableOnce)((TraversableLike)seq2.map((Function1)new Serializable(typ){
                                        public static final long serialVersionUID = 0L;
                                        private final DataType typ$2;

                                        public final Tuple2<Object, DataType> apply(Object v) {
                                            return new Tuple2(v, (Object)this.typ$2);
                                        }
                                        {
                                            this.typ$2 = typ$2;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Tuple2<Object, DataType> a) {
                                            return HiveUtils$.MODULE$.toHiveStructString(a);
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                                    break block3;
                                }
                                if (tuple2 == null) break block5;
                                Object map = tuple2._1();
                                DataType dataType = (DataType)tuple2._2();
                                if (!(map instanceof Map)) break block5;
                                Map map2 = (Map)map;
                                if (!(dataType instanceof MapType)) break block5;
                                MapType mapType = (MapType)dataType;
                                DataType kType = mapType.keyType();
                                DataType vType = mapType.valueType();
                                string = ((TraversableOnce)((TraversableOnce)map2.map((Function1)new Serializable(kType, vType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType kType$2;
                                    private final DataType vType$2;

                                    public final String apply(Tuple2<Object, Object> x0$6) {
                                        Tuple2<Object, Object> tuple2 = x0$6;
                                        if (tuple2 != null) {
                                            Object key = tuple2._1();
                                            Object value = tuple2._2();
                                            String string = new StringBuilder().append((Object)HiveUtils$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)this.kType$2))).append((Object)":").append((Object)HiveUtils$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)this.vType$2))).toString();
                                            return string;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        this.kType$2 = kType$2;
                                        this.vType$2 = vType$2;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                                break block3;
                            }
                            if (tuple2 == null || (object = tuple2._1()) != null) break block6;
                            string = "null";
                            break block3;
                        }
                        if (tuple2 == null) break block7;
                        Object s = tuple2._1();
                        DataType dataType = (DataType)tuple2._2();
                        if (!(s instanceof String)) break block7;
                        String string2 = (String)s;
                        if (!StringType$.MODULE$.equals(dataType)) break block7;
                        string = new StringBuilder().append((Object)"\"").append((Object)string2).append((Object)"\"").toString();
                        break block3;
                    }
                    if (tuple2 == null) break block8;
                    Object decimal = tuple2._1();
                    DataType dataType = (DataType)tuple2._2();
                    if (!DecimalType$.MODULE$.unapply(dataType)) break block8;
                    string = decimal.toString();
                    break block3;
                }
                if (tuple2 == null) break block9;
                Object other = tuple2._1();
                DataType tpe = (DataType)tuple2._2();
                if (!this.primitiveTypes().contains((Object)tpe)) break block9;
                string = other.toString();
            }
            return string;
        }
        throw new MatchError(tuple2);
    }

    private final URL[] allJars$1(ClassLoader classLoader) {
        while (true) {
            ClassLoader classLoader2;
            block5: {
                URL[] uRLArray;
                block4: {
                    block3: {
                        if ((classLoader2 = classLoader) != null) break block3;
                        uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
                        break block4;
                    }
                    if (!(classLoader2 instanceof URLClassLoader)) break block5;
                    URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
                    uRLArray = (URL[])Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.allJars$1(uRLClassLoader.getParent())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
                }
                return uRLArray;
            }
            classLoader = classLoader2.getParent();
        }
    }

    private HiveUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.hiveExecutionVersion = "1.1.0";
        this.HIVE_METASTORE_VERSION = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.metastore.version").doc(new StringBuilder().append((Object)"Version of the Hive metastore. Available options are ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<code>0.12.0</code> through <code>", "</code>."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveExecutionVersion()}))).toString()).stringConf().createWithDefault((Object)this.hiveExecutionVersion());
        this.HIVE_EXECUTION_VERSION = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.version").doc("Version of Hive used internally by Spark SQL.").stringConf().createWithDefault((Object)this.hiveExecutionVersion());
        this.HIVE_METASTORE_JARS = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.metastore.jars").doc(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      | Location of the jars that should be used to instantiate the HiveMetastoreClient.\n      | This property can be one of three options: \"\n      | 1. \"builtin\"\n      |   Use Hive ", ", which is bundled with the Spark assembly when\n      |   <code>-Phive</code> is enabled. When this option is chosen,\n      |   <code>spark.sql.hive.metastore.version</code> must be either\n      |   <code>", "</code> or not defined.\n      | 2. \"maven\"\n      |   Use Hive jars of specified version downloaded from Maven repositories.\n      | 3. A classpath in the standard format for both Hive and Hadoop.\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveExecutionVersion(), this.hiveExecutionVersion()})))).stripMargin()).stringConf().createWithDefault((Object)"builtin");
        this.CONVERT_METASTORE_PARQUET = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.convertMetastoreParquet").doc("When set to false, Spark SQL will use the Hive SerDe for parquet tables instead of the built in support.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.convertMetastoreParquet.mergeSchema").doc("When true, also tries to merge possibly different but compatible Parquet schemas in different Parquet data files. This configuration is only effective when \"spark.sql.hive.convertMetastoreParquet\" is true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.CONVERT_METASTORE_ORC = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.convertMetastoreOrc").internal().doc("When set to false, Spark SQL will use the Hive SerDe for ORC tables instead of the built in support.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_METASTORE_SHARED_PREFIXES = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.metastore.sharedPrefixes").doc("A comma separated list of class prefixes that should be loaded using the classloader that is shared between Spark SQL and a specific version of Hive. An example of classes that should be shared is JDBC drivers that are needed to talk to the metastore. Other classes that need to be shared are those that interact with classes that are already shared. For example, custom appenders that are used by log4j.").stringConf().toSequence().createWithDefault(this.jdbcPrefixes());
        this.HIVE_METASTORE_BARRIER_PREFIXES = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.metastore.barrierPrefixes").doc("A comma separated list of class prefixes that should explicitly be reloaded for each version of Hive that Spark SQL is communicating with. For example, Hive UDFs that are declared in a prefix that typically would be shared (i.e. <code>org.apache.spark.*</code>).").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
        this.HIVE_THRIFT_SERVER_ASYNC = SQLConf.SQLConfigBuilder$.MODULE$.apply("spark.sql.hive.thriftServer.async").doc("When set to true, Hive Thrift server executes SQL queries in an asynchronous way.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$}));
    }
}

