/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;

public final class OrcFileOperator$
implements Logging {
    public static final OrcFileOperator$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OrcFileOperator$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Option<Reader> getFileReader(String basePath, Option<Configuration> config, boolean ignoreCorruptFiles) {
        Configuration conf = (Configuration)config.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
        Path hdfsPath = new Path(basePath);
        FileSystem fs = hdfsPath.getFileSystem(conf);
        return this.listOrcFiles(basePath, conf).iterator().map((Function1)new Serializable(ignoreCorruptFiles, fs){
            public static final long serialVersionUID = 0L;
            private final boolean ignoreCorruptFiles$2;
            private final FileSystem fs$1;

            public final Tuple2<Path, Option<Reader>> apply(Path path) {
                IOException iOException2;
                block3: {
                    Some some;
                    try {
                        some = new Some((Object)OrcFile.createReader((FileSystem)this.fs$1, (Path)path));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        some = None$.MODULE$;
                    }
                    catch (IOException iOException2) {
                        if (!this.ignoreCorruptFiles$2) break block3;
                        OrcFileOperator$.MODULE$.logWarning((Function0<String>)new Serializable(this, path){
                            public static final long serialVersionUID = 0L;
                            private final Path path$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the footer in the corrupted file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                            }
                            {
                                this.path$2 = path$2;
                            }
                        }, iOException2);
                        some = None$.MODULE$;
                    }
                    Some reader = some;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)reader);
                }
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read footer for file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Throwable)iOException2);
            }
            {
                this.ignoreCorruptFiles$2 = ignoreCorruptFiles$2;
                this.fs$1 = fs$1;
            }
        }).collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Path, Option<Reader>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    Reader reader;
                    Path path = (Path)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some && OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path, reader = (Reader)(some = (Some)option).x())) {
                        object = reader;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Path, Option<Reader>> x1) {
                Tuple2<Path, Option<Reader>> tuple2 = x1;
                if (tuple2 == null) return false;
                Path path = (Path)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return false;
                Some some = (Some)option;
                Reader reader = (Reader)some.x();
                if (!OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path, reader)) return false;
                return true;
            }
        });
    }

    public Option<Configuration> getFileReader$default$2() {
        return None$.MODULE$;
    }

    public boolean getFileReader$default$3() {
        return false;
    }

    public Option<StructType> readSchema(Seq<String> paths, Option<Configuration> conf, boolean ignoreCorruptFiles) {
        return paths.toIterator().map((Function1)new Serializable(conf, ignoreCorruptFiles){
            public static final long serialVersionUID = 0L;
            private final Option conf$1;
            private final boolean ignoreCorruptFiles$1;

            public final Option<Reader> apply(String x$1) {
                return OrcFileOperator$.MODULE$.getFileReader(x$1, (Option<Configuration>)this.conf$1, this.ignoreCorruptFiles$1);
            }
            {
                this.conf$1 = conf$1;
                this.ignoreCorruptFiles$1 = ignoreCorruptFiles$1;
            }
        }).collectFirst((PartialFunction)new Serializable(paths){
            public static final long serialVersionUID = 0L;
            public final Seq paths$1;

            public final <A1 extends Option<Reader>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Reader reader = (Reader)some.x();
                    StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
                    String schema = readerInspector.getTypeName();
                    OrcFileOperator$.MODULE$.logDebug((Function0<String>)new Serializable(this, schema){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.readSchema.1 $outer;
                        private final String schema$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading schema from file ", ", got Hive schema string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.paths$1, this.schema$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.schema$1 = schema$1;
                        }
                    });
                    object = (StructType)CatalystSqlParser$.MODULE$.parseDataType(schema);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Reader> x2) {
                Option<Reader> option = x2;
                boolean bl = option instanceof Some;
                return bl;
            }
            {
                this.paths$1 = paths$1;
            }
        });
    }

    public Option<StructObjectInspector> getObjectInspector(String path, Option<Configuration> conf) {
        return this.getFileReader(path, conf, this.getFileReader$default$3()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructObjectInspector apply(Reader x$2) {
                return (StructObjectInspector)x$2.getObjectInspector();
            }
        });
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                return x$3.isDirectory();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$4) {
                return x$4.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$5) {
                return x$5.getName().startsWith("_");
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$6) {
                return x$6.getName().startsWith(".");
            }
        });
        return paths;
    }

    public final boolean org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(Path path, Reader reader) {
        boolean bl;
        StructObjectInspector structObjectInspector;
        ObjectInspector objectInspector = reader.getObjectInspector();
        if (objectInspector instanceof StructObjectInspector && (structObjectInspector = (StructObjectInspector)objectInspector).getAllStructFieldRefs().size() == 0) {
            this.logInfo((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ORC file ", " has empty schema, it probably contains no rows. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}))).append((Object)"Trying to read another ORC file to figure out the schema.").toString();
                }
                {
                    this.path$1 = path$1;
                }
            });
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private OrcFileOperator$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

