/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u001f\t)\")[4ECR\f')\u001a8dQ6\f'o[*vSR,'BA\u0002\u0005\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0006\r\u0005!\u0001.\u001b<f\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0011\u0002*\u001b<f\u0007>l\u0007/\u0019:jg>tG+Z:u\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0012\u0001!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0012!\u0005;fgR$\u0015\r^1ESJ,7\r^8ssV\t1\u0004\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005\u0011\u0011n\u001c\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0003GS2,\u0007B\u0002\u0013\u0001A\u0003%1$\u0001\nuKN$H)\u0019;b\t&\u0014Xm\u0019;pef\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u000ekN,'OV5tSR\u0004\u0016\r\u001e5\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R!aK\u0010\u0002\t1\fgnZ\u0005\u0003[)\u0012aa\u0015;sS:<\u0007BB\u0018\u0001A\u0003%\u0001&\u0001\bvg\u0016\u0014h+[:jiB\u000bG\u000f\u001b\u0011\t\u000fE\u0002!\u0019!C\u0001e\u0005QA/Z:u)\u0006\u0014G.Z:\u0016\u0003M\u00022\u0001N\u001d<\u001b\u0005)$B\u0001\u001c8\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002q\u0005)1oY1mC&\u0011!(\u000e\u0002\u0004'\u0016\f\bC\u0001\u001fV\u001d\ti\u0014K\u0004\u0002?\u001d:\u0011q\b\u0014\b\u0003\u0001.s!!\u0011&\u000f\u0005\tKeBA\"I\u001d\t!u)D\u0001F\u0015\t1e\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA'\u0005\u0003\u0011!Xm\u001d;\n\u0005=\u0003\u0016\u0001\u0003+fgRD\u0015N^3\u000b\u00055#\u0011B\u0001*T\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0013\t!\u0006KA\bUKN$\b*\u001b<f\u0007>tG/\u001a=u\u0013\t1vKA\u0005UKN$H+\u00192mK&\u0011\u0001\f\u0015\u0002\u0015)\u0016\u001cH\u000fS5wKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\ri\u0003\u0001\u0015!\u00034\u0003-!Xm\u001d;UC\ndWm\u001d\u0011")
public class BigDataBenchmarkSuite
extends HiveComparisonTest {
    private final File testDataDirectory = new File(new StringBuilder().append((Object)"target").append((Object)File.separator).append((Object)"big-data-benchmark-testdata").toString());
    private final String userVisitPath = new File(this.testDataDirectory(), "uservisits").getCanonicalPath();
    private final Seq<TestHiveSparkSession.TestTable> testTables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestHiveSparkSession.TestTable[]{new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "rankings", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE EXTERNAL TABLE rankings (\n        |  pageURL STRING,\n        |  pageRank INT,\n        |  avgDuration INT)\n        |  ROW FORMAT DELIMITED FIELDS TERMINATED BY \",\"\n        |  STORED AS TEXTFILE LOCATION \"", "\"\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(this.testDataDirectory(), "rankings").getCanonicalPath()})))).stripMargin()).cmd()})), new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "scratch", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE EXTERNAL TABLE scratch (\n        |  pageURL STRING,\n        |  pageRank INT,\n        |  avgDuration INT)\n        |  ROW FORMAT DELIMITED FIELDS TERMINATED BY \",\"\n        |  STORED AS TEXTFILE LOCATION \"", "\"\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(this.testDataDirectory(), "scratch").getCanonicalPath()})))).stripMargin()).cmd()})), new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "uservisits", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE EXTERNAL TABLE uservisits (\n        |  sourceIP STRING,\n        |  destURL STRING,\n        |  visitDate STRING,\n        |  adRevenue DOUBLE,\n        |  userAgent STRING,\n        |  countryCode STRING,\n        |  languageCode STRING,\n        |  searchWord STRING,\n        |  duration INT)\n        |  ROW FORMAT DELIMITED FIELDS TERMINATED BY \",\"\n        |  STORED AS TEXTFILE LOCATION \"", "\"\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userVisitPath()})))).stripMargin()).cmd()})), new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "documents", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE EXTERNAL TABLE documents (line STRING)\n        |STORED AS TEXTFILE\n        |LOCATION \"", "\"\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(this.testDataDirectory(), "crawl").getCanonicalPath()})))).stripMargin()).cmd()}))}));

    public File testDataDirectory() {
        return this.testDataDirectory;
    }

    public String userVisitPath() {
        return this.userVisitPath;
    }

    public Seq<TestHiveSparkSession.TestTable> testTables() {
        return this.testTables;
    }

    public BigDataBenchmarkSuite() {
        this.testTables().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TestHiveSparkSession.TestTable testTable) {
                TestHive$.MODULE$.sparkSession().registerTestTable(testTable);
            }
        });
        if (this.testDataDirectory().exists()) {
            this.createQueryTest("query1", "SELECT pageURL, pageRank FROM rankings WHERE pageRank > 1", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
            this.createQueryTest("query2", new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUBSTR(sourceIP, 1, 10), SUM(adRevenue) FROM uservisits\n        |GROUP BY SUBSTR(sourceIP, 1, 10)\n      ")).stripMargin(), this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
            this.createQueryTest("query3", new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT sourceIP,\n        |       sum(adRevenue) as totalRevenue,\n        |       avg(pageRank) as pageRank\n        |FROM\n        |  rankings R JOIN\n        |  (SELECT sourceIP, destURL, adRevenue\n        |   FROM uservisits UV\n        |   WHERE UV.visitDate > \"1980-01-01\"\n        |   AND UV.visitDate < \"1980-04-01\")\n        |   NUV ON (R.pageURL = NUV.destURL)\n        |GROUP BY sourceIP\n        |ORDER BY totalRevenue DESC\n        |LIMIT 1\n      ")).stripMargin(), this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
            this.createQueryTest("query4", new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TABLE IF EXISTS url_counts_partial;\n        |CREATE TABLE url_counts_partial AS\n        |  SELECT TRANSFORM (line)\n        |  USING 'python target/url_count.py' as (sourcePage,\n        |    destPage, count) from documents;\n        |DROP TABLE IF EXISTS url_counts_total;\n        |CREATE TABLE url_counts_total AS\n        |  SELECT SUM(count) AS totalCount, destpage\n        |  FROM url_counts_partial GROUP BY destpage\n        |-- The following queries run, but generate different results in HIVE\n        |-- likely because the UDF is not deterministic given different input splits.\n        |-- SELECT CAST(SUM(count) AS INT) FROM url_counts_partial\n        |-- SELECT COUNT(*) FROM url_counts_partial\n        |-- SELECT * FROM url_counts_partial\n        |-- SELECT * FROM url_counts_total\n      ")).stripMargin(), this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        } else {
            this.ignore("No data files found for BigDataBenchmark tests.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                }
            }, new Position("BigDataBenchmarkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }
    }
}

