/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.hive.orc.OrcReadBenchmark$;
import org.apache.spark.sql.hive.orc.OrcReadBenchmark$$anonfun$columnsBenchmark$1$$anonfun$apply$6$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class OrcReadBenchmark$
implements SQLHelper {
    public static final OrcReadBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark;
    private final String NATIVE_ORC_FORMAT;
    private final String HIVE_ORC_FORMAT;

    static {
        new OrcReadBenchmark$();
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.class.withSQLConf((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.class.withTempPath((SQLHelper)this, f);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark() {
        return this.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String viewName) {
                    return OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().catalog().dropTempView(viewName);
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    private String NATIVE_ORC_FORMAT() {
        return this.NATIVE_ORC_FORMAT;
    }

    private String HIVE_ORC_FORMAT() {
        return this.HIVE_ORC_FORMAT;
    }

    public void org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        String dirORC = dir.getCanonicalPath();
        if (partition.isDefined()) {
            df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})).orc(dirORC);
        } else {
            df.write().orc(dirORC);
        }
        this.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().read().format(this.NATIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("nativeOrcTable");
        this.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().read().format(this.HIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("hiveOrcTable");
    }

    public Option<String> org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable$default$3() {
        return None$.MODULE$;
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        Benchmark benchmark = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQL Single ", " Column Scan"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.sql()})), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, dataType, benchmark){
            public static final long serialVersionUID = 0L;
            public final int values$1;
            public final DataType dataType$1;
            public final Benchmark benchmark$1;

            public final void apply(File dir) {
                OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.numericScanBenchmark.1 $outer;
                    private final File dir$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().range((long)this.$outer.values$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$1) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(this.dir$1, (Dataset<Row>)OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT CAST(value as ", ") id FROM t1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.dataType$1.sql()}))), OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$1.addCase("Native ORC MR", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$2) {
                                this.apply$mcVI$sp(x$2);
                            }

                            public void apply$mcVI$sp(int x$2) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(id) FROM nativeOrcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$1.addCase("Native ORC Vectorized", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$3) {
                                this.apply$mcVI$sp(x$3);
                            }

                            public void apply$mcVI$sp(int x$3) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(id) FROM nativeOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$1.addCase("Hive built-in ORC", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$4) {
                                this.apply$mcVI$sp(x$4);
                            }

                            public void apply$mcVI$sp(int x$4) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(id) FROM hiveOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$1.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$1 = dir$1;
                    }
                });
            }
            {
                this.values$1 = values$1;
                this.dataType$1 = dataType$1;
                this.benchmark$1 = benchmark$1;
            }
        });
    }

    public void intStringScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Int and String Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, benchmark){
            public static final long serialVersionUID = 0L;
            public final int values$2;
            public final Benchmark benchmark$2;

            public final void apply(File dir) {
                OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.intStringScanBenchmark.1 $outer;
                    private final File dir$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().range((long)this.$outer.values$2).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$5) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(this.dir$2, (Dataset<Row>)OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$2.addCase("Native ORC MR", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$6) {
                                this.apply$mcVI$sp(x$6);
                            }

                            public void apply$mcVI$sp(int x$6) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$2.addCase("Native ORC Vectorized", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$7) {
                                this.apply$mcVI$sp(x$7);
                            }

                            public void apply$mcVI$sp(int x$7) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$2.addCase("Hive built-in ORC", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$8) {
                                this.apply$mcVI$sp(x$8);
                            }

                            public void apply$mcVI$sp(int x$8) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(c1), sum(length(c2)) FROM hiveOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$2.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$2 = dir$2;
                    }
                });
            }
            {
                this.values$2 = values$2;
                this.benchmark$2 = benchmark$2;
            }
        });
    }

    public void partitionTableScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Partitioned Table", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, benchmark){
            public static final long serialVersionUID = 0L;
            public final int values$3;
            public final Benchmark benchmark$3;

            public final void apply(File dir) {
                OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionTableScanBenchmark.1 $outer;
                    private final File dir$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().range((long)this.$outer.values$3).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$9) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(this.dir$3, (Dataset<Row>)OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                        this.$outer.benchmark$3.addCase("Data column - Native ORC MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$10) {
                                this.apply$mcVI$sp(x$10);
                            }

                            public void apply$mcVI$sp(int x$10) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(id) FROM nativeOrcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - Native ORC Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$11) {
                                this.apply$mcVI$sp(x$11);
                            }

                            public void apply$mcVI$sp(int x$11) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(id) FROM nativeOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - Hive built-in ORC", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$12) {
                                this.apply$mcVI$sp(x$12);
                            }

                            public void apply$mcVI$sp(int x$12) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(id) FROM hiveOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - Native ORC MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$13) {
                                this.apply$mcVI$sp(x$13);
                            }

                            public void apply$mcVI$sp(int x$13) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(p) FROM nativeOrcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - Native ORC Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$14) {
                                this.apply$mcVI$sp(x$14);
                            }

                            public void apply$mcVI$sp(int x$14) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(p) FROM nativeOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - Hive built-in ORC", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$15) {
                                this.apply$mcVI$sp(x$15);
                            }

                            public void apply$mcVI$sp(int x$15) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(p) FROM hiveOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - Native ORC MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$16) {
                                this.apply$mcVI$sp(x$16);
                            }

                            public void apply$mcVI$sp(int x$16) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - Native ORC Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$17) {
                                this.apply$mcVI$sp(x$17);
                            }

                            public void apply$mcVI$sp(int x$17) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - Hive built-in ORC", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$18) {
                                this.apply$mcVI$sp(x$18);
                            }

                            public void apply$mcVI$sp(int x$18) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(p), sum(id) FROM hiveOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$3 = dir$3;
                    }
                });
            }
            {
                this.values$3 = values$3;
                this.benchmark$3 = benchmark$3;
            }
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Repeated String", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, benchmark){
            public static final long serialVersionUID = 0L;
            public final int values$4;
            public final Benchmark benchmark$4;

            public final void apply(File dir) {
                OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.repeatedStringScanBenchmark.1 $outer;
                    private final File dir$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().range((long)this.$outer.values$4).createOrReplaceTempView("t1");
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(this.dir$4, (Dataset<Row>)OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT CAST((id % 200) + 10000 as STRING) AS c1 FROM t1"), OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$4.addCase("Native ORC MR", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$19) {
                                this.apply$mcVI$sp(x$19);
                            }

                            public void apply$mcVI$sp(int x$19) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$4.addCase("Native ORC Vectorized", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$20) {
                                this.apply$mcVI$sp(x$20);
                            }

                            public void apply$mcVI$sp(int x$20) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$4.addCase("Hive built-in ORC", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$21) {
                                this.apply$mcVI$sp(x$21);
                            }

                            public void apply$mcVI$sp(int x$21) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT sum(length(c1)) FROM hiveOrcTable").collect();
                            }
                        });
                        this.$outer.benchmark$4.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$4 = dir$4;
                    }
                });
            }
            {
                this.values$4 = values$4;
                this.benchmark$4 = benchmark$4;
            }
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, fractionOfNulls){
            public static final long serialVersionUID = 0L;
            public final int values$5;
            public final double fractionOfNulls$1;

            public final void apply(File dir) {
                OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stringWithNullsScanBenchmark.1 $outer;
                    private final File dir$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().range((long)this.$outer.values$5).createOrReplaceTempView("t1");
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(this.dir$5, (Dataset<Row>)OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT IF(RAND(1) < ", ", NULL, CAST(id as STRING)) AS c1, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IF(RAND(2) < ", ", NULL, CAST(id as STRING)) AS c2 FROM t1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)}))).toString()), OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable$default$3());
                        Benchmark benchmark = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"String with Nulls Scan (", "%)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)})), (long)this.$outer.values$5, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                        benchmark.addCase("Native ORC MR", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$22) {
                                this.apply$mcVI$sp(x$22);
                            }

                            public void apply$mcVI$sp(int x$22) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect();
                                    }
                                });
                            }
                        });
                        benchmark.addCase("Native ORC Vectorized", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$23) {
                                this.apply$mcVI$sp(x$23);
                            }

                            public void apply$mcVI$sp(int x$23) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect();
                            }
                        });
                        benchmark.addCase("Hive built-in ORC", benchmark.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$24) {
                                this.apply$mcVI$sp(x$24);
                            }

                            public void apply$mcVI$sp(int x$24) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT SUM(LENGTH(c2)) FROM hiveOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect();
                            }
                        });
                        benchmark.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$5 = dir$5;
                    }
                });
            }
            {
                this.values$5 = values$5;
                this.fractionOfNulls$1 = fractionOfNulls$1;
            }
        });
    }

    public void columnsBenchmark(int values, int width) {
        Benchmark benchmark = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Single Column Scan from ", " columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)width)})), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, width, benchmark){
            public static final long serialVersionUID = 0L;
            public final int values$6;
            public final int width$1;
            public final Benchmark benchmark$5;

            public final void apply(File dir) {
                OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.columnsBenchmark.1 $outer;
                    private final File dir$6;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        int middle = this.$outer.width$1 / 2;
                        IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.width$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(int i) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value as c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().range((long)this.$outer.values$6).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$25) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable(this.dir$6, (Dataset<Row>)OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$5.addCase("Native ORC MR", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            public final int middle$1;

                            public final void apply(int x$26) {
                                this.apply$mcVI$sp(x$26);
                            }

                            public void apply$mcVI$sp(int x$26) {
                                OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$columnsBenchmark$1$$anonfun$apply$6$$anonfun$apply$mcV$sp$22 $outer;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM nativeOrcTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.middle$1)}))).collect();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("Native ORC Vectorized", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            private final int middle$1;

                            public final void apply(int x$27) {
                                this.apply$mcVI$sp(x$27);
                            }

                            public void apply$mcVI$sp(int x$27) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM nativeOrcTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.middle$1)}))).collect();
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("Hive built-in ORC", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            private final int middle$1;

                            public final void apply(int x$28) {
                                this.apply$mcVI$sp(x$28);
                            }

                            public void apply$mcVI$sp(int x$28) {
                                OrcReadBenchmark$.MODULE$.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM hiveOrcTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.middle$1)}))).collect();
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$6 = dir$6;
                    }
                });
            }
            {
                this.values$6 = values$6;
                this.width$1 = width$1;
                this.benchmark$5 = benchmark$5;
            }
        });
    }

    public void main(String[] args) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(NumericType dataType) {
                OrcReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            }
        });
        this.intStringScanBenchmark(0xA00000);
        this.partitionTableScanBenchmark(0xF00000);
        this.repeatedStringScanBenchmark(0xA00000);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(double fractionOfNulls) {
                this.apply$mcVD$sp(fractionOfNulls);
            }

            public void apply$mcVD$sp(double fractionOfNulls) {
                OrcReadBenchmark$.MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls);
            }
        });
        this.columnsBenchmark(0x100000, 100);
        this.columnsBenchmark(0x100000, 200);
        this.columnsBenchmark(0x100000, 300);
    }

    private OrcReadBenchmark$() {
        MODULE$ = this;
        SQLHelper.class.$init$((SQLHelper)this);
        this.conf = new SparkConf();
        this.conf().set("orc.compression", "snappy");
        this.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark = SparkSession$.MODULE$.builder().master("local[1]").appName("OrcReadBenchmark").config(this.conf()).getOrCreate();
        this.org$apache$spark$sql$hive$orc$OrcReadBenchmark$$spark().conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        this.NATIVE_ORC_FORMAT = org.apache.spark.sql.execution.datasources.orc.OrcFileFormat.class.getCanonicalName();
        this.HIVE_ORC_FORMAT = OrcFileFormat.class.getCanonicalName();
    }
}

