/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001=\u0011A#T;mi&4\u0018M]5bi\u0016<\u0015-^:tS\u0006t'BA\u0002\u0005\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\t)a!\u0001\u0003ti\u0006$(BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011cF\u0005\u00031I\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u0005[\u0016\fg.F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0004mS:\fGnZ\u0005\u0003Cy\u0011aAV3di>\u0014\bfA\r$SA\u0011AeJ\u0007\u0002K)\u0011a\u0005C\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u0015&\u0005\u0015\u0019\u0016N\\2fC\u0005Q\u0013!\u0002\u001a/a9\u0002\u0004\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000b5,\u0017M\u001c\u0011)\u0007-\u001a\u0013\u0006\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0003\r\u0019wN^\u000b\u0002cA\u0011QDM\u0005\u0003gy\u0011a!T1ue&D\bf\u0001\u0018$S!Aa\u0007\u0001B\u0001B\u0003%\u0011'\u0001\u0003d_Z\u0004\u0003fA\u001b$S!)\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"2aO\u001f@!\ta\u0004!D\u0001\u0003\u0011\u0015Q\u0002\b1\u0001\u001dQ\ri4%\u000b\u0005\u0006_a\u0002\r!\r\u0015\u0004\u007f\rJ\u0003f\u0001\u001d$S!1\u0011\b\u0001C\u0001\r\r#2a\u000f#P\u0011\u0015Q\"\t1\u0001F!\r1%\nT\u0007\u0002\u000f*\u0011q\u0004\u0013\u0006\u0002\u0013\u00061!M]3fu\u0016L!aS$\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\t\u0003#5K!A\u0014\n\u0003\r\u0011{WO\u00197f\u0011\u0015y#\t1\u0001Q!\r1\u0015\u000bT\u0005\u0003%\u001e\u00131\u0002R3og\u0016l\u0015\r\u001e:jq\"AA\u000b\u0001EC\u0002\u0013%Q+\u0001\u0005ce\u0016,'0Z'v+\u0005)\u0005\u0002C,\u0001\u0011\u0003\u0005\u000b\u0015B#\u0002\u0013\t\u0014X-\u001a>f\u001bV\u0004\u0003F\u0001,Z!\t\t\",\u0003\u0002\\%\tIAO]1og&,g\u000e\u001e\u0005\u000b;\u0002\u0001\n\u0011cb!\n\u0013q\u0016a\u0001=%cU\tq\f\u0005\u0003\u0012ABc\u0015BA1\u0013\u0005\u0019!V\u000f\u001d7fe!A1\r\u0001E\u0001B\u0003&q,\u0001\u0003yIE\u0002\u0003\u0002C3\u0001\u0011\u000b\u0007I\u0011\u00024\u0002\u0019I|w\u000e^*jO6\f\u0017J\u001c<\u0016\u0003AC\u0001\u0002\u001b\u0001\t\u0002\u0003\u0006K\u0001U\u0001\u000ee>|GoU5h[\u0006LeN\u001e\u0011)\u0005\u001dL\u0006\u0002C6\u0001\u0011\u000b\u0007I\u0011\u00027\u0002\u0003U,\u0012\u0001\u0014\u0005\t]\u0002A\t\u0011)Q\u0005\u0019\u0006\u0011Q\u000f\t\u0015\u0003[fCQ!\u001d\u0001\u0005\u0002I\f1\u0001\u001d3g)\ta5\u000fC\u0003ua\u0002\u0007A$A\u0001yQ\r\u00018%\u000b\u0005\u0006o\u0002!\t\u0001_\u0001\u0007Y><\u0007\u000f\u001a4\u0015\u00051K\b\"\u0002;w\u0001\u0004a\u0002f\u0001<$S!1\u0011\u000f\u0001C\u0001\rq$\"\u0001T?\t\u000bQ\\\b\u0019\u0001@\u0011\u0007\u0019{H*\u0003\u0002\"\u000f\"9q\u000f\u0001C\u0001\r\u0005\rAc\u0001'\u0002\u0006!1A/!\u0001A\u0002yDa!!\u0003\u0001\t\u0013q\u0016\u0001H2bY\u000e,H.\u0019;f\u0007>4\u0018M]5b]\u000e,7i\u001c8ti\u0006tGo\u001d\u0015\u0004\u0001\u00055\u0001c\u0001\u0013\u0002\u0010%\u0019\u0011\u0011C\u0013\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5)\u0007\u0001\u0019\u0013\u0006")
public class MultivariateGaussian
implements Serializable {
    private final Vector mean;
    private final Matrix cov;
    private transient DenseVector<Object> breezeMu;
    private Tuple2<DenseMatrix<Object>, Object> x$1;
    private transient DenseMatrix<Object> rootSigmaInv;
    private transient double u;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    private DenseVector breezeMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.breezeMu = this.mean().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.breezeMu;
        }
    }

    private Tuple2 x$1$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            Tuple2<DenseMatrix<Object>, Object> tuple2;
            block5: {
                if (!this.bitmap$0) {
                    Tuple2 tuple22;
                    tuple2 = this.calculateCovarianceConstants();
                    if (tuple2 == null) break block5;
                    DenseMatrix rootSigmaInv = (DenseMatrix)tuple2._1();
                    double u = tuple2._2$mcD$sp();
                    if (rootSigmaInv == null) break block5;
                    DenseMatrix denseMatrix = rootSigmaInv;
                    double d = u;
                    this.x$1 = tuple22 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
                    this.bitmap$0 = true;
                }
                return this.x$1;
            }
            throw new MatchError(tuple2);
        }
    }

    private DenseMatrix rootSigmaInv$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rootSigmaInv = (DenseMatrix)this.x$1()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.rootSigmaInv;
        }
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.u = this.x$1()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.u;
        }
    }

    public Vector mean() {
        return this.mean;
    }

    public Matrix cov() {
        return this.cov;
    }

    private DenseVector<Object> breezeMu() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.breezeMu$lzycompute() : this.breezeMu;
    }

    private /* synthetic */ Tuple2 x$1() {
        return this.bitmap$0 ? this.x$1 : this.x$1$lzycompute();
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rootSigmaInv$lzycompute() : this.rootSigmaInv;
    }

    private double u() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.u$lzycompute() : this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.cov().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) throw new MatchError((Object)eigSym2);
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)d, (Object)u);
        DenseVector d2 = (DenseVector)tuple22._1();
        DenseMatrix u2 = (DenseMatrix)tuple22._2();
        double tol = Utils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)new Serializable(this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$1;

                public final boolean apply(double x$3) {
                    return this.apply$mcZD$sp(x$3);
                }

                public boolean apply$mcZD$sp(double x$3) {
                    return x$3 > this.tol$1;
                }
                {
                    this.tol$1 = tol$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.log(x);
                }
            }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)new Serializable(this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$1;

                public final double apply(double v) {
                    return this.apply$mcDD$sp(v);
                }

                public double apply$mcDD$sp(double v) {
                    return v > this.tol$1 ? package$.MODULE$.sqrt(1.0 / v) : 0.0;
                }
                {
                    this.tol$1 = tol$1;
                }
            }, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            return new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mean().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
    }

    public MultivariateGaussian(Vector mean, Matrix cov) {
        this.mean = mean;
        this.cov = cov;
        Predef$.MODULE$.require(cov.numCols() == cov.numRows(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Covariance matrix must be square";
            }
        });
        Predef$.MODULE$.require(mean.size() == cov.numCols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Mean vector length must match covariance matrix size";
            }
        });
    }

    public MultivariateGaussian(DenseVector<Object> mean, DenseMatrix<Object> cov) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mean), Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)cov));
    }
}

