/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.ann;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.storage.Zero;
import org.apache.spark.ml.ann.AffineLayer;
import org.apache.spark.ml.ann.AffineLayerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;

public final class AffineLayerModel$
implements Serializable {
    public static final AffineLayerModel$ MODULE$;

    static {
        new AffineLayerModel$();
    }

    public AffineLayerModel apply(AffineLayer layer, Vector weights2, int position) {
        Tuple2<DenseMatrix<Object>, DenseVector<Object>> tuple2 = this.unroll(weights2, position, layer.numIn(), layer.numOut());
        if (tuple2 != null) {
            Tuple2 tuple22;
            DenseMatrix w2 = (DenseMatrix)tuple2._1();
            DenseVector b = (DenseVector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)w2, (Object)b);
            DenseMatrix w3 = (DenseMatrix)tuple23._1();
            DenseVector b2 = (DenseVector)tuple23._2();
            return new AffineLayerModel((DenseMatrix<Object>)w3, (DenseVector<Object>)b2);
        }
        throw new MatchError(tuple2);
    }

    public AffineLayerModel apply(AffineLayer layer, long seed) {
        Tuple2<DenseMatrix<Object>, DenseVector<Object>> tuple2 = this.randomWeights(layer.numIn(), layer.numOut(), seed);
        if (tuple2 != null) {
            Tuple2 tuple22;
            DenseMatrix w2 = (DenseMatrix)tuple2._1();
            DenseVector b = (DenseVector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)w2, (Object)b);
            DenseMatrix w3 = (DenseMatrix)tuple23._1();
            DenseVector b2 = (DenseVector)tuple23._2();
            return new AffineLayerModel((DenseMatrix<Object>)w3, (DenseVector<Object>)b2);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<DenseMatrix<Object>, DenseVector<Object>> unroll(Vector weights2, int position, int numIn, int numOut) {
        double[] weightsCopy = weights2.toArray();
        DenseMatrix.mcD.sp a = new DenseMatrix.mcD.sp(numOut, numIn, weightsCopy, position);
        DenseVector.mcD.sp b = new DenseVector.mcD.sp(weightsCopy, position + numOut * numIn, 1, numOut);
        return new Tuple2((Object)a, (Object)b);
    }

    public Vector roll(DenseMatrix<Object> a, DenseVector<Object> b) {
        double[] result = new double[a.size() + b.length()];
        System.arraycopy(a.toArray$mcD$sp(), 0, result, 0, a.size());
        System.arraycopy(b.toArray$mcD$sp(ClassTag$.MODULE$.Double()), 0, result, a.size(), b.length());
        return Vectors$.MODULE$.dense(result);
    }

    public Tuple2<DenseMatrix<Object>, DenseVector<Object>> randomWeights(int numIn, int numOut, long seed) {
        XORShiftRandom rand2 = new XORShiftRandom(seed);
        DenseMatrix weights2 = (DenseMatrix)DenseMatrix$.MODULE$.fill$mDc$sp(numOut, numIn, (Function0)new Serializable(numIn, rand2){
            public static final long serialVersionUID = 0L;
            private final int numIn$1;
            private final XORShiftRandom rand$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return (this.rand$1.nextDouble() * 4.8 - 2.4) / (double)this.numIn$1;
            }
            {
                this.numIn$1 = numIn$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        DenseVector bias = (DenseVector)DenseVector$.MODULE$.fill(numOut, (Function0)new Serializable(numIn, rand2){
            public static final long serialVersionUID = 0L;
            private final int numIn$1;
            private final XORShiftRandom rand$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return (this.rand$1.nextDouble() * 4.8 - 2.4) / (double)this.numIn$1;
            }
            {
                this.numIn$1 = numIn$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.Double());
        return new Tuple2((Object)weights2, (Object)bias);
    }

    public long randomWeights$default$3() {
        return 11L;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AffineLayerModel$() {
        MODULE$ = this;
    }
}

