/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001=\u0011A#T;mi&4\u0018M]5bi\u0016<\u0015-^:tS\u0006t'BA\u0002\u0005\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\t)a!\u0001\u0003ti\u0006$(BA\u0004\t\u0003\u0015iG\u000e\\5c\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u0012/%\u0011\u0001D\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t5\u0001\u0011)\u0019!C\u00017\u0005\u0011Q.^\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\u0011qDB\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0005r\"A\u0002,fGR|'\u000fK\u0002\u001aG%\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002)K\t)1+\u001b8dK\u0006\n!&A\u00032]Mr\u0003\u0007\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\riW\u000f\t\u0015\u0004W\rJ\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u000bMLw-\\1\u0016\u0003E\u0002\"!\b\u001a\n\u0005Mr\"AB'biJL\u0007\u0010K\u0002/G%B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0007g&<W.\u0019\u0011)\u0007U\u001a\u0013\u0006C\u0003:\u0001\u0011\u0005!(\u0001\u0004=S:LGO\u0010\u000b\u0004wuz\u0004C\u0001\u001f\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e9\u0001\u0004a\u0002fA\u001f$S!)q\u0006\u000fa\u0001c!\u001aqhI\u0015)\u0007a\u001a\u0013\u0006\u0003\u0005D\u0001!\u0015\r\u0011\"\u0003E\u0003!\u0011'/Z3{K6+X#A#\u0011\u0007\u0019SE*D\u0001H\u0015\ty\u0002JC\u0001J\u0003\u0019\u0011'/Z3{K&\u00111j\u0012\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0002\u0012\u001b&\u0011aJ\u0005\u0002\u0007\t>,(\r\\3\t\u0011A\u0003\u0001\u0012!Q!\n\u0015\u000b\u0011B\u0019:fKj,W*\u001e\u0011)\u0005=\u0013\u0006CA\tT\u0013\t!&CA\u0005ue\u0006t7/[3oi\"1\u0011\b\u0001C\u0001\rY#2aO,Y\u0011\u0015QR\u000b1\u0001F\u0011\u0015yS\u000b1\u0001Z!\r1%\fT\u0005\u00037\u001e\u00131\u0002R3og\u0016l\u0015\r\u001e:jq\"QQ\f\u0001I\u0001\u0012\u000f\u0007K\u0011\u00020\u0002\u0007a$\u0013'F\u0001`!\u0011\t\u0002-\u0017'\n\u0005\u0005\u0014\"A\u0002+va2,'\u0007\u0003\u0005d\u0001!\u0005\t\u0015)\u0003`\u0003\u0011AH%\r\u0011\t\u0011\u0015\u0004\u0001R1A\u0005\n\u0019\fAB]8piNKw-\\1J]Z,\u0012!\u0017\u0005\tQ\u0002A\t\u0011)Q\u00053\u0006i!o\\8u'&<W.Y%om\u0002B#a\u001a*\t\u0011-\u0004\u0001R1A\u0005\n1\f\u0011!^\u000b\u0002\u0019\"Aa\u000e\u0001E\u0001B\u0003&A*\u0001\u0002vA!\u0012QN\u0015\u0005\u0006c\u0002!\tA]\u0001\u0004a\u00124GC\u0001't\u0011\u0015!\b\u000f1\u0001\u001d\u0003\u0005A\bf\u00019$S!)q\u000f\u0001C\u0001q\u00061An\\4qI\u001a$\"\u0001T=\t\u000bQ4\b\u0019\u0001\u000f)\u0007Y\u001c\u0013\u0006\u0003\u0004r\u0001\u0011\u0005a\u0001 \u000b\u0003\u0019vDQ\u0001^>A\u0002y\u00042AR@M\u0013\t\ts\tC\u0004x\u0001\u0011\u0005a!a\u0001\u0015\u00071\u000b)\u0001\u0003\u0004u\u0003\u0003\u0001\rA \u0005\u0007\u0003\u0013\u0001A\u0011\u00020\u00029\r\fGnY;mCR,7i\u001c<be&\fgnY3D_:\u001cH/\u00198ug\"\u001a\u0001!!\u0004\u0011\u0007\u0011\ny!C\u0002\u0002\u0012\u0015\u0012A\u0002R3wK2|\u0007/\u001a:Ba&D3\u0001A\u0012*\u0001")
public class MultivariateGaussian
implements Serializable {
    private final Vector mu;
    private final org.apache.spark.mllib.linalg.Matrix sigma;
    private transient DenseVector<Object> breezeMu;
    private Tuple2<DenseMatrix<Object>, Object> x$1;
    private transient DenseMatrix<Object> rootSigmaInv;
    private transient double u;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    private DenseVector breezeMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.breezeMu = this.mu().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.breezeMu;
        }
    }

    private Tuple2 x$1$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            Tuple2<DenseMatrix<Object>, Object> tuple2;
            block5: {
                if (!this.bitmap$0) {
                    Tuple2 tuple22;
                    tuple2 = this.calculateCovarianceConstants();
                    if (tuple2 == null) break block5;
                    DenseMatrix rootSigmaInv = (DenseMatrix)tuple2._1();
                    double u = tuple2._2$mcD$sp();
                    if (rootSigmaInv == null) break block5;
                    DenseMatrix denseMatrix = rootSigmaInv;
                    double d = u;
                    this.x$1 = tuple22 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
                    this.bitmap$0 = true;
                }
                return this.x$1;
            }
            throw new MatchError(tuple2);
        }
    }

    private DenseMatrix rootSigmaInv$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rootSigmaInv = (DenseMatrix)this.x$1()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.rootSigmaInv;
        }
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.u = this.x$1()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.u;
        }
    }

    public Vector mu() {
        return this.mu;
    }

    public org.apache.spark.mllib.linalg.Matrix sigma() {
        return this.sigma;
    }

    private DenseVector<Object> breezeMu() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.breezeMu$lzycompute() : this.breezeMu;
    }

    private /* synthetic */ Tuple2 x$1() {
        return this.bitmap$0 ? this.x$1 : this.x$1$lzycompute();
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rootSigmaInv$lzycompute() : this.rootSigmaInv;
    }

    private double u() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.u$lzycompute() : this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.sigma().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) throw new MatchError((Object)eigSym2);
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)d, (Object)u);
        DenseVector d2 = (DenseVector)tuple22._1();
        DenseMatrix u2 = (DenseMatrix)tuple22._2();
        double tol = MLUtils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)new Serializable(this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$1;

                public final boolean apply(double x$3) {
                    return this.apply$mcZD$sp(x$3);
                }

                public boolean apply$mcZD$sp(double x$3) {
                    return x$3 > this.tol$1;
                }
                {
                    this.tol$1 = tol$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.log(x);
                }
            }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)new Serializable(this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$1;

                public final double apply(double v) {
                    return this.apply$mcDD$sp(v);
                }

                public double apply$mcDD$sp(double v) {
                    return v > this.tol$1 ? package$.MODULE$.sqrt(1.0 / v) : 0.0;
                }
                {
                    this.tol$1 = tol$1;
                }
            }, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            return new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mu().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
    }

    public MultivariateGaussian(Vector mu2, org.apache.spark.mllib.linalg.Matrix sigma2) {
        this.mu = mu2;
        this.sigma = sigma2;
        Predef$.MODULE$.require(sigma2.numCols() == sigma2.numRows(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Covariance matrix must be square";
            }
        });
        Predef$.MODULE$.require(mu2.size() == sigma2.numCols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Mean vector length must match covariance matrix size";
            }
        });
    }

    public MultivariateGaussian(DenseVector<Object> mu2, DenseMatrix<Object> sigma2) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu2), Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma2));
    }
}

