/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport;
import org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport;
import org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.spark_project.dmg.pmml.regression.RegressionModel;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class PMMLModelExportFactory$ {
    public static final PMMLModelExportFactory$ MODULE$;

    static {
        new PMMLModelExportFactory$();
    }

    public PMMLModelExport createPMMLModelExport(Object model) {
        block8: {
            block9: {
                PMMLModelExport pMMLModelExport;
                block3: {
                    Object object;
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        object = model;
                                        if (!(object instanceof KMeansModel)) break block2;
                                        KMeansModel kMeansModel = (KMeansModel)object;
                                        pMMLModelExport = new KMeansPMMLModelExport(kMeansModel);
                                        break block3;
                                    }
                                    if (!(object instanceof LinearRegressionModel)) break block4;
                                    LinearRegressionModel linearRegressionModel = (LinearRegressionModel)object;
                                    pMMLModelExport = new GeneralizedLinearPMMLModelExport(linearRegressionModel, "linear regression");
                                    break block3;
                                }
                                if (!(object instanceof RidgeRegressionModel)) break block5;
                                RidgeRegressionModel ridgeRegressionModel = (RidgeRegressionModel)object;
                                pMMLModelExport = new GeneralizedLinearPMMLModelExport(ridgeRegressionModel, "ridge regression");
                                break block3;
                            }
                            if (!(object instanceof LassoModel)) break block6;
                            LassoModel lassoModel = (LassoModel)object;
                            pMMLModelExport = new GeneralizedLinearPMMLModelExport(lassoModel, "lasso regression");
                            break block3;
                        }
                        if (!(object instanceof SVMModel)) break block7;
                        SVMModel sVMModel = (SVMModel)object;
                        pMMLModelExport = new BinaryClassificationPMMLModelExport(sVMModel, "linear SVM", RegressionModel.NormalizationMethod.NONE, BoxesRunTime.unboxToDouble((Object)sVMModel.getThreshold().getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        })));
                        break block3;
                    }
                    if (!(object instanceof LogisticRegressionModel)) break block8;
                    LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)object;
                    if (logisticRegressionModel.numClasses() != 2) break block9;
                    pMMLModelExport = new BinaryClassificationPMMLModelExport(logisticRegressionModel, "logistic regression", RegressionModel.NormalizationMethod.LOGIT, BoxesRunTime.unboxToDouble((Object)logisticRegressionModel.getThreshold().getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.5;
                        }
                    })));
                }
                return pMMLModelExport;
            }
            throw new IllegalArgumentException("PMML Export not supported for Multinomial Logistic Regression");
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"PMML Export not supported for model: ").append((Object)model.getClass().getName()).toString());
    }

    private PMMLModelExportFactory$() {
        MODULE$ = this;
    }
}

