/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml.support_vector_machine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.LocalTransformations;
import org.spark_project.dmg.pmml.MathContext;
import org.spark_project.dmg.pmml.MiningFunction;
import org.spark_project.dmg.pmml.MiningSchema;
import org.spark_project.dmg.pmml.Model;
import org.spark_project.dmg.pmml.ModelExplanation;
import org.spark_project.dmg.pmml.ModelStats;
import org.spark_project.dmg.pmml.ModelVerification;
import org.spark_project.dmg.pmml.Output;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.StringValue;
import org.spark_project.dmg.pmml.Targets;
import org.spark_project.dmg.pmml.Version;
import org.spark_project.dmg.pmml.Visitable;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.support_vector_machine.Kernel;
import org.spark_project.dmg.pmml.support_vector_machine.LinearKernel;
import org.spark_project.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.spark_project.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.spark_project.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.spark_project.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.spark_project.dmg.pmml.support_vector_machine.VectorDictionary;
import org.spark_project.jpmml.model.annotations.Added;
import org.spark_project.jpmml.model.annotations.Property;
import org.spark_project.jpmml.model.annotations.Removed;
import org.spark_project.jpmml.model.annotations.Required;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "kernel", "vectorDictionary", "supportVectorMachines", "modelVerification"})
@XmlRootElement(name="SupportVectorMachineModel", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "threshold", "representation", "alternateBinaryTargetCategory", "classificationMethod", "maxWins", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "kernel", "vectorDictionary", "supportVectorMachines", "modelVerification"})
public class SupportVectorMachineModel
extends Model
implements HasExtensions<SupportVectorMachineModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="threshold")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="threshold")
    private Double threshold;
    @XmlAttribute(name="svmRepresentation")
    @JsonProperty(value="svmRepresentation")
    private Representation representation;
    @XmlAttribute(name="alternateBinaryTargetCategory")
    @Added(value=Version.PMML_3_1)
    @Removed(value=Version.PMML_4_0)
    @JsonProperty(value="alternateBinaryTargetCategory")
    private String alternateBinaryTargetCategory;
    @XmlAttribute(name="classificationMethod")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="classificationMethod")
    private ClassificationMethod classificationMethod;
    @XmlAttribute(name="maxWins")
    @Added(value=Version.PMML_4_3)
    @JsonProperty(value="maxWins")
    private Boolean maxWins;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @org.spark_project.jpmml.model.annotations.Extension
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements(value={@XmlElement(name="LinearKernelType", namespace="http://www.dmg.org/PMML-4_3", type=LinearKernel.class), @XmlElement(name="PolynomialKernelType", namespace="http://www.dmg.org/PMML-4_3", type=PolynomialKernel.class), @XmlElement(name="RadialBasisKernelType", namespace="http://www.dmg.org/PMML-4_3", type=RadialBasisKernel.class), @XmlElement(name="SigmoidKernelType", namespace="http://www.dmg.org/PMML-4_3", type=SigmoidKernel.class)})
    @JsonProperty(value="Kernel")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="LinearKernel", value=LinearKernel.class), @JsonSubTypes.Type(name="PolynomialKernel", value=PolynomialKernel.class), @JsonSubTypes.Type(name="RadialBasisKernel", value=RadialBasisKernel.class), @JsonSubTypes.Type(name="SigmoidKernel", value=SigmoidKernel.class)})
    private Kernel kernel;
    @XmlElement(name="VectorDictionary", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @Required(value=Version.PMML_3_1)
    @JsonProperty(value="VectorDictionary")
    private VectorDictionary vectorDictionary;
    @XmlElement(name="SupportVectorMachine", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="SupportVectorMachine")
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Double DEFAULT_THRESHOLD = 0.0;
    private static final Boolean DEFAULT_MAX_WINS = false;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67305485L;

    public SupportVectorMachineModel() {
    }

    public SupportVectorMachineModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="vectorDictionary") VectorDictionary vectorDictionary, @Property(value="supportVectorMachines") List<SupportVectorMachine> supportVectorMachines) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public SupportVectorMachineModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public SupportVectorMachineModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public SupportVectorMachineModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Double getThreshold() {
        if (this.threshold == null) {
            return DEFAULT_THRESHOLD;
        }
        return this.threshold;
    }

    public SupportVectorMachineModel setThreshold(@Property(value="threshold") Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Representation getRepresentation() {
        if (this.representation == null) {
            return Representation.SUPPORT_VECTORS;
        }
        return this.representation;
    }

    public SupportVectorMachineModel setRepresentation(@Property(value="representation") Representation representation) {
        this.representation = representation;
        return this;
    }

    public String getAlternateBinaryTargetCategory() {
        return this.alternateBinaryTargetCategory;
    }

    public SupportVectorMachineModel setAlternateBinaryTargetCategory(@Property(value="alternateBinaryTargetCategory") String alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    public ClassificationMethod getClassificationMethod() {
        if (this.classificationMethod == null) {
            return ClassificationMethod.ONE_AGAINST_ALL;
        }
        return this.classificationMethod;
    }

    public SupportVectorMachineModel setClassificationMethod(@Property(value="classificationMethod") ClassificationMethod classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    public boolean isMaxWins() {
        if (this.maxWins == null) {
            return DEFAULT_MAX_WINS;
        }
        return this.maxWins;
    }

    public SupportVectorMachineModel setMaxWins(@Property(value="maxWins") Boolean maxWins) {
        this.maxWins = maxWins;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public SupportVectorMachineModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public SupportVectorMachineModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SupportVectorMachineModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public SupportVectorMachineModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public SupportVectorMachineModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public SupportVectorMachineModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public SupportVectorMachineModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public SupportVectorMachineModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public SupportVectorMachineModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public SupportVectorMachineModel setKernel(@Property(value="kernel") Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    public VectorDictionary getVectorDictionary() {
        return this.vectorDictionary;
    }

    public SupportVectorMachineModel setVectorDictionary(@Property(value="vectorDictionary") VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return this.supportVectorMachines != null && this.supportVectorMachines.size() > 0;
    }

    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (this.supportVectorMachines == null) {
            this.supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine ... supportVectorMachines) {
        this.getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public SupportVectorMachineModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getKernel(), this.getVectorDictionary());
            }
            if (status == VisitorAction.CONTINUE && this.hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, this.getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Representation implements StringValue<Representation>
    {
        SUPPORT_VECTORS("SupportVectors"),
        COEFFICIENTS("Coefficients");

        private final String value;

        private Representation(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Representation fromValue(String v) {
            for (Representation c : Representation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ClassificationMethod implements StringValue<ClassificationMethod>
    {
        ONE_AGAINST_ALL("OneAgainstAll"),
        ONE_AGAINST_ONE("OneAgainstOne");

        private final String value;

        private ClassificationMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ClassificationMethod fromValue(String v) {
            for (ClassificationMethod c : ClassificationMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

