/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model.visitors;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.spark_project.dmg.pmml.DataDictionary;
import org.spark_project.dmg.pmml.DataField;
import org.spark_project.dmg.pmml.Field;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.MiningField;
import org.spark_project.dmg.pmml.MiningSchema;
import org.spark_project.dmg.pmml.Model;
import org.spark_project.dmg.pmml.PMML;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitable;
import org.spark_project.jpmml.model.visitors.FieldDependencyResolver;
import org.spark_project.jpmml.model.visitors.FieldUtil;
import org.spark_project.jpmml.model.visitors.ModelCleaner;

public class DataDictionaryCleaner
extends ModelCleaner {
    private Set<Field<?>> targetFields = new HashSet();

    @Override
    public void applyTo(Visitable visitable) {
        this.targetFields.clear();
        super.applyTo(visitable);
    }

    @Override
    public PMMLObject popParent() {
        PMML pmml;
        DataDictionary dataDictionary;
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        } else if (parent instanceof PMML && (dataDictionary = (pmml = (PMML)parent).getDataDictionary()) != null) {
            this.processDataDictionary(dataDictionary);
        }
        return parent;
    }

    private void processModel(Model model) {
        Set<Field<?>> targetFields = this.getTargetFields();
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema != null && miningSchema.hasMiningFields()) {
            LinkedHashSet<FieldName> targetFieldNames = new LinkedHashSet<FieldName>();
            List<MiningField> miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case TARGET: 
                    case PREDICTED: {
                        targetFieldNames.add(name);
                        break;
                    }
                }
            }
            if (targetFieldNames.size() > 0) {
                Set<Field<?>> modelFields = this.getFields(model);
                targetFields.addAll(FieldUtil.selectAll(modelFields, targetFieldNames));
            }
        }
    }

    private void processDataDictionary(DataDictionary dataDictionary) {
        if (dataDictionary.hasDataFields()) {
            List<DataField> dataFields = dataDictionary.getDataFields();
            Set<DataField> usedDataFields = this.getUsedDataFields();
            dataFields.retainAll(usedDataFields);
        }
    }

    private Set<DataField> getUsedDataFields() {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        HashSet usedFields = new HashSet(this.getActiveFields());
        usedFields.addAll(this.getTargetFields());
        fieldDependencyResolver.expand(usedFields, fieldDependencyResolver.getLocalDerivedFields());
        fieldDependencyResolver.expand(usedFields, fieldDependencyResolver.getGlobalDerivedFields());
        return usedFields;
    }

    public Set<Field<?>> getTargetFields() {
        return this.targetFields;
    }
}

