/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model.visitors;

import org.spark_project.dmg.pmml.MathContext;
import org.spark_project.dmg.pmml.MiningFunction;
import org.spark_project.dmg.pmml.Visitable;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.tree.DecisionTree;
import org.spark_project.dmg.pmml.tree.Node;
import org.spark_project.dmg.pmml.tree.TreeModel;
import org.spark_project.jpmml.model.visitors.AbstractVisitor;

public class NodeScoreParser
extends AbstractVisitor {
    private MathContext mathContext = null;

    @Override
    public void applyTo(Visitable visitable) {
        this.mathContext = null;
        super.applyTo(visitable);
    }

    @Override
    public VisitorAction visit(DecisionTree decisionTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(TreeModel treeModel) {
        MiningFunction miningFunction = treeModel.getMiningFunction();
        if (miningFunction != null) {
            switch (miningFunction) {
                case REGRESSION: {
                    this.mathContext = treeModel.getMathContext();
                    break;
                }
                default: {
                    this.mathContext = null;
                }
            }
        }
        if (this.mathContext == null) {
            return VisitorAction.SKIP;
        }
        return super.visit(treeModel);
    }

    @Override
    public VisitorAction visit(Node node) {
        Object score;
        MathContext mathContext = this.mathContext;
        if (mathContext != null && node.hasScore() && (score = node.getScore()) instanceof String) {
            String stringScore = (String)score;
            try {
                switch (mathContext) {
                    case DOUBLE: {
                        node.setScore(Double.parseDouble(stringScore));
                        break;
                    }
                    case FLOAT: {
                        node.setScore(Float.valueOf(Float.parseFloat(stringScore)));
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.visit(node);
    }
}

