/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import org.apache.spark.SparkContext$;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.FitEnd;
import org.apache.spark.ml.FitStart;
import org.apache.spark.ml.LoadInstanceEnd;
import org.apache.spark.ml.LoadInstanceStart;
import org.apache.spark.ml.MLEvent;
import org.apache.spark.ml.MLEvents;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.SaveInstanceEnd;
import org.apache.spark.ml.SaveInstanceStart;
import org.apache.spark.ml.TransformEnd;
import org.apache.spark.ml.TransformStart;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.Dataset;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public abstract class MLEvents$class {
    private static LiveListenerBus listenerBus(MLEvents $this) {
        return SparkContext$.MODULE$.getOrCreate().listenerBus();
    }

    public static void logEvent(MLEvents $this, MLEvent event) {
        $this.logDebug((Function0)new Serializable($this, event){
            public static final long serialVersionUID = 0L;
            private final MLEvent event$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending an MLEvent: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.event$1}));
            }
            {
                this.event$1 = event$1;
            }
        });
    }

    public static Model withFitEvent(MLEvents $this, Estimator estimator, Dataset dataset, Function0 func) {
        FitStart startEvent = new FitStart(estimator, dataset);
        $this.logEvent(startEvent);
        MLEvents$class.listenerBus($this).post(startEvent);
        Model model = (Model)func.apply();
        FitEnd<Model> endEvent = new FitEnd<Model>(estimator, model);
        $this.logEvent(endEvent);
        MLEvents$class.listenerBus($this).post(endEvent);
        return model;
    }

    public static Dataset withTransformEvent(MLEvents $this, Transformer transformer, Dataset input, Function0 func) {
        TransformStart startEvent = new TransformStart(transformer, input);
        $this.logEvent(startEvent);
        MLEvents$class.listenerBus($this).post((SparkListenerEvent)startEvent);
        Dataset output = (Dataset)func.apply();
        TransformEnd endEvent = new TransformEnd(transformer, output);
        $this.logEvent(endEvent);
        MLEvents$class.listenerBus($this).post((SparkListenerEvent)endEvent);
        return output;
    }

    public static Object withLoadInstanceEvent(MLEvents $this, MLReader reader, String path, Function0 func) {
        LoadInstanceStart startEvent = new LoadInstanceStart(reader, path);
        $this.logEvent(startEvent);
        MLEvents$class.listenerBus($this).post(startEvent);
        Object instance = func.apply();
        LoadInstanceEnd<Object> endEvent = new LoadInstanceEnd<Object>(reader, instance);
        $this.logEvent(endEvent);
        MLEvents$class.listenerBus($this).post(endEvent);
        return instance;
    }

    public static void withSaveInstanceEvent(MLEvents $this, MLWriter writer, String path, Function0 func) {
        MLEvents$class.listenerBus($this).post((SparkListenerEvent)new SaveInstanceEnd(writer, path));
        SaveInstanceStart startEvent = new SaveInstanceStart(writer, path);
        $this.logEvent(startEvent);
        MLEvents$class.listenerBus($this).post((SparkListenerEvent)startEvent);
        func.apply$mcV$sp();
        SaveInstanceEnd endEvent = new SaveInstanceEnd(writer, path);
        $this.logEvent(endEvent);
        MLEvents$class.listenerBus($this).post((SparkListenerEvent)endEvent);
    }

    public static void $init$(MLEvents $this) {
    }
}

