/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport$class;
import org.spark_project.dmg.pmml.Array;
import org.spark_project.dmg.pmml.CompareFunction;
import org.spark_project.dmg.pmml.ComparisonMeasure;
import org.spark_project.dmg.pmml.DataDictionary;
import org.spark_project.dmg.pmml.DataField;
import org.spark_project.dmg.pmml.DataType;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.MiningField;
import org.spark_project.dmg.pmml.MiningFunction;
import org.spark_project.dmg.pmml.MiningSchema;
import org.spark_project.dmg.pmml.OpType;
import org.spark_project.dmg.pmml.PMML;
import org.spark_project.dmg.pmml.SquaredEuclidean;
import org.spark_project.dmg.pmml.clustering.Cluster;
import org.spark_project.dmg.pmml.clustering.ClusteringField;
import org.spark_project.dmg.pmml.clustering.ClusteringModel;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000192Q!\u0001\u0002\u0001\r9\u0011QcS'fC:\u001c\b+T'M\u001b>$W\r\\#ya>\u0014HO\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\tAlW\u000e\u001c\u0006\u0003\u000f!\tQ!\u001c7mS\nT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\t!!\u0003\u0002\u0019\u0005\ty\u0001+T'M\u001b>$W\r\\#ya>\u0014H\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015iw\u000eZ3m\u0007\u0001\u0001\"!\b\u0011\u000e\u0003yQ!a\b\u0004\u0002\u0015\rdWo\u001d;fe&tw-\u0003\u0002\"=\tY1*T3b]Nlu\u000eZ3m\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\u0011QE\n\t\u0003-\u0001AQA\u0007\u0012A\u0002qAQ\u0001\u000b\u0001\u0005\n%\n!\u0003]8qk2\fG/Z&NK\u0006t7\u000fU'N\u0019R\u0011!&\f\t\u0003!-J!\u0001L\t\u0003\tUs\u0017\u000e\u001e\u0005\u00065\u001d\u0002\r\u0001\b")
public class KMeansPMMLModelExport
implements PMMLModelExport {
    private final PMML pmml;

    @Override
    public PMML pmml() {
        return this.pmml;
    }

    @Override
    public void org$apache$spark$mllib$pmml$export$PMMLModelExport$_setter_$pmml_$eq(PMML x$1) {
        this.pmml = x$1;
    }

    @Override
    public PMML getPmml() {
        return PMMLModelExport$class.getPmml(this);
    }

    private void populateKMeansPMML(KMeansModel model) {
        this.pmml().getHeader().setDescription("k-means clustering");
        if (model.clusterCenters().length > 0) {
            Vector clusterCenter = model.clusterCenters()[0];
            FieldName[] fields = new FieldName[clusterCenter.size()];
            DataDictionary dataDictionary = new DataDictionary();
            MiningSchema miningSchema = new MiningSchema();
            ComparisonMeasure comparisonMeasure = new ComparisonMeasure().setKind(ComparisonMeasure.Kind.DISTANCE).setMeasure(new SquaredEuclidean());
            ClusteringModel clusteringModel = new ClusteringModel().setModelName("k-means").setMiningSchema(miningSchema).setComparisonMeasure(comparisonMeasure).setMiningFunction(MiningFunction.CLUSTERING).setModelClass(ClusteringModel.ModelClass.CENTER_BASED).setNumberOfClusters(model.clusterCenters().length);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), clusterCenter.size()).foreach((Function1)new Serializable(this, fields, dataDictionary, miningSchema, clusteringModel){
                public static final long serialVersionUID = 0L;
                private final FieldName[] fields$1;
                private final DataDictionary dataDictionary$1;
                private final MiningSchema miningSchema$1;
                private final ClusteringModel clusteringModel$1;

                public final ClusteringModel apply(int i) {
                    this.fields$1[i] = FieldName.create(new StringBuilder().append((Object)"field_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                    this.dataDictionary$1.addDataFields(new DataField(this.fields$1[i], OpType.CONTINUOUS, DataType.DOUBLE));
                    this.miningSchema$1.addMiningFields(new MiningField(this.fields$1[i]).setUsageType(MiningField.UsageType.ACTIVE));
                    return this.clusteringModel$1.addClusteringFields(new ClusteringField(this.fields$1[i]).setCompareFunction(CompareFunction.ABS_DIFF));
                }
                {
                    this.fields$1 = fields$1;
                    this.dataDictionary$1 = dataDictionary$1;
                    this.miningSchema$1 = miningSchema$1;
                    this.clusteringModel$1 = clusteringModel$1;
                }
            });
            dataDictionary.setNumberOfFields(Predef$.MODULE$.int2Integer(dataDictionary.getDataFields().size()));
            Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).indices().foreach((Function1)new Serializable(this, model, clusterCenter, clusteringModel){
                public static final long serialVersionUID = 0L;
                private final KMeansModel model$1;
                private final Vector clusterCenter$1;
                private final ClusteringModel clusteringModel$1;

                public final ClusteringModel apply(int i) {
                    Cluster cluster = new Cluster().setName(new StringBuilder().append((Object)"cluster_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString()).setArray(new Array().setType(Array.Type.REAL).setN(Predef$.MODULE$.int2Integer(this.clusterCenter$1.size())).setValue(Predef$.MODULE$.doubleArrayOps(this.model$1.clusterCenters()[i].toArray()).mkString(" ")));
                    return this.clusteringModel$1.addClusters(cluster);
                }
                {
                    this.model$1 = model$1;
                    this.clusterCenter$1 = clusterCenter$1;
                    this.clusteringModel$1 = clusteringModel$1;
                }
            });
            this.pmml().setDataDictionary(dataDictionary);
            this.pmml().addModels(clusteringModel);
        }
    }

    public KMeansPMMLModelExport(KMeansModel model) {
        PMMLModelExport$class.$init$(this);
        this.populateKMeansPMML(model);
    }
}

