/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model.filters;

import org.spark_project.dmg.pmml.Version;
import org.spark_project.jpmml.model.filters.PMMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class ImportFilter
extends PMMLFilter {
    private boolean extensions = true;

    public ImportFilter() {
        this(true);
    }

    public ImportFilter(boolean extensions) {
        super(Version.PMML_4_3);
        this.setExtensions(extensions);
    }

    public ImportFilter(XMLReader reader) {
        this(reader, true);
    }

    public ImportFilter(XMLReader reader, boolean extensions) {
        super(reader, Version.PMML_4_3);
        this.setExtensions(extensions);
    }

    @Override
    public String filterLocalName(String localName) {
        if ("Trend".equals(localName) && ImportFilter.compare(this.getSource(), Version.PMML_4_0) == 0) {
            return "Trend_ExpoSmooth";
        }
        return localName;
    }

    @Override
    public Attributes filterAttributes(String localName, Attributes attributes) {
        if ("Apply".equals(localName) && ImportFilter.compare(this.getSource(), Version.PMML_4_1) == 0) {
            return ImportFilter.renameAttribute(attributes, "mapMissingTo", "defaultValue");
        }
        if ("PMML".equals(localName)) {
            Version target = this.getTarget();
            if (this.getExtensions()) {
                attributes = ImportFilter.renameAttribute(attributes, "version", "x-baseVersion");
            }
            return ImportFilter.setAttribute(attributes, "version", target.getVersion());
        }
        if ("TargetValue".equals(localName) && ImportFilter.compare(this.getSource(), Version.PMML_3_1) <= 0) {
            return ImportFilter.renameAttribute(attributes, "rawDataValue", "displayValue");
        }
        return attributes;
    }

    public boolean getExtensions() {
        return this.extensions;
    }

    private void setExtensions(boolean extensions) {
        this.extensions = extensions;
    }
}

