/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitable;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.tree.Node;
import org.spark_project.jpmml.model.visitors.AbstractVisitor;

public class TreePathFinder
extends AbstractVisitor {
    private Map<Node, List<Node>> paths = new HashMap<Node, List<Node>>();

    @Override
    public void applyTo(Visitable visitable) {
        this.paths.clear();
        super.applyTo(visitable);
    }

    @Override
    public VisitorAction visit(Node node) {
        if (!node.hasNodes()) {
            this.process(node);
        }
        return super.visit(node);
    }

    private void process(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        path.add(node);
        Deque<PMMLObject> parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (!(parent instanceof Node)) break;
            path.add((Node)parent);
        }
        Collections.reverse(path);
        this.paths.put(node, path);
    }

    public Map<Node, List<Node>> getPaths() {
        return this.paths;
    }
}

