/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool$CachedFetchedData$;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g!\u0002!B\u0001\u0005k\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dD\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\u0011\t\u0006\u0001Q\u0001\nuD\u0011Ba\u0015\u0001\u0005\u0004%I!!\u001e\t\u0011\tU\u0003\u0001)A\u0005\u0003oB\u0011Ba\u0016\u0001\u0005\u0004%I!!\u001e\t\u0011\te\u0003\u0001)A\u0005\u0003oBqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0005\u0003z\u0001\u0001\r\u0011\"\u0003\u0003|!I!Q\u0010\u0001A\u0002\u0013%!q\u0010\u0005\t\u0005\u0007\u0003\u0001\u0015)\u0003\u0003`!I!Q\u0011\u0001C\u0002\u0013%!q\u0011\u0005\t\u0005+\u0003\u0001\u0015!\u0003\u0003\n\"I!q\u0013\u0001C\u0002\u0013%!q\u0011\u0005\t\u00053\u0003\u0001\u0015!\u0003\u0003\n\"9!1\u0014\u0001\u0005\u0002\u0005U\u0004b\u0002BO\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0005?\u0003A\u0011\u0001BQ\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005[CqA!-\u0001\t\u0003\u0011\u0019\fC\u0004\u0003:\u0002!\tAa/\t\u000f\tu\u0006\u0001\"\u0001\u0003<\"9!q\u0018\u0001\u0005\n\tmv\u0001CA\u001e\u0003\"\u0005\u0011)!\u0010\u0007\u000f\u0001\u000b\u0005\u0012A!\u0002@!1\u0011/\bC\u0001\u0003\u00032q!a\u0011\u001e\u0001\u0006\u000b)\u0005\u0003\u0006\u0002`}\u0011)\u001a!C\u0001\u0003CB!\"!\u001b \u0005#\u0005\u000b\u0011BA2\u0011\u0019\tx\u0004\"\u0001\u0002l!I\u00111O\u0010A\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003{z\u0002\u0019!C\u0001\u0003\u007fB\u0001\"a# A\u0003&\u0011q\u000f\u0005\n\u0003\u001b{\u0002\u0019!C\u0001\u0003kB\u0011\"a$ \u0001\u0004%\t!!%\t\u0011\u0005Uu\u0004)Q\u0005\u0003oB\u0011\"a& \u0001\u0004%\t!!'\t\u0013\u0005\u0005v\u00041A\u0005\u0002\u0005\r\u0006\u0002CAT?\u0001\u0006K!a'\t\u000f\u0005%v\u0004\"\u0001\u0002b!I\u00111V\u0010\u0002\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003c{\u0012\u0013!C\u0001\u0003gC\u0011\"!3 \u0003\u0003%\t%a3\t\u0013\u0005ew$!A\u0005\u0002\u0005m\u0007\"CAr?\u0005\u0005I\u0011AAs\u0011%\tyoHA\u0001\n\u0003\n\t\u0010C\u0005\u0002|~\t\t\u0011\"\u0001\u0002~\"I!\u0011A\u0010\u0002\u0002\u0013\u0005#1\u0001\u0005\n\u0005\u000fy\u0012\u0011!C!\u0005\u0013A\u0011Ba\u0003 \u0003\u0003%\tE!\u0004\t\u0013\t=q$!A\u0005B\tEqa\u0002B\u000b;!%!q\u0003\u0004\b\u0003\u0007j\u0002\u0012\u0002B\r\u0011\u0019\t\u0018\b\"\u0001\u0003&!9!qE\u001d\u0005\u0002\t%\u0002\"\u0003B\u0016s\u0005\u0005I\u0011\u0011B\u0017\u0011%\u0011\t$OA\u0001\n\u0003\u0013\u0019\u0004C\u0005\u0003@e\n\t\u0011\"\u0003\u0003B\u00159!\u0011J\u000f\u0001\u0003\n-#a\u0004$fi\u000eDW\r\u001a#bi\u0006\u0004vn\u001c7\u000b\u0005\t\u001b\u0015\u0001C2p]N,X.\u001a:\u000b\u0005\u0011+\u0015\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u0019;\u0015aA:rY*\u0011\u0001*S\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015.\u000ba!\u00199bG\",'\"\u0001'\u0002\u0007=\u0014xmE\u0002\u0001\u001dR\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+Y\u001b\u00051&BA,H\u0003!Ig\u000e^3s]\u0006d\u0017BA-W\u0005\u001daunZ4j]\u001e\fq\"\u001a=fGV$xN]*feZL7-Z\u0002\u0001!\tiF-D\u0001_\u0015\ty\u0006-\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u00192\u0002\tU$\u0018\u000e\u001c\u0006\u0002G\u0006!!.\u0019<b\u0013\t)gL\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fQa\u00197pG.\u0004\"\u0001\u001b6\u000e\u0003%T!!Y$\n\u0005-L'!B\"m_\u000e\\\u0017\u0001B2p]\u001a\u0004\"A\\8\u000e\u0003\u001dK!\u0001]$\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0003tkZ<\bC\u0001;\u0001\u001b\u0005\t\u0005\"\u0002.\u0005\u0001\u0004a\u0006\"\u00024\u0005\u0001\u00049\u0007\"\u00027\u0005\u0001\u0004iGCA:z\u0011\u0015QX\u00011\u0001n\u0003%\u0019\b/\u0019:l\u0007>tg-A\u0003dC\u000eDW-F\u0001~!\u001dq\u0018qAA\u0006\u0003oi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0015\u0001+\u0001\u0006d_2dWm\u0019;j_:L1!!\u0003\u0000\u0005\ri\u0015\r\u001d\t\u0005\u0003\u001b\t\tD\u0004\u0003\u0002\u0010\u00055b\u0002BA\t\u0003WqA!a\u0005\u0002*9!\u0011QCA\u0014\u001d\u0011\t9\"!\n\u000f\t\u0005e\u00111\u0005\b\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD.\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015B\u0001&L\u0013\tA\u0015*\u0003\u0002G\u000f&\u0011A)R\u0005\u0003\u0005\u000eK1!a\fB\u0003EY\u0015MZ6b\t\u0006$\u0018mQ8ogVlWM]\u0005\u0005\u0003g\t)D\u0001\u0005DC\u000eDWmS3z\u0015\r\ty#\u0011\t\u0004\u0003sydB\u0001;\u001d\u0003=1U\r^2iK\u0012$\u0015\r^1Q_>d\u0007C\u0001;\u001e'\tib\n\u0006\u0002\u0002>\t\t2)Y2iK\u00124U\r^2iK\u0012$\u0015\r^1\u0014\r}q\u0015qIA'!\ry\u0015\u0011J\u0005\u0004\u0003\u0017\u0002&a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u001f\nIF\u0004\u0003\u0002R\u0005Uc\u0002BA\u000e\u0003'J\u0011!U\u0005\u0004\u0003/\u0002\u0016a\u00029bG.\fw-Z\u0005\u0005\u00037\niF\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002XA\u000b1BZ3uG\",G\rR1uCV\u0011\u00111\r\t\u0004i\u0006\u0015\u0014bAA4\u0003\nYa)\u001a;dQ\u0016$G)\u0019;b\u000311W\r^2iK\u0012$\u0015\r^1!)\u0011\ti'!\u001d\u0011\u0007\u0005=t$D\u0001\u001e\u0011\u001d\tyF\ta\u0001\u0003G\nQ\u0003\\1tiJ+G.Z1tK\u0012$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002xA\u0019q*!\u001f\n\u0007\u0005m\u0004K\u0001\u0003M_:<\u0017!\u00077bgR\u0014V\r\\3bg\u0016$G+[7fgR\fW\u000e]0%KF$B!!!\u0002\bB\u0019q*a!\n\u0007\u0005\u0015\u0005K\u0001\u0003V]&$\b\"CAEI\u0005\u0005\t\u0019AA<\u0003\rAH%M\u0001\u0017Y\u0006\u001cHOU3mK\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7qA\u0005)B.Y:u\u0003\u000e\fX/\u001b:fIRKW.Z:uC6\u0004\u0018!\u00077bgR\f5-];je\u0016$G+[7fgR\fW\u000e]0%KF$B!!!\u0002\u0014\"I\u0011\u0011R\u0014\u0002\u0002\u0003\u0007\u0011qO\u0001\u0017Y\u0006\u001cH/Q2rk&\u0014X\r\u001a+j[\u0016\u001cH/Y7qA\u0005)\u0011N\\+tKV\u0011\u00111\u0014\t\u0004\u001f\u0006u\u0015bAAP!\n9!i\\8mK\u0006t\u0017!C5o+N,w\fJ3r)\u0011\t\t)!*\t\u0013\u0005%%&!AA\u0002\u0005m\u0015AB5o+N,\u0007%A\u0005hKR|%M[3di\u0006!1m\u001c9z)\u0011\ti'a,\t\u0013\u0005}S\u0006%AA\u0002\u0005\r\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kSC!a\u0019\u00028.\u0012\u0011\u0011\u0018\t\u0005\u0003w\u000b)-\u0004\u0002\u0002>*!\u0011qXAa\u0003%)hn\u00195fG.,GMC\u0002\u0002DB\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9-!0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'\u0014\u0017\u0001\u00027b]\u001eLA!a6\u0002R\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!8\u0011\u0007=\u000by.C\u0002\u0002bB\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a:\u0002nB\u0019q*!;\n\u0007\u0005-\bKA\u0002B]fD\u0011\"!#2\u0003\u0003\u0005\r!!8\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a=\u0011\r\u0005U\u0018q_At\u001b\t\t\u0019!\u0003\u0003\u0002z\u0006\r!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a'\u0002\u0000\"I\u0011\u0011R\u001a\u0002\u0002\u0003\u0007\u0011q]\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002N\n\u0015\u0001\"CAEi\u0005\u0005\t\u0019AAo\u0003!A\u0017m\u001d5D_\u0012,GCAAo\u0003!!xn\u0015;sS:<GCAAg\u0003\u0019)\u0017/^1mgR!\u00111\u0014B\n\u0011%\tIiNA\u0001\u0002\u0004\t9/A\tDC\u000eDW\r\u001a$fi\u000eDW\r\u001a#bi\u0006\u00042!a\u001c:'\u0011IdJa\u0007\u0011\t\tu!1E\u0007\u0003\u0005?Q1A!\tc\u0003\tIw.\u0003\u0003\u0002\\\t}AC\u0001B\f\u0003\u0015)W\u000e\u001d;z)\t\ti'A\u0003baBd\u0017\u0010\u0006\u0003\u0002n\t=\u0002bBA0y\u0001\u0007\u00111M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)Da\u000f\u0011\u000b=\u00139$a\u0019\n\u0007\te\u0002K\u0001\u0004PaRLwN\u001c\u0005\n\u0005{i\u0014\u0011!a\u0001\u0003[\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u0005\u0005\u0003\u0002P\n\u0015\u0013\u0002\u0002B$\u0003#\u0014aa\u00142kK\u000e$(!F\"bG\",GMR3uG\",G\rR1uC2K7\u000f\u001e\t\u0006}\n5\u0013QN\u0005\u0004\u0005\u001fz(A\u0003'jgR\u0014UO\u001a4fe\u000611-Y2iK\u0002\n!$\\5o\u000bZL7\r^1cY\u0016LE\r\\3US6,W*\u001b7mSN\f1$\\5o\u000bZL7\r^1cY\u0016LE\r\\3US6,W*\u001b7mSN\u0004\u0013AH3wS\u000e$xN\u001d+ie\u0016\fGMU;o\u0013:$XM\u001d<bY6KG\u000e\\5t\u0003})g/[2u_J$\u0006N]3bIJ+h.\u00138uKJ4\u0018\r\\'jY2L7\u000fI\u0001\u0013gR\f'\u000f^#wS\u000e$xN\u001d+ie\u0016\fG\r\u0006\u0002\u0003`A)qJa\u000e\u0003bA\"!1\rB7!\u0015i&Q\rB5\u0013\r\u00119G\u0018\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB!!1\u000eB7\u0019\u0001!1Ba\u001c\r\u0003\u0003\u0005\tQ!\u0001\u0003r\t\u0019q\fJ\u0019\u0012\t\tM\u0014q\u001d\t\u0004\u001f\nU\u0014b\u0001B<!\n9aj\u001c;iS:<\u0017!C:dQ\u0016$W\u000f\\3e+\t\u0011y&A\u0007tG\",G-\u001e7fI~#S-\u001d\u000b\u0005\u0003\u0003\u0013\t\tC\u0005\u0002\n:\t\t\u00111\u0001\u0003`\u0005Q1o\u00195fIVdW\r\u001a\u0011\u0002+9,Xn\u0011:fCR,GMR3uG\",G\rR1uCV\u0011!\u0011\u0012\t\u0005\u0005\u0017\u0013\t*\u0004\u0002\u0003\u000e*\u0019!q\u00120\u0002\r\u0005$x.\\5d\u0013\u0011\u0011\u0019J!$\u0003\u00131{gnZ!eI\u0016\u0014\u0018A\u00068v[\u000e\u0013X-\u0019;fI\u001a+Go\u00195fI\u0012\u000bG/\u0019\u0011\u0002!9,X\u000eV8uC2,E.Z7f]R\u001c\u0018!\u00058v[R{G/\u00197FY\u0016lWM\u001c;tA\u0005Qa.^7De\u0016\fG/\u001a3\u0002\u00119,X\u000eV8uC2\fq!Y2rk&\u0014X\r\u0006\u0004\u0002d\t\r&q\u0015\u0005\b\u0005K3\u0002\u0019AA\u0006\u0003\rYW-\u001f\u0005\b\u0005S3\u0002\u0019AA<\u0003I!Wm]5sK\u0012\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0002\u0015%tg/\u00197jI\u0006$X\r\u0006\u0003\u0002\u0002\n=\u0006b\u0002BS/\u0001\u0007\u00111B\u0001\be\u0016dW-Y:f)\u0019\t\tI!.\u00038\"9!Q\u0015\rA\u0002\u0005-\u0001bBA01\u0001\u0007\u00111M\u0001\tg\",H\u000fZ8x]R\u0011\u0011\u0011Q\u0001\u0006e\u0016\u001cX\r^\u0001\u0016e\u0016lwN^3JI2,g)\u001a;dQ\u0016$G)\u0019;b\u0001")
public class FetchedDataPool
implements Logging {
    private final ScheduledExecutorService executorService;
    private final Clock clock;
    private final Map<KafkaDataConsumer.CacheKey, ListBuffer<CachedFetchedData>> cache;
    private final long minEvictableIdleTimeMillis;
    private final long evictorThreadRunIntervalMillis;
    private Option<ScheduledFuture<?>> scheduled;
    private final LongAdder numCreatedFetchedData;
    private final LongAdder numTotalElements;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<KafkaDataConsumer.CacheKey, ListBuffer<CachedFetchedData>> cache() {
        return this.cache;
    }

    private long minEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    private long evictorThreadRunIntervalMillis() {
        return this.evictorThreadRunIntervalMillis;
    }

    private Option<ScheduledFuture<?>> startEvictorThread() {
        None$ none$;
        if (this.evictorThreadRunIntervalMillis() > 0L) {
            ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(() -> Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> this.removeIdleFetchedData()), 0L, this.evictorThreadRunIntervalMillis(), TimeUnit.MILLISECONDS);
            none$ = new Some(future);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<ScheduledFuture<?>> scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(Option<ScheduledFuture<?>> x$1) {
        this.scheduled = x$1;
    }

    private LongAdder numCreatedFetchedData() {
        return this.numCreatedFetchedData;
    }

    private LongAdder numTotalElements() {
        return this.numTotalElements;
    }

    public long numCreated() {
        return this.numCreatedFetchedData().sum();
    }

    public long numTotal() {
        return this.numTotalElements().sum();
    }

    public synchronized FetchedData acquire(KafkaDataConsumer.CacheKey key, long desiredStartOffset) {
        ListBuffer fetchedDataList = (ListBuffer)this.cache().getOrElseUpdate((Object)key, (Function0 & Serializable)() -> new ListBuffer());
        Option cachedFetchedDataOption = fetchedDataList.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$acquire$2(desiredStartOffset, p)));
        CachedFetchedData cachedFetchedData = null;
        if (cachedFetchedDataOption.isDefined()) {
            cachedFetchedData = (CachedFetchedData)cachedFetchedDataOption.get();
        } else {
            cachedFetchedData = FetchedDataPool$CachedFetchedData$.MODULE$.empty();
            fetchedDataList.$plus$eq((Object)cachedFetchedData);
            this.numCreatedFetchedData().increment();
            this.numTotalElements().increment();
        }
        cachedFetchedData.lastAcquiredTimestamp_$eq(this.clock.getTimeMillis());
        cachedFetchedData.inUse_$eq(true);
        return cachedFetchedData.getObject();
    }

    public synchronized void invalidate(KafkaDataConsumer.CacheKey key) {
        Option option = this.cache().remove((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            ListBuffer lst = (ListBuffer)some.value();
            this.numTotalElements().add(-1 * lst.size());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public synchronized void release(KafkaDataConsumer.CacheKey key, FetchedData fetchedData) {
        Option option = this.cache().get((Object)key);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ListBuffer fetchedDataList = (ListBuffer)some.value();
            Option cachedFetchedDataOption = fetchedDataList.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$release$2(fetchedData, p)));
            if (cachedFetchedDataOption.isEmpty()) {
                this.warnReleasedDataNotInPool$1(key, fetchedData);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                CachedFetchedData cachedFetchedData = (CachedFetchedData)cachedFetchedDataOption.get();
                cachedFetchedData.inUse_$eq(false);
                cachedFetchedData.lastReleasedTimestamp_$eq(this.clock.getTimeMillis());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.warnReleasedDataNotInPool$1(key, fetchedData);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void shutdown() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.executorService, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public synchronized void reset() {
        this.scheduled().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cancel(true)));
        this.cache().clear();
        this.numTotalElements().reset();
        this.numCreatedFetchedData().reset();
        this.scheduled_$eq(this.startEvictorThread());
    }

    private synchronized void removeIdleFetchedData() {
        long now = this.clock.getTimeMillis();
        long maxAllowedReleasedTimestamp = now - this.minEvictableIdleTimeMillis();
        this.cache().values().foreach((Function1 & Serializable)p -> {
            FetchedDataPool.$anonfun$removeIdleFetchedData$1(this, maxAllowedReleasedTimestamp, p);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$acquire$2(long desiredStartOffset$1, CachedFetchedData p) {
        return !p.inUse() && p.getObject().nextOffsetInFetchedData() == desiredStartOffset$1;
    }

    private final void warnReleasedDataNotInPool$1(KafkaDataConsumer.CacheKey key, FetchedData fetchedData) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append(new StringBuilder(39).append("No matching data in pool for ").append(fetchedData).append(" in key ").append(key).append(". ").toString()).append("It might be released before, or it was not a part of pool.").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$release$2(FetchedData fetchedData$2, CachedFetchedData p) {
        if (!p.inUse()) return false;
        FetchedData fetchedData = p.getObject();
        FetchedData fetchedData2 = fetchedData$2;
        if (fetchedData != null) {
            if (!((Object)fetchedData).equals(fetchedData2)) return false;
            return true;
        }
        if (fetchedData2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeIdleFetchedData$2(long maxAllowedReleasedTimestamp$1, CachedFetchedData q) {
        return !q.inUse() && q.lastReleasedTimestamp() < maxAllowedReleasedTimestamp$1;
    }

    public static final /* synthetic */ void $anonfun$removeIdleFetchedData$1(FetchedDataPool $this, long maxAllowedReleasedTimestamp$1, ListBuffer p) {
        ListBuffer expired = (ListBuffer)p.filter((Function1 & Serializable)q -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$removeIdleFetchedData$2(maxAllowedReleasedTimestamp$1, q)));
        p.$minus$minus$eq((IterableOnce)expired);
        $this.numTotalElements().add(-1 * expired.size());
    }

    public FetchedDataPool(ScheduledExecutorService executorService, Clock clock, SparkConf conf) {
        this.executorService = executorService;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.cache = HashMap$.MODULE$.empty();
        this.minEvictableIdleTimeMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.FETCHED_DATA_CACHE_TIMEOUT()));
        this.evictorThreadRunIntervalMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.FETCHED_DATA_CACHE_EVICTOR_THREAD_RUN_INTERVAL()));
        this.scheduled = this.startEvictorThread();
        this.numCreatedFetchedData = new LongAdder();
        this.numTotalElements = new LongAdder();
    }

    public FetchedDataPool(SparkConf sparkConf) {
        this(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kafka-fetched-data-cache-evictor"), (Clock)new SystemClock(), sparkConf);
    }

    public static class CachedFetchedData
    implements Product,
    Serializable {
        private final FetchedData fetchedData;
        private long lastReleasedTimestamp;
        private long lastAcquiredTimestamp;
        private boolean inUse;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public FetchedData fetchedData() {
            return this.fetchedData;
        }

        public long lastReleasedTimestamp() {
            return this.lastReleasedTimestamp;
        }

        public void lastReleasedTimestamp_$eq(long x$1) {
            this.lastReleasedTimestamp = x$1;
        }

        public long lastAcquiredTimestamp() {
            return this.lastAcquiredTimestamp;
        }

        public void lastAcquiredTimestamp_$eq(long x$1) {
            this.lastAcquiredTimestamp = x$1;
        }

        public boolean inUse() {
            return this.inUse;
        }

        public void inUse_$eq(boolean x$1) {
            this.inUse = x$1;
        }

        public FetchedData getObject() {
            return this.fetchedData();
        }

        public CachedFetchedData copy(FetchedData fetchedData) {
            return new CachedFetchedData(fetchedData);
        }

        public FetchedData copy$default$1() {
            return this.fetchedData();
        }

        public String productPrefix() {
            return "CachedFetchedData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.fetchedData();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CachedFetchedData;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "fetchedData";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CachedFetchedData)) return false;
            boolean bl = true;
            if (!bl) return false;
            CachedFetchedData cachedFetchedData = (CachedFetchedData)x$1;
            FetchedData fetchedData = this.fetchedData();
            FetchedData fetchedData2 = cachedFetchedData.fetchedData();
            if (fetchedData == null) {
                if (fetchedData2 != null) {
                    return false;
                }
            } else if (!((Object)fetchedData).equals(fetchedData2)) return false;
            if (!cachedFetchedData.canEqual(this)) return false;
            return true;
        }

        public CachedFetchedData(FetchedData fetchedData) {
            this.fetchedData = fetchedData;
            Product.$init$((Product)this);
            this.lastReleasedTimestamp = Long.MAX_VALUE;
            this.lastAcquiredTimestamp = Long.MIN_VALUE;
            this.inUse = false;
        }
    }
}

