/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.deploy.SparkHadoopUtil;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.compat.RowGroupFilter;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ConfigurationUtil;
import parquet.schema.MessageType;

public abstract class SpecificParquetRecordReaderBase<T>
extends RecordReader<Void, T> {
    protected Path file;
    protected MessageType fileSchema;
    protected MessageType requestedSchema;
    protected ReadSupport<T> readSupport;
    protected long totalRowCount;
    protected ParquetFileReader reader;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        ArrayList<BlockMetaData> blocks;
        MessageType fileSchema;
        ParquetMetadata footer;
        Configuration configuration = SparkHadoopUtil.get().getConfigurationFromJobContext((JobContext)taskAttemptContext);
        ParquetInputSplit split = (ParquetInputSplit)inputSplit;
        this.file = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        if (rowGroupOffsets == null) {
            footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)split.getStart(), (long)split.getEnd()));
            fileSchema = footer.getFileMetaData().getSchema();
            FilterCompat.Filter filter2 = ParquetInputFormat.getFilter((Configuration)configuration);
            blocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter2, (List)footer.getBlocks(), (MessageType)fileSchema);
        } else {
            footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            HashSet<Long> offsets = new HashSet<Long>();
            for (long offset : rowGroupOffsets) {
                offsets.add(offset);
            }
            blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : footer.getBlocks()) {
                if (!offsets.contains(block.getStartingPos())) continue;
                blocks.add(block);
            }
            if (blocks.size() != rowGroupOffsets.length) {
                long[] foundRowGroupOffsets = new long[footer.getBlocks().size()];
                for (int i = 0; i < foundRowGroupOffsets.length; ++i) {
                    foundRowGroupOffsets[i] = ((BlockMetaData)footer.getBlocks().get(i)).getStartingPos();
                }
                throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks + " out of: " + Arrays.toString(foundRowGroupOffsets) + " in range " + split.getStart() + ", " + split.getEnd());
            }
        }
        fileSchema = footer.getFileMetaData().getSchema();
        Map fileMetadata = footer.getFileMetaData().getKeyValueMetaData();
        this.readSupport = SpecificParquetRecordReaderBase.getReadSupportInstance(SpecificParquetRecordReaderBase.getReadSupportClass(configuration));
        ReadSupport.ReadContext readContext = this.readSupport.init(new InitContext(configuration, SpecificParquetRecordReaderBase.toSetMultiMap(fileMetadata), fileSchema));
        this.requestedSchema = readContext.getRequestedSchema();
        this.fileSchema = fileSchema;
        this.reader = new ParquetFileReader(configuration, this.file, blocks, this.requestedSchema.getColumns());
        for (BlockMetaData block : blocks) {
            this.totalRowCount += block.getRowCount();
        }
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    protected static IntIterator createRLEIterator(int maxLevel, BytesInput bytes, ColumnDescriptor descriptor) throws IOException {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new IOException("could not read levels in page for col " + descriptor, e);
        }
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map2) {
        HashMap setMultiMap = new HashMap();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            HashSet<V> set2 = new HashSet<V>();
            set2.add(entry.getValue());
            setMultiMap.put(entry.getKey(), Collections.unmodifiableSet(set2));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }

    private static Class<?> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig((Configuration)configuration, (String)"parquet.read.support.class", ReadSupport.class);
    }

    private static <T> ReadSupport<T> getReadSupportInstance(Class<? extends ReadSupport<T>> readSupportClass) {
        try {
            return readSupportClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate read support class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate read support class", (Throwable)e);
        }
    }

    protected static final class NullIntIterator
    extends IntIterator {
        protected NullIntIterator() {
        }

        @Override
        int nextInt() throws IOException {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    extends IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() throws IOException {
            return this.delegate.readInt();
        }
    }

    protected static final class ValuesReaderIntIterator
    extends IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() throws IOException {
            return this.delegate.readInteger();
        }
    }

    static abstract class IntIterator {
        IntIterator() {
        }

        abstract int nextInt() throws IOException;
    }
}

