/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetOutputCommitter;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005f\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0002\u0001\u00131q\u0011\u0003\u0006\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011!BR5mK\u001a{'/\\1u!\ti\u0002%D\u0001\u001f\u0015\ty\u0002\"A\u0004t_V\u00148-Z:\n\u0005\u0005r\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0006\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oOB\u00111#K\u0005\u0003UQ\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000bE\u0002A\u0011\t\u001a\u0002\u0013MDwN\u001d;OC6,G#A\u001a\u0011\u0005Q:dBA\n6\u0013\t1D#\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c\u0015\u0011\u0015Y\u0004\u0001\"\u00113\u0003!!xn\u0015;sS:<\u0007\"B\u001f\u0001\t\u0003r\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003}\u0002\"a\u0005!\n\u0005\u0005#\"aA%oi\")1\t\u0001C!\t\u00061Q-];bYN$\"!\u0012%\u0011\u0005M1\u0015BA$\u0015\u0005\u001d\u0011un\u001c7fC:DQ!\u0013\"A\u0002)\u000bQa\u001c;iKJ\u0004\"aE&\n\u00051#\"aA!os\")a\n\u0001C!\u001f\u0006a\u0001O]3qCJ,wK]5uKR)\u0001kU-dQB\u0011\u0011$U\u0005\u0003%\u0012\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQ\u0001V'A\u0002U\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"AV,\u000e\u0003!I!\u0001\u0017\u0005\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bik\u0005\u0019A.\u0002\u0007)|'\r\u0005\u0002]C6\tQL\u0003\u0002_?\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003A2\ta\u0001[1e_>\u0004\u0018B\u00012^\u0005\rQuN\u0019\u0005\u0006I6\u0003\r!Z\u0001\b_B$\u0018n\u001c8t!\u0011!dmM\u001a\n\u0005\u001dL$aA'ba\")\u0011.\u0014a\u0001U\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005-tW\"\u00017\u000b\u00055D\u0011!\u0002;za\u0016\u001c\u0018BA8m\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006c\u0002!\tA]\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003tm^L\bcA\nuU&\u0011Q\u000f\u0006\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bQ\u0003\b\u0019A+\t\u000ba\u0004\b\u0019A3\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fC\u0003{a\u0002\u000710A\u0003gS2,7\u000fE\u0003}\u0003\u0013\tyAD\u0002~\u0003\u000bq1A`A\u0002\u001b\u0005y(bAA\u0001!\u00051AH]8pizJ\u0011!F\u0005\u0004\u0003\u000f!\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\tiAA\u0002TKFT1!a\u0002\u0015!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b?\u0006\u0011am]\u0005\u0005\u00033\t\u0019B\u0001\u0006GS2,7\u000b^1ukN4a!!\b\u0001\u0001\u0006}!!\u0003$jY\u0016$\u0016\u0010]3t'\u0019\tYBEA\u0011QA\u00191#a\t\n\u0007\u0005\u0015BCA\u0004Qe>$Wo\u0019;\t\u0017\u0005%\u00121\u0004BK\u0002\u0013\u0005\u00111F\u0001\u0005I\u0006$\u0018-F\u0001|\u0011)\ty#a\u0007\u0003\u0012\u0003\u0006Ia_\u0001\u0006I\u0006$\u0018\r\t\u0005\f\u0003g\tYB!f\u0001\n\u0003\tY#\u0001\u0005nKR\fG-\u0019;b\u0011)\t9$a\u0007\u0003\u0012\u0003\u0006Ia_\u0001\n[\u0016$\u0018\rZ1uC\u0002B1\"a\u000f\u0002\u001c\tU\r\u0011\"\u0001\u0002,\u0005q1m\\7n_:lU\r^1eCR\f\u0007BCA \u00037\u0011\t\u0012)A\u0005w\u0006y1m\\7n_:lU\r^1eCR\f\u0007\u0005C\u0004-\u00037!\t!a\u0011\u0015\u0011\u0005\u0015\u0013\u0011JA&\u0003\u001b\u0002B!a\u0012\u0002\u001c5\t\u0001\u0001C\u0004\u0002*\u0005\u0005\u0003\u0019A>\t\u000f\u0005M\u0012\u0011\ta\u0001w\"9\u00111HA!\u0001\u0004Y\bBCA)\u00037\t\t\u0011\"\u0001\u0002T\u0005!1m\u001c9z)!\t)%!\u0016\u0002X\u0005e\u0003\"CA\u0015\u0003\u001f\u0002\n\u00111\u0001|\u0011%\t\u0019$a\u0014\u0011\u0002\u0003\u00071\u0010C\u0005\u0002<\u0005=\u0003\u0013!a\u0001w\"Q\u0011QLA\u000e#\u0003%\t!a\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\r\u0016\u0004w\u0006\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=D#\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005]\u00141DI\u0001\n\u0003\ty&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0005m\u00141DI\u0001\n\u0003\ty&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005}\u00141DA\u0001\n\u0003\n\t)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0003mC:<'BAAG\u0003\u0011Q\u0017M^1\n\u0007a\n9\t\u0003\u0006\u0002\u0014\u0006m\u0011\u0011!C\u0001\u0003+\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u0010\u0005\u000b\u00033\u000bY\"!A\u0005\u0002\u0005m\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u0015\u0006u\u0005\"CAP\u0003/\u000b\t\u00111\u0001@\u0003\rAH%\r\u0005\u000b\u0003G\u000bY\"!A\u0005B\u0005\u0015\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0006#BAU\u0003_SUBAAV\u0015\r\ti\u000bF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAY\u0003W\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0003k\u000bY\"!A\u0005\u0002\u0005]\u0016\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0015\u000bI\fC\u0005\u0002 \u0006M\u0016\u0011!a\u0001\u0015\"AQ(a\u0007\u0002\u0002\u0013\u0005c\bC\u0005<\u00037\t\t\u0011\"\u0011\u0002@R\u0011\u00111\u0011\u0005\n\u0007\u0006m\u0011\u0011!C!\u0003\u0007$2!RAc\u0011%\ty*!1\u0002\u0002\u0003\u0007!jB\u0005\u0002J\u0002\t\t\u0011#\u0001\u0002L\u0006Ia)\u001b7f)f\u0004Xm\u001d\t\u0005\u0003\u000f\niMB\u0005\u0002\u001e\u0001\t\t\u0011#\u0001\u0002PN)\u0011QZAiQAI\u00111[Amwn\\\u0018QI\u0007\u0003\u0003+T1!a6\u0015\u0003\u001d\u0011XO\u001c;j[\u0016LA!a7\u0002V\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f1\ni\r\"\u0001\u0002`R\u0011\u00111\u001a\u0005\nw\u00055\u0017\u0011!C#\u0003\u007fC!\"!:\u0002N\u0006\u0005I\u0011QAt\u0003\u0015\t\u0007\u000f\u001d7z)!\t)%!;\u0002l\u00065\bbBA\u0015\u0003G\u0004\ra\u001f\u0005\b\u0003g\t\u0019\u000f1\u0001|\u0011\u001d\tY$a9A\u0002mD!\"!=\u0002N\u0006\u0005I\u0011QAz\u0003\u001d)h.\u00199qYf$B!!>\u0002~B!1\u0003^A|!\u0019\u0019\u0012\u0011`>|w&\u0019\u00111 \u000b\u0003\rQ+\b\u000f\\34\u0011)\ty0a<\u0002\u0002\u0003\u0007\u0011QI\u0001\u0004q\u0012\u0002\u0004b\u0002B\u0002\u0001\u0011%!QA\u0001\u000bgBd\u0017\u000e\u001e$jY\u0016\u001cH\u0003BA#\u0005\u000fAqA!\u0003\u0003\u0002\u0001\u000710\u0001\u0005bY24\u0015\u000e\\3t\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\tQ\"[:Tk6l\u0017M]=GS2,GcA#\u0003\u0012!A!1\u0003B\u0006\u0001\u0004\u0011)\"\u0001\u0003gS2,\u0007\u0003BA\t\u0005/IAA!\u0007\u0002\u0014\t!\u0001+\u0019;i\u0011\u001d\u0011i\u0002\u0001C!\u0005?\tAb];qa>\u0014HOQ1uG\"$R!\u0012B\u0011\u0005GAa\u0001\u0016B\u000e\u0001\u0004)\u0006b\u0002B\u0013\u00057\u0001\rA[\u0001\u0007g\u000eDW-\\1\t\u000f\t%\u0002\u0001\"\u0011\u0003,\u0005Y\u0011n]*qY&$\u0018M\u00197f)\u001d)%Q\u0006B\u0018\u0005cAa\u0001\u0016B\u0014\u0001\u0004)\u0006B\u00023\u0003(\u0001\u0007Q\r\u0003\u0005\u00034\t\u001d\u0002\u0019\u0001B\u000b\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\t]\u0002\u0001\"\u0011\u0003:\u0005q\"-^5mIJ+\u0017\rZ3s/&$\b\u000eU1si&$\u0018n\u001c8WC2,Xm\u001d\u000b\u0011\u0005w\u00119F!\u0017\u0003\\\t}#1\rB8\u0005c\u0002ra\u0005B\u001f\u0005\u0003\u00129%C\u0002\u0003@Q\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007e\u0011\u0019%C\u0002\u0003F\u0011\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006y\n%#1J\u0005\u0005\u0003c\u000bi\u0001\u0005\u0003\u0003N\tMSB\u0001B(\u0015\r\u0011\t\u0006C\u0001\tG\u0006$\u0018\r\\=ti&!!Q\u000bB(\u0005-Ie\u000e^3s]\u0006d'k\\<\t\rQ\u0013)\u00041\u0001V\u0011\u0019I'Q\u0007a\u0001U\"9!Q\fB\u001b\u0001\u0004Q\u0017a\u00049beRLG/[8o'\u000eDW-\\1\t\u000f\t\u0005$Q\u0007a\u0001U\u0006q!/Z9vSJ,GmU2iK6\f\u0007\u0002\u0003B3\u0005k\u0001\rAa\u001a\u0002\u000f\u0019LG\u000e^3sgB)A0!\u0003\u0003jA\u0019QDa\u001b\n\u0007\t5dD\u0001\u0004GS2$XM\u001d\u0005\u0007I\nU\u0002\u0019A3\t\u0011\tM$Q\u0007a\u0001\u0005k\n!\u0002[1e_>\u00048i\u001c8g!\u0011\u00119H! \u000e\u0005\te$b\u0001B>?\u0006!1m\u001c8g\u0013\u0011\u0011yH!\u001f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\u0011\u0019\t\u0001C!\u0005\u000b\u000b1BY;jY\u0012\u0014V-\u00193feR\u0001\"1\bBD\u0005\u0013\u0013YI!$\u0003\u0010\nE%1\u0013\u0005\u0007)\n\u0005\u0005\u0019A+\t\r%\u0014\t\t1\u0001k\u0011\u001d\u0011iF!!A\u0002)DqA!\u0019\u0003\u0002\u0002\u0007!\u000e\u0003\u0005\u0003f\t\u0005\u0005\u0019\u0001B4\u0011\u0019!'\u0011\u0011a\u0001K\"A!1\u000fBA\u0001\u0004\u0011)\bC\u0004\u0003\u0018\u0002!\tE!'\u0002\u0017\t,\u0018\u000e\u001c3Xe&$XM\u001d\u000b\b!\nm%Q\u0015BT\u0011!\u0011iJ!&A\u0002\t}\u0015AC:rY\u000e{g\u000e^3yiB\u0019aK!)\n\u0007\t\r\u0006B\u0001\u0006T#2\u001buN\u001c;fqRDa!\u001bBK\u0001\u0004Q\u0007B\u00023\u0003\u0016\u0002\u0007QmB\u0004\u0003,\nA\tA!,\u0002#A\u000b'/];fi\u001aKG.\u001a$pe6\fG\u000fE\u00020\u0005_3a!\u0001\u0002\t\u0002\tE6#\u0002BX%\tB\u0003b\u0002\u0017\u00030\u0012\u0005!Q\u0017\u000b\u0003\u0005[C\u0001B!/\u00030\u0012%!1X\u0001\u0015_Z,'O]5eK6Kgn\u00159mSR\u001c\u0016N_3\u0015\r\tu&1\u0019Bg!\r\u0019\"qX\u0005\u0004\u0005\u0003$\"\u0001B+oSRD\u0001B!2\u00038\u0002\u0007!qY\u0001\u0011a\u0006\u0014\u0018/^3u\u00052|7m[*ju\u0016\u00042a\u0005Be\u0013\r\u0011Y\r\u0006\u0002\u0005\u0019>tw\r\u0003\u0005\u0003|\t]\u0006\u0019\u0001B;\u0011%\u0011\tNa,\u0005\u0002\t\u0011\u0019.\u0001\fj]&$\u0018.\u00197ju\u0016dunY1m\u0015>\u0014g)\u001e8d)I\u0011)N!7\u0003d\n\u001d(\u0011\u001eBv\u0005_\u0014\u0019Pa>\u0015\t\tu&q\u001b\u0005\u00075\n=\u0007\u0019A.\t\u0011\tm'q\u001aa\u0001\u0005;\fqB]3rk&\u0014X\rZ\"pYVlgn\u001d\t\u0005'\t}7'C\u0002\u0003bR\u0011Q!\u0011:sCfD\u0001B!\u001a\u0003P\u0002\u0007!Q\u001d\t\u0006'\t}'\u0011\u000e\u0005\u0007S\n=\u0007\u0019\u00016\t\u0011\t\u0015'q\u001aa\u0001\u0005\u000fDqA!<\u0003P\u0002\u0007Q)\u0001\tvg\u0016lU\r^1eCR\f7)Y2iK\"9!\u0011\u001fBh\u0001\u0004)\u0015!\u00069beF,X\r\u001e$jYR,'\u000fU;tQ\u0012{wO\u001c\u0005\b\u0005k\u0014y\r1\u0001F\u0003Q\t7o];nK\nKg.\u0019:z\u0013N\u001cFO]5oO\"9!\u0011 Bh\u0001\u0004)\u0015AF1tgVlW-\u00138usYJ5\u000fV5nKN$\u0018-\u001c9\t\u0013\tu(q\u0016C\u0001\u0005\t}\u0018aG5oSRL\u0017\r\\5{K\u0012\u0013\u0018N^3s'&$WMS8c\rVt7\r\u0006\u0004\u0004\u0002\r\u001511\u0002\u000b\u0005\u0005{\u001b\u0019\u0001\u0003\u0004[\u0005w\u0004\ra\u0017\u0005\t\u0007\u000f\u0011Y\u00101\u0001\u0004\n\u0005Q\u0011N\u001c9vi\u001aKG.Z:\u0011\u000bM\u0011y.a\u0004\t\u0011\t\u0015'1 a\u0001\u0005\u000fD\u0011ba\u0004\u00030\u0012\u0005!a!\u0005\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\rF\u0003t\u0007'\u0019)\u0003\u0003\u0005\u0004\u0016\r5\u0001\u0019AB\f\u0003\u001d1wn\u001c;feN\u0004R\u0001`A\u0005\u00073\u0001Baa\u0007\u0004\"5\u00111Q\u0004\u0006\u0004A\u000e}!\"A\u0002\n\t\r\r2Q\u0004\u0002\u0007\r>|G/\u001a:\t\rQ\u001bi\u00011\u0001V\u0011!\u0019ICa,\u0005\u0002\r-\u0012aG7fe\u001e,W*\u001a;bgR|'/\u001a)beF,X\r^*dQ\u0016l\u0017\rF\u0003k\u0007[\u0019\t\u0004C\u0004\u00040\r\u001d\u0002\u0019\u00016\u0002\u001f5,G/Y:u_J,7k\u00195f[\u0006Dqaa\r\u0004(\u0001\u0007!.A\u0007qCJ\fX/\u001a;TG\",W.\u0019\u0005\n\u0007o\u0011y\u000b\"\u0001\u0003\u0007s\t!$\\3sO\u0016l\u0015n]:j]\u001etU\u000f\u001c7bE2,g)[3mIN$RA[B\u001e\u0007{Aqaa\f\u00046\u0001\u0007!\u000eC\u0004\u00044\rU\u0002\u0019\u00016\t\u0011\r\u0005#q\u0016C\u0001\u0007\u0007\na#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\u0006g\u000e\u00153\u0011\n\u0005\b\u0007\u000f\u001ay\u00041\u0001|\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u0019!6q\ba\u0001+\"A1Q\nBX\t\u0003\u0019y%\u0001\u000bsK\u0006$7k\u00195f[\u00064%o\\7G_>$XM\u001d\u000b\u0006U\u000eE3Q\u000b\u0005\t\u0007'\u001aY\u00051\u0001\u0004\u001a\u00051am\\8uKJD\u0001ba\u0016\u0004L\u0001\u00071\u0011L\u0001\nG>tg/\u001a:uKJ\u00042aLB.\u0013\r\u0019iF\u0001\u0002\u0017!\u0006\u0014\u0018/^3u'\u000eDW-\\1D_:4XM\u001d;fe\"A1\u0011\rBX\t\u0013\u0019\u0019'A\feKN,'/[1mSj,7k\u00195f[\u0006\u001cFO]5oOR\u00191o!\u001a\t\u000f\r\u001d4q\fa\u0001g\u0005a1o\u00195f[\u0006\u001cFO]5oO\"Q11\u000eBX\u0005\u0004%\ta!\u001c\u0002'\u0005\u0004\u0018m\u00195f!\u0006\u0014\u0018/^3u\u0019><w-\u001a:\u0016\u0005\r=\u0004\u0003BB9\u0007wj!aa\u001d\u000b\t\rU4qO\u0001\bY><w-\u001b8h\u0015\u0011\u0019I(a#\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007{\u001a\u0019H\u0001\u0004M_\u001e<WM\u001d\u0005\n\u0007\u0003\u0013y\u000b)A\u0005\u0007_\nA#\u00199bG\",\u0007+\u0019:rk\u0016$Hj\\4hKJ\u0004\u0003BCBC\u0005_\u0013\r\u0011\"\u0001\u0004n\u0005i\u0001/\u0019:rk\u0016$Hj\\4hKJD\u0011b!#\u00030\u0002\u0006Iaa\u001c\u0002\u001dA\f'/];fi2{wmZ3sA!Q1Q\u0012BX\u0005\u0004%\taa$\u00027I,G-\u001b:fGR\u0004\u0016M]9vKRdunZ:WS\u0006\u001cFJ\u0012\u001bK+\t\u0011i\fC\u0005\u0004\u0014\n=\u0006\u0015!\u0003\u0003>\u0006a\"/\u001a3je\u0016\u001cG\u000fU1scV,G\u000fT8hgZK\u0017m\u0015'Gi)\u0003\u0003BCBL\u0005_\u000b\t\u0011\"\u0003\u0004\u001a\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\n\u0005\u0003\u0002\u0006\u000eu\u0015\u0002BBP\u0003\u000f\u0013aa\u00142kK\u000e$\b")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private volatile ParquetFileFormat$FileTypes$ FileTypes$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void redirectParquetLogsViaSLF4J() {
        ParquetFileFormat$.MODULE$.redirectParquetLogsViaSLF4J();
    }

    public static java.util.logging.Logger parquetLogger() {
        return ParquetFileFormat$.MODULE$.parquetLogger();
    }

    public static java.util.logging.Logger apacheParquetLogger() {
        return ParquetFileFormat$.MODULE$.apacheParquetLogger();
    }

    public static StructType readSchemaFromFooter(Footer footer, ParquetSchemaConverter parquetSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(seq, sparkSession);
    }

    public static StructType mergeMetastoreParquetSchema(StructType structType, StructType structType2) {
        return ParquetFileFormat$.MODULE$.mergeMetastoreParquetSchema(structType, structType2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParquetFileFormat$FileTypes$ FileTypes$lzycompute() {
        ParquetFileFormat parquetFileFormat = this;
        synchronized (parquetFileFormat) {
            if (this.FileTypes$module != null) return this.FileTypes$module;
            this.FileTypes$module = new ParquetFileFormat$FileTypes$(this);
            return this.FileTypes$module;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "ParquetFormat";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, ParquetOutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using default output committer for Parquet: ").append((Object)ParquetOutputCommitter.class.getCanonicalName()).toString();
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using user defined output committer for Parquet: ").append((Object)this.committerClass$1.getCanonicalName()).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, ParquetOutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)dataSchema);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetBinaryAsString())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetINT96AsTimestamp())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set("parquet.compression", parquetOptions.compressionCodec());
        if (conf.get("parquet.enable.summary-metadata") == null) {
            conf.setBoolean("parquet.enable.summary-metadata", false);
        }
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, bucketId, context);
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_SCHEMA_RESPECT_SUMMARIES()));
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.metadata().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            }).orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.data().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            })).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    public ParquetFileFormat$FileTypes$ FileTypes() {
        return this.FileTypes$module == null ? this.FileTypes$lzycompute() : this.FileTypes$module;
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles2) {
        FileStatus[] leaves = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)allFiles2.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath()) || (!f.getPath().getName().startsWith("_") || f.getPath().getName().contains("=")) && !f.getPath().getName().startsWith(".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).toArray(ClassTag$.MODULE$.apply(FileStatus.class))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$2) {
                String string = x$2.getPath().getName();
                String string2 = "_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_common_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                return x$4.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return this.buildReader(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)requiredSchema);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING())));
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP())));
        None$ pushed = new StringOps(Predef$.MODULE$.augmentString(sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()))).toBoolean() ? ((TraversableOnce)filters.flatMap((Function1)new Serializable(this, requiredSchema){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;

            public final Iterable<FilterPredicate> apply(Filter x$5) {
                return Option$.MODULE$.option2Iterable(ParquetFilters$.MODULE$.createFilter(this.requiredSchema$1, x$5));
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
            }
        }) : None$.MODULE$;
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        boolean enableVectorizedReader = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && resultSchema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$6) {
                return x$6.dataType() instanceof AtomicType;
            }
        });
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        return new Serializable(this, partitionSchema, requiredSchema, (Option)pushed, broadcastedHadoopConf, enableVectorizedReader, returningBatch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;
            public final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final Option pushed$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final boolean enableVectorizedReader$1;
            private final boolean returningBatch$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedParquetRecordReader;
                Predef$.MODULE$.assert(file.partitionValues().numFields() == this.partitionSchema$1.size());
                FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                ParquetInputSplit split = new ParquetInputSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value(), attemptId);
                if (this.pushed$1.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)this.pushed$1.get()));
                }
                if (this.enableVectorizedReader$1) {
                    VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader();
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildReader$1 $outer;
                        private final PartitionedFile file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionSchema$1, this.file$1.partitionValues()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                    vectorizedReader.initBatch(this.partitionSchema$1, file.partitionValues());
                    if (this.returningBatch$1) {
                        vectorizedReader.enableReturningBatches();
                    }
                    vectorizedParquetRecordReader = vectorizedReader;
                } else {
                    ParquetRecordReader parquetRecordReader;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to parquet-mr"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    Option option = this.pushed$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FilterPredicate filter2 = (FilterPredicate)some.x();
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport(), FilterCompat.get((FilterPredicate)filter2, null));
                    } else {
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport());
                    }
                    ParquetRecordReader reader = parquetRecordReader;
                    reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    vectorizedParquetRecordReader = reader;
                }
                VectorizedParquetRecordReader parquetReader = vectorizedParquetRecordReader;
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(parquetReader);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, iter){
                    public static final long serialVersionUID = 0L;
                    public final RecordReaderIterator iter$1;

                    public final TaskContext apply(TaskContext x$7) {
                        return x$7.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$4 $outer;

                            public final void apply(TaskContext x$8) {
                                this.$outer.iter$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.iter$1 = iter$1;
                    }
                });
                if (parquetReader instanceof VectorizedParquetRecordReader && this.enableVectorizedReader$1) {
                    recordReaderIterator = iter;
                } else {
                    Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    JoinedRow joinedRow = new JoinedRow();
                    UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    recordReaderIterator = this.partitionSchema$1.length() == 0 ? iter : iter.map(new Serializable(this, joinedRow, appendPartitionColumns, file){
                        public static final long serialVersionUID = 0L;
                        private final JoinedRow joinedRow$1;
                        private final UnsafeProjection appendPartitionColumns$1;
                        private final PartitionedFile file$1;

                        public final UnsafeRow apply(InternalRow d) {
                            return this.appendPartitionColumns$1.apply((InternalRow)this.joinedRow$1.apply(d, this.file$1.partitionValues()));
                        }
                        {
                            this.joinedRow$1 = joinedRow$1;
                            this.appendPartitionColumns$1 = appendPartitionColumns$1;
                            this.file$1 = file$1;
                        }
                    });
                }
                return recordReaderIterator;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.pushed$1 = pushed$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.returningBatch$1 = returningBatch$1;
            }
        };
    }

    @Override
    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return new ParquetOutputWriterFactory(sqlContext.conf(), dataSchema, sqlContext.sessionState().newHadoopConf(), options);
    }

    public ParquetFileFormat() {
        FileFormat$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }

    public class FileTypes
    implements Product,
    Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ ParquetFileFormat $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 0: {
                    seq = this.data();
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ParquetFileFormat org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(ParquetFileFormat $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

