/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedColumnReader;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import parquet.column.ColumnDescriptor;
import parquet.column.page.PageReadStore;
import parquet.schema.Type;

public class VectorizedParquetRecordReader
extends SpecificParquetRecordReaderBase<Object> {
    private int batchIdx = 0;
    private int numBatched = 0;
    private VectorizedColumnReader[] columnReaders;
    private long rowsReturned;
    private long totalCountLoadedSoFar = 0L;
    private boolean[] missingColumns;
    private ColumnarBatch columnarBatch;
    private boolean returnColumnarBatch;
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.ON_HEAP;

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException, UnsupportedOperationException {
        super.initialize(inputSplit, taskAttemptContext);
        this.initializeInternal();
    }

    @Override
    public void initialize(String path, List<String> columns2) throws IOException, UnsupportedOperationException {
        super.initialize(path, columns2);
        this.initializeInternal();
    }

    @Override
    public void close() throws IOException {
        if (this.columnarBatch != null) {
            this.columnarBatch.close();
            this.columnarBatch = null;
        }
        super.close();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.resultBatch();
        if (this.returnColumnarBatch) {
            return this.nextBatch();
        }
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        if (this.returnColumnarBatch) {
            return this.columnarBatch;
        }
        return this.columnarBatch.getRow(this.batchIdx - 1);
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.rowsReturned / (float)this.totalRowCount;
    }

    public void initBatch(MemoryMode memMode, StructType partitionColumns, InternalRow partitionValues) {
        StructType batchSchema = new StructType();
        for (StructField f : this.sparkSchema.fields()) {
            batchSchema = batchSchema.add(f);
        }
        if (partitionColumns != null) {
            for (StructField f : partitionColumns.fields()) {
                batchSchema = batchSchema.add(f);
            }
        }
        this.columnarBatch = ColumnarBatch.allocate(batchSchema, memMode);
        if (partitionColumns != null) {
            int partitionIdx = this.sparkSchema.fields().length;
            for (int i = 0; i < partitionColumns.fields().length; ++i) {
                ColumnVectorUtils.populate(this.columnarBatch.column(i + partitionIdx), partitionValues, i);
                this.columnarBatch.column(i + partitionIdx).setIsConstant();
            }
        }
        for (int i = 0; i < this.missingColumns.length; ++i) {
            if (!this.missingColumns[i]) continue;
            this.columnarBatch.column(i).putNulls(0, this.columnarBatch.capacity());
            this.columnarBatch.column(i).setIsConstant();
        }
    }

    public void initBatch() {
        this.initBatch(DEFAULT_MEMORY_MODE, null, null);
    }

    public void initBatch(StructType partitionColumns, InternalRow partitionValues) {
        this.initBatch(DEFAULT_MEMORY_MODE, partitionColumns, partitionValues);
    }

    public ColumnarBatch resultBatch() {
        if (this.columnarBatch == null) {
            this.initBatch();
        }
        return this.columnarBatch;
    }

    public void enableReturningBatches() {
        this.returnColumnarBatch = true;
    }

    public boolean nextBatch() throws IOException {
        this.columnarBatch.reset();
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min((long)this.columnarBatch.capacity(), this.totalCountLoadedSoFar - this.rowsReturned);
        for (int i = 0; i < this.columnReaders.length; ++i) {
            if (this.columnReaders[i] == null) continue;
            this.columnReaders[i].readBatch(num, this.columnarBatch.column(i));
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        this.numBatched = num;
        this.batchIdx = 0;
        return true;
    }

    private void initializeInternal() throws IOException, UnsupportedOperationException {
        this.missingColumns = new boolean[this.requestedSchema.getFieldCount()];
        for (int i = 0; i < this.requestedSchema.getFieldCount(); ++i) {
            Type t = (Type)this.requestedSchema.getFields().get(i);
            if (!t.isPrimitive() || t.isRepetition(Type.Repetition.REPEATED)) {
                throw new UnsupportedOperationException("Complex types not supported.");
            }
            Object[] colPath = (String[])this.requestedSchema.getPaths().get(i);
            if (this.fileSchema.containsPath((String[])colPath)) {
                ColumnDescriptor fd = this.fileSchema.getColumnDescription((String[])colPath);
                if (!fd.equals(this.requestedSchema.getColumns().get(i))) {
                    throw new UnsupportedOperationException("Schema evolution not supported.");
                }
                this.missingColumns[i] = false;
                continue;
            }
            if (((ColumnDescriptor)this.requestedSchema.getColumns().get(i)).getMaxDefinitionLevel() == 0) {
                throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(colPath));
            }
            this.missingColumns[i] = true;
        }
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List columns2 = this.requestedSchema.getColumns();
        this.columnReaders = new VectorizedColumnReader[columns2.size()];
        for (int i = 0; i < columns2.size(); ++i) {
            if (this.missingColumns[i]) continue;
            this.columnReaders[i] = new VectorizedColumnReader((ColumnDescriptor)columns2.get(i), pages.getPageReader((ColumnDescriptor)columns2.get(i)));
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }
}

