/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.unsafe.Platform;
import parquet.column.values.ValuesReader;
import parquet.io.api.Binary;

public class VectorizedPlainValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private byte[] buffer;
    private int offset;
    private int bitOffset;
    private ByteBuffer byteBuffer;
    private static final boolean bigEndianPlatform = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);

    public void initFromPage(int valueCount, byte[] bytes, int offset) throws IOException {
        this.buffer = bytes;
        this.offset = offset + Platform.BYTE_ARRAY_OFFSET;
        if (bigEndianPlatform) {
            this.byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public void skip() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void readBooleans(int total, ColumnVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            c.putBoolean(rowId + i, this.readBoolean());
        }
    }

    @Override
    public final void readIntegers(int total, ColumnVector c, int rowId) {
        c.putIntsLittleEndian(rowId, total, this.buffer, this.offset - Platform.BYTE_ARRAY_OFFSET);
        this.offset += 4 * total;
    }

    @Override
    public final void readLongs(int total, ColumnVector c, int rowId) {
        c.putLongsLittleEndian(rowId, total, this.buffer, this.offset - Platform.BYTE_ARRAY_OFFSET);
        this.offset += 8 * total;
    }

    @Override
    public final void readFloats(int total, ColumnVector c, int rowId) {
        c.putFloats(rowId, total, this.buffer, this.offset - Platform.BYTE_ARRAY_OFFSET);
        this.offset += 4 * total;
    }

    @Override
    public final void readDoubles(int total, ColumnVector c, int rowId) {
        c.putDoubles(rowId, total, this.buffer, this.offset - Platform.BYTE_ARRAY_OFFSET);
        this.offset += 8 * total;
    }

    @Override
    public final void readBytes(int total, ColumnVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            c.putByte(rowId + i, Platform.getByte((Object)this.buffer, (long)this.offset));
            this.offset += 4;
        }
    }

    @Override
    public final boolean readBoolean() {
        byte b = Platform.getByte((Object)this.buffer, (long)this.offset);
        boolean v = (b & 1 << this.bitOffset) != 0;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
            ++this.offset;
        }
        return v;
    }

    @Override
    public final int readInteger() {
        int v = Platform.getInt((Object)this.buffer, (long)this.offset);
        if (bigEndianPlatform) {
            v = Integer.reverseBytes(v);
        }
        this.offset += 4;
        return v;
    }

    @Override
    public final long readLong() {
        long v = Platform.getLong((Object)this.buffer, (long)this.offset);
        if (bigEndianPlatform) {
            v = Long.reverseBytes(v);
        }
        this.offset += 8;
        return v;
    }

    @Override
    public final byte readByte() {
        return (byte)this.readInteger();
    }

    @Override
    public final float readFloat() {
        float v = !bigEndianPlatform ? Platform.getFloat((Object)this.buffer, (long)this.offset) : this.byteBuffer.getFloat(this.offset - Platform.BYTE_ARRAY_OFFSET);
        this.offset += 4;
        return v;
    }

    @Override
    public final double readDouble() {
        double v = !bigEndianPlatform ? Platform.getDouble((Object)this.buffer, (long)this.offset) : this.byteBuffer.getDouble(this.offset - Platform.BYTE_ARRAY_OFFSET);
        this.offset += 8;
        return v;
    }

    @Override
    public final void readBinary(int total, ColumnVector v, int rowId) {
        for (int i = 0; i < total; ++i) {
            int len = this.readInteger();
            int start = this.offset;
            this.offset += len;
            v.putByteArray(rowId + i, this.buffer, start - Platform.BYTE_ARRAY_OFFSET, len);
        }
    }

    @Override
    public final Binary readBinary(int len) {
        Binary result = Binary.fromByteArray((byte[])this.buffer, (int)(this.offset - Platform.BYTE_ARRAY_OFFSET), (int)len);
        this.offset += len;
        return result;
    }
}

