/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.local.LocalFs;
import org.apache.hadoop.fs.local.RawLocalFs;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$$anonfun$add$1$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]1\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011$!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\n%\u0013\t)3CA\u0002B]f\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0005\u0002\u0011%tG/\u001a:oC2L!a\u000b\u0015\u0003\u000f1{wmZ5oO\"AQ\u0006\u0001B\u0001B\u0003%a&\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u00020a5\ta!\u0003\u00022\r\ta1\u000b]1sWN+7o]5p]\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\u0003qCRD\u0007CA\u001b9\u001d\t\u0011b'\u0003\u00028'\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t94\u0003\u0003\u0005=\u0001\t\r\t\u0015a\u0003>\u0003))g/\u001b3f]\u000e,G%\r\t\u0004}\u0005[R\"A \u000b\u0005\u0001\u001b\u0012a\u0002:fM2,7\r^\u0005\u0003\u0005~\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019K%\n\u0006\u0002H\u0011B\u0019\u0001\u0004A\u000e\t\u000bq\u001a\u00059A\u001f\t\u000b5\u001a\u0005\u0019\u0001\u0018\t\u000bM\u001a\u0005\u0019\u0001\u001b\t\u000f1\u0003!\u0019!C\u0001\u001b\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQV\ta\n\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006\u0011am\u001d\u0006\u0003'*\ta\u0001[1e_>\u0004\u0018BA+Q\u0005\u0011\u0001\u0016\r\u001e5\t\r]\u0003\u0001\u0015!\u0003O\u00035iW\r^1eCR\f\u0007+\u0019;iA!9\u0011\f\u0001b\u0001\n#Q\u0016a\u00034jY\u0016l\u0015M\\1hKJ,\u0012a\u0017\t\u00039\u0012t!\u0001G/\b\u000by\u0013\u0001\u0012A0\u0002\u001f!#eiU'fi\u0006$\u0017\r^1M_\u001e\u0004\"\u0001\u00071\u0007\u000b\u0005\u0011\u0001\u0012A1\u0014\u0005\u0001\f\u0002\"\u0002#a\t\u0003\u0019G#A0\u0007\u000f\u0015\u0004\u0007\u0013aI\u0001M\nYa)\u001b7f\u001b\u0006t\u0017mZ3s'\t!\u0017\u0003C\u0003iI\u001a\u0005\u0011.\u0001\u0003mSN$Hc\u00016qcB\u0019!c[7\n\u00051\u001c\"!B!se\u0006L\bCA(o\u0013\ty\u0007K\u0001\u0006GS2,7\u000b^1ukNDQaM4A\u00029CQA]4A\u0002M\faAZ5mi\u0016\u0014\bCA(u\u0013\t)\bK\u0001\u0006QCRDg)\u001b7uKJDQa\u001e3\u0007\u0002a\fa!\\6eSJ\u001cHCA=}!\t\u0011\"0\u0003\u0002|'\t!QK\\5u\u0011\u0015\u0019d\u000f1\u0001O\u0011\u0015qHM\"\u0001\u0000\u0003\u0019)\u00070[:ugR!\u0011\u0011AA\u0004!\r\u0011\u00121A\u0005\u0004\u0003\u000b\u0019\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006gu\u0004\rA\u0014\u0005\b\u0003\u0017!g\u0011AA\u0007\u0003\u0011y\u0007/\u001a8\u0015\t\u0005=\u0011Q\u0003\t\u0004\u001f\u0006E\u0011bAA\n!\n\tbi\u0015#bi\u0006Le\u000e];u'R\u0014X-Y7\t\rM\nI\u00011\u0001O\u0011\u001d\tI\u0002\u001aD\u0001\u00037\taa\u0019:fCR,G\u0003BA\u000f\u0003G\u00012aTA\u0010\u0013\r\t\t\u0003\u0015\u0002\u0013\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u00044\u0003/\u0001\rA\u0014\u0005\b\u0003O!g\u0011AA\u0015\u0003\u0019\u0011XM\\1nKR)\u00110a\u000b\u00020!9\u0011QFA\u0013\u0001\u0004q\u0015aB:sGB\u000bG\u000f\u001b\u0005\b\u0003c\t)\u00031\u0001O\u0003!!Wm\u001d;QCRD\u0007bBA\u001bI\u001a\u0005\u0011qG\u0001\u0007I\u0016dW\r^3\u0015\u0007e\fI\u0004\u0003\u00044\u0003g\u0001\rA\u0014\u0005\b\u0003{!g\u0011AA \u0003EI7\u000fT8dC24\u0015\u000e\\3TsN$X-\\\u000b\u0003\u0003\u00031a!a\u0011a\u0001\u0005\u0015#A\u0005$jY\u0016\u001cuN\u001c;fqRl\u0015M\\1hKJ\u001cR!!\u0011\u0012\u0003\u000f\u00022!!\u0013e\u001b\u0005\u0001\u0007\"C\u001a\u0002B\t\u0005\t\u0015!\u0003O\u0011-\ty%!\u0011\u0003\u0002\u0003\u0006I!!\u0015\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9FU\u0001\u0005G>tg-\u0003\u0003\u0002\\\u0005U#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004E\u0003\u0003\"\t!a\u0018\u0015\r\u0005\u0005\u00141MA3!\u0011\tI%!\u0011\t\rM\ni\u00061\u0001O\u0011!\ty%!\u0018A\u0002\u0005E\u0003BCA5\u0003\u0003\u0012\r\u0011\"\u0003\u0002l\u0005\u0011amY\u000b\u0003\u0003[\u00022aTA8\u0013\r\t\t\b\u0015\u0002\f\r&dWmQ8oi\u0016DH\u000fC\u0005\u0002v\u0005\u0005\u0003\u0015!\u0003\u0002n\u0005\u0019am\u0019\u0011\t\u000f!\f\t\u0005\"\u0011\u0002zQ)!.a\u001f\u0002~!11'a\u001eA\u00029CaA]A<\u0001\u0004\u0019\b\u0002CA\u0014\u0003\u0003\"\t%!!\u0015\u000be\f\u0019)!\"\t\u000f\u00055\u0012q\u0010a\u0001\u001d\"9\u0011\u0011GA@\u0001\u0004q\u0005bB<\u0002B\u0011\u0005\u0013\u0011\u0012\u000b\u0004s\u0006-\u0005BB\u001a\u0002\b\u0002\u0007a\n\u0003\u0005\u0002\f\u0005\u0005C\u0011IAH)\u0011\ty!!%\t\rM\ni\t1\u0001O\u0011!\tI\"!\u0011\u0005B\u0005UE\u0003BA\u000f\u0003/CaaMAJ\u0001\u0004q\u0005b\u0002@\u0002B\u0011\u0005\u00131\u0014\u000b\u0005\u0003\u0003\ti\n\u0003\u00044\u00033\u0003\rA\u0014\u0005\t\u0003k\t\t\u0005\"\u0011\u0002\"R\u0019\u00110a)\t\rM\ny\n1\u0001O\u0011!\ti$!\u0011\u0005B\u0005}bABAUA\u0002\tYKA\tGS2,7+_:uK6l\u0015M\\1hKJ\u001cR!a*\u0012\u0003\u000fB\u0011bMAT\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0017\u0005=\u0013q\u0015B\u0001B\u0003%\u0011\u0011\u000b\u0005\b\t\u0006\u001dF\u0011AAZ)\u0019\t),a.\u0002:B!\u0011\u0011JAT\u0011\u0019\u0019\u0014\u0011\u0017a\u0001\u001d\"A\u0011qJAY\u0001\u0004\t\t\u0006C\u0005R\u0003O\u0013\r\u0011\"\u0003\u0002>V\u0011\u0011q\u0018\t\u0004\u001f\u0006\u0005\u0017bAAb!\nQa)\u001b7f'f\u001cH/Z7\t\u0013\u0005\u001d\u0017q\u0015Q\u0001\n\u0005}\u0016a\u00014tA!9\u0001.a*\u0005B\u0005-G#\u00026\u0002N\u0006=\u0007BB\u001a\u0002J\u0002\u0007a\n\u0003\u0004s\u0003\u0013\u0004\ra\u001d\u0005\t\u0003O\t9\u000b\"\u0011\u0002TR)\u00110!6\u0002X\"9\u0011QFAi\u0001\u0004q\u0005bBA\u0019\u0003#\u0004\rA\u0014\u0005\bo\u0006\u001dF\u0011IAn)\rI\u0018Q\u001c\u0005\u0007g\u0005e\u0007\u0019\u0001(\t\u0011\u0005-\u0011q\u0015C!\u0003C$B!a\u0004\u0002d\"11'a8A\u00029C\u0001\"!\u0007\u0002(\u0012\u0005\u0013q\u001d\u000b\u0005\u0003;\tI\u000f\u0003\u00044\u0003K\u0004\rA\u0014\u0005\b}\u0006\u001dF\u0011IAw)\u0011\t\t!a<\t\rM\nY\u000f1\u0001O\u0011!\t)$a*\u0005B\u0005MHcA=\u0002v\"11'!=A\u00029C\u0001\"!\u0010\u0002(\u0012\u0005\u0013q\b\u0005\b\u0003w\u0004\u0001\u0015!\u0003\\\u000311\u0017\u000e\\3NC:\fw-\u001a:!\u0011%\ty\u0010\u0001b\u0001\n\u0013\u0011\t!\u0001\tcCR\u001c\u0007NR5mKN4\u0015\u000e\u001c;feV\u0011!1\u0001\n\u0006\u0005\u000b\u0011ia\u001d\u0004\b\u0005\u000f\u0011I\u0001\u0001B\u0002\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0011!\u0011Y\u0001\u0001Q\u0001\n\t\r\u0011!\u00052bi\u000eDg)\u001b7fg\u001aKG\u000e^3sAA!!q\u0002B\r\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\tU\u0011\u0001\u00027b]\u001eT!Aa\u0006\u0002\t)\fg/Y\u0005\u0005\u00057\u0011\tB\u0001\u0004PE*,7\r\u001e\u0005\n\u0005?\u0001!\u0019!C\u0005\u0005C\t!b]3sS\u0006d\u0017N_3s+\t\u0011\u0019\u0003\u0005\u0003\u0003&\t%RB\u0001B\u0014\u0015\r\u0011y\u0002C\u0005\u0005\u0005W\u00119C\u0001\nTKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007\u0002\u0003B\u0018\u0001\u0001\u0006IAa\t\u0002\u0017M,'/[1mSj,'\u000f\t\u0005\b\u0005g\u0001A\u0011\u0003B\u001b\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR\u0019aJa\u000e\t\u0011\te\"\u0011\u0007a\u0001\u0005w\tqAY1uG\"LE\rE\u0002\u0013\u0005{I1Aa\u0010\u0014\u0005\u0011auN\\4\t\u000f\t\r\u0003\u0001\"\u0005\u0003F\u0005i\u0001/\u0019;i)>\u0014\u0015\r^2i\u0013\u0012$BAa\u000f\u0003H!11G!\u0011A\u00029CqAa\u0013\u0001\t#\u0011i%A\u0006jg\n\u000bGo\u00195GS2,G\u0003BA\u0001\u0005\u001fBaa\rB%\u0001\u0004q\u0005b\u0002B*\u0001\u0011E!QK\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$R!\u001fB,\u00057BqA!\u0017\u0003R\u0001\u00071$\u0001\u0005nKR\fG-\u0019;b\u0011!\u0011iF!\u0015A\u0002\t}\u0013aA8viB!!\u0011\rB4\u001b\t\u0011\u0019G\u0003\u0003\u0003f\tU\u0011AA5p\u0013\u0011\u0011IGa\u0019\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u000f\t5\u0004\u0001\"\u0005\u0003p\u0005YA-Z:fe&\fG.\u001b>f)\rY\"\u0011\u000f\u0005\t\u0005g\u0012Y\u00071\u0001\u0003v\u0005\u0011\u0011N\u001c\t\u0005\u0005C\u00129(\u0003\u0003\u0003z\t\r$aC%oaV$8\u000b\u001e:fC6DqA! \u0001\t\u0003\u0012y(A\u0002bI\u0012$b!!\u0001\u0003\u0002\n\r\u0005\u0002\u0003B\u001d\u0005w\u0002\rAa\u000f\t\u000f\te#1\u0010a\u00017!9!q\u0011\u0001\u0005\n\t%\u0015AC<sSR,')\u0019;dQR9\u0011Pa#\u0003\u000e\n=\u0005\u0002\u0003B\u001d\u0005\u000b\u0003\rAa\u000f\t\u000f\te#Q\u0011a\u00017!A!\u0011\u0013BC\u0001\u0004\u0011\u0019*\u0001\u0004xe&$XM\u001d\t\b%\tU5Da\u0018z\u0013\r\u00119j\u0005\u0002\n\rVt7\r^5p]JBqAa'\u0001\t\u0013\u0011i*\u0001\u000fjg\u001aKG.Z!me\u0016\fG-_#ySN$8/\u0012=dKB$\u0018n\u001c8\u0015\t\u0005\u0005!q\u0014\u0005\t\u0005C\u0013I\n1\u0001\u0003$\u0006\tQ\r\u0005\u0003\u0003b\t\u0015\u0016\u0002\u0002BT\u0005G\u00121\"S(Fq\u000e,\u0007\u000f^5p]\"9!1\u0016\u0001\u0005B\t5\u0016aA4fiR!!q\u0016B[!\u0011\u0011\"\u0011W\u000e\n\u0007\tM6C\u0001\u0004PaRLwN\u001c\u0005\t\u0005s\u0011I\u000b1\u0001\u0003<!9!1\u0016\u0001\u0005B\teFC\u0002B^\u0005\u0007\u0014I\r\u0005\u0003\u0013W\nu\u0006C\u0002\n\u0003@\nm2$C\u0002\u0003BN\u0011a\u0001V;qY\u0016\u0014\u0004\u0002\u0003Bc\u0005o\u0003\rAa2\u0002\u000fM$\u0018M\u001d;JIB)!C!-\u0003<!A!1\u001aB\\\u0001\u0004\u00119-A\u0003f]\u0012LE\rC\u0004\u0003P\u0002!\tE!5\u0002\u0013\u001d,G\u000fT1uKN$HC\u0001Bj!\u0015\u0011\"\u0011\u0017B_\u0011\u001d\u00119\u000e\u0001C!\u00053\fQ\u0001];sO\u0016$2!\u001fBn\u0011!\u0011iN!6A\u0002\tm\u0012\u0001\u0005;ie\u0016\u001c\bn\u001c7e\u0005\u0006$8\r[%e\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005G\f\u0011c\u0019:fCR,g)\u001b7f\u001b\u0006t\u0017mZ3s)\u0005Y\u0006")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final ClassTag<T> evidence$1;
    private final Path metadataPath;
    private final FileManager fileManager;
    private final PathFilter batchFilesFilter;
    private final SerializerInstance serializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    private PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    private SerializerInstance serializer() {
        return this.serializer;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        SerializationStream outStream = this.serializer().serializeStream(out);
        outStream.writeObject(metadata, this.evidence$1);
    }

    public T deserialize(InputStream in) {
        DeserializationStream inStream = this.serializer().deserializeStream(in);
        return (T)inStream.readObject(this.evidence$1);
    }

    @Override
    public boolean add(long batchId, T metadata) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$1) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(this, batchId, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            public final long batchId$1;
            public final Object metadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                if (this.$outer.fileManager().isLocalFileSystem()) {
                    Thread thread = Thread.currentThread();
                    if (!(thread instanceof UninterruptibleThread)) throw new IllegalStateException("HDFSMetadataLog.add() on a local file system must be executed on a o.a.spark.util.UninterruptibleThread");
                    UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
                    BoxedUnit boxedUnit = (BoxedUnit)uninterruptibleThread.runUninterruptibly((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$add$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(this.$outer.batchId$1, this.$outer.metadata$1, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$add$1$$anonfun$apply$mcZ$sp$1 $outer;

                                public final void apply(T metadata, OutputStream out) {
                                    this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().serialize(metadata, out);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$add$1 org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return true;
                } else {
                    this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(this.batchId$1, this.metadata$1, new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$add$1 $outer;

                        public final void apply(T metadata, OutputStream out) {
                            this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().serialize(metadata, out);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return true;
            }

            public /* synthetic */ HDFSMetadataLog org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchId$1 = batchId$1;
                this.metadata$1 = var4_3;
            }
        }));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(long batchId, T metadata, Function2<T, OutputStream, BoxedUnit> writer) {
        int nextId = 0;
        Path tempPath = new Path(this.metadataPath(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString()})));
        {
            FSDataOutputStream output2 = this.fileManager().create(tempPath);
            try {
                writer.apply(metadata, (Object)output2);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output2);
            }
            {
                this.logDebug((Function0<String>)new Serializable(this, batchId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final long batchId$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to write log #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.batchIdToPath(this.batchId$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.batchId$2 = batchId$2;
                    }
                });
                this.fileManager().rename(tempPath, this.batchIdToPath(batchId));
                this.fileManager().delete(tempPath);
                return;
            }
        }
    }

    private boolean isFileAlreadyExistsException(IOException e) {
        return e instanceof FileAlreadyExistsException || e.getMessage() != null && e.getMessage().startsWith("File already exists: ");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Option<T> get(long batchId) {
        Some some;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (!this.fileManager().exists(batchMetadataFile)) {
            this.logDebug((Function0<String>)new Serializable(this, batchMetadataFile){
                public static final long serialVersionUID = 0L;
                private final Path batchMetadataFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchMetadataFile$1}));
                }
                {
                    this.batchMetadataFile$1 = batchMetadataFile$1;
                }
            });
            some = None$.MODULE$;
            return some;
        }
        FSDataInputStream input = this.fileManager().open(batchMetadataFile);
        try {
            some = new Some(this.deserialize((InputStream)input));
        }
        catch (Throwable throwable) {
            void var4_3;
            IOUtils.closeQuietly((InputStream)var4_3);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return some;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).filter((Function1)new Serializable(this, startId, endId){
            public static final long serialVersionUID = 0L;
            private final Option startId$1;
            private final Option endId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return !(!this.endId$1.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)this.endId$1.get()) || !this.startId$1.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)this.startId$1.get()));
            }
            {
                void var3_3;
                this.startId$1 = startId$1;
                this.endId$1 = var3_3;
            }
        });
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(batchIds).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, Option<T>> apply(long batchId) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), this.$outer.get(batchId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<T>> x$2) {
                return ((Option)x$2._2()).isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, T> apply(Tuple2<Object, Option<T>> x0$1) {
                Tuple2<Object, Option<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    Option metadataOption = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;

                    public final long apply(FileStatus f) {
                        return this.$outer.pathToBatchId(f.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sorted((Ordering)Ordering.Long$.MODULE$)).reverse();
                Predef$.MODULE$.longArrayOps(batchIds).foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long batchId) {
                        this.apply$mcVJ$sp(batchId);
                    }

                    public void apply$mcVJ$sp(long batchId) {
                        Option<T> batch = this.$outer.get(batchId);
                        if (batch.isDefined()) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId < this.thresholdBatchId$1;
            }
            {
                this.thresholdBatchId$1 = thresholdBatchId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private FileManager createFileManager() {
        FileManager fileManager;
        Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConf();
        try {
            fileManager = new FileContextManager(this.metadataPath(), hadoopConf);
        }
        catch (UnsupportedFileSystemException unsupportedFileSystemException) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Could not use FileContext API for managing metadata log files at path ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Using FileSystem API instead for managing log files. The log may be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.metadataPath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inconsistent under failures."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            fileManager = new FileSystemManager(this.metadataPath(), hadoopConf);
        }
        return fileManager;
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.evidence$1 = evidence$1;
        Logging.class.$init$((Logging)this);
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Should not create a log with type Seq, use Arrays instead - see SPARK-17372";
            }
        });
        this.metadataPath = new Path(path);
        this.fileManager = this.createFileManager();
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.serializer = new JavaSerializer(sparkSession.sparkContext().conf()).newInstance();
    }

    public static interface FileManager {
        public FileStatus[] list(Path var1, PathFilter var2);

        public void mkdirs(Path var1);

        public boolean exists(Path var1);

        public FSDataInputStream open(Path var1);

        public FSDataOutputStream create(Path var1);

        public void rename(Path var1, Path var2);

        public void delete(Path var1);

        public boolean isLocalFileSystem();
    }

    public static class FileSystemManager
    implements FileManager {
        private final FileSystem fs;

        private FileSystem fs() {
            return this.fs;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fs().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            if (this.fs().exists(srcPath)) {
                if (this.fs().exists(destPath)) {
                    throw new FileAlreadyExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination path already exists: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destPath})));
                }
                if (this.fs().rename(srcPath, destPath)) {
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, destPath})));
            }
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath})));
        }

        @Override
        public void mkdirs(Path path) {
            this.fs().mkdirs(path, FsPermission.getDirDefault());
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fs().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fs().create(path, false);
        }

        @Override
        public boolean exists(Path path) {
            return this.fs().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fs().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isLocalFileSystem() {
            FileSystem fileSystem = this.fs();
            boolean bl = fileSystem instanceof LocalFileSystem ? true : fileSystem instanceof RawLocalFileSystem;
            boolean bl2 = bl;
            return bl2;
        }

        public FileSystemManager(Path path, Configuration hadoopConf) {
            this.fs = path.getFileSystem(hadoopConf);
        }
    }

    public static class FileContextManager
    implements FileManager {
        private final FileContext fc;

        private FileContext fc() {
            return this.fc;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fc().util().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            this.fc().rename(srcPath, destPath, new Options.Rename[0]);
        }

        @Override
        public void mkdirs(Path path) {
            this.fc().mkdir(path, FsPermission.getDirDefault(), true);
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fc().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fc().create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        }

        @Override
        public boolean exists(Path path) {
            return this.fc().util().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fc().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isLocalFileSystem() {
            AbstractFileSystem abstractFileSystem = this.fc().getDefaultFileSystem();
            boolean bl = abstractFileSystem instanceof LocalFs ? true : abstractFileSystem instanceof RawLocalFs;
            boolean bl2 = bl;
            return bl2;
        }

        public FileContextManager(Path path, Configuration hadoopConf) {
            this.fc = path.toUri().getScheme() == null ? FileContext.getFileContext((Configuration)hadoopConf) : FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
        }
    }
}

