/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00055\u0011\u0001\u0003R1uCN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005a1\u000f]1sWN+7o]5p]B\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0007C\u0001!\t\u0001\u0002\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001cA\u0001\u0007A\u0004C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003G%BQA\u000b\u0014A\u0002-\naa]8ve\u000e,\u0007C\u0001\u00170\u001d\tyQ&\u0003\u0002/!\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq\u0003\u0003C\u00034\u0001\u0011\u0005A'\u0001\u0004tG\",W.\u0019\u000b\u0003GUBQa\r\u001aA\u0002Y\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0003\u0002\u000bQL\b/Z:\n\u0005mB$AC*ueV\u001cG\u000fV=qK\")Q\b\u0001C\u0001}\u00051q\u000e\u001d;j_:$2aI B\u0011\u0015\u0001E\b1\u0001,\u0003\rYW-\u001f\u0005\u0006\u0005r\u0002\raK\u0001\u0006m\u0006dW/\u001a\u0005\u0006{\u0001!\t\u0001\u0012\u000b\u0004G\u00153\u0005\"\u0002!D\u0001\u0004Y\u0003\"\u0002\"D\u0001\u00049\u0005CA\bI\u0013\tI\u0005CA\u0004C_>dW-\u00198\t\u000bu\u0002A\u0011A&\u0015\u0007\rbU\nC\u0003A\u0015\u0002\u00071\u0006C\u0003C\u0015\u0002\u0007a\n\u0005\u0002\u0010\u001f&\u0011\u0001\u000b\u0005\u0002\u0005\u0019>tw\rC\u0003>\u0001\u0011\u0005!\u000bF\u0002$'RCQ\u0001Q)A\u0002-BQAQ)A\u0002U\u0003\"a\u0004,\n\u0005]\u0003\"A\u0002#pk\ndW\rC\u0003Z\u0001\u0011\u0005!,A\u0004paRLwN\\:\u0015\u0005\rZ\u0006\"B-Y\u0001\u0004a\u0006\u0003B/aW-j\u0011A\u0018\u0006\u0003?B\t!bY8mY\u0016\u001cG/[8o\u0013\t\tgLA\u0002NCBDQ!\u0017\u0001\u0005\u0002\r$\"a\t3\t\u000be\u0013\u0007\u0019A3\u0011\t\u0019\\7fK\u0007\u0002O*\u0011\u0001.[\u0001\u0005kRLGNC\u0001k\u0003\u0011Q\u0017M^1\n\u0005\u0005<\u0007\"B7\u0001\t\u0003q\u0017\u0001\u00027pC\u0012$\u0012a\u001c\t\u0003azt!!\u001d?\u000f\u0005I\\hBA:{\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA?\u0005\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002~\t!1Q\u000e\u0001C\u0001\u0003\u000b!2a\\A\u0004\u0011\u001d\tI!a\u0001A\u0002-\nA\u0001]1uQ\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011\u0001\u00026t_:$2a\\A\t\u0011\u001d\tI!a\u0003A\u0002-Bq!!\u0006\u0001\t\u0003\t9\"A\u0002dgZ$2a\\A\r\u0011\u001d\tI!a\u0005A\u0002-Bq!!\b\u0001\t\u0003\ty\"A\u0004qCJ\fX/\u001a;\u0015\u0007=\f\t\u0003C\u0004\u0002\n\u0005m\u0001\u0019A\u0016\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u0005!A/\u001a=u)\ry\u0017\u0011\u0006\u0005\b\u0003\u0013\t\u0019\u00031\u0001,\u0011!Q\u0003\u00011A\u0005\n\u00055R#A\u0016\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0012AC:pkJ\u001cWm\u0018\u0013fcR!\u0011QGA\u001e!\ry\u0011qG\u0005\u0004\u0003s\u0001\"\u0001B+oSRD\u0011\"!\u0010\u00020\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013\u0007C\u0004\u0002B\u0001\u0001\u000b\u0015B\u0016\u0002\u000fM|WO]2fA!I\u0011Q\t\u0001A\u0002\u0013%\u0011qI\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.Y\u000b\u0003\u0003\u0013\u0002BaDA&m%\u0019\u0011Q\n\t\u0003\r=\u0003H/[8o\u0011%\t\t\u0006\u0001a\u0001\n\u0013\t\u0019&A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017m\u0018\u0013fcR!\u0011QGA+\u0011)\ti$a\u0014\u0002\u0002\u0003\u0007\u0011\u0011\n\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002J\u0005!Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC\u0002B\u0011\"!\u0018\u0001\u0001\u0004%I!a\u0018\u0002\u0019\u0015DHO]1PaRLwN\\:\u0016\u0005\u0005\u0005\u0004CBA2\u0003SZ3&\u0004\u0002\u0002f)\u0019\u0011q\r0\u0002\u000f5,H/\u00192mK&!\u00111NA3\u0005\u001dA\u0015m\u001d5NCBD\u0011\"a\u001c\u0001\u0001\u0004%I!!\u001d\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003BA\u001b\u0003gB!\"!\u0010\u0002n\u0005\u0005\t\u0019AA1\u0011!\t9\b\u0001Q!\n\u0005\u0005\u0014!D3yiJ\fw\n\u001d;j_:\u001c\b\u0005K\u0002\u0001\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u00033\u0011AC1o]>$\u0018\r^5p]&!\u0011QQA@\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        SparkSession x$1 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        DataSource dataSource = new DataSource(x$1, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)StreamingRelation$.MODULE$.apply(dataSource));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load();
    }

    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

